/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.UninstallSchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTask;
import com.ibm.ws.webservices.admin.serviceindex.impl.ServiceIndexReader;
import java.io.File;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class ServiceIndexReadTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(ServiceIndexServerTask.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private RepositoryContext _deployContext = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    protected String SOURCE_FILE = ((Object)((Object)this)).getClass().getName();

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServiceIndexReadTask.performTask()");
        }
        try {
            String string = (String)this.scheduler.getProperties().get("contenttype");
            String string2 = (String)this.scheduler.getProperties().get("app");
            if (!(this.scheduler instanceof UninstallSchedulerImpl) || string != null || string2 != null) {
                this._deployContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
                EARFile eARFile = ConfigRepoHelper.getEarFileForApp((WorkSpace)this.scheduler.getWorkSpace(), (RepositoryContext)this._deployContext, (ResourceBundle)this.getResourceBundle(), (boolean)true);
                Map map = this.readIndexFile(eARFile);
                if (map != null && !map.isEmpty()) {
                    this.scheduler.getProperties().put("ServiceIndexTask.ServiceIndexMap", map);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ServiceIndexReadTask.performTask()");
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.SOURCE_FILE + ".performTask", FFDC_ID_1, (Object)this);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), throwable.toString()}));
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, AppUtils.getMessage((ResourceBundle)this.getResourceBundle(), (String)"ADMA0066E"));
        }
    }

    private Map[] readIndexFile(ModuleFile moduleFile) throws Exception {
        String string = moduleFile.getName() + File.separator + this.getMetaDirectory(moduleFile) + File.separator + "servicesIndex.xml";
        Map[] mapArray = null;
        try {
            File file = new File(this._deployContext.getPath() + File.separator + string);
            if (file.exists()) {
                InputStream inputStream = this._deployContext.getInputStream(string);
                ServiceIndexReader serviceIndexReader = new ServiceIndexReader(inputStream);
                mapArray = serviceIndexReader.read(true);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.SOURCE_FILE + ".readIndexFile", FFDC_ID_2, (Object)this);
        }
        return mapArray;
    }

    private String getMetaDirectory(ModuleFile moduleFile) {
        return moduleFile.isWARFile() ? "WEB-INF" : "META-INF";
    }

    private Map readIndexFile(EARFile eARFile) throws Exception {
        Hashtable<String, Map[]> hashtable = new Hashtable<String, Map[]>();
        List list = eARFile.getModuleFiles();
        for (ModuleFile moduleFile : list) {
            Map[] mapArray = this.readIndexFile(moduleFile);
            if (mapArray == null || (mapArray[0] == null || mapArray[0].isEmpty()) && (mapArray[1] == null || mapArray[1].isEmpty())) continue;
            hashtable.put(moduleFile.getName(), mapArray);
        }
        return hashtable;
    }
}

