/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.deploy;

import com.ibm.ws.webservices.admin.serviceindex.impl.EndpointBean;
import com.ibm.ws.webservices.admin.serviceindex.impl.WebServiceBean;
import com.ibm.ws.websvcs.desc.WSDescriptionBuilderFactory;
import com.ibm.wsspi.websvcs.desc.WSClientEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientOperationDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientServiceDescriptor;
import com.ibm.wsspi.websvcs.desc.WSDescriptionBuilder;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import com.ibm.wsspi.websvcs.desc.WSOperationDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class ServiceIndexDataBuilder {
    private static WSDescriptionBuilder builder = WSDescriptionBuilderFactory.getBuilder();

    public static void getWSData(ModuleFile moduleFile, Map map, Map map2) {
        WSModuleDescriptor wSModuleDescriptor = builder.getModuleDescriptor(moduleFile);
        if (wSModuleDescriptor.containsJAXWSWebServices()) {
            WebServiceBean webServiceBean;
            Iterator iterator = wSModuleDescriptor.getServices();
            while (iterator.hasNext()) {
                webServiceBean = ServiceIndexDataBuilder.getWSBean((WSServiceDescriptor)iterator.next());
                if (webServiceBean == null) continue;
                map.put(webServiceBean.getServiceName(), webServiceBean);
            }
            iterator = wSModuleDescriptor.getServiceRefs();
            while (iterator.hasNext()) {
                webServiceBean = ServiceIndexDataBuilder.getWSBean((WSClientServiceDescriptor)iterator.next());
                if (webServiceBean == null) continue;
                map2.put(webServiceBean.getServiceName(), webServiceBean);
            }
        }
    }

    private static WebServiceBean getWSBean(WSServiceDescriptor wSServiceDescriptor) {
        WebServiceBean webServiceBean = null;
        if (wSServiceDescriptor.isJAXWSService()) {
            webServiceBean = new WebServiceBean();
            webServiceBean.setServiceName(wSServiceDescriptor.getQName().toString());
            webServiceBean.setType("JAX-WS");
            Iterator iterator = wSServiceDescriptor.getEndpoints();
            while (iterator.hasNext()) {
                EndpointBean endpointBean = ServiceIndexDataBuilder.getEndpointBean((WSEndpointDescriptor)iterator.next());
                webServiceBean.addEndpoint(endpointBean);
            }
        }
        return webServiceBean;
    }

    private static WebServiceBean getWSBean(WSClientServiceDescriptor wSClientServiceDescriptor) {
        WebServiceBean webServiceBean = new WebServiceBean();
        webServiceBean.setClient(true);
        webServiceBean.setServiceName(wSClientServiceDescriptor.getQName().toString());
        webServiceBean.setType("JAX-WS");
        Iterator iterator = wSClientServiceDescriptor.getEndpoints();
        while (iterator.hasNext()) {
            EndpointBean endpointBean = ServiceIndexDataBuilder.getEndpointBean((WSClientEndpointDescriptor)iterator.next());
            webServiceBean.addEndpoint(endpointBean);
        }
        return webServiceBean;
    }

    private static EndpointBean getEndpointBean(WSEndpointDescriptor wSEndpointDescriptor) {
        EndpointBean endpointBean = new EndpointBean();
        endpointBean.setName(wSEndpointDescriptor.getName());
        Iterator iterator = wSEndpointDescriptor.getOperations();
        while (iterator.hasNext()) {
            WSOperationDescriptor wSOperationDescriptor = (WSOperationDescriptor)iterator.next();
            endpointBean.addOperation(wSOperationDescriptor.getName());
        }
        return endpointBean;
    }

    private static EndpointBean getEndpointBean(WSClientEndpointDescriptor wSClientEndpointDescriptor) {
        EndpointBean endpointBean = new EndpointBean();
        endpointBean.setName(wSClientEndpointDescriptor.getName());
        Iterator iterator = wSClientEndpointDescriptor.getOperations();
        while (iterator.hasNext()) {
            WSClientOperationDescriptor wSClientOperationDescriptor = (WSClientOperationDescriptor)iterator.next();
            endpointBean.addOperation(wSClientOperationDescriptor.getName());
        }
        return endpointBean;
    }
}

