/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.websphere.management.application.AppManagementExtensions;
import com.ibm.websphere.management.application.EditScheduler;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.UpdateSchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.webservices.admin.deploy.ServiceIndexServerTask;
import com.ibm.ws.webservices.admin.serviceindex.impl.ServiceIndexReader;
import com.ibm.ws.webservices.admin.serviceindex.impl.WebServiceBean;
import com.ibm.ws.websvcs.desc.WSDescriptionBuilderFactory;
import com.ibm.wsspi.websvcs.desc.WSDescriptionBuilder;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class DeploymentValidation
implements AppManagementExtensions.AppValidationHelper,
AppManagementExtensions.AppValidationHelper2 {
    private static TraceComponent tc = Tr.register(ServiceIndexServerTask.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    protected String className = this.getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private static WSDescriptionBuilder builder = WSDescriptionBuilderFactory.getBuilder();

    public void validateOperation_Required(Scheduler scheduler, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation.validateOperation_Required())");
        }
        try {
            if (scheduler instanceof UpdateScheduler && ((UpdateSchedulerImpl)scheduler).getContentType().equals("modulefile")) {
                ModuleFile moduleFile = (ModuleFile)((UpdateSchedulerImpl)scheduler).getContentAsArchive(true, true);
                this.validate(moduleFile, scheduler, list);
            } else {
                EARFile eARFile = this.getEar(scheduler);
                if (eARFile != null) {
                    eARFile.getOptions().setUseJavaReflection(true);
                    this.validate(eARFile, scheduler, list);
                    this.closeEar(eARFile, scheduler);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to get an EARFile for deployment validation");
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className, FFDC_ID_1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation.validateOperation_Required())");
        }
    }

    private void closeEar(EARFile eARFile, Scheduler scheduler) throws Exception {
        EARFile eARFile2;
        if (scheduler instanceof UpdateScheduler) {
            eARFile.close();
        } else if (scheduler instanceof EditScheduler && (eARFile2 = ((EditScheduler)scheduler).getEarFile()) == null) {
            eARFile.close();
        }
    }

    public void validateOperation_Optional(Scheduler scheduler, List list) {
    }

    private void validate(EARFile eARFile, Scheduler scheduler, List list) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation.validate(EARFile)");
        }
        EList eList = eARFile.getModuleRefs();
        for (ModuleRef moduleRef : eList) {
            ModuleFile moduleFile = moduleRef.getModuleFile();
            List list2 = AppDeploymentUtil.getTargetNodes((Scheduler)scheduler, (String)moduleRef.getUri(), (String)moduleRef.getDeploymentDescriptor().eResource().getURI().toString());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validating " + moduleFile.getName() + " for these nodes, " + list2);
            }
            this.validate(moduleFile, scheduler, moduleFile.getName(), list2, list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation.validate(EARFile)");
        }
    }

    private void validate(ModuleFile moduleFile, Scheduler scheduler, List list) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation.validate(ModuleFile)");
        }
        String string = ((UpdateScheduler)scheduler).getContentURI();
        List list2 = AppDeploymentUtil.getTargetNodes((Scheduler)scheduler, (String)string, (String)moduleFile.getDeploymentDescriptorUri());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validating " + moduleFile.getName() + " for these nodes, " + list2);
        }
        this.validate(moduleFile, scheduler, string, list2, list);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation.validate(ModuleFile)");
        }
    }

    private void validate(ModuleFile moduleFile, Scheduler scheduler, String string, List list, List list2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation.validate(ModuleFile)");
        }
        if (this.hasJAXWSWebServices(moduleFile, scheduler)) {
            Locale locale = (Locale)scheduler.getProperties().get("app.client.locale");
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", locale);
            String string2 = resourceBundle.getString("CWSAD0016W");
            ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(null));
            SortedMap sortedMap = null;
            String string32 = null;
            String string42 = null;
            List list3 = this.getManagedNodes();
            for (String string32 : list) {
                for (String string42 : list3) {
                    if (!string42.equals(string32)) continue;
                    sortedMap = managedObjectMetadataHelper.getNodeProductVersions(string32);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Product map for node, " + string32 + ", is " + sortedMap);
                    }
                    if (sortedMap.get("WS FEP") != null) continue;
                    String string5 = MessageFormat.format(string2, string, string32);
                    list2.add(string5);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Node, " + string32 + ", doesn't contain WSFP");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation.validate(ModuleFile)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getManagedNodes() throws Exception {
        List list = null;
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        if (commandMgr != null) {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = new Session();
            try {
                AdminCommand adminCommand = commandMgr.createCommand("listManagedNodes");
                adminCommand.setConfigSession(session);
                adminCommand.execute();
                CommandResult commandResult = adminCommand.getCommandResult();
                if (!commandResult.isSuccessful()) {
                    throw new Exception("failure during");
                }
                list = (List)commandResult.getResult();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, this.className, FFDC_ID_1);
                Tr.error(tc, "Exception: " + exception.getMessage());
            }
            finally {
                configService.discard(session);
            }
        }
        return list;
    }

    private EARFile getEar(Scheduler scheduler) throws Exception {
        EARFile eARFile = null;
        if (scheduler instanceof InstallScheduler) {
            eARFile = ((InstallScheduler)scheduler).getEarFile(true, false);
        } else if (scheduler instanceof UpdateScheduler) {
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig((String)scheduler.getAppName(), (WorkSpace)scheduler.getWorkSpace(), (Hashtable)scheduler.getProperties());
            if (!ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)repositoryContext).isZeroBinaryCopy()) {
                String string = "com.ibm.ws.management.resources.AppDeploymentMessages";
                eARFile = ConfigRepoHelper.getEarFileFromBinaries((RepositoryContext)repositoryContext, (WorkSpace)scheduler.getWorkSpace(), (ResourceBundle)AppUtils.getBundle((String)string, (Locale)Locale.getDefault()), (boolean)true);
            } else {
                eARFile = (EARFile)((UpdateSchedulerImpl)scheduler).getContentAsArchive(false, true);
            }
        } else if (scheduler instanceof EditScheduler && (eARFile = ((EditScheduler)scheduler).getEarFile()) == null) {
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig((String)scheduler.getAppName(), (WorkSpace)scheduler.getWorkSpace(), (Hashtable)scheduler.getProperties());
            eARFile = ConfigRepoHelper.getEarFileFromDeployment((WorkSpace)scheduler.getWorkSpace(), (RepositoryContext)repositoryContext);
        }
        return eARFile;
    }

    private boolean hasJAXWSWebServices(ModuleFile moduleFile, Scheduler scheduler) {
        boolean bl;
        block8: {
            bl = false;
            if (scheduler instanceof EditScheduler) {
                String string = "WEB-INF/servicesIndex.xml";
                try {
                    File file;
                    InputStream inputStream;
                    boolean bl2 = moduleFile.containsFile(string);
                    if (bl2 && (inputStream = (file = moduleFile.getFile(string)).getInputStream()) != null) {
                        ServiceIndexReader serviceIndexReader = new ServiceIndexReader(inputStream);
                        Map[] mapArray = serviceIndexReader.read(true);
                        inputStream.close();
                        HashMap hashMap = new HashMap();
                        HashMap hashMap2 = new HashMap();
                        if (mapArray != null && mapArray[0] != null) {
                            hashMap.putAll(mapArray[0]);
                        }
                        if (mapArray != null && mapArray[1] != null) {
                            hashMap2.putAll(mapArray[1]);
                        }
                        bl = this.hasJAXWSWebServices(hashMap) || this.hasJAXWSWebServices(hashMap2);
                    }
                    break block8;
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Receiving exception in hasJAXWSWebServices(ModuleFile, Scheduler), " + exception);
                    }
                    break block8;
                }
            }
            WSModuleDescriptor wSModuleDescriptor = builder.getModuleDescriptor(moduleFile);
            bl = wSModuleDescriptor.containsJAXWSWebServices();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, moduleFile.getName() + " contains JAX-WS web services? " + bl);
        }
        return bl;
    }

    private boolean hasJAXWSWebServices(Map map) {
        boolean bl = false;
        for (String string : map.keySet()) {
            WebServiceBean webServiceBean = (WebServiceBean)map.get(string);
            if (!"JAX-WS".equals(webServiceBean.getType())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void isApplicationDeployable(String string, String string2, String string3, EARFile eARFile, String string4, Locale locale, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation.isApplicationDeployable()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodName = " + string + ", clusterName = " + string2 + ", appName = " + string3 + ", workspaceID = " + string4);
        }
        try {
            if (eARFile != null) {
                eARFile.getOptions().setUseJavaReflection(true);
                this.validate(string, string2, string3, eARFile, string4, locale, list);
                eARFile.close();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "EARFile is null");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className, FFDC_ID_1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation.isApplicationDeployable()");
        }
    }

    private void validate(String string, String string2, String string3, EARFile eARFile, String string4, Locale locale, List list) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation.validate(nodeName)");
        }
        EList eList = eARFile.getModuleRefs();
        for (ModuleRef moduleRef : eList) {
            ModuleFile moduleFile = moduleRef.getModuleFile();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validating " + moduleFile.getName() + " for node " + string + " and/or cluster " + string2);
            }
            this.validate(moduleFile, moduleFile.getName(), string, string2, string3, string4, locale, list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation.validate(nodeName)");
        }
    }

    private void validate(ModuleFile moduleFile, String string, String string2, String string3, String string4, String string5, Locale locale, List list) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentValidation.validate(ModuleFile, mfName)");
        }
        if (this.hasJAXWSWebServices(moduleFile)) {
            ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(null));
            SortedMap sortedMap = null;
            String string62 = null;
            List list2 = this.getManagedNodes();
            for (String string62 : list2) {
                if (!string62.equals(string2)) continue;
                sortedMap = managedObjectMetadataHelper.getNodeProductVersions(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Product map for node, " + string2 + ", is " + sortedMap);
                }
                if (sortedMap.get("WS FEP") != null) break;
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", locale);
                String string7 = resourceBundle.getString("CWSAD0016W");
                String string8 = MessageFormat.format(string7, string, string2);
                list.add(string8);
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Node, " + string2 + ", doesn't contain WSFP");
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentValidation.validate(ModuleFile, mfName)");
        }
    }

    private boolean hasJAXWSWebServices(ModuleFile moduleFile) {
        boolean bl;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DeploymentValidation.hasJAXWSWebServices(ModuleFile)");
            }
            bl = false;
            String string = "WEB-INF/servicesIndex.xml";
            try {
                File file;
                InputStream inputStream;
                boolean bl2 = moduleFile.containsFile(string);
                if (bl2 && (inputStream = (file = moduleFile.getFile(string)).getInputStream()) != null) {
                    ServiceIndexReader serviceIndexReader = new ServiceIndexReader(inputStream);
                    Map[] mapArray = serviceIndexReader.read(true);
                    inputStream.close();
                    HashMap hashMap = new HashMap();
                    HashMap hashMap2 = new HashMap();
                    if (mapArray != null && mapArray[0] != null) {
                        hashMap.putAll(mapArray[0]);
                    }
                    if (mapArray != null && mapArray[1] != null) {
                        hashMap2.putAll(mapArray[1]);
                    }
                    bl = this.hasJAXWSWebServices(hashMap) || this.hasJAXWSWebServices(hashMap2);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Receiving exception in hasJAXWSWebServices(ModuleFile), " + exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, moduleFile.getName() + " contains JAX-WS web services? " + bl);
            Tr.exit(tc, "DeploymentValidation.validate(ModuleFile)");
        }
        return bl;
    }
}

