/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.util.Utils;
import com.ibm.wsspi.management.tools.NodeSideExtensionChecker;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class AddNodeValidation
implements NodeSideExtensionChecker {
    private static TraceComponent tc = Tr.register(AddNodeValidation.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    protected String className = this.getClass().getName();
    private ResourceBundle res = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", Locale.getDefault());

    public void checkCompatibility(Properties properties, Properties properties2, AdminClient adminClient) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AddNodeValidation.checkCompatibility()");
        }
        for (String string : properties.keySet()) {
            if (string.indexOf("WebServicesFeaturePackProductVersion") <= 0) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking " + string);
            }
            String string2 = properties.getProperty(string);
            String string3 = properties2.getProperty(string);
            if (string3 == null || string3.length() == 0) {
                String string4 = properties2.getProperty("com.ibm.websphere.baseProductVersion");
                String string5 = this.getMajorVersion(string4);
                if (string5 != null && "7".compareTo(string5) <= 0) break;
                throw new AdminException(this.getFormattedMessage("CWSAD0015E", new String[]{string2}, null));
            }
            if (Utils.compareVersions((String)string3, (String)string2) >= 0) break;
            throw new AdminException(this.getFormattedMessage("CWSAD0014E", new String[]{string3, string2}, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AddNodeValidation.checkCompatibility()");
        }
    }

    private String getMajorVersion(String string) {
        String string2 = null;
        if (string != null) {
            int n = string.indexOf(46);
            string2 = n == -1 ? string : string.substring(0, n);
        }
        return string2;
    }

    private String getFormattedMessage(String string, Object[] objectArray, String string2) {
        try {
            String string3 = this.res.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            return string2;
        }
    }
}

