/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.commands.j2eeStep;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.webservices.admin.exceptions.NoItemFoundException;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexWorkSpaceHelper;
import java.io.File;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ServiceIndexWorkSpaceHelperImpl
implements ServiceIndexWorkSpaceHelper,
ServiceIndexConstants {
    public static final String APP_METADATA_TYPE = "deployments";
    public static final String MODULE_METADATA_DIR = "META-INF";
    private static TraceComponent tc = Tr.register(ServiceIndexWorkSpaceHelper.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");

    public List listServiceIndexFiles(Session session, String string, String string2) throws Exception {
        if (session == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "listServicIndexFiles session is null");
            }
            throw new NoItemFoundException("Session is null");
        }
        final Session session2 = session;
        WorkSpace workSpace = null;
        try {
            workSpace = (WorkSpace)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws WorkSpaceException {
                    return WorkSpaceManagerFactory.getManager().getWorkSpace(session2.getUserName());
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is thrown from AccessController: " + privilegedActionException);
            }
            throw (WorkSpaceException)((Object)privilegedActionException.getException());
        }
        if (string == null || string.equals("*")) {
            return this.listServiceIndexFilesInCell(workSpace);
        }
        if (string2 == null) {
            return this.listServiceIndexFilesInApp(this.getAppRepositoryContext(workSpace, string), string);
        }
        return this.listServiceIndexFilesInModule(this.getAppRepositoryContext(workSpace, string), string, string2);
    }

    private RepositoryContext getAppRepositoryContext(WorkSpace workSpace, String string) throws WorkSpaceException {
        final String string2 = string;
        final WorkSpace workSpace2 = workSpace;
        Collection collection = null;
        try {
            collection = (Collection)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws WorkSpaceException {
                    return workSpace2.getRootContext().findContext(ServiceIndexWorkSpaceHelperImpl.APP_METADATA_TYPE, string2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is thrown from AccessController: " + privilegedActionException);
            }
            throw (WorkSpaceException)((Object)privilegedActionException.getException());
        }
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            return (RepositoryContext)iterator.next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAppRepositoryContext, cannot get deployment RepositoryContext for app " + string);
        }
        return null;
    }

    private List listServiceIndexFilesInCell(WorkSpace workSpace) throws WorkSpaceException {
        RepositoryMetaData repositoryMetaData = workSpace.getMetaData();
        RepositoryContextType repositoryContextType = repositoryMetaData.getContextType(APP_METADATA_TYPE);
        Collection collection = workSpace.findContext(repositoryContextType);
        Iterator iterator = collection.iterator();
        RepositoryContext repositoryContext = null;
        ArrayList arrayList = new ArrayList();
        List list = null;
        while (iterator.hasNext()) {
            repositoryContext = (RepositoryContext)iterator.next();
            String string = this.getApplicationName(repositoryContext);
            list = this.listServiceIndexFilesInApp(repositoryContext, string);
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(list.get(i));
            }
        }
        return arrayList;
    }

    private List listServiceIndexFilesInApp(RepositoryContext repositoryContext, String string) throws WorkSpaceException {
        ArrayList<Properties> arrayList = new ArrayList<Properties>(1);
        if (repositoryContext == null) {
            Properties properties = new Properties();
            properties.setProperty("application", "AppNotExist");
            arrayList.add(properties);
            return arrayList;
        }
        Iterator iterator = repositoryContext.getFiles().iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (!string2.endsWith("servicesIndex.xml")) continue;
            repositoryContext.extract(string2, false);
            StringBuffer stringBuffer = new StringBuffer(repositoryContext.getPath());
            stringBuffer.append(File.separatorChar).append(string2);
            Properties properties = new Properties();
            properties.setProperty("application", string);
            properties.setProperty("module", this.getModuleName(string2));
            properties.setProperty("file", stringBuffer.toString());
            arrayList.add(properties);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "listServiceIndexFilesInApp : find file=" + stringBuffer.toString());
        }
        return arrayList;
    }

    private List listServiceIndexFilesInModule(RepositoryContext repositoryContext, String string, String string2) throws WorkSpaceException {
        Serializable serializable;
        ArrayList<Properties> arrayList = new ArrayList<Properties>(1);
        if (repositoryContext == null) {
            Properties properties = new Properties();
            properties.setProperty("application", "AppNotExist");
            arrayList.add(properties);
            return arrayList;
        }
        Iterator iterator = repositoryContext.getFiles().iterator();
        String string3 = null;
        boolean bl = false;
        String string4 = string2 + '/';
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "listServiceIndexFilesInModule, fileName is " + string3);
            }
            if (!string3.startsWith(string4)) continue;
            bl = true;
            if (!string3.endsWith("servicesIndex.xml")) continue;
            repositoryContext.extract(string3, false);
            serializable = new StringBuffer(repositoryContext.getPath());
            ((StringBuffer)serializable).append(File.separatorChar).append(string3);
            Properties properties = new Properties();
            properties.setProperty("application", string);
            properties.setProperty("module", string2);
            properties.setProperty("file", ((StringBuffer)serializable).toString());
            arrayList.add(properties);
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "listServiceIndexFilesInModule, find the services index file " + ((StringBuffer)serializable).toString());
            break;
        }
        if (!bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "listServiceIndexFilesInModule, not found module: application=" + string + "module=" + string2);
            }
            serializable = new Properties();
            ((Properties)serializable).setProperty("application", string);
            ((Properties)serializable).setProperty("module", "ModuleNotExist");
            arrayList.add((Properties)serializable);
            return arrayList;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "listServiceIndexFilesInModule, find module: application=" + string + "module=" + string2);
        }
        return arrayList;
    }

    private String getApplicationName(RepositoryContext repositoryContext) {
        String string = repositoryContext.getPath();
        int n = string.lastIndexOf(File.separatorChar);
        if (n < 0) {
            n = string.lastIndexOf(47);
        }
        String string2 = string.substring(n + 1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getApplicationName, path is " + string + ", appName=" + string2);
        }
        return string2;
    }

    private String getModuleName(String string) {
        int n = string.indexOf(File.separatorChar);
        if (n < 0) {
            n = string.indexOf(47);
        }
        String string2 = string.substring(0, n);
        return string2;
    }
}

