/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.ws.webservices.admin.commands.CommandBase;
import com.ibm.ws.webservices.admin.commands.GetWebService;
import com.ibm.ws.webservices.admin.commands.ListWebServiceEndpoints;
import com.ibm.ws.webservices.admin.commands.ListWebServiceOperations;
import com.ibm.ws.webservices.admin.commands.ListWebServices;

public class WebServiceCommandProvider
extends CommandProvider {
    private static TraceComponent tc = Tr.register(WebServiceCommandProvider.class, "WebServiceCommandProvider", "com.ibm.ws.webservices.admin.commands");

    public AbstractAdminCommand createCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommand");
        }
        String string = commandMetadata.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, commandMetadata.toString());
            Tr.debug(tc, "Trying to create new " + string + " command.");
        }
        CommandBase commandBase = null;
        if (string.equals("listWebServices")) {
            commandBase = new ListWebServices((TaskCommandMetadata)commandMetadata);
        } else if (string.equals("getWebService")) {
            commandBase = new GetWebService((TaskCommandMetadata)commandMetadata);
        } else if (string.equals("listWebServiceEndpoints")) {
            commandBase = new ListWebServiceEndpoints((TaskCommandMetadata)commandMetadata);
        } else if (string.equals("listWebServiceOperations")) {
            commandBase = new ListWebServiceOperations((TaskCommandMetadata)commandMetadata);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find command " + string + " to create.");
            }
            throw new CommandNotFoundException(string);
        }
        return commandBase;
    }

    public AbstractAdminCommand loadCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCommand");
        }
        String string = commandData.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, commandData.toString());
            Tr.debug(tc, "Trying to load new " + string + " command.");
        }
        CommandBase commandBase = null;
        if (string.equals("listWebServices")) {
            commandBase = new ListWebServices(commandData);
        } else if (string.equals("getWebService")) {
            commandBase = new GetWebService(commandData);
        } else if (string.equals("listWebServiceEndpoints")) {
            commandBase = new ListWebServiceEndpoints(commandData);
        } else if (string.equals("listWebServiceOperations")) {
            commandBase = new ListWebServiceOperations(commandData);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find task command " + string + " to load.");
            }
            throw new CommandNotFoundException(string);
        }
        return commandBase;
    }
}

