/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.ws.webservices.admin.WebServiceAdminConstants;
import com.ibm.ws.webservices.admin.commands.WebServiceUtils;
import com.ibm.ws.webservices.admin.exceptions.MultipleItemsFoundException;
import com.ibm.ws.webservices.admin.exceptions.NoItemFoundException;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexConstants;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelper;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelperFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class CommandBase
extends AbstractTaskCommand
implements ServiceIndexConstants,
WebServiceAdminConstants {
    private static TraceComponent tc = Tr.register(CommandBase.class, "webservices.admin", "com.ibm.ws.webservices.admin.resources.websvcsAdmin");
    private ResourceBundle resourceBundle = null;

    public CommandBase(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor metadata=" + taskCommandMetadata);
        }
    }

    public CommandBase(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    protected List getIndexHelpersFromSteps(TaskCommandResultImpl taskCommandResultImpl, String string, String string2) throws Exception {
        Locale locale;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIndexHelpersFromSteps, ", new Object[]{string, string2});
        }
        if ((locale = this.getLocale()) == null) {
            locale = Locale.getDefault();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getIndexHelpersFromSteps, AbstractCommand.getLocale returns null, so use Locale.getDefault() instead");
            }
        }
        this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.webservices.admin.resources.websvcsAdmin", locale);
        String[] stringArray = this.listCommandSteps();
        this.validateStepResults(taskCommandResultImpl, stringArray, string, string2);
        ArrayList<ServiceIndexHelper> arrayList = new ArrayList<ServiceIndexHelper>();
        Properties properties = null;
        List list = null;
        boolean bl = tc.isDebugEnabled();
        for (int i = 0; i < stringArray.length; ++i) {
            list = (List)taskCommandResultImpl.getStepResult(stringArray[i]).getResult();
            if (list == null || list.size() == 0) continue;
            for (int j = 0; j < list.size(); ++j) {
                properties = (Properties)list.get(j);
                if (bl) {
                    Tr.debug(tc, "getIndexHelpersFromSteps, step=" + stringArray[i] + ", file properties is " + properties.toString());
                }
                arrayList.add(ServiceIndexHelperFactory.createHelper(properties));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIndexHelpersFromSteps, return list size " + arrayList.size());
        }
        return arrayList;
    }

    private void validateStepResults(TaskCommandResultImpl taskCommandResultImpl, String[] stringArray, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateStepResults", new Object[]{string, string2});
        }
        if (string == null) {
            return;
        }
        Properties properties = null;
        List list = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = tc.isDebugEnabled();
        for (int i = 0; i < stringArray.length; ++i) {
            list = (List)taskCommandResultImpl.getStepResult(stringArray[i]).getResult();
            if (list == null || list.size() == 0) {
                bl = true;
                bl2 = true;
                continue;
            }
            boolean bl4 = false;
            String string3 = null;
            String string4 = null;
            for (int j = 0; j < list.size(); ++j) {
                properties = (Properties)list.get(j);
                if (bl3) {
                    Tr.debug(tc, "validateStepResults, step=" + stringArray[i] + ", file properties is " + properties.toString());
                }
                string3 = properties.getProperty("application");
                string4 = properties.getProperty("module");
                if ("AppNotExist".equals(string3)) break;
                if ("ModuleNotExist".equals(string4)) {
                    bl = true;
                    break;
                }
                if (string != null && !string.equals(string3)) break;
                if (string2 != null && !string2.equals(string4)) {
                    bl = true;
                    break;
                }
                bl = true;
                bl2 = true;
                bl4 = true;
            }
            if (bl4) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateStepResults, cannot find app or module for step=" + stringArray[i]);
            }
            taskCommandResultImpl.setStepResult(stringArray[i], new CommandResultImpl());
        }
        if (!bl && string != null) {
            throw new NoItemFoundException(WebServiceUtils.getFormattedMessage(this.resourceBundle, "CWSAD0003E", new Object[]{string}, "No application is found: " + string));
        }
        if (!bl2 && string2 != null) {
            throw new NoItemFoundException(WebServiceUtils.getFormattedMessage(this.resourceBundle, "CWSAD0004E", new Object[]{string2}, "No module is found: " + string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateStepResults");
        }
    }

    protected void handleErrors(List list, String string, String string2, String string3) throws NoItemFoundException, MultipleItemsFoundException {
        if (list.size() == 0) {
            throw new NoItemFoundException(WebServiceUtils.getFormattedMessage(this.resourceBundle, "CWSAD0005E", new Object[]{""}, "No web service is found: "));
        }
        if (list.size() > 1) {
            if (tc.isDebugEnabled()) {
                for (int i = 0; i < list.size(); ++i) {
                    Tr.debug(tc, "handleErrors, multiple service index files, app=" + string + ", module=" + string2);
                }
            }
            throw new MultipleItemsFoundException(WebServiceUtils.getFormattedMessage(this.resourceBundle, "CWSAD0005E", new Object[]{string, string2}, "Multiple services index files are found when no more than one file is expected"));
        }
    }
}

