/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.webapp;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.container.Container;
import com.ibm.ws.container.DeployedModule;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.VirtualHost;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.core.BaseContainer;
import com.ibm.ws.webcontainer.exception.WebAppNotLoadedException;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.webapp.WebGroupConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class WebGroup
extends BaseContainer {
    protected static TraceComponent tc = Tr.register(WebGroup.class, "Webcontainer", "com.ibm.ws.webcontainer.resources.Messages");
    private static String sessUrlRewritePrefix = ";jsessionid=";
    private static final String qMark = "?";
    private WebGroupConfiguration config;
    protected WebApp webApp;

    public WebGroup(String string, Container container) {
        super(string, container);
    }

    public void initialize(WebGroupConfiguration webGroupConfiguration) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "initialize");
        }
        this.config = webGroupConfiguration;
        this.webApp = null;
    }

    public void removeContextAttribute(String string) {
    }

    public void setContextAttribute(String string, Object object) {
    }

    public WebGroupConfiguration getConfiguration() {
        return this.config;
    }

    public void addWebApplication(DeployedModule deployedModule, List list, boolean bl) throws Throwable {
        WebAppConfiguration webAppConfiguration = deployedModule.getWebAppConfig();
        String string = webAppConfiguration.getDisplayName();
        Tr.audit(tc, "loading.web.module", string);
        WebApp webApp = deployedModule.getWebApp();
        try {
            this.webApp = webApp;
            webApp.initialize(webAppConfiguration, deployedModule, list, bl);
        }
        catch (Throwable throwable) {
            webApp.failed();
            this.webApp = null;
            FFDCFilter.processException(throwable, "com.ibm.ws.webcontainer.webapp.WebGroup", "131", this);
            Object[] objectArray = new Object[]{string};
            Tr.error(tc, "Failed.to.initialize.webapp.{0}", objectArray);
            throw throwable;
        }
        webApp.started();
    }

    public String getMimeType(String string, String string2) {
        return ((VirtualHost)this.parent).getMimeType(string, string2);
    }

    public IHttpSessionContext getSessionContext(DeployedModule deployedModule, WebApp webApp, ArrayList[] arrayListArray) throws Throwable {
        return ((VirtualHost)this.parent).getSessionContext(deployedModule, webApp, arrayListArray);
    }

    public ServletContext findContext(String string) {
        return ((VirtualHost)this.parent).findContext(string);
    }

    public ServletContext getContext() {
        return this.webApp;
    }

    public synchronized void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy()");
        }
        super.destroy();
        this.requestMapper = null;
        this.config = null;
        this.webApp = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy()");
        }
    }

    public synchronized void removeWebApplication(DeployedModule deployedModule) {
        if (this.webApp == null) {
            return;
        }
        this.destroy();
    }

    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WebGroup found --> " + this.getConfiguration().getContextRoot());
        }
        if (this.webApp == null) {
            throw new WebAppNotLoadedException(this.getConfiguration().getContextRoot());
        }
        this.webApp.handleRequest(servletRequest, servletResponse);
    }

    public static String stripURL(String string) {
        return WebGroup.stripURL(string, true);
    }

    public static String stripURL(String string, boolean bl) {
        int n;
        int n2 = string.indexOf(sessUrlRewritePrefix);
        if (bl && (n = string.indexOf(qMark)) != -1) {
            if (n2 > n) {
                throw new IllegalArgumentException("'jsessionid' Must occur before '?' in URL.");
            }
            string = string.substring(0, n);
        }
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        return string;
    }

    public static String decodeUri(String string) {
        int n = string.indexOf(sessUrlRewritePrefix);
        int n2 = string.indexOf(qMark);
        String string2 = null;
        if (n2 != -1 && n2 > n) {
            string2 = string.substring(n2);
        }
        if (n != -1) {
            string = string.substring(0, n);
            if (string2 != null) {
                string = string + string2;
            }
        }
        return string;
    }

    public ArrayList getWebApps() {
        ArrayList<WebApp> arrayList = new ArrayList<WebApp>();
        arrayList.add(this.webApp);
        return arrayList;
    }

    static {
        if (WebContainer.getWebContainerProperties().get("sessionrewriteidentifier") != null) {
            sessUrlRewritePrefix = ";" + WebContainer.getWebContainerProperties().get("sessionrewriteidentifier") + "=";
        }
    }
}

