/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.webapp;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.core.Request;
import com.ibm.ws.webcontainer.core.Response;
import com.ibm.ws.webcontainer.servlet.ServletMapping;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.srt.SRTRequestContext;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.util.UnsynchronizedStack;
import com.ibm.ws.webcontainer.util.WebContainerSystemProps;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.webapp.WebAppErrorReport;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import java.io.IOException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public abstract class WebAppDispatcherContext
implements Cloneable {
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private static TraceComponent tc = Tr.register(WebAppDispatcherContext.class, "Webcontainer", "com.ibm.ws.webcontainer.resources.Messages");
    protected UnsynchronizedStack _servletReferenceStack = new UnsynchronizedStack();
    private UnsynchronizedStack _exceptionStack = new UnsynchronizedStack();
    protected Request _request;
    protected SRTRequestContext reqContext = null;
    private WebAppDispatcherContext parentContext = null;
    private String relativeUri;
    private String _servletPath;
    private String _pathInfo;
    private String _requestUri;
    private String _contextPath = null;
    private String queryString = null;
    private boolean _useParent = false;
    private boolean enforceSecurity = true;
    private boolean _isInclude = false;
    private boolean isForward = false;
    private String decodedReqUri;
    private static final boolean redirectWithPathInfo = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.redirectwithpathinfo"));
    private static final boolean removeServletPathSlash = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.removetrailingservletpathslash"));
    private boolean possibleSlashStarMapping = true;
    protected WebApp _webapp;

    public void setParentContext(WebAppDispatcherContext webAppDispatcherContext) {
        this.parentContext = webAppDispatcherContext;
    }

    public void finish() {
        this.resetObject();
    }

    public void setIsInclude(boolean bl) {
        this._isInclude = bl;
    }

    public void setUseParent(boolean bl) {
        this._useParent = bl;
    }

    public boolean getIsInclude() {
        return this._isInclude;
    }

    public WebApp getWebApp() {
        return this._webapp;
    }

    public void initForNextDispatch(Request request) {
        this._request = request;
        if (request != null) {
            this.reqContext = ((SRTServletRequest)this._request).getRequestContext();
        }
    }

    public void pushServletReference(IServletWrapper iServletWrapper) {
        this._servletReferenceStack.push(iServletWrapper);
    }

    public void popServletReference() {
        this._servletReferenceStack.pop();
    }

    public IServletWrapper getCurrentServletReference() {
        return (IServletWrapper)this._servletReferenceStack.peek();
    }

    public Throwable getCurrentException() {
        if (this._exceptionStack.size() == 0) {
            return null;
        }
        return (Throwable)this._exceptionStack.peek();
    }

    public ServletRequest getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._request.getResponse();
    }

    void resetObject() {
        this._servletReferenceStack.clear();
        this._exceptionStack.clear();
        this._isInclude = false;
        this._pathInfo = null;
        this._servletPath = null;
        this._webapp = null;
        this.relativeUri = null;
        this.queryString = null;
        this._requestUri = null;
        this.isForward = false;
        this.enforceSecurity = true;
    }

    private IHttpSessionContext getSessionContext() {
        return this._webapp.getSessionContext();
    }

    public String getRequestedSessionId() {
        return this.getSessionContext().getRequestedSessionId((HttpServletRequest)((Object)this._request));
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.getSessionContext().isRequestedSessionIdFromCookie((HttpServletRequest)((Object)this._request));
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.getSessionContext().isRequestedSessionIdFromUrl((HttpServletRequest)((Object)this._request));
    }

    public void sessionPreInvoke() {
        this.reqContext.sessionPreInvoke(this._webapp);
    }

    public void sessionPostInvoke() {
        try {
            this.reqContext.sessionPostInvoke();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String encodeURL(String string) {
        return this.reqContext.encodeURL(this._webapp, (HttpServletRequest)((Object)this._request), string);
    }

    public String getRelativeUri() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getRelativeUri();
        }
        return this.relativeUri;
    }

    public void setRelativeUri(String string) {
        this.relativeUri = string;
    }

    public String getRealPath(String string) {
        return this.getWebApp().getRealPath(string);
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        String string2;
        String string3;
        String string4;
        if (string == null) {
            return null;
        }
        if (string.startsWith("/")) {
            return this.getWebApp().getRequestDispatcher(string);
        }
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        if ((string4 = (String)this._request.getAttribute("javax.servlet.include.servlet_path")) == null) {
            string3 = this.getPathInfo();
            string2 = this.getServletPath();
            if (string3 != null) {
                string2 = string2 + string3;
            }
        } else {
            string3 = (String)this._request.getAttribute("javax.servlet.include.path_info");
            string2 = string4;
            if (string3 != null) {
                string2 = string2 + string3;
            }
        }
        if (string2 != null) {
            int n = string2.indexOf(59);
            string2 = n == -1 ? string2.substring(0, string2.lastIndexOf("/")) : string2.substring(0, string2.lastIndexOf("/", n));
            string = string2 + '/' + string;
        } else {
            string = '/' + string;
        }
        return this.getWebApp().getRequestDispatcher(string);
    }

    public abstract Principal getUserPrincipal();

    public abstract boolean isUserInRole(String var1, HttpServletRequest var2);

    public String getPathInfo() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getPathInfo();
        }
        return this._pathInfo;
    }

    public void setPathInfo(String string) {
        this._pathInfo = string;
    }

    public String getRequestURI() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getRequestURI();
        }
        return this._requestUri;
    }

    public String getContextPath() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getContextPath();
        }
        String string = null;
        string = this._contextPath != null ? this._contextPath : this.getWebApp().getContextPath();
        if (string.equals("/")) {
            return "";
        }
        return string;
    }

    public String getPathTranslated() {
        String string = this.getPathInfo();
        if (string == null) {
            return null;
        }
        return this.getWebApp().getRealPath(string);
    }

    public String getServletPath() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getServletPath();
        }
        return this._servletPath;
    }

    public void setServletPath(String string) {
        this._servletPath = string;
    }

    public boolean isInclude() {
        return this.getIsInclude();
    }

    public void sendRedirect303(String string) throws IOException {
        this.sendRedirectWithStatusCode(string, 303);
    }

    public void sendRedirect(String string) throws IOException {
        this.sendRedirectWithStatusCode(string, 302);
    }

    private void sendRedirectWithStatusCode(String string, int n) throws IOException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)((Object)this.getResponse());
        if (!httpServletResponse.isCommitted()) {
            if (string == null) {
                throw new IllegalArgumentException("Location cannot be null in javax.servlet.http.HttpServletResponse.sendRedirect(location)");
            }
        } else {
            throw new IllegalStateException();
        }
        httpServletResponse.resetBuffer();
        string = this.convertRelativeURIToURL(string);
        httpServletResponse.setHeader("Location", string);
        httpServletResponse.setStatus(n);
        httpServletResponse.flushBuffer();
    }

    public void sendError(int n) throws IOException {
        IServletWrapper iServletWrapper = this.getCurrentServletReference();
        if (iServletWrapper != null) {
            this.sendError(n, MessageFormat.format(nls.getString("[{0}].reported.an.error", "[{0}] reported an error"), iServletWrapper.getServletName()));
        } else {
            this.sendError(n, MessageFormat.format(nls.getString("[{0}].reported.an.error", "[{0}] reported an error"), this.getWebApp().getConfiguration().getDisplayName()));
        }
    }

    public void sendError(int n, String string) throws IOException {
        if (this.getResponse().isCommitted()) {
            throw new IllegalStateException("Response already committed.");
        }
        this.getResponse().resetBuffer();
        int n2 = n;
        try {
            if (!this.getResponse().isCommitted()) {
                ((HttpServletResponse)((Object)this.getResponse())).setStatus(n2);
            }
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.webcontainer.webapp.WebAppDispatcherResponse.sendError", "112", this);
        }
        WebApp webApp = this.getWebApp();
        Object object = this.getRequest().getAttribute("com.ibm.ws.webcontainer.filter.filterproxyservletfilenotfound");
        if (object != null) {
            this.getRequest().removeAttribute("com.ibm.ws.webcontainer.filter.filterproxyservletfilenotfound");
            this.getWebApp().sendError((HttpServletRequest)((Object)this._request), (HttpServletResponse)((Object)this.getResponse()), (ServletErrorReport)object);
        } else {
            WebAppErrorReport webAppErrorReport = null;
            webAppErrorReport = new WebAppErrorReport(string);
            webAppErrorReport.setErrorCode(n2);
            IServletWrapper iServletWrapper = this.getCurrentServletReference();
            if (iServletWrapper != null) {
                webAppErrorReport.setTargetServletName(iServletWrapper.getServletName());
            }
            this.getWebApp().sendError((HttpServletRequest)((Object)this._request), (HttpServletResponse)((Object)this.getResponse()), webAppErrorReport);
        }
        this.getResponse().flushBuffer();
    }

    private String convertRelativeURIToURL(String string) {
        block18: {
            int n;
            if (string == null) {
                throw new IllegalStateException();
            }
            String string2 = string;
            int n2 = (string = string.trim()).indexOf("://");
            if (n2 != -1 && ((n = string.indexOf(63)) == -1 || n2 < n)) {
                return string;
            }
            String string3 = null;
            boolean bl = false;
            try {
                string3 = this.getWebApp().getContextPath().trim();
                if (!string3.startsWith("/")) {
                    string3 = "/" + string3;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webcontainer.webapp.WebAppDispatcherResponse.convertRelativeURIToURL", "184", this);
                string3 = "/";
            }
            try {
                bl = string.startsWith("/");
                if (string.startsWith("./")) {
                    string = string.substring(2);
                }
                Request request = this._request;
                String string4 = request.getScheme();
                int n3 = request.getServerPort();
                StringBuffer stringBuffer = new StringBuffer(string4);
                stringBuffer.append("://");
                stringBuffer.append(request.getServerName());
                if (string4.equals("http") && n3 != 80 || string4.equals("https") && n3 != 443) {
                    stringBuffer.append(":");
                    stringBuffer.append(n3);
                }
                String string5 = null;
                if (bl) {
                    if (WebContainerSystemProps.getSendRedirectCompatibilty()) {
                        stringBuffer.append(string3);
                        stringBuffer.append(string);
                    } else {
                        stringBuffer.append(string);
                    }
                    string5 = stringBuffer.toString();
                } else {
                    String string6 = HttpUtils.getRequestURL((HttpServletRequest)((Object)request)).toString();
                    String string7 = request.getPathInfo();
                    if (string7 != null && string7.length() > 0) {
                        if (!string7.startsWith("/")) {
                            string7 = "/" + string7;
                        }
                        string6 = redirectWithPathInfo ? string6.substring(0, string6.lastIndexOf("/")) : string6.substring(0, string6.lastIndexOf(string7));
                        string5 = string6 + "/" + string;
                    } else {
                        string5 = string6.substring(0, string6.lastIndexOf(47) + 1) + string;
                    }
                }
                if (string5.indexOf("..") > -1) {
                    int n4 = new String(string4 + "://").length();
                    int n5 = string5.indexOf("/", n4);
                    String string8 = string5.substring(0, n5);
                    String string9 = string5.substring(n5);
                    string9 = this.getWebApp().normalize(string9);
                    if (string9 != null) {
                        return string8 + string9;
                    }
                    break block18;
                }
                return string5;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webcontainer.webapp.WebAppDispatcherResponse.convertRelativeURIToURL", "256", this);
            }
        }
        return string;
    }

    public void callPage(String string, HttpServletRequest httpServletRequest) throws IOException, ServletException {
        ServletContext servletContext = this.getWebApp().getContext(string);
        WebApp webApp = (WebApp)servletContext;
        String string2 = string.substring(webApp.getContextPath().length());
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(string2);
        requestDispatcher.forward(httpServletRequest, this.getResponse());
    }

    public void _include(String string, HttpServletRequest httpServletRequest) throws IOException, ServletException {
        WebApp webApp = this.getWebApp();
        RequestDispatcher requestDispatcher = webApp.getRequestDispatcher(string);
        requestDispatcher.include(httpServletRequest, this.getResponse());
    }

    public void _forward(String string, HttpServletRequest httpServletRequest) throws IOException, ServletException {
        WebApp webApp = this.getWebApp();
        RequestDispatcher requestDispatcher = webApp.getRequestDispatcher(string);
        requestDispatcher.forward(httpServletRequest, this.getResponse());
    }

    public boolean isAutoRequestEncoding() {
        return this.getWebApp().getConfiguration().isAutoResponseEncoding();
    }

    public void setRequestURI(String string) {
        if (string == null) {
            this._requestUri = string;
            return;
        }
        int n = string.indexOf("?");
        if (n != -1) {
            this.queryString = string.substring(n + 1);
            this._requestUri = string.substring(0, n);
        } else {
            this._requestUri = string;
        }
    }

    public void setPathElements(String string, String string2) {
        ((SRTServletRequest)this._request).resetPathElements();
        if (removeServletPathSlash) {
            boolean bl = false;
            boolean bl2 = this.isPossibleSlashStarMapping();
            if (bl2) {
                bl = this.hasSlashStarMapping();
            }
            if (bl) {
                this._servletPath = "";
                this._pathInfo = string == null ? string2 : (string2 == null ? string : string + string2);
            } else if (bl2) {
                if (string == null || string.equals("")) {
                    this._servletPath = string2;
                    this._pathInfo = null;
                } else {
                    this._servletPath = string;
                    this._pathInfo = string2;
                }
            } else {
                this._servletPath = string;
                this._pathInfo = string2;
            }
            if (this._servletPath != null && this._servletPath.length() > 1 && this._servletPath.endsWith("/")) {
                this._servletPath = this._servletPath.substring(0, this._servletPath.length() - 1);
                this._pathInfo = this._pathInfo == null ? "/" : "/" + this._pathInfo;
            }
        } else if (string.length() == 1 && string.charAt(0) == '/') {
            this._servletPath = "";
            this._pathInfo = string2 == null ? "/" : "/" + string2;
        } else {
            this._servletPath = string;
            this._pathInfo = string2;
        }
        this.relativeUri = this._servletPath;
        if (this._pathInfo != null) {
            this.relativeUri = this.relativeUri + this._pathInfo;
        }
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setForward(boolean bl) {
        this.isForward = bl;
    }

    public String getQueryString() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getQueryString();
        }
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public void pushException(Throwable throwable) {
        this._exceptionStack.push(throwable);
    }

    public void setWebApp(WebApp webApp) {
        this._webapp = webApp;
        if (this.reqContext != null) {
            this.reqContext.setCurrWebAppBoundary(webApp);
        }
    }

    public void setContextPath(String string) {
        this._contextPath = string;
    }

    public boolean isEnforceSecurity() {
        return this.enforceSecurity;
    }

    public void setEnforceSecurity(boolean bl) {
        this.enforceSecurity = bl;
    }

    public void setDecodedReqUri(String string) {
        this.decodedReqUri = string;
    }

    public String getDecodedReqUri() {
        return this.decodedReqUri;
    }

    public boolean isSecurityEnabledForApplication() {
        return SecurityContext.isSecurityEnabled();
    }

    public void dumpDispatchContextHierarchy() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "current context -->" + this);
            WebAppDispatcherContext webAppDispatcherContext = this.parentContext;
            while (webAppDispatcherContext != null) {
                Tr.debug(tc, "parent context -->" + webAppDispatcherContext);
                webAppDispatcherContext = webAppDispatcherContext.parentContext;
            }
        }
    }

    public Object clone(SRTServletRequest sRTServletRequest, SRTRequestContext sRTRequestContext) throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "clone entry");
        }
        WebAppDispatcherContext webAppDispatcherContext = (WebAppDispatcherContext)super.clone();
        webAppDispatcherContext._request = sRTServletRequest;
        webAppDispatcherContext.reqContext = sRTRequestContext;
        if (this._servletReferenceStack != null) {
            webAppDispatcherContext._servletReferenceStack = (UnsynchronizedStack)this._servletReferenceStack.clone();
        }
        if (this._exceptionStack != null) {
            webAppDispatcherContext._exceptionStack = (UnsynchronizedStack)this._exceptionStack.clone();
        }
        if (this.parentContext != null) {
            webAppDispatcherContext.parentContext = (WebAppDispatcherContext)this.parentContext.clone(sRTServletRequest, sRTRequestContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "clone exit original -->" + this + " cloned -->" + webAppDispatcherContext);
        }
        return webAppDispatcherContext;
    }

    public boolean hasSlashStarMapping() {
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasSlashStarMapping");
        }
        boolean bl = false;
        WebAppConfiguration webAppConfiguration = null;
        WebApp webApp = this._webapp;
        if (webApp != null) {
            webAppConfiguration = webApp.getConfiguration();
        }
        if (webAppConfiguration != null && (hashMap = webAppConfiguration.getServletMappings()) != null) {
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            block0: while (iterator.hasNext()) {
                List list = (List)hashMap.get(iterator.next());
                if (list == null) continue;
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    ServletMapping servletMapping = (ServletMapping)iterator2.next();
                    if (servletMapping == null || !"/*".equals(servletMapping.getUrlPattern())) continue;
                    bl = true;
                    continue block0;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasSlashStarMapping isSlashStar: " + bl);
        }
        return bl;
    }

    public void setPossibleSlashStarMapping(boolean bl) {
        this.possibleSlashStarMapping = bl;
    }

    public boolean isPossibleSlashStarMapping() {
        return this.possibleSlashStarMapping;
    }
}

