/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DecimalFormat;

public class WSURLDecoder {
    private static final int STATE_NORMAL_CHAR = 0;
    private static final int STATE_START_DECODE = 1;
    private static final int STATE_DECODE_FIRST_DIGIT = 2;
    private static final int STATE_DECODE_SECOND_DIGIT = 3;
    private static final int STATE_FINISH_DECODE = 4;
    private static final String ERROR_INCOMPLETE = "URLDecoder: Incomplete trailing escape (%) pattern";
    private static final String ERROR_ILLEGAL = "URLDecoder: Illegal hex characters in escape (%) pattern";

    public static String decode(String string, String string2) throws UnsupportedEncodingException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (string.length() == 0) {
            throw new UnsupportedEncodingException();
        }
        char[] cArray = string.toCharArray();
        int n5 = cArray.length;
        byte[] byArray = new byte[n5];
        StringBuffer stringBuffer = new StringBuffer(n5);
        block24: for (int i = 0; i < n5; ++i) {
            char c = cArray[i];
            switch (n4) {
                case 0: {
                    if (c != '%') continue block24;
                    n4 = 2;
                    stringBuffer.append(cArray, n, i - n);
                    continue block24;
                }
                case 2: {
                    switch (c) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            n2 = 16 * (c - 48);
                            break;
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': {
                            n2 = 16 * (c - 55);
                            break;
                        }
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            n2 = 16 * (c - 87);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(ERROR_ILLEGAL);
                        }
                    }
                    n4 = 3;
                    continue block24;
                }
                case 3: {
                    switch (c) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            n2 += c - 48;
                            break;
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': {
                            n2 += c - 55;
                            break;
                        }
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            n2 += c - 87;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(ERROR_ILLEGAL);
                        }
                    }
                    byArray[n3++] = (byte)n2;
                    n4 = 4;
                    continue block24;
                }
                case 4: {
                    switch (c) {
                        case '%': {
                            n4 = 2;
                            continue block24;
                        }
                    }
                    stringBuffer.append(new String(byArray, 0, n3, string2));
                    n3 = 0;
                    n = i;
                    n4 = 0;
                }
            }
        }
        switch (n4) {
            case 0: {
                stringBuffer.append(cArray, n, n5 - n);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                throw new IllegalArgumentException(ERROR_INCOMPLETE);
            }
            case 4: {
                stringBuffer.append(new String(byArray, 0, n3, string2));
            }
        }
        return stringBuffer.toString();
    }

    private static void testDecode(String string, String string2, int n, int n2) throws Exception {
        int n3;
        int n4;
        long l = 0L;
        long l2 = 0L;
        double d = 0.0;
        double d2 = 0.0;
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        System.out.println("Encoding url: '" + string + "', encoding: " + string2);
        for (n4 = 0; n4 < n2; ++n4) {
            if (n4 == n2 - 1) {
                l = System.currentTimeMillis();
            }
            for (n3 = 0; n3 < n; ++n3) {
                URLDecoder.decode(string, string2);
            }
            if (n4 != n2 - 1) continue;
            l2 = System.currentTimeMillis();
        }
        d = l2 - l;
        System.out.println("java.net.WSURLDecoder result: '" + URLDecoder.decode(string, string2) + "'");
        System.out.println("java.net.WSURLDecoder time, " + n + " repetitions after " + n2 + " runs: " + d + "ms\n");
        for (n4 = 0; n4 < n2; ++n4) {
            if (n4 == n2 - 1) {
                l = System.currentTimeMillis();
            }
            for (n3 = 0; n3 < n; ++n3) {
                WSURLDecoder.decode(string, string2);
            }
            if (n4 != n2 - 1) continue;
            l2 = System.currentTimeMillis();
        }
        d2 = l2 - l;
        System.out.println("webcontainer WSURLDecoder result: '" + WSURLDecoder.decode(string, string2) + "'");
        System.out.println("webcontainer WSURLDecoder time, " + n + " repetitions after " + n2 + " runs: " + d2 + "ms");
        System.out.println("webcontainer WSURLDecoder performance difference: " + decimalFormat.format((d - d2) / d * 100.0) + "%\n");
    }

    public static void main(String[] stringArray) throws Exception {
        WSURLDecoder.testDecode("a", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("ab", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("abc", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("abcd", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("abcde", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("abcdef", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("this/is/a/short/url/with/no/encoded/chars", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("this/is/a/looooooooooooooooonger/url/with/no/encoded/chars", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("this/is/a/muuuuuuuuuuuuuuuuuuuuuuuuuuuuch/looooooooooooooooooooooooooooooonger/url/with/no/encoded/chars/and/some+plus+characters", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("this/is/a/short/url/with/some/%65%66%67%68%69/encoded/chars", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("this/%65%66%67%68%69/is/%65%66%67%68%69/a/%65%66%67%68%69/longer/%65%66%67%68%69/url/with/scattered/%65%66%67%68%69/encoded/chars", "UTF-8", 100000, 5);
        WSURLDecoder.testDecode("this/%65%66%67%68%69/is/%65%66%67%68%69/a/%65%66%67%68%69/longer/%65%66%67%68%69/url/with/scattered/%65%66%67%68%69/encoded/chars/and/ends/with/encoded/chars/%65%66%67%68%69", "UTF-8", 100000, 5);
    }
}

