/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.util.EventListenerV;
import java.util.EventListener;
import java.util.EventObject;

public class EventListeners {
    private static final EventListener[] EMPTY_LISTENERS = new EventListener[0];
    private static TraceComponent tc = Tr.register(EventListeners.class, "Webcontainer", "com.ibm.ws.webcontainer.resources.Messages");
    private EventListener[] listeners = EMPTY_LISTENERS;

    public final EventListener[] getListenerArray() {
        return this.listeners;
    }

    public final void fireEvent(EventObject eventObject, EventListenerV eventListenerV) {
        EventListener[] eventListenerArray = this.getListenerArray();
        for (int i = 0; i < eventListenerArray.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Use visitor " + eventListenerV + " to fire event to " + eventListenerArray[i] + ", class:" + eventListenerArray[i].getClass());
            }
            eventListenerV.fireEvent(eventObject, eventListenerArray[i]);
        }
    }

    public final int getListenerCount() {
        return this.listeners.length;
    }

    public final synchronized void addListener(EventListener eventListener) {
        if (eventListener == null) {
            throw new IllegalArgumentException("Listener " + eventListener + " is null");
        }
        if (this.listeners == EMPTY_LISTENERS) {
            this.listeners = new EventListener[1];
            this.listeners[0] = eventListener;
        } else {
            int n = this.listeners.length;
            EventListener[] eventListenerArray = new EventListener[n + 1];
            System.arraycopy(this.listeners, 0, eventListenerArray, 0, n);
            eventListenerArray[n] = eventListener;
            this.listeners = eventListenerArray;
        }
    }

    public final synchronized void removeListener(EventListener eventListener) {
        if (eventListener == null) {
            throw new IllegalArgumentException("Listener " + eventListener + " is null");
        }
        int n = -1;
        for (int i = this.listeners.length - 1; i >= 0; --i) {
            if (!this.listeners[i].equals(eventListener)) continue;
            n = i;
            break;
        }
        if (n != -1) {
            EventListener[] eventListenerArray = new EventListener[this.listeners.length - 1];
            System.arraycopy(this.listeners, 0, eventListenerArray, 0, n);
            if (n < eventListenerArray.length) {
                System.arraycopy(this.listeners, n + 1, eventListenerArray, n, eventListenerArray.length - n);
            }
            this.listeners = eventListenerArray.length == 0 ? EMPTY_LISTENERS : eventListenerArray;
        }
    }

    public String toString() {
        EventListener[] eventListenerArray = this.getListenerArray();
        String string = "EventListenerList: ";
        string = string + this.getListenerCount() + " listeners: ";
        for (int i = 0; i < eventListenerArray.length; ++i) {
            string = string + " listener " + eventListenerArray[i] + "\n";
        }
        return string;
    }
}

