/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.webcontainer.srt.SRTServletResponse;
import com.ibm.wsspi.webcontainer.util.WSServletInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HttpInputStream
extends WSServletInputStream {
    protected InputStream in;
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int total;
    protected int limit;
    protected int length;
    private static TraceComponent tc = Tr.register(HttpInputStream.class, "Webcontainer", "com.ibm.ws.webcontainer.resources.Messages");
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");

    public HttpInputStream(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Constructor --> " + n);
        }
        this.buf = new byte[n];
    }

    public HttpInputStream() {
        this(512);
    }

    public void init(InputStream inputStream) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "init");
        }
        this.in = inputStream;
        this.next();
    }

    public void next() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "next");
        }
        this.length = -1;
        this.limit = Integer.MAX_VALUE;
        this.total = 0;
        this.count = 0;
        this.pos = 0;
    }

    public void finish() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "finish");
        }
        if (!SRTServletResponse.isSkipInputStreamRead() && this.length != -1) {
            int n;
            for (int i = this.limit - this.total; i > 0; i -= n) {
                n = (int)this.skip(i);
                if (n != 0) continue;
                throw new IOException(nls.getString("Invalid.Content.Length", "Invalid content length"));
            }
        }
    }

    public void resets() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "resets");
        }
        this.in = null;
    }

    public int getTotal() {
        return this.total;
    }

    public void setContentLength(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setContentLength --> " + n);
        }
        if (n < 0) {
            Tr.error(tc, "Illegal Argument: Invalid Content Length");
            throw new IllegalArgumentException(nls.getString("Illegal.Argument.Invalid.Content.Length", "Illegal Argument: Invalid Content Length"));
        }
        this.length = n;
        if (Integer.MAX_VALUE - this.total > n) {
            this.limit = this.total + n;
        }
    }

    public int getContentLength() {
        return this.length;
    }

    public int read() throws IOException {
        if (this.total >= this.limit) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Over the limit: -1");
            }
            return -1;
        }
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, this.pos + " >= " + this.count + " : -1");
                }
                return -1;
            }
        }
        ++this.total;
        return this.buf[this.pos++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "read length -->" + n2);
        }
        if ((n3 = this.count - this.pos) > 0) {
            if (n3 >= n2) {
                System.arraycopy(this.buf, this.pos, byArray, n, n2);
                this.pos += n2;
                this.total += n2;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "read returning -->" + n2);
                }
                return n2;
            }
            System.arraycopy(this.buf, this.pos, byArray, n, n3);
            this.pos = 0;
            this.count = 0;
            n += n3;
            n2 -= n3;
        }
        int n4 = n3;
        int n5 = 0;
        if (n2 > 0) {
            n5 = this.in.read(byArray, n, n2);
        }
        if (n5 > 0) {
            n4 += n5;
        }
        this.total += n4;
        if (n4 == 0) {
            n4 = -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "read returning -->" + n4);
        }
        return n4;
    }

    public int readLine(byte[] byArray, int n, int n2) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "readLine");
        }
        if (this.total >= this.limit) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "readLine Over the limit: -1");
            }
            return -1;
        }
        int n3 = 0;
        n3 = n2;
        int n4 = this.count - this.pos;
        if (n4 <= 0) {
            this.fill();
            n4 = this.count - this.pos;
            if (n4 <= 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "readLine avail less than 0: -1");
                }
                return -1;
            }
        }
        int n5 = n4 < n2 ? n4 : n2;
        int n6 = HttpInputStream.copyLine(this.buf, this.pos, byArray, n, n5);
        this.pos += n6;
        this.total += n6;
        n3 -= n6;
        int n7 = n6;
        if (n7 == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "readLine totalRead is 0: -1");
            }
            return -1;
        }
        while (n3 > 0 && byArray[n + n7 - 1] != 10) {
            this.fill();
            n4 = this.count - this.pos;
            if (n4 <= 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "readLine returning --> " + n7);
                }
                return n7;
            }
            n5 = n4 < n3 ? n4 : n3;
            n6 = HttpInputStream.copyLine(this.buf, this.pos, byArray, n + n7, n5);
            this.pos += n6;
            this.total += n6;
            n3 -= n6;
            n7 += n6;
        }
        return n7;
    }

    private static int copyLine(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "copyLine");
        }
        int n4 = n;
        while (n3-- > 0 && byArray[n4++] != 10) {
        }
        System.arraycopy(byArray, n, byArray2, n2, n4 - n);
        return n4 - n;
    }

    public long skip(long l) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "skip");
        }
        if (this.total >= this.limit) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Total over limit: 0");
            }
            return 0L;
        }
        long l2 = l;
        while (l2 > 0L) {
            int n = this.count - this.pos;
            if (n <= 0) {
                this.fill();
                n = this.count - this.pos;
                if (n <= 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "skip avail < 0: " + (l - l2));
                    }
                    return l - l2;
                }
            }
            if (l2 < (long)n) {
                n = (int)l2;
            }
            l2 -= (long)n;
            this.pos += n;
            this.total += n;
        }
        return l;
    }

    public int available() throws IOException {
        return Math.min(this.count - this.pos + this.in.available(), this.limit - this.total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "close");
        }
        try {
            this.finish();
        }
        finally {
            this.in.close();
        }
    }

    protected void fill() throws IOException {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "fill");
        }
        if ((n = Math.min(this.buf.length, this.limit - this.total)) > 0 && (n = this.in.read(this.buf, 0, n)) > 0) {
            this.pos = 0;
            this.count = n;
        }
    }
}

