/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.core.Request;
import com.ibm.ws.webcontainer.core.Response;
import com.ibm.ws.webcontainer.srt.IExtendedResponse;
import com.ibm.ws.webcontainer.srt.SRTConnectionContext;
import com.ibm.ws.webcontainer.srt.SRTOutputStream;
import com.ibm.ws.webcontainer.srt.http.HttpDate;
import com.ibm.wsspi.webcontainer.IResponse;
import com.ibm.wsspi.webcontainer.servlet.IServletResponse;
import com.ibm.wsspi.webcontainer.util.BufferedServletOutputStream;
import com.ibm.wsspi.webcontainer.util.BufferedWriter;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import com.ibm.wsspi.webcontainer.util.IOutputStreamObserver;
import com.ibm.wsspi.webcontainer.util.IResponseOutput;
import com.ibm.wsspi.webcontainer.util.ResponseBuffer;
import com.ibm.wsspi.webcontainer.util.WSServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SRTServletResponse
implements HttpServletResponse,
IResponseOutput,
IExtendedResponse,
IServletResponse,
Response,
IOutputStreamObserver {
    private static boolean skipInputStreamRead = false;
    private boolean isCharEncodingExplicit;
    private static final byte[] REASON_OK = "OK".getBytes();
    private static final String CONTENT_LANGUAGE_HEADER = "Content-Language";
    private static final byte[] CONTENT_LANGUAGE_HEADER_BYTES = "Content-Language".getBytes();
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final byte[] HEADER_CONTENT_TYPE_BYTES = "Content-Type".getBytes();
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final byte[] HEADER_CONTENT_LENGTH_BYTES = "Content-Length".getBytes();
    private static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final byte[] HEADER_CONTENT_ENCODING_BYTES = "Content-Encoding".getBytes();
    private static final boolean keepContentLength = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("keepcontentlength"));
    private static final boolean skipHeaderFlush = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.skipheaderflush"));
    private static final String contentTypeCompatibility = WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.contenttypecompatibility");
    protected static final TraceComponent tc = Tr.register(SRTServletResponse.class, "Webcontainer", "com.ibm.ws.webcontainer.resources.Messages");
    protected static final NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final Locale _defaultLocale = Locale.getDefault();
    public static final String _defaultEncoding = "ISO-8859-1";
    protected IResponse _response = null;
    protected boolean writerClosed = false;
    protected SRTOutputStream _rawOut = new SRTOutputStream();
    protected ResponseBuffer _responseBuffer = null;
    protected WSServletOutputStream _bufferedOut;
    protected BufferedWriter _bufferedWriter = new BufferedWriter(4096);
    protected PrintWriter _pwriter;
    protected boolean _firstWrite = false;
    protected boolean _firstWriteToCurrentBuffer = false;
    protected int _bufferSize = 4096;
    protected boolean _gotWriter = false;
    protected boolean _gotOutputStream = false;
    protected OutputStreamWriter _outWriter = null;
    protected String _outWriterEncoding;
    protected boolean writerException = false;
    protected boolean _ignoreStateErrors;
    protected boolean _headersWritten = false;
    protected Locale _locale;
    protected String _encoding;
    protected int _contentLength = -1;
    protected int _statusCode = 200;
    private SRTConnectionContext _connContext;

    public SRTServletResponse() {
        this._bufferedOut = this.createOutputStream(4096);
        this._bufferedWriter.setObserver(this);
        this._bufferedOut.setObserver(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "outputstream is of type --> " + this._bufferedOut);
        }
    }

    public SRTServletResponse(SRTConnectionContext sRTConnectionContext) {
        this();
        this._connContext = sRTConnectionContext;
    }

    public void alertClose() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "alertClose _outWriter: --> " + this._outWriter + " : " + this);
        }
        this.writerClosed = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "alertClose");
        }
    }

    public void alertFirstWrite() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "alertFirstWrite : " + this);
        }
        this._firstWrite = true;
        this._firstWriteToCurrentBuffer = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "alertFirstWrite");
        }
    }

    public void alertFirstFlush() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "alertFirstFlush : " + this);
        }
        if (!this.isCommitted()) {
            this.commit();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "alertFirstFlush");
        }
    }

    public void alertException() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "alertException  _outWriter: --> " + this._outWriter + " : " + this);
        }
        this.writerException = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "alertException");
        }
    }

    public boolean writerObtained() {
        return this._gotWriter;
    }

    public boolean outputStreamObtained() {
        return this._gotOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finish : " + this);
        }
        if (!this.isCommitted()) {
            this.commit();
        }
        try {
            try {
                this.flushBuffer(false);
                this._rawOut.close();
            }
            catch (IOException iOException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Servlet.Exception:.Error.while.finishing.response", iOException);
                }
                Object var3_2 = null;
                this._rawOut.reset();
                this._response = null;
                this._bufferSize = 4096;
                this._encoding = null;
                this._bufferedOut.reset();
                this._bufferedWriter.reset();
                this._responseBuffer = null;
                this._gotOutputStream = false;
                this._gotWriter = false;
                this._pwriter = null;
                this._responseBuffer = null;
            }
            Object var3_1 = null;
            this._rawOut.reset();
            this._response = null;
            this._bufferSize = 4096;
            this._encoding = null;
            this._bufferedOut.reset();
            this._bufferedWriter.reset();
            this._responseBuffer = null;
            this._gotOutputStream = false;
            this._gotWriter = false;
            this._pwriter = null;
            this._responseBuffer = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._rawOut.reset();
            this._response = null;
            this._bufferSize = 4096;
            this._encoding = null;
            this._bufferedOut.reset();
            this._bufferedWriter.reset();
            this._responseBuffer = null;
            this._gotOutputStream = false;
            this._gotWriter = false;
            this._pwriter = null;
            this._responseBuffer = null;
            throw throwable;
        }
        this.resetState();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finish");
        }
    }

    protected void resetState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resetState");
        }
        this._headersWritten = false;
        this._firstWrite = false;
        this._firstWriteToCurrentBuffer = false;
        this._ignoreStateErrors = false;
        this._contentLength = -1;
        this._locale = _defaultLocale;
        this.writerClosed = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resetState");
        }
    }

    public void addField(String string, String string2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "addField : " + this);
        }
        this._response.addHeader(string, string2);
    }

    public void addDateField(String string, long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "addDateField : " + this);
        }
        this._response.addDateHeader(string, l);
    }

    public void addIntField(String string, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "addIntField : " + this);
        }
        this._response.addIntHeader(string, n);
    }

    protected String getHeader(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeader name --> " + string + " response --> " + this._response.getHeader(string));
        }
        return this._response.getHeader(string);
    }

    public IResponse getIResponse() {
        return this._response;
    }

    protected String getHeader(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeader name --> " + (byArray != null ? new String(byArray) : "") + " response --> " + this._response.getHeader(byArray));
        }
        return this._response.getHeader(byArray);
    }

    public boolean containsHeader(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "containsHeader name --> " + string + " response --> " + String.valueOf(this._response.containsHeader(string)) + " : " + this);
        }
        return this._response.containsHeader(string);
    }

    public boolean containsHeader(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "containsHeader name --> " + (byArray != null ? new String(byArray) : "") + " response --> " + String.valueOf(this._response.containsHeader(byArray)) + " : " + this);
        }
        return this._response.containsHeader(byArray);
    }

    protected void removeHeader(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeHeader name --> " + string);
        }
        this._response.removeHeader(string);
    }

    protected void removeHeader(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeHeader name --> " + (byArray != null ? new String(byArray) : ""));
        }
        this._response.removeHeader(byArray);
    }

    public void resetBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resetBuffer : " + this);
        }
        if (this._responseBuffer != null) {
            this._responseBuffer.clearBuffer();
        }
        if (this._bufferedWriter != null) {
            this._bufferedWriter.clearBuffer();
        }
        this._firstWriteToCurrentBuffer = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resetBuffer");
        }
    }

    public void closeResponseOutput() {
        if (!this.writerClosed) {
            this._response.setFlushMode(false);
            try {
                if (this._gotOutputStream) {
                    this._bufferedOut.flush();
                } else if (this._gotWriter) {
                    this._pwriter.flush();
                }
            }
            catch (Throwable throwable) {
                Tr.error(tc, "Error while flushing last response");
            }
            this._response.setFlushMode(true);
            try {
                if (this._gotOutputStream) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "setLastBuffer to true ");
                    }
                    this._response.setLastBuffer(true);
                    this._bufferedOut.close();
                    this._rawOut.close();
                } else if (this._gotWriter) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "setLastBuffer to true ");
                    }
                    this._response.setLastBuffer(true);
                    this._pwriter.close();
                    this._rawOut.close();
                }
            }
            catch (Throwable throwable) {
                Tr.error(tc, "Error while closing response output.");
            }
        }
    }

    public void setIgnoreStateErrors(boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setIgnoreStateErrors --> " + String.valueOf(bl) + " : " + this);
        }
        this._ignoreStateErrors = bl;
    }

    public void setBufferSize(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setBufferSize - " + String.valueOf(n) + " : " + this);
        }
        this._bufferSize = n;
        if (this._responseBuffer != null) {
            if (!this._firstWrite) {
                this._responseBuffer.setBufferSize(n);
            } else {
                Tr.error(tc, "setbuffer.size.called.after.write");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "setBufferSize");
                }
                throw new IllegalStateException("setBufferSize() called after first write to Output Stream/Writer");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setBufferSize");
        }
    }

    public int getBufferSize() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getBufferSize : " + this);
        }
        if (this._responseBuffer == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getBufferSize");
            }
            return this._bufferSize;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getBufferSize");
        }
        return this._responseBuffer.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.flushBuffer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBuffer(boolean bl) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "flushBuffer : " + this);
        }
        boolean bl2 = false;
        if (!bl) {
            this._response.setFlushMode(false);
        }
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "flushBuffer: _firstWriteToCurrentBuffer->" + this._firstWriteToCurrentBuffer + ", skipHeaderFlush->" + skipHeaderFlush);
            }
            if (this._firstWriteToCurrentBuffer || skipHeaderFlush) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "flushBuffer: we've written output so flush");
                }
                if (this._pwriter != null && !this.writerClosed) {
                    this._pwriter.flush();
                    bl2 = true;
                }
                if (this._gotOutputStream) {
                    this._responseBuffer.flushBuffer();
                    bl2 = true;
                }
            }
            if (!this.isCommitted() && !bl2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "flushBuffer: Not committed, so write headers");
                }
                this.commit();
                this._response.writeHeaders();
            }
        }
        finally {
            if (!bl) {
                this._response.setFlushMode(true);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "flushBuffer");
        }
    }

    public boolean isCommitted() {
        if (this._headersWritten) {
            return true;
        }
        if (this._gotWriter || this._gotOutputStream) {
            if (this._responseBuffer == null) {
                return false;
            }
            return this._responseBuffer.isCommitted();
        }
        return false;
    }

    public Request getRequest() {
        return this._connContext.getRequest();
    }

    public ServletOutputStream getOutputStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutputStream : " + this);
        }
        if (!this._ignoreStateErrors && this._gotWriter) {
            throw new IllegalStateException(nls.getString("Writer.already.obtained", "Writer already obtained"));
        }
        this._gotOutputStream = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutputStream");
        }
        this._bufferedOut.init(this._rawOut, this.getBufferSize());
        this._bufferedOut.setLimit(this._contentLength);
        this._bufferedOut.setResponse(this._response);
        this._responseBuffer = this._bufferedOut;
        return this._bufferedOut;
    }

    public PrintWriter getWriter() throws IOException, UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWriter : " + this);
        }
        if (!this._ignoreStateErrors && this._gotOutputStream) {
            throw new IllegalStateException(nls.getString("OutputStream.already.obtained", "OutputStream already obtained"));
        }
        if (!this._gotWriter) {
            String string;
            String string2 = this.getCharacterEncoding();
            if ((contentTypeCompatibility == null || !contentTypeCompatibility.equalsIgnoreCase("V4") && !contentTypeCompatibility.equalsIgnoreCase("V5")) && (string = this.getContentType()) != null && string.indexOf("charset") == -1 && string.startsWith("text")) {
                if (string.endsWith(";")) {
                    this.setContentType(string + "charset=" + string2);
                } else {
                    this.setContentType(string + ";charset=" + string2);
                }
            }
            if (this._outWriter == null || this.writerException || !string2.equals(this._outWriterEncoding)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this.writerException) {
                    Tr.debug(tc, "writerException: " + this.writerException + "--> creating new OutputStreamWriter");
                }
                this._outWriter = new OutputStreamWriter((OutputStream)this._rawOut, EncodingUtils.getJvmConverter(string2));
                this._outWriterEncoding = string2;
                this.writerException = false;
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "reusing _outWriter: --> " + this._outWriter);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "created writer with encoding: " + this._outWriter.getEncoding());
            }
            this._bufferedWriter.init(this._outWriter, this.getBufferSize());
            this._bufferedWriter.setLimit(this._contentLength);
            this._bufferedWriter.setResponse(this._response);
            this._pwriter = new PrintWriter((Writer)this._bufferedWriter, false);
            this._responseBuffer = this._bufferedWriter;
            this._gotWriter = true;
            this.writerClosed = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWriter");
        }
        return this._pwriter;
    }

    public void start() {
        this.setDefaultResponseEncoding();
    }

    protected SRTConnectionContext getConnectionContext() {
        return this._connContext;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void addCookie(Cookie cookie) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding cookie --> " + cookie.getName() + " : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addCookie cookie --> " + cookie.getName());
            }
        } else if (!this._ignoreStateErrors && this.isCommitted()) {
            Tr.warning(tc, "WARNING: Cannot set header. Response already committed.");
        } else {
            this._response.addCookie(cookie);
        }
    }

    protected synchronized void commit() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "commit");
        }
        if (!this._headersWritten && !this.isCommitted()) {
            this.addLocaleHeader();
            if (this.containsHeader(HEADER_CONTENT_ENCODING_BYTES) && this.containsHeader(HEADER_CONTENT_LENGTH_BYTES)) {
                if (keepContentLength) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "WebContainer custom property set to keep Content-Length header w/presence of Content-Encoding header");
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Content-Length header disallowed w/presence of Content-Encoding header");
                    }
                    this.removeHeader(HEADER_CONTENT_LENGTH_BYTES);
                }
            }
            WebContainer.notifyHttpServletResponseListenersPreHeaderCommit((HttpServletRequest)((Object)this._connContext.getRequest()), this);
            this._response.prepareHeadersForWrite();
            this._headersWritten = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "commit");
        }
    }

    private void addLocaleHeader() {
        this._response.setContentLanguage(this._locale.toString().replace('_', '-'));
    }

    public String encodeRedirectUrl(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "encodeRedirectUrl : " + this);
        }
        return this.encodeURL(string);
    }

    public String encodeRedirectURL(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "encodeRedirectURL : " + this);
        }
        return this.encodeURL(string);
    }

    public String encodeUrl(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "encodeUrl : " + this);
        }
        return this.encodeURL(string);
    }

    public String encodeURL(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "encodeURL url --> " + string + " : " + this);
        }
        return this.getRequest().getWebAppDispatcherContext().encodeURL(string);
    }

    protected void setDefaultResponseEncoding() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting the default response encoding");
        }
        if (this.getRequest().getWebAppDispatcherContext().getWebApp().getConfiguration().isAutoResponseEncoding()) {
            this._locale = this.getRequest().getLocale();
            if (this._locale == null) {
                this._locale = _defaultLocale;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "_locale is null: default to " + this._locale.toString());
                }
            }
            this._encoding = this.getRequest().getCharacterEncoding();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Encoding from request: " + this._encoding);
            }
            if (this._encoding != null && !EncodingUtils.isCharsetSupported(this._encoding)) {
                this._encoding = null;
            }
            if (this._encoding == null) {
                this._encoding = this.getRequest().getWebAppDispatcherContext().getWebApp().getConfiguration().getLocaleEncoding(this._locale);
                if (this._encoding == null) {
                    this._encoding = EncodingUtils.getEncodingFromLocale(this._locale);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Encoding from locale: " + this._encoding);
                    }
                    if (this._encoding == null) {
                        this._encoding = _defaultEncoding;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "_encoding is null: default to " + this._encoding);
                        }
                    }
                }
            }
            this.setContentType("text/html; charset=" + this._encoding);
        } else {
            this._locale = _defaultLocale;
            this._encoding = _defaultEncoding;
            if (contentTypeCompatibility != null) {
                if (contentTypeCompatibility.equalsIgnoreCase("V4")) {
                    this.setContentType("text/html");
                } else if (contentTypeCompatibility.equalsIgnoreCase("V5")) {
                    this.setContentType("text/html; charset=" + this._encoding);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "_locale: " + this._locale.toString());
            Tr.debug(tc, "_encoding: " + this._encoding);
        }
    }

    public void reset() {
        this._response.setReason(REASON_OK);
        this._response.setStatusCode(200);
        if (this._responseBuffer != null) {
            this._responseBuffer.clearBuffer();
        }
        if (this._bufferedWriter != null) {
            this._bufferedWriter.clearBuffer();
        }
        this._response.clearHeaders();
        this.resetState();
        this.setDefaultResponseEncoding();
    }

    public String getCharacterEncoding() {
        if (this._encoding == null) {
            this.setDefaultResponseEncoding();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getCharacterEncoding encoding --> " + this._encoding + " : " + this);
        }
        return this._encoding;
    }

    public String getContentType() {
        if (this.containsHeader(HEADER_CONTENT_TYPE_BYTES)) {
            return this.getHeader(HEADER_CONTENT_TYPE_BYTES);
        }
        return null;
    }

    public void setCharacterEncoding(String string) {
        String string2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setCharacterEncoding encoding --> " + string + " : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setCharacterEncoding encoding --> " + string);
            }
            return;
        }
        if (this._gotWriter || this._headersWritten) {
            return;
        }
        if (string != null) {
            string2 = "'";
            String string3 = "\"";
            if (string.startsWith(string2) || string.startsWith(string3)) {
                string = string.substring(1);
            }
            if (string.endsWith(string2) || string.endsWith(string3)) {
                string = string.substring(0, string.length() - 1);
            }
            this._encoding = string;
            this.isCharEncodingExplicit = true;
        }
        if (this.containsHeader(HEADER_CONTENT_TYPE_BYTES)) {
            string2 = this.getHeader(HEADER_CONTENT_TYPE_BYTES);
            int n = string2.indexOf("charset=");
            string2 = n != -1 ? string2.substring(0, n) + "charset=" + this._encoding : string2 + "; charset=" + this._encoding;
            this._response.setContentType(string2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "set response character encoding: " + this.getCharacterEncoding());
        }
    }

    public Cookie[] getCookies() {
        return this._response.getCookies();
    }

    public void sendError(int n) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "sendError --> " + String.valueOf(n) + " : " + this);
        }
        Object[] objectArray = new Object[]{new Integer(n)};
        this.sendError(n, MessageFormat.format(nls.getString("Error.reported.{0}", "Error reported: {0}"), objectArray));
    }

    public void sendError(int n, String string) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "sendError --> " + n + " " + string + " : " + this);
        }
        this.getRequest().getWebAppDispatcherContext().sendError(n, string);
        this.closeResponseOutput();
    }

    public void setReason(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setReason message --> " + string + " : " + this);
        }
        this._response.setReason(string);
    }

    public void sendRedirect(String string) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "sendRedirect --> " + string + " : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "sendRedirect location --> " + string);
            }
        } else {
            this.getRequest().getWebAppDispatcherContext().sendRedirect(string);
        }
        this.closeResponseOutput();
    }

    public void sendRedirect303(String string) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "sendRedirect303 --> " + string + " : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "sendRedirect303 location -->" + string);
            }
        } else {
            this.getRequest().getWebAppDispatcherContext().sendRedirect303(string);
        }
        this.closeResponseOutput();
    }

    public void setContentLength(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setContentLength --> " + String.valueOf(n) + " : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setContentLength length --> " + String.valueOf(n));
            }
        } else {
            this._contentLength = n;
            this._bufferedOut.setLimit(this._contentLength);
            this._bufferedWriter.setLimit(this._contentLength);
            this.setIntHeader(HEADER_CONTENT_LENGTH, n);
        }
    }

    public void setContentType(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setContentType type --> " + string + " : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setContentType type --> " + string);
            }
        } else {
            String string2 = string.toLowerCase();
            int n = string2.indexOf("charset=");
            if (n != -1) {
                if (!this._gotWriter && !this.isCommitted()) {
                    int n2 = n + 8;
                    int n3 = string.length() - 1;
                    if (n2 < n3) {
                        this.isCharEncodingExplicit = true;
                        boolean bl = string.charAt(n2) == '\"' || string.charAt(n2) == '\'';
                        boolean bl2 = string.charAt(n3) == '\"' || string.charAt(n3) == '\'';
                        this._encoding = bl && bl2 ? string.substring(n2 + 1, n3) : string.substring(n2);
                        string = string.substring(0, n) + "charset=" + this._encoding;
                    }
                } else if ((string = string.substring(0, n).trim()).endsWith(";")) {
                    string = string.substring(0, string.length() - 1);
                }
            }
            this._response.setContentType(string);
        }
    }

    public void setDateHeader(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setDateHeader : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setDateHeader name --> " + string);
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning(tc, "WARNING: Cannot set header. Response already committed.");
                return;
            }
            this.setHeader(string, this.createCompliantHttpDateString(System.currentTimeMillis()));
        }
    }

    public void setDateHeader(String string, long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setDateHeader name --> " + string + " value --> " + String.valueOf(l) + " : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setDateHeader name --> " + string + " value --> " + String.valueOf(l));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning(tc, "WARNING: Cannot set header. Response already committed.");
                return;
            }
            this._response.setDateHeader(string, l);
        }
    }

    public void setHeader(String string, String string2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader name --> " + string + " value --> " + string2 + " : " + this);
        }
        this.setHeader(string, string2, true);
    }

    public void setHeader(String string, String string2, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader name --> " + string + " value --> " + string2 + " checkInclude --> " + bl + " : " + this);
        }
        if (bl && this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setHeader name --> " + string + " value --> " + string2 + " checkInclude --> " + bl);
            }
        } else {
            if (string == null) {
                return;
            }
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning(tc, "WARNING: Cannot set header. Response already committed.");
                return;
            }
            if (string2 == null) {
                this.removeHeader(string);
            } else {
                if (string.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                    String string3 = string2.toLowerCase();
                    int n = string3.indexOf("charset=");
                    if (n != -1) {
                        this._encoding = string2.substring(n + 8);
                        string2 = string2.substring(0, n) + "charset=" + this._encoding;
                    } else if (this.getRequest().getWebAppDispatcherContext().isAutoRequestEncoding()) {
                        string2 = string2.endsWith(";") ? string2 + "charset=" + this.getCharacterEncoding() : string2 + ";charset=" + this.getCharacterEncoding();
                    }
                }
                this._response.setHeader(string, string2);
            }
        }
    }

    public void setInternalHeader(String string, String string2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setInternalHeader name --> " + string + " value --> " + string2 + " : " + this);
        }
        this.setHeader(string, string2, false);
    }

    protected void setHeader(byte[] byArray, String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader name --> " + byArray + " value --> " + string + " : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setHeader name --> " + byArray + " value --> " + string);
            }
        } else {
            if (byArray == null) {
                return;
            }
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning(tc, "WARNING: Cannot set header. Response already committed.");
                return;
            }
            if (string == null) {
                this.removeHeader(byArray);
            } else {
                if (Arrays.equals(byArray, HEADER_CONTENT_TYPE_BYTES)) {
                    String string2 = string.toLowerCase();
                    int n = string2.indexOf("charset=");
                    if (n != -1) {
                        this._encoding = string.substring(n + 8);
                        string = string.substring(0, n) + "charset=" + this._encoding;
                    } else if (this.getRequest().getWebAppDispatcherContext().isAutoRequestEncoding()) {
                        string = string2.endsWith(";") ? string + "charset=" + this.getCharacterEncoding() : string + ";charset=" + this.getCharacterEncoding();
                    }
                }
                this._response.setHeader(byArray, string.getBytes());
            }
        }
    }

    public void setIntHeader(String string, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setIntHeader name --> " + string + " value --> " + String.valueOf(n) + " : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setIntHeader name --> " + string + " value --> " + String.valueOf(n));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning(tc, "WARNING: Cannot set header. Response already committed.");
                return;
            }
            this._response.setIntHeader(string, n);
        }
    }

    public void setStatus(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setStatus status --> " + String.valueOf(n) + " : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setStatus status --> " + String.valueOf(n));
            }
        } else if (!this._ignoreStateErrors && this.isCommitted()) {
            Tr.warning(tc, "WARNING: Cannot set status. Response already committed.");
        } else {
            this.resetBuffer();
            this._response.setStatusCode(n);
            this._statusCode = n;
        }
    }

    public void setStatus(int n, String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setStatus status --> " + String.valueOf(n) + " reason --> " + string + " : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setStatus status --> " + String.valueOf(n) + " reason --> " + string);
            }
        } else if (!this._ignoreStateErrors && this.isCommitted()) {
            Tr.warning(tc, "WARNING: Cannot set status. Response already committed.");
        } else {
            this.resetBuffer();
            this._response.setStatusCode(n);
            this._response.setReason(string);
            this._statusCode = n;
        }
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    public void setLocale(Locale locale) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setLocale locale --> " + (locale != null ? locale.toString() : "") + " : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setLocale locale --> " + (locale != null ? locale.toString() : ""));
            }
            return;
        }
        this._locale = locale;
        if (this.isCharEncodingSet() || this._gotWriter || this._headersWritten) {
            return;
        }
        this.isCharEncodingExplicit = false;
        this._encoding = this.getRequest().getWebAppDispatcherContext().getWebApp().getConfiguration().getLocaleEncoding(this._locale);
        if (this._encoding == null) {
            this._encoding = EncodingUtils.getEncodingFromLocale(this._locale);
            if (this._encoding == null) {
                this._encoding = _defaultEncoding;
            }
        }
        if (this.containsHeader(HEADER_CONTENT_TYPE_BYTES)) {
            String string = this.getHeader(HEADER_CONTENT_TYPE_BYTES);
            int n = string.indexOf("charset=");
            string = n != -1 ? string.substring(0, n) + "charset=" + this._encoding : string + "; charset=" + this._encoding;
            this._response.setContentType(string);
        }
    }

    private boolean isCharEncodingSet() {
        String string;
        int n;
        if (this.containsHeader(HEADER_CONTENT_TYPE_BYTES) && (n = (string = this.getHeader(HEADER_CONTENT_TYPE_BYTES)).indexOf("charset=")) != -1) {
            return this.isCharEncodingExplicit;
        }
        return false;
    }

    public Locale getLocale() {
        if (this._locale == null) {
            this.setDefaultResponseEncoding();
        }
        return this._locale;
    }

    public void addDateHeader(String string, long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addDateHeader : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addDateHeader name --> " + string + " value --> " + String.valueOf(l));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning(tc, "WARNING: Cannot set header. Response already committed.");
                return;
            }
            if (string.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                throw new IllegalArgumentException("Cannot Set Content-Type to a Date value");
            }
            this.setHeader(string, this.createCompliantHttpDateString(l));
        }
    }

    public void addHeader(String string, String string2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "addHeader --> " + string + " with value --> " + string2 + " : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addHeader --> " + string + " with value --> " + string2);
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning(tc, "WARNING: Cannot set header. Response already committed.");
                return;
            }
            if (string.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                this._response.setContentType(string2);
            } else {
                this.addField(string, string2);
            }
        }
    }

    public void addHeader(byte[] byArray, byte[] byArray2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "addHeader(byte) --> " + (byArray != null ? new String(byArray) : "") + " with value --> " + (byArray2 != null ? new String(byArray2) : "") + " : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addHeader(byte) --> " + (byArray != null ? new String(byArray) : "") + " with value --> " + (byArray2 != null ? new String(byArray2) : ""));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning(tc, "WARNING: Cannot set header. Response already committed.");
                return;
            }
            this._response.addHeader(byArray, byArray2);
        }
    }

    public void addIntHeader(String string, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "addIntHeader name --> " + string + " value --> " + String.valueOf(n) + " : " + this);
        }
        if (this.getRequest().getWebAppDispatcherContext().isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addIntHeader name --> " + string + " value --> " + String.valueOf(n));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning(tc, "WARNING: Cannot set header. Response already committed.");
                return;
            }
            if (string.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                throw new IllegalArgumentException("Cannot Set Content-Type to an Int value");
            }
            this.addIntField(string, n);
        }
    }

    public void addSessionCookie(Cookie cookie) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "addSessionCookie --> " + cookie.getName() + " : " + this);
        }
        if (this.isCommitted()) {
            Tr.warning(tc, "WARNING: Cannot set session cookie. Response already committed.");
        } else {
            this._response.addCookie(cookie);
        }
    }

    public void initForNextResponse(IResponse iResponse) {
        if (iResponse == null) {
            this._rawOut.init(null);
            return;
        }
        iResponse.setStatusCode(200);
        iResponse.setReason(REASON_OK);
        this._statusCode = 200;
        this._response = iResponse;
        try {
            this._rawOut.init(this._response.getOutputStream());
        }
        catch (IOException iOException) {
            Tr.error(tc, "error initializing rawOut \n{0}", iOException);
        }
        this._bufferedOut.reset();
        this._bufferedWriter.reset();
        this._responseBuffer = null;
        this._bufferSize = 4096;
        this._encoding = null;
        this._gotOutputStream = false;
        this._gotWriter = false;
        this._pwriter = null;
        this.resetState();
    }

    public Vector[] getHeaderTable() {
        return this._response.getHeaderTable();
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "destroy entry : " + this);
        }
        this._connContext = null;
        this._rawOut = null;
        this._bufferedOut = null;
        this._bufferedWriter = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "destroy exit");
        }
    }

    protected WSServletOutputStream createOutputStream(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "createOutputStream entry");
        }
        return new BufferedServletOutputStream(n);
    }

    protected String createCompliantHttpDateString(long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "createCompliantHttpDateString entry");
        }
        return new HttpDate(l).toString();
    }

    public static void setSkipInputStreamRead(boolean bl) {
        skipInputStreamRead = bl;
    }

    public static boolean isSkipInputStreamRead() {
        return skipInputStreamRead;
    }
}

