/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.webcontainer.util.IOutputStreamObserver;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;

public class SRTOutputStream
extends ServletOutputStream {
    private OutputStream _conn;
    private IOutputStreamObserver _observer;
    private static TraceComponent tc = Tr.register(SRTOutputStream.class, "Webcontainer", "com.ibm.ws.webcontainer.resources.Messages");

    public void init(OutputStream outputStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Initializing");
        }
        this._conn = outputStream;
    }

    public void flush() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Flushing");
        }
        this._conn.flush();
    }

    public void reset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Reseting");
        }
        this._conn = null;
    }

    public void close() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Closing");
        }
        if (this._observer != null) {
            this._observer.alertClose();
        }
        super.close();
    }

    protected void setObserver(IOutputStreamObserver iOutputStreamObserver) {
        this._observer = iOutputStreamObserver;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Writing");
        }
        if (this._observer != null) {
            this._observer.alertFirstWrite();
        }
        this._conn.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }
}

