/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ws.webcontainer.servlet.TimedServletPoolElement;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

public class TimedServletPool {
    private long _maxIdleTime;
    protected Vector _allElements = new Vector();
    private Vector _idleElements = new Vector();
    protected ServletConfig _config;
    protected Class _servletClass;

    public TimedServletPool(int n, long l, Class clazz, ServletConfig servletConfig) throws InstantiationException, IllegalAccessException, ServletException {
        this._maxIdleTime = l;
        this._servletClass = clazz;
        this._config = servletConfig;
        long l2 = l = l < 1000L ? 1000L : l;
        if (n < 1) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            this.addElementToIdleList(this.createNewElement());
        }
    }

    public synchronized TimedServletPoolElement getNextElement() throws InstantiationException, IllegalAccessException, ServletException {
        int n = this._idleElements.size();
        TimedServletPoolElement timedServletPoolElement = null;
        if (n > 0) {
            int n2 = 0;
            timedServletPoolElement = (TimedServletPoolElement)this._idleElements.elementAt(n2);
            this._idleElements.removeElementAt(n2);
        } else {
            timedServletPoolElement = this.createNewElement();
        }
        return timedServletPoolElement;
    }

    synchronized void removeExpiredElements() {
        TimedServletPoolElement timedServletPoolElement = null;
        int n = this._idleElements.size();
        for (int i = 0; i < n; ++i) {
            timedServletPoolElement = (TimedServletPoolElement)this._idleElements.elementAt(0);
            if (timedServletPoolElement.getIdleTime() <= this._maxIdleTime) {
                return;
            }
            this._allElements.removeElement(timedServletPoolElement);
            this._idleElements.removeElementAt(0);
            timedServletPoolElement.getServlet().destroy();
        }
    }

    synchronized void removeAllElements() {
        Enumeration enumeration = this._allElements.elements();
        while (enumeration.hasMoreElements()) {
            TimedServletPoolElement timedServletPoolElement = (TimedServletPoolElement)enumeration.nextElement();
            this._allElements.removeElement(timedServletPoolElement);
            this._idleElements.removeElement(timedServletPoolElement);
            timedServletPoolElement.getServlet().destroy();
        }
    }

    public synchronized void returnElement(TimedServletPoolElement timedServletPoolElement) {
        this.addElementToIdleList(timedServletPoolElement);
    }

    public void setMaxIdleTime(long l) {
        this._maxIdleTime = l;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public int getSize() {
        return this._allElements.size();
    }

    protected TimedServletPoolElement createNewElement() throws InstantiationException, IllegalAccessException, ServletException {
        Servlet servlet = (Servlet)this._servletClass.newInstance();
        servlet.init(this._config);
        TimedServletPoolElement timedServletPoolElement = new TimedServletPoolElement(servlet);
        this._allElements.addElement(timedServletPoolElement);
        return timedServletPoolElement;
    }

    protected synchronized void addElementToIdleList(TimedServletPoolElement timedServletPoolElement) {
        timedServletPoolElement.access();
        this._idleElements.addElement(timedServletPoolElement);
    }
}

