/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.websphere.servlet.event.ServletErrorEvent;
import com.ibm.websphere.servlet.event.ServletEvent;
import com.ibm.websphere.servlet.filter.ChainedResponse;
import com.ibm.ws.container.Configuration;
import com.ibm.ws.container.Container;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.core.Command;
import com.ibm.ws.webcontainer.core.Request;
import com.ibm.ws.webcontainer.core.Response;
import com.ibm.ws.webcontainer.exception.WebContainerUnavailableException;
import com.ibm.ws.webcontainer.filter.WebAppFilterManager;
import com.ibm.ws.webcontainer.servlet.SingleThreadModelServlet;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.srt.WriteBeyondContentLengthException;
import com.ibm.ws.webcontainer.util.ThreadContextHelper;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppErrorReport;
import com.ibm.ws.webcontainer.webapp.WebAppEventSource;
import com.ibm.ws.webcontainer.webapp.WebAppServletInvocationEvent;
import com.ibm.wsspi.webcontainer.ClosedConnectionException;
import com.ibm.wsspi.webcontainer.IInternalConfig;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.servlet.ServletReferenceListener;
import com.ibm.wsspi.webcontainer.util.IResponseOutput;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import java.beans.Beans;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ServletWrapper
extends GenericServlet
implements RequestProcessor,
Container,
IServletWrapper {
    private static final long serialVersionUID = -4479626085298397598L;
    private boolean notifyInvocationListeners;
    protected final byte UNINITIALIZED_STATE = (byte)-1;
    protected final byte AVAILABLE_STATE = 0;
    protected final byte UNAVAILABLE_STATE = 1;
    protected final byte UNAVAILABLE_PERMANENTLY_STATE = (byte)2;
    private int nServicing = 0;
    private long lastAccessTime = 0L;
    protected byte state = (byte)-1;
    private static TraceComponent tc = Tr.register(ServletWrapper.class, "Webcontainer", "com.ibm.ws.webcontainer.resources.Messages");
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    protected IServletConfig servletConfig;
    protected WebApp context;
    protected Servlet target;
    private List cacheWrappers = null;
    protected ClassLoader targetLoader;
    protected WebAppEventSource evtSource;
    private ServletEvent event;
    protected String unavailableMessage;
    private long unavailableUntil = -1L;
    protected boolean isSTM = false;
    protected boolean internalServlet = false;
    private static boolean suppressServletExceptionLogging = new Boolean(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.suppressservletexceptionlogging", "false"));
    public static int destroyWaitTime = 60;
    private static boolean discernUnavailableServlet;

    public ServletWrapper(IServletContext iServletContext) {
        this.context = (WebApp)iServletContext;
        this.evtSource = (WebAppEventSource)this.context.getServletContextEventSource();
        this.notifyInvocationListeners = this.evtSource.hasServletInvocationListeners();
        this.lastAccessTime = System.currentTimeMillis();
    }

    public void setParent(IServletContext iServletContext) {
        this.context = (WebApp)iServletContext;
    }

    public synchronized void init(ServletConfig servletConfig) throws ServletException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ServletWrapper enter init for servletName--> [" + this.getServletName() + "] , state -->[" + this.state + "]");
        }
        if (this.state != -1) {
            return;
        }
        if (this.servletConfig instanceof IInternalConfig) {
            this.internalServlet = ((IInternalConfig)((Object)this.servletConfig)).getIsInternal();
        }
        ClassLoader classLoader = null;
        try {
            classLoader = ThreadContextHelper.getContextClassLoader();
            ClassLoader classLoader2 = this.context.getClassLoader();
            if (classLoader2 != classLoader) {
                ThreadContextHelper.setClassLoader(classLoader2);
            } else {
                classLoader = null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ClassLoader set to: " + classLoader2.toString());
            }
            this.evtSource.onServletStartInit(this.getServletEvent());
            this.target.init(servletConfig);
            Tr.info(tc, "[{0}].Initialization.successful", new Object[]{this.getServletName(), this.context.getContextPath(), this.context.getApplicationName()});
            this.evtSource.onServletFinishInit(this.getServletEvent());
            this.evtSource.onServletAvailableForService(this.getServletEvent());
            this.setAvailable();
        }
        catch (UnavailableException unavailableException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "unavailableException throw by --> [" + this.getServletName(), unavailableException);
            }
            FFDCFilter.processException((Throwable)unavailableException, "com.ibm.ws.webcontainer.servlet.ServletInstance.service", "259", this);
            this.handleUnavailableException(unavailableException);
            ServletErrorEvent servletErrorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), unavailableException);
            this.evtSource.onServletInitError(servletErrorEvent);
            if (discernUnavailableServlet) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Create WebContainerUnavailableException");
                }
                throw WebContainerUnavailableException.create(unavailableException);
            }
            throw unavailableException;
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, "com.ibm.ws.webcontainer.servlet.ServletInstance.init", "172", this);
            Tr.error(tc, "Uncaught init() exception thrown by servlet {0}", new Object[]{this.getServletName()});
            ServletErrorEvent servletErrorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), servletException);
            this.evtSource.onServletInitError(servletErrorEvent);
            this.evtSource.onServletUnloaded(servletErrorEvent);
            throw servletException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webcontainer.servlet.ServletInstance.init", "181", this);
            Tr.error(tc, "Uncaught init() exception thrown by servlet {0}: {1}", new Object[]{this.getServletName(), throwable});
            ServletErrorEvent servletErrorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), throwable);
            this.evtSource.onServletInitError(servletErrorEvent);
            this.evtSource.onServletUnloaded(servletErrorEvent);
            throw new ServletException(nls.getString("Uncaught.initialization.exception.thrown.by.servlet", "Uncaught initialization exception thrown by servlet"), throwable);
        }
        finally {
            if (classLoader != null) {
                ClassLoader classLoader3 = classLoader;
                ThreadContextHelper.setClassLoader(classLoader3);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ServletWrapper exit init for servletName--> [" + this.getServletName() + "] , state -->[" + this.state + "]");
        }
    }

    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        Request request = (Request)ServletUtil.unwrapRequest(servletRequest);
        WebAppDispatcherContext webAppDispatcherContext = request.getWebAppDispatcherContext();
        this.handleRequest(servletRequest, servletResponse, webAppDispatcherContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse, WebAppDispatcherContext webAppDispatcherContext) throws Exception {
        Object object;
        HttpServletRequest httpServletRequest;
        block95: {
            IServletWrapper iServletWrapper;
            String string;
            String string2;
            ChainedResponse chainedResponse;
            Object object2;
            HttpServletResponse httpServletResponse;
            block94: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "handleRequest " + this.toString());
                }
                this.notifyInvocationListeners = this.evtSource.hasServletInvocationListeners();
                webAppDispatcherContext.pushServletReference(this);
                httpServletRequest = (HttpServletRequest)servletRequest;
                httpServletResponse = (HttpServletResponse)servletResponse;
                if (this.state == 2) {
                    boolean bl2 = false;
                    UnavailableException unavailableException = new UnavailableException(this.unavailableMessage);
                    ServletErrorReport servletErrorReport = this.constructErrorReport(unavailableException, webAppDispatcherContext.getCurrentServletReference());
                    if (WebAppFilterManager.invokeFiltersCompatibility && !this.context.isMimeFilteringEnabled() && this.getWebApp().isFiltersDefined()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "UnavailableException before calling servlet - call Filters");
                        }
                        httpServletRequest.setAttribute("com.ibm.ws.webcontainer.filter.filenotfound", servletErrorReport);
                        httpServletRequest.setAttribute("com.ibm.ws.webcontainer.filter.filenotfound.context", this.context);
                        IServletWrapper iServletWrapper2 = (IServletWrapper)this.context.getRequestMapper().map(WebApp.FILTER_PROXY_MAPPING);
                        bl2 = this.context.getFilterManager().invokeFilters(httpServletRequest, httpServletResponse, iServletWrapper2, this.context, this);
                    }
                    if (bl2) return;
                    if (!webAppDispatcherContext.isInclude()) {
                        if (!webAppDispatcherContext.isForward()) throw servletErrorReport;
                    }
                    if (!discernUnavailableServlet) throw unavailableException;
                    if (!tc.isDebugEnabled()) throw WebContainerUnavailableException.create(unavailableException);
                    Tr.debug(tc, "Create WebContainerUnavailableException");
                    throw WebContainerUnavailableException.create(unavailableException);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    object2 = (String)httpServletRequest.getAttribute("javax.servlet.include.request_uri");
                    object = httpServletRequest.getRequestURI();
                    Tr.debug(tc, "handling request for resource [" + (String)(object2 == null ? object : object2) + "]");
                }
                if (httpServletRequest.isSecure()) {
                    object2 = null;
                    object = ServletUtil.unwrapRequest(httpServletRequest);
                    object2 = ((SRTServletRequest)object).getCipherSuite();
                    if (object2 != null) {
                        httpServletRequest.setAttribute("javax.servlet.request.cipher_suite", object2);
                        Integer n = WebContainer.getWebContainer().getKeySize((String)object2);
                        if (n != null) {
                            httpServletRequest.setAttribute("javax.servlet.request.key_size", n);
                        }
                    }
                }
                object2 = null;
                if (this.notifyInvocationListeners) {
                    object2 = new WebAppServletInvocationEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), httpServletRequest, httpServletResponse);
                }
                object = null;
                boolean bl = false;
                try {
                    try {
                        this.target = this.loadServlet();
                        if (this.state == -1) {
                            this.init(this.servletConfig);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this.servletConfig instanceof IInternalConfig) {
                            Tr.debug(tc, "handleRequest(): internal servlet -->" + ((IInternalConfig)((Object)this.servletConfig)).getIsInternal());
                        }
                        object = ThreadContextHelper.getContextClassLoader();
                        ClassLoader classLoader = this.context.getClassLoader();
                        if (classLoader != object) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "PK26183 re-set class loader from: " + object.toString() + " ,to: " + classLoader.toString());
                            }
                            ThreadContextHelper.setClassLoader(classLoader);
                        } else {
                            object = null;
                        }
                        if (!this.internalServlet) {
                            webAppDispatcherContext.sessionPreInvoke();
                        }
                        if (!webAppDispatcherContext.getIsInclude() && !webAppDispatcherContext.isForward()) {
                            this.context.notifyServletRequestCreated(httpServletRequest);
                        }
                        if (this.context.isMimeFilteringEnabled()) {
                            chainedResponse = new ChainedResponse(httpServletRequest, httpServletResponse);
                            chainedResponse.setContentType("text/html");
                            Enumeration enumeration = httpServletRequest.getHeaderNames();
                            while (enumeration.hasMoreElements()) {
                                string2 = (String)enumeration.nextElement();
                                string = httpServletRequest.getHeader(string2);
                                if (string2.toLowerCase().startsWith("content")) continue;
                                chainedResponse.setAutoTransferringHeader(string2, string);
                            }
                            this.service(httpServletRequest, chainedResponse, (WebAppServletInvocationEvent)object2);
                            string2 = null;
                            if (chainedResponse.isRedirected()) {
                                string2 = chainedResponse.getRedirectURI();
                            }
                            string = chainedResponse.getHeader("content-type");
                            iServletWrapper = this.getMimeFilterWrapper(string);
                            break block94;
                        }
                        if (this.context.isFiltersDefined()) {
                            WebAppFilterManager webAppFilterManager = this.context.getFilterManager();
                            bl = true;
                            webAppFilterManager.doFilter(httpServletRequest, httpServletResponse, this, webAppDispatcherContext);
                        } else {
                            bl = true;
                            this.service(httpServletRequest, httpServletResponse, (WebAppServletInvocationEvent)object2);
                        }
                        if (webAppDispatcherContext.isInclude()) break block95;
                        if (httpServletResponse instanceof IResponseOutput) {
                            ((IResponseOutput)((Object)httpServletResponse)).flushBuffer(false);
                            break block95;
                        }
                        httpServletResponse.flushBuffer();
                    }
                    catch (WriteBeyondContentLengthException writeBeyondContentLengthException) {
                        block97: {
                            FFDCFilter.processException(writeBeyondContentLengthException, "com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest()", "293");
                            webAppDispatcherContext.pushException(writeBeyondContentLengthException);
                            try {
                                httpServletResponse.flushBuffer();
                            }
                            catch (IOException iOException) {
                                ServletErrorReport servletErrorReport = this.constructErrorReport(iOException, webAppDispatcherContext.getCurrentServletReference());
                                FFDCFilter.processException(iOException, "com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest()", "298");
                                throw servletErrorReport;
                            }
                            Object var23_45 = null;
                            try {
                                block96: {
                                    try {
                                        if (object != null) {
                                            Object object4 = object;
                                            ThreadContextHelper.setClassLoader((ClassLoader)object4);
                                        }
                                        if (!this.internalServlet) {
                                            webAppDispatcherContext.sessionPostInvoke();
                                        }
                                        if (webAppDispatcherContext.getIsInclude() || webAppDispatcherContext.isForward()) break block96;
                                        this.context.notifyServletRequestDestroyed(httpServletRequest);
                                    }
                                    catch (Exception exception) {
                                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest() finilizer", "865", this);
                                        ServletErrorReport servletErrorReport = this.constructErrorReport(exception, webAppDispatcherContext.getCurrentServletReference());
                                        throw servletErrorReport;
                                    }
                                }
                                Object var27_58 = null;
                                webAppDispatcherContext.popServletReference();
                                if (this.context.getJSPClassLoaderLimit() <= 0 || this.context.getJSPClassLoaderExclusionList() != null && this.context.getJSPClassLoaderExclusionList().contains(httpServletRequest.getRequestURI()) || webAppDispatcherContext.getIsInclude() || webAppDispatcherContext.isForward()) break block97;
                                ClassLoader classLoader = this.getTargetClassLoader();
                                Class clazz = this.context.getJSPClassLoaderClassName();
                                if (classLoader != null && classLoader.getClass().isAssignableFrom(clazz)) {
                                    this.context.addAndCheckJSPClassLoaderLimit(this);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var27_59 = null;
                                webAppDispatcherContext.popServletReference();
                                if (this.context.getJSPClassLoaderLimit() <= 0) throw throwable;
                                if (this.context.getJSPClassLoaderExclusionList() != null) {
                                    if (this.context.getJSPClassLoaderExclusionList().contains(httpServletRequest.getRequestURI())) throw throwable;
                                }
                                if (webAppDispatcherContext.getIsInclude()) throw throwable;
                                if (webAppDispatcherContext.isForward()) throw throwable;
                                ClassLoader classLoader = this.getTargetClassLoader();
                                Class clazz = this.context.getJSPClassLoaderClassName();
                                if (classLoader == null) throw throwable;
                                if (!classLoader.getClass().isAssignableFrom(clazz)) throw throwable;
                                this.context.addAndCheckJSPClassLoaderLimit(this);
                                throw throwable;
                            }
                        }
                        if (!TraceComponent.isAnyTracingEnabled()) return;
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit(tc, "handleRequest");
                        return;
                    }
                    catch (IOException iOException) {
                        if (!webAppDispatcherContext.isInclude() && !webAppDispatcherContext.isForward()) {
                            ServletErrorReport servletErrorReport = this.constructErrorReport(iOException, webAppDispatcherContext.getCurrentServletReference());
                            webAppDispatcherContext.pushException(iOException);
                            FFDCFilter.processException(iOException, "com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest()", "298");
                            throw servletErrorReport;
                        }
                        webAppDispatcherContext.pushException(iOException);
                        throw iOException;
                    }
                    catch (UnavailableException unavailableException) {
                        ServletErrorReport servletErrorReport;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if (discernUnavailableServlet) {
                            bl4 = unavailableException instanceof WebContainerUnavailableException;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "UnavailableException Caught : caughtUEIsInstanceOfWUE=" + bl4 + ", discernUnavailableServlet=" + discernUnavailableServlet);
                        }
                        try {
                            try {
                                servletErrorReport = this.constructErrorReport(unavailableException, webAppDispatcherContext.getCurrentServletReference());
                                if (!bl4) {
                                    this.handleUnavailableException(unavailableException);
                                }
                                if (WebAppFilterManager.invokeFiltersCompatibility && !bl && !this.context.isMimeFilteringEnabled() && this.getWebApp().isFiltersDefined()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "UnavailableException before calling servlet - call Filters");
                                    }
                                    httpServletRequest.setAttribute("com.ibm.ws.webcontainer.filter.filenotfound", servletErrorReport);
                                    httpServletRequest.setAttribute("com.ibm.ws.webcontainer.filter.filenotfound.context", this.context);
                                    IServletWrapper iServletWrapper3 = (IServletWrapper)this.context.getRequestMapper().map(WebApp.FILTER_PROXY_MAPPING);
                                    bl3 = this.context.getFilterManager().invokeFilters(httpServletRequest, httpServletResponse, iServletWrapper3, this.context, this);
                                }
                                if (!bl3) {
                                    if (webAppDispatcherContext.isInclude()) throw unavailableException;
                                    if (webAppDispatcherContext.isForward()) {
                                        throw unavailableException;
                                    }
                                }
                                Object var21_88 = null;
                                if (!(bl4 && bl || unavailableException.isPermanent() || this.state != this.UNAVAILABLE_STATE)) {
                                    httpServletResponse.setHeader("Retry-After", String.valueOf(unavailableException.getUnavailableSeconds()));
                                }
                                if (!bl3) {
                                    webAppDispatcherContext.pushException(unavailableException);
                                }
                            }
                            catch (UnavailableException unavailableException2) {
                                if (webAppDispatcherContext.isInclude() || webAppDispatcherContext.isForward()) {
                                    if (!discernUnavailableServlet) throw unavailableException2;
                                    if (unavailableException2 instanceof WebContainerUnavailableException) {
                                        throw unavailableException2;
                                    }
                                    if (!tc.isDebugEnabled()) throw WebContainerUnavailableException.create(unavailableException);
                                    Tr.debug(tc, "Create WebContainerUnavailableException");
                                    throw WebContainerUnavailableException.create(unavailableException);
                                }
                                servletErrorReport = this.constructErrorReport(unavailableException2, webAppDispatcherContext.getCurrentServletReference());
                                Object var21_89 = null;
                                if (!(bl4 && bl || unavailableException.isPermanent() || this.state != this.UNAVAILABLE_STATE)) {
                                    httpServletResponse.setHeader("Retry-After", String.valueOf(unavailableException.getUnavailableSeconds()));
                                }
                                if (!bl3) {
                                    webAppDispatcherContext.pushException(unavailableException);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var21_90 = null;
                            if (!(bl4 && bl || unavailableException.isPermanent() || this.state != this.UNAVAILABLE_STATE)) {
                                httpServletResponse.setHeader("Retry-After", String.valueOf(unavailableException.getUnavailableSeconds()));
                            }
                            if (bl3) throw throwable;
                            webAppDispatcherContext.pushException(unavailableException);
                            throw throwable;
                        }
                        if (!bl3) {
                            FFDCFilter.processException(unavailableException, "com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest()", "302");
                            throw servletErrorReport;
                        }
                        Object var23_46 = null;
                        try {}
                        catch (Throwable throwable) {
                            Object var27_61 = null;
                            webAppDispatcherContext.popServletReference();
                            if (this.context.getJSPClassLoaderLimit() <= 0) throw throwable;
                            if (this.context.getJSPClassLoaderExclusionList() != null) {
                                if (this.context.getJSPClassLoaderExclusionList().contains(httpServletRequest.getRequestURI())) throw throwable;
                            }
                            if (webAppDispatcherContext.getIsInclude()) throw throwable;
                            if (webAppDispatcherContext.isForward()) throw throwable;
                            ClassLoader classLoader = this.getTargetClassLoader();
                            Class clazz = this.context.getJSPClassLoaderClassName();
                            if (classLoader == null) throw throwable;
                            if (!classLoader.getClass().isAssignableFrom(clazz)) throw throwable;
                            this.context.addAndCheckJSPClassLoaderLimit(this);
                            throw throwable;
                        }
                        try {}
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest() finilizer", "865", this);
                            ServletErrorReport servletErrorReport2 = this.constructErrorReport(exception, webAppDispatcherContext.getCurrentServletReference());
                            throw servletErrorReport2;
                        }
                        if (object != null) {
                            Object object5 = object;
                            ThreadContextHelper.setClassLoader((ClassLoader)object5);
                        }
                        if (!this.internalServlet) {
                            webAppDispatcherContext.sessionPostInvoke();
                        }
                        if (!webAppDispatcherContext.getIsInclude() && !webAppDispatcherContext.isForward()) {
                            this.context.notifyServletRequestDestroyed(httpServletRequest);
                        }
                        Object var27_60 = null;
                        webAppDispatcherContext.popServletReference();
                        if (!(this.context.getJSPClassLoaderLimit() <= 0 || this.context.getJSPClassLoaderExclusionList() != null && this.context.getJSPClassLoaderExclusionList().contains(httpServletRequest.getRequestURI()) || webAppDispatcherContext.getIsInclude() || webAppDispatcherContext.isForward())) {
                            ClassLoader classLoader = this.getTargetClassLoader();
                            Class clazz = this.context.getJSPClassLoaderClassName();
                            if (classLoader != null && classLoader.getClass().isAssignableFrom(clazz)) {
                                this.context.addAndCheckJSPClassLoaderLimit(this);
                            }
                        }
                        if (!TraceComponent.isAnyTracingEnabled()) return;
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit(tc, "handleRequest");
                        return;
                    }
                    catch (ServletErrorReport servletErrorReport) {
                        FFDCFilter.processException((Throwable)servletErrorReport, "com.ibm.ws.webcontainer.webapp.WebAppRequestDispatcher.dispatch", "428", this);
                        webAppDispatcherContext.pushException(servletErrorReport);
                        throw servletErrorReport;
                    }
                    catch (ServletException servletException) {
                        if (!webAppDispatcherContext.isInclude() && !webAppDispatcherContext.isForward()) {
                            servletErrorReport = this.constructErrorReport(servletException, webAppDispatcherContext.getCurrentServletReference());
                            FFDCFilter.processException(servletException, "com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest()", "309");
                            webAppDispatcherContext.pushException(servletException);
                            throw servletErrorReport;
                        }
                        webAppDispatcherContext.pushException(servletException);
                        throw servletException;
                    }
                    catch (RuntimeException runtimeException) {
                        if (!webAppDispatcherContext.isInclude() && !webAppDispatcherContext.isForward()) {
                            servletErrorReport = this.constructErrorReport(runtimeException, webAppDispatcherContext.getCurrentServletReference());
                            webAppDispatcherContext.pushException(runtimeException);
                            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.webcontainer.webapp.WebAppRequestDispatcher.dispatch", "448", this);
                            throw servletErrorReport;
                        }
                        webAppDispatcherContext.pushException(runtimeException);
                        throw runtimeException;
                    }
                    catch (Throwable throwable) {
                        servletErrorReport = this.constructErrorReport(throwable, webAppDispatcherContext.getCurrentServletReference());
                        webAppDispatcherContext.pushException(throwable);
                        FFDCFilter.processException(throwable, "com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest()", "313");
                        throw servletErrorReport;
                    }
                    break block95;
                }
                catch (Throwable throwable) {
                    Object var23_47 = null;
                    try {}
                    catch (Throwable throwable2) {
                        Object var27_63 = null;
                        webAppDispatcherContext.popServletReference();
                        if (this.context.getJSPClassLoaderLimit() <= 0) throw throwable2;
                        if (this.context.getJSPClassLoaderExclusionList() != null) {
                            if (this.context.getJSPClassLoaderExclusionList().contains(httpServletRequest.getRequestURI())) throw throwable2;
                        }
                        if (webAppDispatcherContext.getIsInclude()) throw throwable2;
                        if (webAppDispatcherContext.isForward()) throw throwable2;
                        ClassLoader classLoader = this.getTargetClassLoader();
                        Class clazz = this.context.getJSPClassLoaderClassName();
                        if (classLoader == null) throw throwable2;
                        if (!classLoader.getClass().isAssignableFrom(clazz)) throw throwable2;
                        this.context.addAndCheckJSPClassLoaderLimit(this);
                        throw throwable2;
                    }
                    try {}
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest() finilizer", "865", this);
                        ServletErrorReport servletErrorReport = this.constructErrorReport(exception, webAppDispatcherContext.getCurrentServletReference());
                        throw servletErrorReport;
                    }
                    if (object != null) {
                        Object object6 = object;
                        ThreadContextHelper.setClassLoader((ClassLoader)object6);
                    }
                    if (!this.internalServlet) {
                        webAppDispatcherContext.sessionPostInvoke();
                    }
                    if (!webAppDispatcherContext.getIsInclude() && !webAppDispatcherContext.isForward()) {
                        this.context.notifyServletRequestDestroyed(httpServletRequest);
                    }
                    Object var27_62 = null;
                    webAppDispatcherContext.popServletReference();
                    if (!(this.context.getJSPClassLoaderLimit() <= 0 || this.context.getJSPClassLoaderExclusionList() != null && this.context.getJSPClassLoaderExclusionList().contains(httpServletRequest.getRequestURI()) || webAppDispatcherContext.getIsInclude() || webAppDispatcherContext.isForward())) {
                        ClassLoader classLoader = this.getTargetClassLoader();
                        Class clazz = this.context.getJSPClassLoaderClassName();
                        if (classLoader != null && classLoader.getClass().isAssignableFrom(clazz)) {
                            this.context.addAndCheckJSPClassLoaderLimit(this);
                        }
                    }
                    if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit(tc, "handleRequest");
                    throw throwable;
                }
            }
            while (iServletWrapper != null) {
                httpServletRequest = chainedResponse.getChainedRequest();
                ChainedResponse chainedResponse2 = chainedResponse;
                chainedResponse = new ChainedResponse(httpServletRequest, httpServletResponse);
                chainedResponse.setContentType(string);
                this.transferHeadersFromPrevChainedResp(chainedResponse, chainedResponse2);
                if (string2 != null) {
                    chainedResponse.setHeader("location", string2);
                    chainedResponse.setStatus(302);
                }
                webAppDispatcherContext.pushServletReference(iServletWrapper);
                ((ServletWrapper)iServletWrapper).service(httpServletRequest, chainedResponse, (WebAppServletInvocationEvent)object2);
                webAppDispatcherContext.popServletReference();
                String string3 = chainedResponse.getHeader("content-type");
                String string4 = string3.toLowerCase();
                String string5 = string.toLowerCase();
                int n = string4.indexOf(";");
                if (n != -1) {
                    string4 = string4.substring(0, n);
                }
                if ((n = string5.indexOf(";")) != -1) {
                    string5 = string5.substring(0, n);
                }
                if (string4.equals(string5)) {
                    iServletWrapper = null;
                    continue;
                }
                string = string3;
                iServletWrapper = this.getMimeFilterWrapper(string);
            }
            chainedResponse.transferResponse(httpServletResponse);
        }
        Object var23_44 = null;
        try {}
        catch (Throwable throwable) {
            Object var27_57 = null;
            webAppDispatcherContext.popServletReference();
            if (this.context.getJSPClassLoaderLimit() <= 0) throw throwable;
            if (this.context.getJSPClassLoaderExclusionList() != null) {
                if (this.context.getJSPClassLoaderExclusionList().contains(httpServletRequest.getRequestURI())) throw throwable;
            }
            if (webAppDispatcherContext.getIsInclude()) throw throwable;
            if (webAppDispatcherContext.isForward()) throw throwable;
            ClassLoader classLoader = this.getTargetClassLoader();
            Class clazz = this.context.getJSPClassLoaderClassName();
            if (classLoader == null) throw throwable;
            if (!classLoader.getClass().isAssignableFrom(clazz)) throw throwable;
            this.context.addAndCheckJSPClassLoaderLimit(this);
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest() finilizer", "865", this);
            ServletErrorReport servletErrorReport = this.constructErrorReport(exception, webAppDispatcherContext.getCurrentServletReference());
            throw servletErrorReport;
        }
        if (object != null) {
            Object object3 = object;
            ThreadContextHelper.setClassLoader((ClassLoader)object3);
        }
        if (!this.internalServlet) {
            webAppDispatcherContext.sessionPostInvoke();
        }
        if (!webAppDispatcherContext.getIsInclude() && !webAppDispatcherContext.isForward()) {
            this.context.notifyServletRequestDestroyed(httpServletRequest);
        }
        Object var27_56 = null;
        webAppDispatcherContext.popServletReference();
        if (!(this.context.getJSPClassLoaderLimit() <= 0 || this.context.getJSPClassLoaderExclusionList() != null && this.context.getJSPClassLoaderExclusionList().contains(httpServletRequest.getRequestURI()) || webAppDispatcherContext.getIsInclude() || webAppDispatcherContext.isForward())) {
            ClassLoader classLoader = this.getTargetClassLoader();
            Class clazz = this.context.getJSPClassLoaderClassName();
            if (classLoader != null && classLoader.getClass().isAssignableFrom(clazz)) {
                this.context.addAndCheckJSPClassLoaderLimit(this);
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return;
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "handleRequest");
    }

    public ServletErrorReport constructErrorReport(Throwable throwable, IServletWrapper iServletWrapper) {
        WebAppErrorReport webAppErrorReport = new WebAppErrorReport(throwable);
        if (iServletWrapper != null) {
            if (iServletWrapper.getServletConfig() != null) {
                webAppErrorReport.setTargetServletName(iServletWrapper.getServletName());
            }
        } else if (this.servletConfig != null) {
            webAppErrorReport.setTargetServletName(this.getServletName());
        }
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        if (throwable2 instanceof FileNotFoundException) {
            webAppErrorReport.setErrorCode(404);
        } else if (throwable2 instanceof UnavailableException) {
            UnavailableException unavailableException = (UnavailableException)throwable2;
            if (unavailableException.isPermanent()) {
                webAppErrorReport.setErrorCode(404);
            } else {
                webAppErrorReport.setErrorCode(503);
            }
        } else {
            webAppErrorReport.setErrorCode(500);
        }
        return webAppErrorReport;
    }

    public void addCommand(Command command) {
    }

    public String getName() {
        return this.servletConfig.getServletName();
    }

    public void removeCommand(Command command) {
    }

    protected void doDestroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "doDestroy " + this.toString());
        }
        if (this.state != this.UNINITIALIZED_STATE) {
            try {
                ClassLoader classLoader = null;
                try {
                    classLoader = ThreadContextHelper.getContextClassLoader();
                    ClassLoader classLoader2 = this.context.getClassLoader();
                    if (classLoader2 != classLoader) {
                        ThreadContextHelper.setClassLoader(classLoader2);
                    } else {
                        classLoader = null;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Servlet.unload.initiated:.{0}", this.getServletName());
                    }
                    this.setUnavailable();
                    this.evtSource.onServletStartDestroy(this.getServletEvent());
                    for (int i = 0; this.nServicing > 0 && i < destroyWaitTime; ++i) {
                        try {
                            if (i == 0) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "servlet is still servicing...will wait up to 60 seconds for servlet to become idle: {0}", this.getServletName());
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Waiting.servlet.to.finish.servicing.requests:.{0}", this.getServletName());
                                }
                            }
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.webcontainer.servlet.ServletInstance.destroy", "377", this);
                        }
                    }
                    if (this.nServicing > 0 && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Servlet.wait.for.destroy.timeout.has.expired,.destroy.will.be.forced:.{0}", this.getServletName());
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "enter Servlet.destroy(): {0}", this.getServletName());
                    }
                    if (this.target != null) {
                        this.target.destroy();
                        Tr.info(tc, "[{0}].Destroy.successful", new Object[]{this.getServletName(), this.context.getContextPath(), this.context.getApplicationName()});
                    }
                    this.evtSource.onServletFinishDestroy(this.getServletEvent());
                    this.evtSource.onServletUnloaded(this.getServletEvent());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Servlet.unloaded:.{0}", this.getServletName());
                    }
                }
                catch (Exception exception) {
                    throw new ServletException(exception);
                }
                finally {
                    if (classLoader != null) {
                        ClassLoader classLoader3 = classLoader;
                        ThreadContextHelper.setClassLoader(classLoader3);
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.webcontainer.servlet.ServletWrapper.destroy", "403", this);
                Tr.error(tc, "Uncaught destroy() exception thrown by servlet {0}: {1}", new Object[]{this.getServletName(), throwable});
                this.evtSource.onServletDestroyError(new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), throwable));
                this.context.log("Error occurred while destroying servlet", throwable);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "exit Servlet.destroy(): {0}", this.getServletName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "doDestroy");
        }
    }

    public void prepareForReload() {
        this.doDestroy();
        this.target = null;
        this.targetLoader = null;
        this.state = (byte)this.UNINITIALIZED_STATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "servlet destroy for -->" + this.getServletName() + ", state is -->" + this.state);
        }
        try {
            if (this.state == -1) return;
            if (this.state == 2) return;
            try {
                try {
                    this.doDestroy();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.webcontainer.servlet.ServletWrapper", "1152", this);
                    Tr.error(tc, "Exception occured during servlet destroy", throwable);
                    Object var3_2 = null;
                    this.target = null;
                    this.servletConfig = null;
                    this.targetLoader = null;
                    this.state = (byte)this.UNAVAILABLE_PERMANENTLY_STATE;
                    return;
                }
                Object var3_1 = null;
                this.target = null;
                this.servletConfig = null;
                this.targetLoader = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.target = null;
                this.servletConfig = null;
                this.targetLoader = null;
                this.state = (byte)this.UNAVAILABLE_PERMANENTLY_STATE;
                throw throwable;
            }
            this.state = (byte)this.UNAVAILABLE_PERMANENTLY_STATE;
            return;
        }
        finally {
            this.invalidateCacheWrappers();
        }
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletInfo() {
        return this.getName() + ":" + this.servletConfig.getClassName();
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        WebAppServletInvocationEvent webAppServletInvocationEvent = null;
        if (this.notifyInvocationListeners) {
            webAppServletInvocationEvent = new WebAppServletInvocationEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), servletRequest, servletResponse);
        }
        this.service(servletRequest, servletResponse, webAppServletInvocationEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(ServletRequest servletRequest, ServletResponse servletResponse, WebAppServletInvocationEvent webAppServletInvocationEvent) throws ServletException, IOException {
        ServletWrapper servletWrapper;
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "service " + this.toString());
        }
        boolean bl2 = bl = this.notifyInvocationListeners && webAppServletInvocationEvent != null;
        if (this.unavailableUntil != -1L) {
            this.lastAccessTime = System.currentTimeMillis();
            long l = this.unavailableUntil - this.lastAccessTime;
            if (l > 0L) {
                int n = (int)l / 1000;
                if (n != 0) throw new UnavailableException(this.unavailableMessage, n);
                n = 1;
                throw new UnavailableException(this.unavailableMessage, n);
            }
            this.setAvailable();
        }
        try {
            try {
                if (this.target == null) {
                    this.load();
                }
                try {
                    if (bl) {
                        this.evtSource.onServletStartService(webAppServletInvocationEvent);
                    }
                }
                finally {
                    ServletWrapper servletWrapper2 = this;
                    synchronized (servletWrapper2) {
                        ++this.nServicing;
                    }
                }
                if (bl) {
                    long l;
                    this.lastAccessTime = l = System.currentTimeMillis();
                    this.target.service(servletRequest, servletResponse);
                    long l2 = System.currentTimeMillis();
                    webAppServletInvocationEvent.setResponseTime(l2 - l);
                    this.evtSource.onServletFinishService(webAppServletInvocationEvent);
                }
                this.target.service(servletRequest, servletResponse);
            }
            catch (UnavailableException unavailableException) {
                throw unavailableException;
            }
            catch (IOException iOException) {
                if (iOException instanceof ClosedConnectionException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Caught ClosedConnectionException for servlet [" + this.getServletName() + "]");
                    }
                } else if (!WebApp.modifiedFileNotFoundExceptionBehavior) {
                    Tr.error(tc, "Uncaught service() exception thrown by servlet {0}: {1}", new Object[]{this.getServletName(), iOException});
                }
                if (!bl) throw iOException;
                ServletErrorEvent servletErrorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), iOException);
                this.evtSource.onServletServiceError(servletErrorEvent);
                this.evtSource.onServletFinishService(webAppServletInvocationEvent);
                throw iOException;
            }
            catch (ServletException servletException) {
                if (!suppressServletExceptionLogging) {
                    Tr.error(tc, "Uncaught service() exception thrown by servlet {0}: {1}", new Object[]{this.getServletName(), servletException});
                }
                if (!bl) throw servletException;
                ServletErrorEvent servletErrorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), servletException);
                this.evtSource.onServletServiceError(servletErrorEvent);
                this.evtSource.onServletFinishService(webAppServletInvocationEvent);
                throw servletException;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Tr.error(tc, "Place your servlet's class on classpath of the application server {0}: {1}", new Object[]{this.getServletName(), unsatisfiedLinkError});
                if (!bl) throw new ServletException(unsatisfiedLinkError);
                ServletErrorEvent servletErrorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), unsatisfiedLinkError);
                this.evtSource.onServletServiceError(servletErrorEvent);
                this.evtSource.onServletFinishService(webAppServletInvocationEvent);
                throw new ServletException(unsatisfiedLinkError);
            }
            catch (RuntimeException runtimeException) {
                Tr.error(tc, "Uncaught service() exception thrown by servlet {0}: {1}", new Object[]{this.getServletName(), runtimeException});
                if (!bl) throw runtimeException;
                ServletErrorEvent servletErrorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), runtimeException);
                this.evtSource.onServletServiceError(servletErrorEvent);
                this.evtSource.onServletFinishService(webAppServletInvocationEvent);
                throw runtimeException;
            }
            catch (Throwable throwable) {
                Tr.error(tc, "Uncaught service() exception thrown by servlet {0}: {1}", new Object[]{this.getServletName(), throwable});
                FFDCFilter.processException(throwable, "com.ibm.ws.webcontainer.servlet.ServletInstance.service", "290", this);
                if (!bl) throw new ServletException(throwable);
                this.evtSource.onServletFinishService(webAppServletInvocationEvent);
                ServletErrorEvent servletErrorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), throwable);
                this.evtSource.onServletServiceError(servletErrorEvent);
                throw new ServletException(throwable);
            }
            Object var11_23 = null;
            servletWrapper = this;
        }
        catch (Throwable throwable) {
            Object var11_24 = null;
            ServletWrapper servletWrapper2 = this;
            synchronized (servletWrapper2) {
                --this.nServicing;
            }
            if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "service");
            throw throwable;
        }
        synchronized (servletWrapper) {
            --this.nServicing;
        }
        if (!TraceComponent.isAnyTracingEnabled()) return;
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "service");
    }

    public void initialize(IServletConfig iServletConfig) throws Exception {
        this.servletConfig = iServletConfig;
        if (iServletConfig.isLoadOnStartup()) {
            try {
                this.loadServlet();
            }
            catch (UnavailableException unavailableException) {
                this.handleUnavailableException(unavailableException);
                if (discernUnavailableServlet) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Create WebContainerUnavailableException");
                    }
                    throw WebContainerUnavailableException.create(unavailableException);
                }
                throw unavailableException;
            }
            this.init(this.servletConfig);
        }
    }

    public void load() throws Exception {
        this.loadServlet();
        this.init(this.servletConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unload() throws Exception {
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "unload, className-->[" + this.servletConfig.getClassName() + "], servletName[" + this.servletConfig.getServletName() + "]");
            }
            if (this.state == -1) {
                return;
            }
            try {
                try {
                    this.doDestroy();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.webcontainer.servlet.ServletWrapper", "1511", this);
                    Tr.error(tc, "Exception occured during servlet unload", throwable);
                    Object var3_2 = null;
                    this.target = null;
                    this.targetLoader = null;
                    this.invalidateCacheWrappers();
                    this.state = (byte)-1;
                    break block7;
                }
                Object var3_1 = null;
                this.target = null;
                this.targetLoader = null;
                this.invalidateCacheWrappers();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.target = null;
                this.targetLoader = null;
                this.invalidateCacheWrappers();
                this.state = (byte)-1;
                throw throwable;
            }
            this.state = (byte)-1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unload");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized Servlet loadServlet() throws Exception {
        block13: {
            ClassLoader classLoader;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "loadServlet, className-->[" + this.servletConfig.getClassName() + "], servletName[" + this.servletConfig.getServletName() + "]");
            }
            if (this.target != null) {
                return this.target;
            }
            final String string = this.servletConfig.getClassName();
            final String string2 = this.servletConfig.getServletName();
            ClassLoader classLoader2 = null;
            try {
                try {
                    ClassLoader classLoader3;
                    classLoader2 = ThreadContextHelper.getContextClassLoader();
                    if (this.targetLoader == null) {
                        classLoader3 = this.context.getClassLoader();
                        this.setTargetClassLoader(classLoader3);
                    } else {
                        classLoader3 = this.targetLoader;
                    }
                    if (classLoader3 != classLoader2) {
                        ThreadContextHelper.setClassLoader(classLoader3);
                    } else {
                        classLoader2 = null;
                    }
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ServletException {
                            try {
                                Servlet servlet = (Servlet)Beans.instantiate(ThreadContextHelper.getContextClassLoader(), string);
                                ServletWrapper.this.createTarget(servlet);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.webcontainer.webapp.WebAppServletManager.loadServlet", "208", this);
                                Object[] objectArray = new Object[]{classNotFoundException.getMessage(), classNotFoundException};
                                Tr.error(tc, "[Servlet Error]-[{0}]: {1}", objectArray);
                                throw new UnavailableException(MessageFormat.format(nls.getString("Servlet.Could.not.find.required.servlet.class", "Servlet [{0}]: Could not find required servlet - {1}"), string, classNotFoundException.getMessage()));
                            }
                            catch (ClassCastException classCastException) {
                                FFDCFilter.processException((Throwable)classCastException, "com.ibm.ws.webcontainer.webapp.WebAppServletManager.loadServlet", "213", this);
                                throw new UnavailableException(MessageFormat.format(nls.getString("Servlet.not.a.servlet.class", "Servlet [{0}]: not a servlet class"), string));
                            }
                            catch (NoClassDefFoundError noClassDefFoundError) {
                                FFDCFilter.processException((Throwable)noClassDefFoundError, "com.ibm.ws.webcontainer.webapp.WebAppServletManager.loadServlet", "218", this);
                                throw new UnavailableException(MessageFormat.format(nls.getString("Servlet.was.found.but.is.missing.another.required.class", "Servlet [{0}]: {1} was found, but is missing another required class.\n"), string2, string) + nls.getString("This.error.implies.servlet.was.originally.compiled.with.classes.which.cannot.be.located.by.server", "This error typically implies that the servlet was originally compiled with classes which cannot be located by the server.\n") + nls.getString("Check.your.classpath.ensure.all.classes.present", "Check your classpath to ensure that all classes required by the servlet are present.\n") + nls.getString("be.debugged.by.recompiling.the.servlet.using.only.the.classes.in.the.application's.runtime.classpath", "\n  This problem can be debugged by recompiling the servlet using only the classes in the application's runtime classpath\n") + MessageFormat.format(nls.getString("Application.classpath", "Application classpath=[{0}]"), ServletWrapper.this.context.getClasspath()));
                            }
                            catch (ClassFormatError classFormatError) {
                                FFDCFilter.processException((Throwable)classFormatError, "com.ibm.ws.webcontainer.webapp.WebAppServletManager.loadServlet", "227", this);
                                throw new UnavailableException(MessageFormat.format(nls.getString("Servlet.found.but.corrupt", "Servlet [{0}]: {1} was found, but is corrupt:\n"), string2, string) + nls.getString("class.resides.in.proper.package.directory", "1. Check that the class resides in the proper package directory.\n") + nls.getString("classname.defined.in.server.using.proper.case.and.fully.qualified.package", "2. Check that the classname has been defined in the server using the proper case and fully qualified package.\n") + nls.getString("class.transfered.using.binary.mode", "3. Check that the class was transfered to the filesystem using a binary tranfer mode.\n") + nls.getString("class.compiled.using.proper.case", "4. Check that the class was compiled using the proper case (as defined in the class definition).\n") + nls.getString("class.not.renamed.after.compiled", "5. Check that the class file was not renamed after it was compiled."));
                            }
                            catch (IOException iOException) {
                                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webcontainer.webapp.WebAppServletManager.loadServlet", "227", this);
                                throw new ServletException(MessageFormat.format(nls.getString("Servlet.found.but.corrupt", "Servlet [{0}]: {1} was found, but is corrupt:\n"), string2, string) + nls.getString("class.resides.in.proper.package.directory", "1. Check that the class resides in the proper package directory.\n") + nls.getString("classname.defined.in.server.using.proper.case.and.fully.qualified.package", "2. Check that the classname has been defined in the server using the proper case and fully qualified package.\n") + nls.getString("class.transfered.using.binary.mode", "3. Check that the class was transfered to the filesystem using a binary tranfer mode.\n") + nls.getString("class.compiled.using.proper.case", "4. Check that the class was compiled using the proper case (as defined in the class definition).\n") + nls.getString("class.not.renamed.after.compiled", "5. Check that the class file was not renamed after it was compiled."), iOException);
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                Tr.exit(tc, "loadServlet");
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Throwable throwable = privilegedActionException.getCause();
                    if (!(throwable instanceof Exception)) throw new Exception(throwable);
                    throw (Exception)throwable;
                }
                catch (Throwable throwable) {
                    throw new Exception(throwable);
                }
                Object var7_7 = null;
                if (classLoader2 == null) break block13;
                classLoader = classLoader2;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (classLoader2 != null) {
                    ClassLoader classLoader4 = classLoader2;
                    ThreadContextHelper.setClassLoader(classLoader4);
                }
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "loadServlet");
                throw throwable;
            }
            ThreadContextHelper.setClassLoader(classLoader);
        }
        if (!TraceComponent.isAnyTracingEnabled()) return this.target;
        if (!tc.isEntryEnabled()) return this.target;
        Tr.exit(tc, "loadServlet");
        return this.target;
    }

    private ServletEvent getServletEvent() {
        if (this.event == null) {
            this.event = new ServletEvent(this, this.servletConfig.getServletContext(), this.servletConfig.getServletName(), this.servletConfig.getClassName());
        }
        return this.event;
    }

    private synchronized void handleUnavailableException(UnavailableException unavailableException) throws UnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleUnavailableException", unavailableException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "UnavailableException was thrown by servlet: " + this.getServletName() + " reason:" + unavailableException.getMessage());
        }
        if (this.state == 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "state is already permanently unavailable, throw ue");
            }
            throw new UnavailableException(this.unavailableMessage);
        }
        if (unavailableException.isPermanent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "exception is permanent");
            }
            if (this.state == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "state is available so destroy the servlet");
                }
                if (!this.context.removeServlet(this.getServletName())) {
                    // empty if block
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.debug(tc, "removeServlet didn't destroy. destroy from handleUnavailableException");
                }
                this.destroy();
            }
            this.unavailableMessage = unavailableException.getMessage();
            this.setUnavailable();
        } else {
            long l;
            int n = unavailableException.getUnavailableSeconds();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ue is not permanent, unavailable secs -->[" + n + "]");
            }
            if (n > 0 && (l = System.currentTimeMillis() + (long)(n * 1000)) > this.unavailableUntil) {
                this.unavailableMessage = unavailableException.getMessage();
                this.setUnavailableUntil(l);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleUnavailableException");
        }
    }

    private void setUnavailableUntil(long l) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setUnavailableUntil() : " + l);
        }
        this.state = 1;
        this.unavailableUntil = l;
        this.evtSource.onServletUnavailableForService(this.getServletEvent());
    }

    protected void setUnavailable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setUnavailable()");
        }
        this.state = (byte)2;
        this.evtSource.onServletUnavailableForService(this.getServletEvent());
    }

    private void setAvailable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setAvailable() :" + this.toString());
        }
        this.evtSource.onServletAvailableForService(this.getServletEvent());
        this.state = 0;
        this.unavailableMessage = null;
        this.unavailableUntil = -1L;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setAvailable");
        }
    }

    protected synchronized void invalidateCacheWrappers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "invalidateCacheWrappers");
        }
        if (this.cacheWrappers != null) {
            Iterator iterator = this.cacheWrappers.iterator();
            while (iterator.hasNext()) {
                ServletReferenceListener servletReferenceListener = (ServletReferenceListener)iterator.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "servlet reference listener -->[" + servletReferenceListener + "]");
                }
                servletReferenceListener.invalidate();
            }
            this.cacheWrappers = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "invalidateCacheWrappers");
        }
    }

    public void addSubContainer(Container container) {
    }

    public Container getParent() {
        return this.context;
    }

    public Container getSubContainer(String string) {
        return null;
    }

    public void initialize(Configuration configuration) {
    }

    public boolean isActive() {
        return this.state != -1;
    }

    public boolean isAlive() {
        return this.state != this.UNAVAILABLE_PERMANENTLY_STATE && this.state != this.UNAVAILABLE_STATE;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public Container removeSubContainer(String string) {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Iterator subContainers() {
        return null;
    }

    public void execute(Request request, Response response) {
    }

    public ServletContext getServletContext() {
        return this.servletConfig.getServletContext();
    }

    public WebApp getWebApp() {
        return this.context;
    }

    public String getServletName() {
        if (this.servletConfig == null) {
            return null;
        }
        return this.servletConfig.getServletName();
    }

    private IServletWrapper getMimeFilterWrapper(String string) {
        try {
            if (string.indexOf(";") != -1) {
                string = string.substring(0, string.indexOf(";"));
            }
            return this.context.getMimeFilterWrapper(string);
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, "com.ibm.ws.webcontainer.webapp.WebAppRequestDispatcher.getMimeFilterReference", "834", this);
            this.context.logError("Failed to load filter for mime-type: " + string, servletException);
            return null;
        }
    }

    private void transferHeadersFromPrevChainedResp(ChainedResponse chainedResponse, ChainedResponse chainedResponse2) {
        Object object;
        Enumeration enumeration = chainedResponse2.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = chainedResponse2.getHeader((String)object);
            chainedResponse.setHeader((String)object, string);
        }
        object = chainedResponse2.getCookies();
        for (int i = 0; i < ((Cookie[])object).length; ++i) {
            Cookie cookie = object[i];
            chainedResponse.addCookie(cookie);
        }
    }

    public void addServletReferenceListener(ServletReferenceListener servletReferenceListener) {
        if (this.cacheWrappers == null) {
            this.cacheWrappers = new ArrayList();
        }
        this.cacheWrappers.add(servletReferenceListener);
    }

    public void setTargetClassLoader(ClassLoader classLoader) {
        this.targetLoader = classLoader;
    }

    public Servlet getTarget() {
        return this.target;
    }

    public ClassLoader getTargetClassLoader() {
        return this.targetLoader;
    }

    public void setTarget(Servlet servlet) {
        this.target = servlet;
    }

    public String toString() {
        if (this.state == 2) {
            return "ServletWrapper[Servlet is permanently unavailable]";
        }
        return "ServletWrapper[" + this.getServletName() + ":" + this.servletConfig.getMappings() + "]";
    }

    public boolean isAvailable() {
        return true;
    }

    protected synchronized void createTarget(Servlet servlet) throws UnavailableException {
        if (servlet instanceof SingleThreadModel) {
            this.isSTM = true;
            this.target = new SingleThreadModelServlet(servlet.getClass());
        } else {
            this.target = servlet;
        }
    }

    public void nameSpacePostInvoke() {
    }

    public void nameSpacePreInvoke() {
    }

    static {
        String string = WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.servletdestroywaittime");
        if (string != null) {
            try {
                destroyWaitTime = Integer.parseInt(string);
            }
            catch (Exception exception) {
                Tr.error(tc, "Illegal value for com.ibm.ws.webcontainer.servletdestroywaittime: " + string, exception);
            }
        }
        discernUnavailableServlet = new Boolean(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.discernunavailableservlet", "false"));
    }
}

