/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class RequestUtils
extends com.ibm.wsspi.webcontainer.util.RequestUtils {
    private static String SYSTEM_CLIENT_ENCODING;
    private static String SYSTEM_FILE_ENCODING;
    public static final String SYS_PROP_FILE_ENCODING = "file.encoding";
    public static final String SYS_PROP_DFLT_CLIENT_ENCODING = "default.client.encoding";
    private static NLS nls;
    protected static TraceComponent tc;
    public static final String ACCEPT_CHARSET_HEADER = "Accept-Charset";
    public static final String ACCEPT_LANGUAGE_HEADER = "Accept-Language";
    public static final String DEFAULT_CLIENT_ENCODING = "iso-8859-1";
    public static final String HEADER_SEPARATOR = ",";
    public static final String LANG_CHINESE_S = "zh-cn";
    public static final String LANG_CHINESE = "zh";
    public static final String LANG_CHINESE_T = "zh-tw";
    public static final String LANG_EN = "en";
    public static final String LANG_KOREA = "ko";
    public static final String LANG_JAPAN1 = "ja";
    public static final String LANG_JAPAN2 = "jp";
    public static final String ENC_CHINESE_S = "Cp1381";
    public static final String ENC_CHINESE_T = "Cp950";
    public static final String ENC_ENGLISH = "iso-8859-1";
    public static final String ENC_KOREA = "KSC5601";
    public static final String ENC_JAPAN = "Shift_JIS";
    private static final String SHORT_ASCII = "8859";
    private static final String ACCEPT_ALL_VAL = "*";
    private static final String CP1047_ENCODING = "Cp1047";
    private static final String ISO8859_1_ENCODING = "8859_1";
    private static final String CP939_ENCODING = "Cp939";
    private static final String SJIS_ENCODING = "SJIS";
    private static final int DEFAULT_BUFFER_SIZE = 2048;

    public static String getClientEncoding(HttpServletRequest httpServletRequest) {
        String string = null;
        if (SYSTEM_CLIENT_ENCODING != null) {
            string = SYSTEM_CLIENT_ENCODING;
            return string;
        }
        String string2 = httpServletRequest.getHeader(ACCEPT_CHARSET_HEADER);
        if (string2 != null) {
            if (string2.indexOf(SHORT_ASCII) != -1) {
                string = RequestUtils.getLanguage(httpServletRequest);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, HEADER_SEPARATOR);
                string = stringTokenizer.nextToken().trim();
                if (string.equals(ACCEPT_ALL_VAL)) {
                    string = "iso-8859-1";
                }
                if (!EncodingUtils.isCharsetSupported(string)) {
                    string = RequestUtils.getLanguage(httpServletRequest);
                }
            }
        } else {
            string = RequestUtils.getLanguage(httpServletRequest);
        }
        return string;
    }

    public static String getEbcdicEncodingIfZos() {
        String string = System.getProperty("os.name");
        String string2 = null;
        if (string.equalsIgnoreCase("z/OS") || string.equalsIgnoreCase("OS/390")) {
            String string3 = Locale.getDefault().getLanguage();
            if (string3.startsWith(LANG_EN)) {
                string2 = CP1047_ENCODING;
            } else if (string3.equals(LANG_JAPAN1) || string3.equals(LANG_JAPAN2)) {
                string2 = SJIS_ENCODING;
            }
        }
        return string2;
    }

    public static String getEncodingFromLanguage(String string) {
        if (string.startsWith(LANG_EN)) {
            return "iso-8859-1";
        }
        if (string.equals(LANG_JAPAN1) || string.equals(LANG_JAPAN2)) {
            return ENC_JAPAN;
        }
        if (string.equals(LANG_CHINESE_T)) {
            return ENC_CHINESE_T;
        }
        if (string.equals(LANG_KOREA)) {
            return ENC_KOREA;
        }
        if (string.equals(LANG_CHINESE_S) || string.equals(LANG_CHINESE)) {
            return ENC_CHINESE_S;
        }
        return "iso-8859-1";
    }

    public static String getLanguage(HttpServletRequest httpServletRequest) {
        String string = null;
        String string2 = httpServletRequest.getHeader(ACCEPT_LANGUAGE_HEADER);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, HEADER_SEPARATOR);
            String string3 = stringTokenizer.nextToken().trim().toLowerCase();
            string = RequestUtils.getEncodingFromLanguage(string3);
        } else {
            string = SYSTEM_FILE_ENCODING != null ? (SYSTEM_FILE_ENCODING.equals(CP1047_ENCODING) ? ISO8859_1_ENCODING : (SYSTEM_FILE_ENCODING.equals(CP939_ENCODING) ? SJIS_ENCODING : "iso-8859-1")) : "iso-8859-1";
        }
        if (!EncodingUtils.isCharsetSupported(string)) {
            string = SYSTEM_FILE_ENCODING == null ? "iso-8859-1" : SYSTEM_FILE_ENCODING;
        }
        return string;
    }

    private static String parseName(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    continue block7;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        FFDCFilter.processException(numberFormatException, "com.ibm.ws.webcontainer.servlet.RequestUtils.parseName", "337");
                        throw new IllegalArgumentException("Unable to parse query string name or value  [" + string + "] ");
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        FFDCFilter.processException(stringIndexOutOfBoundsException, "com.ibm.ws.webcontainer.servlet.RequestUtils.parseName", "342");
                        String string2 = string.substring(i);
                        stringBuffer.append(string2);
                        if (string2.length() != 2) continue block7;
                        ++i;
                        continue block7;
                    }
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Hashtable parsePostData(int n, ServletInputStream servletInputStream, String string) throws IOException {
        String string2;
        byte[] byArray = null;
        if (n <= 0) {
            return null;
        }
        if (servletInputStream == null) {
            throw new IllegalArgumentException("post data inputstream is null");
        }
        try {
            int n2;
            byArray = new byte[n];
            int n3 = 0;
            do {
                if ((n2 = servletInputStream.read(byArray, n3, n - n3)) > 0) continue;
                String string3 = nls.getString("post.body.contains.less.bytes.than.specified", "post body contains less bytes than specified by content-length");
                throw new IOException(string3);
            } while (n - (n3 += n2) > 0);
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.webcontainer.servlet.RequestUtils.parsePostData", "398");
            throw iOException;
        }
        try {
            string2 = new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException(unsupportedEncodingException, "com.ibm.ws.webcontainer.servlet.RequestUtils.parsePostData", "411");
            string2 = new String(byArray);
        }
        return RequestUtils.parseQueryString(string2, string);
    }

    public static Hashtable parsePostData(ServletInputStream servletInputStream, String string) throws IOException {
        String string2;
        byte[] byArray = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parsePostData", "parsing chunked post data");
        }
        if (servletInputStream == null) {
            throw new IllegalArgumentException("post data inputstream is null");
        }
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            do {
                byte[] byArray2;
                if ((n = servletInputStream.read(byArray2 = new byte[2048], 0, 2048)) <= 0) continue;
                byteArrayOutputStream.write(byArray2, 0, n);
            } while (n != -1);
            byArray = byteArrayOutputStream.toByteArray();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parsePostData", "finished reading [" + byArray.length + "] bytes");
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.webcontainer.servlet.RequestUtils.parsePostData", "598");
            throw iOException;
        }
        try {
            string2 = new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException(unsupportedEncodingException, "com.ibm.ws.webcontainer.servlet.RequestUtils.parsePostData", "618");
            string2 = new String(byArray);
        }
        return RequestUtils.parseQueryString(string2, string);
    }

    static {
        nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
        tc = Tr.register(RequestUtils.class, "Webcontainer", "com.ibm.ws.webcontainer.resources.Messages");
        SYSTEM_FILE_ENCODING = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(RequestUtils.SYS_PROP_FILE_ENCODING);
            }
        });
        SYSTEM_CLIENT_ENCODING = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(RequestUtils.SYS_PROP_DFLT_CLIENT_ENCODING);
            }
        });
    }
}

