/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.core.Request;
import com.ibm.ws.webcontainer.servlet.exception.NoTargetForURIException;
import com.ibm.ws.webcontainer.util.InvalidCacheTargetException;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppErrorReport;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.servlet.ServletReferenceListener;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheServletWrapper
implements RequestProcessor,
ServletReferenceListener {
    private static TraceComponent tc = Tr.register(CacheServletWrapper.class, "Webcontainer", "com.ibm.ws.webcontainer.resources.Messages");
    private String _servletPath;
    private String _pathInfo;
    private IServletWrapper cacheTarget;
    private HashMap cache;
    private String cacheKeyStr;
    private volatile boolean isValid = false;
    private WebApp webapp;
    private String requestUri;

    public CacheServletWrapper(IServletWrapper iServletWrapper, HttpServletRequest httpServletRequest, HashMap hashMap, StringBuffer stringBuffer, WebApp webApp) {
        this.cacheTarget = iServletWrapper;
        this.cacheTarget.addServletReferenceListener(this);
        this._pathInfo = httpServletRequest.getPathInfo();
        this._servletPath = httpServletRequest.getServletPath();
        this.requestUri = httpServletRequest.getRequestURI();
        this.cache = hashMap;
        this.cacheKeyStr = stringBuffer.toString();
        this.webapp = webApp;
        hashMap.put(this.cacheKeyStr, this);
        this.isValid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        block12: {
            IServletWrapper iServletWrapper;
            boolean bl;
            CacheServletWrapper cacheServletWrapper = this;
            synchronized (cacheServletWrapper) {
                bl = this.isValid;
                iServletWrapper = this.cacheTarget;
            }
            try {
                if (!bl) {
                    throw InvalidCacheTargetException.instance();
                }
                iServletWrapper.handleRequest(servletRequest, servletResponse);
            }
            catch (NoTargetForURIException noTargetForURIException) {
                WebAppErrorReport webAppErrorReport = new WebAppErrorReport(noTargetForURIException);
                if (iServletWrapper != null && iServletWrapper instanceof IServletWrapper) {
                    webAppErrorReport.setTargetServletName(iServletWrapper.getServletName());
                }
                webAppErrorReport.setErrorCode(404);
                WebApp webApp = ((Request)servletRequest).getWebAppDispatcherContext().getWebApp();
                if (servletRequest instanceof HttpServletRequest) {
                    webApp.sendError((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, webAppErrorReport);
                }
            }
            catch (ServletErrorReport servletErrorReport) {
                WebApp webApp = ((Request)servletRequest).getWebAppDispatcherContext().getWebApp();
                if (servletRequest instanceof HttpServletRequest) {
                    webApp.sendError((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, servletErrorReport);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.webcontainer.webapp.WebApp.handleRequest", "985", this);
                WebAppErrorReport webAppErrorReport = new WebAppErrorReport(throwable);
                if (iServletWrapper != null && iServletWrapper instanceof IServletWrapper) {
                    webAppErrorReport.setTargetServletName(iServletWrapper.getServletName());
                }
                webAppErrorReport.setErrorCode(500);
                WebApp webApp = ((Request)servletRequest).getWebAppDispatcherContext().getWebApp();
                if (!(servletRequest instanceof HttpServletRequest)) break block12;
                webApp.sendError((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, webAppErrorReport);
            }
        }
    }

    public String getPathInfo() {
        return this._pathInfo;
    }

    public String getServletPath() {
        return this._servletPath;
    }

    public void setPathInfo(String string) {
        this._pathInfo = string;
    }

    public void setServletPath(String string) {
        this._servletPath = string;
    }

    public WebApp getWebApp() {
        if (this.cacheTarget != null) {
            return this.webapp;
        }
        throw InvalidCacheTargetException.instance();
    }

    public synchronized void invalidate() {
        if (this.isValid) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "first invalidate");
            }
            this.cache.remove(this.cacheKeyStr);
            this.isValid = false;
            this.cacheTarget = null;
            this._servletPath = null;
            this._pathInfo = null;
            this.cache = null;
            this.webapp = null;
            this.cacheKeyStr = null;
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "additional invalidate");
        }
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getCacheKeyString() {
        return this.cacheKeyStr;
    }

    public IServletWrapper getCacheTarget() {
        return this.cacheTarget;
    }

    public String toString() {
        String string = this.webapp == null ? " Webapp nulled::  " + this.webapp + "  " + " ServletPath:: " + this._servletPath + "  " + " CacheKey ::" + this.cacheKeyStr + "  " + " _pathInfo::" + this._pathInfo + "  " + " requestUri ::" + this.requestUri + "  " : " Webapp::  " + this.webapp + "  " + " ServletPath:: " + this._servletPath + "  " + " CacheKey ::" + this.cacheKeyStr + "  " + " _pathInfo::" + this._pathInfo + "  " + " requestUri ::" + this.requestUri + "  " + "ApplicationName::" + this.webapp.getApplicationName() + "  " + "WebAppContxtPath::" + this.webapp.getContextPath();
        return string;
    }
}

