/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.filter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.event.FilterListenerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.core.Request;
import com.ibm.ws.webcontainer.filter.FilterChainContents;
import com.ibm.ws.webcontainer.filter.FilterInstanceWrapper;
import com.ibm.ws.webcontainer.filter.FilterMapping;
import com.ibm.ws.webcontainer.filter.WebAppFilterChain;
import com.ibm.ws.webcontainer.servlet.ServletWrapper;
import com.ibm.ws.webcontainer.util.ThreadContextHelper;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppEventSource;
import com.ibm.wsspi.webcontainer.IInternalConfig;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.filter.IFilterConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import com.ibm.wsspi.webcontainer.webapp.NamespaceInvoker;
import java.beans.Beans;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebAppFilterManager
implements com.ibm.wsspi.webcontainer.filter.WebAppFilterManager {
    protected Hashtable _filterWrappers = new Hashtable();
    private Map chainCache = Collections.synchronizedMap(new LinkedHashMap(20, 0.75f, true){

        public boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 200;
        }
    });
    private Map forwardChainCache = Collections.synchronizedMap(new LinkedHashMap(10, 0.75f, true){

        public boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 100;
        }
    });
    private Map includeChainCache = Collections.synchronizedMap(new LinkedHashMap(5, 0.75f, true){

        public boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 100;
        }
    });
    private Map errorChainCache = Collections.synchronizedMap(new LinkedHashMap(2, 0.75f, true){

        public boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 100;
        }
    });
    private ArrayList _uriFilterMappings = new ArrayList();
    private ArrayList _servletFilterMappings = new ArrayList();
    public boolean _filtersDefined = false;
    static final int FMI_MAPPING_SINGLE_SLASH = 0;
    static final int FMI_MAPPING_PATH_MATCH = 1;
    static final int FMI_MAPPING_EXTENSION_MATCH = 2;
    static final int FMI_MAPPING_EXACT_MATCH = 3;
    private static TraceComponent tc = Tr.register(WebAppFilterManager.class, "Webcontainer", "com.ibm.ws.webcontainer.resources.Messages");
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private boolean _entryEnabled = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled();
    WebAppConfiguration webAppConfig;
    protected WebApp webApp;
    private WebAppEventSource _evtSource = null;
    private static boolean mapFiltersToAsterisk = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.mapfilterstoasterisk"));

    public WebAppFilterManager(WebAppConfiguration webAppConfiguration, WebApp webApp) {
        this.webAppConfig = webAppConfiguration;
        this.webApp = webApp;
        this._evtSource = (WebAppEventSource)webApp.getServletContextEventSource();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding debug filter invocation listener");
            FilterListenerImpl filterListenerImpl = new FilterListenerImpl();
            this._evtSource.addFilterInvocationListener(filterListenerImpl);
            this._evtSource.addFilterListener(filterListenerImpl);
            this._evtSource.addFilterErrorListener(filterListenerImpl);
        }
    }

    public void init() {
        List list = this.webAppConfig.getFilterMappings();
        if (!list.isEmpty()) {
            this._filtersDefined = true;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FilterMapping filterMapping = (FilterMapping)iterator.next();
                this.addFilterMapping(filterMapping);
            }
        }
    }

    public void addFilterMapping(FilterMapping filterMapping) {
        if (filterMapping != null) {
            this._filtersDefined = true;
            FilterMappingInfo filterMappingInfo = new FilterMappingInfo();
            String string = filterMapping.getUrlPattern();
            IFilterConfig iFilterConfig = filterMapping.getFilterConfig();
            if (iFilterConfig instanceof IInternalConfig) {
                filterMappingInfo.setIsInternal(((IInternalConfig)((Object)iFilterConfig)).getIsInternal());
            }
            if (string != null) {
                filterMappingInfo.setFilterName(filterMapping.getFilterConfig().getFilterName());
                filterMappingInfo.setFilterURI(string);
                filterMappingInfo.setDispatchMode(filterMapping.getDispatchMode());
                this._uriFilterMappings.add(filterMappingInfo);
            } else {
                filterMappingInfo.setFilterName(filterMapping.getFilterConfig().getFilterName());
                IServletConfig iServletConfig = filterMapping.getServletConfig();
                if (iServletConfig != null) {
                    filterMappingInfo.setFilterServlet(iServletConfig.getServletName());
                }
                filterMappingInfo.setDispatchMode(filterMapping.getDispatchMode());
                this._servletFilterMappings.add(filterMappingInfo);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding filterMappingInfo -->" + filterMappingInfo.toString());
            }
        }
    }

    public FilterInstanceWrapper getFilterInstanceWrapper(String string) throws ServletException {
        if (this._entryEnabled) {
            Tr.entry(tc, "getFilterInstance");
        }
        try {
            FilterInstanceWrapper filterInstanceWrapper = (FilterInstanceWrapper)this._filterWrappers.get(string);
            if (filterInstanceWrapper != null) {
                return filterInstanceWrapper;
            }
            return this.loadFilter(string);
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.getFilterInstanceWrapper", "166", this);
            throw servletException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.getFilterInstanceWrapper", "172", this);
            throw new ServletException(MessageFormat.format("Filter [{0}]: could not be loaded", string), throwable);
        }
    }

    public WebAppFilterChain getFilterChain(String string, IServletWrapper iServletWrapper, int n) throws ServletException {
        Object object;
        String string2 = "null";
        boolean bl = false;
        if (iServletWrapper != null) {
            string2 = iServletWrapper.getServletName();
            object = (IServletConfig)iServletWrapper.getServletConfig();
            if (object instanceof IInternalConfig) {
                bl = ((IInternalConfig)object).getIsInternal();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "requestURI [" + string + "] isInternal [" + bl + "]");
        }
        object = this.getFilterChainContents(string, string2, n, bl);
        WebAppFilterChain webAppFilterChain = new WebAppFilterChain(this.webApp);
        if (((FilterChainContents)object)._hasFilters) {
            ArrayList arrayList = ((FilterChainContents)object).getFilterNames();
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                webAppFilterChain.addFilter(this.getFilterInstanceWrapper((String)arrayList.get(i)));
            }
        }
        webAppFilterChain.setRequestedServlet(iServletWrapper);
        return webAppFilterChain;
    }

    public WebAppFilterChain getFilterChain(String string, ServletWrapper servletWrapper) throws ServletException {
        return this.getFilterChain(string, servletWrapper, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Enumeration enumeration = this._filterWrappers.elements();
        ClassLoader classLoader = ThreadContextHelper.getContextClassLoader();
        try {
            ClassLoader classLoader2 = this.webApp.getClassLoader();
            if (classLoader2 != classLoader) {
                ThreadContextHelper.setClassLoader(classLoader2);
            }
            while (enumeration.hasMoreElements()) {
                try {
                    ((FilterInstanceWrapper)enumeration.nextElement()).destroy();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.shutdown", "237", this);
                }
            }
        }
        finally {
            ThreadContextHelper.setClassLoader(classLoader);
        }
        this._filterWrappers = null;
        this.chainCache = null;
        this.forwardChainCache = null;
        this.includeChainCache = null;
        this.errorChainCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterInstanceWrapper loadFilter(String string) throws ServletException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader2 = this.webApp.getClassLoader();
            if (classLoader2 != classLoader) {
                ThreadContextHelper.setClassLoader(classLoader2);
            }
            FilterInstanceWrapper filterInstanceWrapper = this._loadFilter(string);
            return filterInstanceWrapper;
        }
        finally {
            ThreadContextHelper.setClassLoader(classLoader);
        }
    }

    private FilterInstanceWrapper _loadFilter(String string) throws ServletException {
        if (this._entryEnabled) {
            Tr.entry(tc, "createFilterInstance");
        }
        FilterInstanceWrapper filterInstanceWrapper = null;
        try {
            Filter filter;
            IFilterConfig iFilterConfig = this.webAppConfig.getFilterInfo(string);
            iFilterConfig.setContext(this.webApp.getFacade());
            String string2 = iFilterConfig.getFilterClassName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Instantiating Filter Class: {0}", string2);
            }
            try {
                ClassLoader classLoader = iFilterConfig.getFilterClassLoader();
                if (classLoader != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "FilterConfig classloader: " + classLoader);
                    }
                    filter = (Filter)Beans.instantiate(classLoader, string2);
                    iFilterConfig.setFilterClassLoader(null);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Filter default classloader: " + this.webApp.getClassLoader());
                    }
                    filter = (Filter)Beans.instantiate(this.webApp.getClassLoader(), string2);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "298", this);
                throw new ServletException(MessageFormat.format(nls.getString("Could.not.find.required.filter.class", "Filter [{0}]: Could not find required filter class - {1}.class"), string, string2), classNotFoundException);
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "303", this);
                throw new ServletException(MessageFormat.format(nls.getString("Filter.not.a.filter.class", "Filter [{0}]: not a filter class"), string), classCastException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                FFDCFilter.processException((Throwable)noClassDefFoundError, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "308", this);
                throw new ServletException(MessageFormat.format(nls.getString("Filter.was.found.but.is.missing.another.required.class", "Filter [{0}]: {1} was found, but is missing another required class.\n"), string, string2), noClassDefFoundError);
            }
            catch (ClassFormatError classFormatError) {
                FFDCFilter.processException((Throwable)classFormatError, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "313", this);
                throw new ServletException(MessageFormat.format(nls.getString("Filter.found.but.corrupt", "Filter [{0}]: {1} was found, but is corrupt:\n"), string, string2), classFormatError);
            }
            filterInstanceWrapper = this.createFilterInstanceWrapper(string, filter);
            filterInstanceWrapper.init(iFilterConfig);
            this._filterWrappers.put(string, filterInstanceWrapper);
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "380", this);
            throw servletException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "385", this);
            throw new ServletException(MessageFormat.format("Filter [{0}]: could not be loaded", string), throwable);
        }
        if (this._entryEnabled) {
            Tr.exit(tc, "loadFilter");
        }
        return filterInstanceWrapper;
    }

    protected FilterInstanceWrapper createFilterInstanceWrapper(String string, Filter filter) throws Exception {
        return new FilterInstanceWrapper(string, filter, this._evtSource);
    }

    private FilterChainContents getFilterChainContents(String string, String string2, int n, boolean bl) {
        int n2;
        FilterChainContents filterChainContents = null;
        String string3 = null;
        if (string != null) {
            n2 = string.indexOf("?");
            string3 = n2 > 0 ? string.substring(0, n2) : string;
            int n3 = string3.indexOf(59);
            if (n3 != -1) {
                string3 = string3.substring(0, n3);
            }
            if (n == 0) {
                filterChainContents = (FilterChainContents)this.chainCache.get(string3);
            } else if (n == 1) {
                filterChainContents = (FilterChainContents)this.forwardChainCache.get(string3);
            } else if (n == 2) {
                filterChainContents = (FilterChainContents)this.includeChainCache.get(string3);
            } else if (n == 3) {
                filterChainContents = (FilterChainContents)this.errorChainCache.get(string3);
            }
        } else if (n == 0) {
            filterChainContents = (FilterChainContents)this.chainCache.get(string2);
        } else if (n == 1) {
            filterChainContents = (FilterChainContents)this.forwardChainCache.get(string2);
        } else if (n == 2) {
            filterChainContents = (FilterChainContents)this.includeChainCache.get(string2);
        } else if (n == 3) {
            filterChainContents = (FilterChainContents)this.errorChainCache.get(string2);
        }
        if (filterChainContents == null) {
            int n4;
            filterChainContents = new FilterChainContents();
            if (string3 != null) {
                n4 = this._uriFilterMappings.size();
                for (n2 = 0; n2 < n4; ++n2) {
                    FilterMappingInfo filterMappingInfo = (FilterMappingInfo)this._uriFilterMappings.get(n2);
                    if (bl != filterMappingInfo._isInternal || !this.uriMatch(string3, filterMappingInfo, n)) continue;
                    filterChainContents.addFilter(filterMappingInfo._filterName);
                }
            }
            n4 = this._servletFilterMappings.size();
            block1: for (n2 = 0; n2 < n4; ++n2) {
                FilterMappingInfo filterMappingInfo = (FilterMappingInfo)this._servletFilterMappings.get(n2);
                if (!string2.equals(filterMappingInfo._filterServlet)) continue;
                for (int i = 0; i < filterMappingInfo.dispatchMode.length; ++i) {
                    if (bl != filterMappingInfo._isInternal || n != filterMappingInfo.dispatchMode[i]) continue;
                    filterChainContents.addFilter(filterMappingInfo._filterName);
                    continue block1;
                }
            }
            if (string3 != null) {
                if (n == 0) {
                    this.chainCache.put(string3, filterChainContents);
                } else if (n == 1) {
                    this.forwardChainCache.put(string3, filterChainContents);
                } else if (n == 2) {
                    this.includeChainCache.put(string3, filterChainContents);
                } else if (n == 3) {
                    this.errorChainCache.put(string3, filterChainContents);
                }
            } else if (n == 0) {
                this.chainCache.put(string2, filterChainContents);
            } else if (n == 1) {
                this.forwardChainCache.put(string2, filterChainContents);
            } else if (n == 2) {
                this.includeChainCache.put(string2, filterChainContents);
            } else if (n == 3) {
                this.errorChainCache.put(string2, filterChainContents);
            }
        }
        return filterChainContents;
    }

    private boolean uriMatch(String string, FilterMappingInfo filterMappingInfo, int n) {
        int n2;
        boolean bl = false;
        switch (filterMappingInfo._mappingType) {
            case 0: {
                if (!string.equals("/")) break;
                bl = true;
                break;
            }
            case 1: {
                if (!string.startsWith(filterMappingInfo._filterURI + "/") && !string.equals(filterMappingInfo._filterURI)) break;
                bl = true;
                break;
            }
            case 2: {
                String string2 = filterMappingInfo._filterURI.substring(2);
                n2 = string.lastIndexOf(46);
                if (n2 == -1 || !string2.equals(string.substring(n2 + 1))) break;
                bl = true;
                break;
            }
            case 3: {
                if (!string.equals(filterMappingInfo._filterURI)) break;
                bl = true;
                break;
            }
        }
        boolean bl2 = false;
        if (bl) {
            for (n2 = 0; n2 < filterMappingInfo.dispatchMode.length; ++n2) {
                if (n != filterMappingInfo.dispatchMode[n2]) continue;
                bl2 = true;
                break;
            }
        }
        return bl2 && bl;
    }

    public void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, IServletWrapper iServletWrapper, WebAppDispatcherContext webAppDispatcherContext) throws ServletException, IOException {
        this.doFilter(httpServletRequest, httpServletResponse, iServletWrapper, null, webAppDispatcherContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeFilters(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, IServletWrapper iServletWrapper, IServletContext iServletContext, NamespaceInvoker namespaceInvoker) throws ServletException, IOException {
        boolean bl = false;
        try {
            if (namespaceInvoker != null) {
                namespaceInvoker.nameSpacePreInvoke();
            }
            if (iServletContext.isFiltersDefined()) {
                bl = this.invokeFilters(httpServletRequest, httpServletResponse, iServletWrapper, null, iServletContext);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (namespaceInvoker != null) {
                namespaceInvoker.nameSpacePostInvoke();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeFilters(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, IServletWrapper iServletWrapper, ExtensionProcessor extensionProcessor, IServletContext iServletContext) throws ServletException, IOException {
        boolean bl;
        block15: {
            ClassLoader classLoader;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "invokeFilters target=" + iServletWrapper);
            }
            ClassLoader classLoader2 = null;
            WebAppDispatcherContext webAppDispatcherContext = null;
            try {
                Request request = (Request)ServletUtil.unwrapRequest(httpServletRequest);
                webAppDispatcherContext = request.getWebAppDispatcherContext();
                classLoader2 = ThreadContextHelper.getContextClassLoader();
                ClassLoader classLoader3 = iServletContext.getClassLoader();
                if (classLoader3 != classLoader2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "PK26183 re-set class loader from: " + classLoader2.toString() + " ,to: " + classLoader3.toString());
                    }
                    ThreadContextHelper.setClassLoader(classLoader3);
                } else {
                    classLoader2 = null;
                }
                if (webAppDispatcherContext != null) {
                    webAppDispatcherContext.sessionPreInvoke();
                }
                this.doFilter(httpServletRequest, httpServletResponse, iServletWrapper, extensionProcessor, webAppDispatcherContext);
                bl = true;
                Object var12_13 = null;
                if (webAppDispatcherContext != null) {
                    webAppDispatcherContext.sessionPostInvoke();
                }
                if (classLoader2 == null) break block15;
                classLoader = classLoader2;
            }
            catch (Exception exception) {
                boolean bl2;
                block16: {
                    ClassLoader classLoader4;
                    try {
                        httpServletRequest.setAttribute("com.ibm.ws.webcontainer.filter.exceptioninfilter", exception);
                        bl2 = false;
                        Object var12_14 = null;
                        if (webAppDispatcherContext != null) {
                            webAppDispatcherContext.sessionPostInvoke();
                        }
                        if (classLoader2 == null) break block16;
                        classLoader4 = classLoader2;
                    }
                    catch (Throwable throwable) {
                        block17: {
                            Object var12_15 = null;
                            if (webAppDispatcherContext != null) {
                                webAppDispatcherContext.sessionPostInvoke();
                            }
                            if (classLoader2 != null) {
                                ClassLoader classLoader5 = classLoader2;
                                ThreadContextHelper.setClassLoader(classLoader5);
                            }
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block17;
                            Tr.exit(tc, "invokeFilters");
                        }
                        throw throwable;
                    }
                    ThreadContextHelper.setClassLoader(classLoader4);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "invokeFilters");
                }
                return bl2;
            }
            ThreadContextHelper.setClassLoader(classLoader);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeFilters");
        }
        return bl;
    }

    public void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, IServletWrapper iServletWrapper, ExtensionProcessor extensionProcessor, WebAppDispatcherContext webAppDispatcherContext) throws ServletException, IOException {
        WebAppFilterChain webAppFilterChain;
        String string;
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "doFilter");
        }
        boolean bl2 = bl = (string = (String)httpServletRequest.getAttribute("com.ibm.servlet.engine.webapp.dispatch_nested")) != null && string.equalsIgnoreCase("true");
        if (!bl) {
            webAppFilterChain = this.getFilterChain(webAppDispatcherContext.getRelativeUri(), iServletWrapper, 0);
        } else if (httpServletRequest.getAttribute("javax.servlet.jsp.jspException") != null) {
            webAppFilterChain = this.getFilterChain(webAppDispatcherContext.getRelativeUri(), iServletWrapper, 3);
        } else if (httpServletRequest.getAttribute("com.ibm.servlet.engine.webapp.dispatch_type").equals("include")) {
            String string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
            if (string2 == null) {
                webAppFilterChain = this.getFilterChain(null, iServletWrapper, 2);
            } else {
                StringBuffer stringBuffer = new StringBuffer(string2);
                String string3 = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
                if (string3 != null) {
                    stringBuffer.append(string3);
                }
                String string4 = stringBuffer.toString();
                webAppFilterChain = this.getFilterChain(string4, iServletWrapper, 2);
            }
        } else {
            webAppFilterChain = httpServletRequest.getAttribute("com.ibm.servlet.engine.webapp.dispatch_type").equals("forward") ? this.getFilterChain(webAppDispatcherContext.getRelativeUri(), iServletWrapper, 1) : this.getFilterChain(webAppDispatcherContext.getRelativeUri(), iServletWrapper, 0);
        }
        if (extensionProcessor != null) {
            webAppFilterChain.setExtensionProcessor(extensionProcessor);
        }
        webAppFilterChain._doFilter(httpServletRequest, httpServletResponse);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "doFilter");
        }
    }

    public boolean areFiltersDefined() {
        return this._filtersDefined;
    }

    protected class FilterMappingInfo {
        String _filterName;
        String _filterURI;
        String _filterServlet;
        int _mappingType;
        int[] dispatchMode;
        boolean _isInternal = false;

        protected FilterMappingInfo() {
        }

        public void setFilterName(String string) {
            this._filterName = string;
        }

        public void setDispatchMode(int[] nArray) {
            this.dispatchMode = nArray;
        }

        public void setFilterURI(String string) {
            if (string.equals("/")) {
                this._mappingType = 0;
            } else if (string.startsWith("/") && string.endsWith("/*")) {
                this._mappingType = 1;
                string = string.substring(0, string.length() - 2);
            } else if (string.startsWith("*.")) {
                this._mappingType = 2;
            } else if (mapFiltersToAsterisk && string.equals("*")) {
                this._mappingType = 1;
                string = "";
            } else {
                this._mappingType = 3;
            }
            this._filterURI = string;
        }

        public void setFilterServlet(String string) {
            this._filterServlet = string;
        }

        public void setIsInternal(boolean bl) {
            this._isInternal = bl;
        }

        public String toString() {
            return new String("filterName [" + this._filterName + "] filterURI [" + this._filterURI + "] _filterServlet [" + this._filterServlet + "] isInternal [" + this._isInternal + "]");
        }
    }
}

