/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.container.Container;
import com.ibm.ws.container.DeployedModule;
import com.ibm.ws.http.Alias;
import com.ibm.ws.webcontainer.VirtualHostConfiguration;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.core.BaseContainer;
import com.ibm.ws.webcontainer.core.Request;
import com.ibm.ws.webcontainer.exception.WebAppNotLoadedException;
import com.ibm.ws.webcontainer.exception.WebGroupVHostNotFoundException;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.util.URIMapper;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.ws.webcontainer.webapp.WebGroupConfiguration;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public abstract class VirtualHost
extends BaseContainer {
    protected static TraceComponent tc = Tr.register(VirtualHost.class, "Webcontainer", "com.ibm.ws.webcontainer.resources.Messages");
    protected VirtualHostConfiguration vHostConfig;

    public VirtualHost(String string, Container container) {
        super(string, container);
        this.requestMapper = new URIMapper();
    }

    public void init(VirtualHostConfiguration virtualHostConfiguration) {
        this.vHostConfig = virtualHostConfiguration;
    }

    public void addWebApplication(DeployedModule deployedModule, List list, boolean bl) throws WebAppNotLoadedException {
        WebGroupConfiguration webGroupConfiguration = deployedModule.getWebGroupConfig();
        WebGroup webGroup = deployedModule.getWebGroup();
        String string = deployedModule.getContextRoot();
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (string.endsWith("/") && !string.equals("/")) {
            string = string.substring(0, string.length() - 1);
        }
        String string2 = string;
        string = string.equals("/") ? string + "*" : string + "/*";
        String string3 = deployedModule.getDisplayName();
        WebGroup webGroup2 = null;
        webGroup2 = (WebGroup)this.requestMapper.map(string);
        if (webGroup2 != null && string2.equalsIgnoreCase(webGroup2.getConfiguration().getContextRoot())) {
            ArrayList arrayList = webGroup2.getWebApps();
            String string4 = "";
            if (arrayList != null && arrayList.size() > 0) {
                WebApp webApp = (WebApp)arrayList.get(0);
                string4 = webApp.getWebAppName();
            }
            Tr.error(tc, "context.root.already.in.use", new Object[]{string3, string, string4, string3});
            throw new WebAppNotLoadedException("Context root " + string + " is already bound. Cannot start application " + string3);
        }
        webGroup2 = webGroup;
        this.setWebAppVirtualHostList(deployedModule.getWebAppConfig());
        webGroupConfiguration.setWebAppHost(this);
        webGroup2.initialize(webGroupConfiguration);
        try {
            webGroup2.addWebApplication(deployedModule, list, bl);
            Object[] objectArray = new Object[]{string3, this.vHostConfig.toString()};
            Tr.info(tc, "module.[{0}].successfully.bound.to.virtualhost.[{1}]", objectArray);
        }
        catch (Throwable throwable) {
            throw new WebAppNotLoadedException(throwable.getMessage(), throwable);
        }
        try {
            this.addMapping(string, webGroup2);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error adding mapping \n{0}", exception);
            }
            webGroup2.destroy();
            throw new WebAppNotLoadedException("Context root " + string + " mapping unable to be bound. Application " + string3 + " unavailable.", exception);
        }
    }

    protected void setWebAppVirtualHostList(WebAppConfiguration webAppConfiguration) {
        Alias[] aliasArray = this.vHostConfig.getAliases();
        List list = webAppConfiguration.getVirtualHostList();
        for (int i = 0; i < aliasArray.length; ++i) {
            String string = aliasArray[i].getHostname();
            String string2 = aliasArray[i].getPort();
            list.add(string + ":" + string2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "virtualHostList -->" + list);
        }
    }

    public String getMimeType(String string, String string2) {
        String string3 = this.vHostConfig.getMimeType(string2);
        if (string3 == null) {
            string3 = this.vHostConfig.getMimeType(string);
        }
        return string3;
    }

    public IHttpSessionContext getSessionContext(DeployedModule deployedModule, WebApp webApp, ArrayList[] arrayListArray) throws Throwable {
        return ((WebContainer)this.parent).getSessionContext(deployedModule, webApp, this.vHostConfig.getName(), arrayListArray);
    }

    public ServletContext findContext(String string) {
        WebGroup webGroup = (WebGroup)this.requestMapper.map(string);
        if (webGroup != null) {
            return webGroup.getContext();
        }
        return null;
    }

    public synchronized void destroy() {
        super.destroy();
        this.requestMapper = null;
        this.vHostConfig = null;
    }

    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        String string = ((Request)servletRequest).getWebAppDispatcherContext().getDecodedReqUri();
        RequestProcessor requestProcessor = this.requestMapper.map(string);
        if (requestProcessor == null) {
            throw new WebGroupVHostNotFoundException(string);
        }
        requestProcessor.handleRequest(servletRequest, servletResponse);
    }

    public void removeWebApplication(DeployedModule deployedModule) {
        String string = deployedModule.getContextRoot();
        this.removeWebApplication(deployedModule, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWebApplication(DeployedModule deployedModule, String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (string.endsWith("/") && !string.equals("/")) {
            string = string.substring(0, string.length() - 1);
        }
        WebGroup webGroup = null;
        if (this.requestMapper != null) {
            VirtualHost virtualHost = this;
            synchronized (virtualHost) {
                if (this.requestMapper != null) {
                    webGroup = (WebGroup)this.requestMapper.map(string);
                    this.removeMapping(string.equals("/") ? string + "*" : string + "/*");
                }
            }
        }
        if (webGroup != null) {
            this.removeMapping(string.equals("/") ? string + "*" : string + "/*");
            webGroup.removeWebApplication(deployedModule);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeWebApplication name: " + webGroup.getName());
            }
            this.removeSubContainer(webGroup.getName());
        }
    }

    protected void addMapping(String string, WebGroup webGroup) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addMapping contextRoot -->" + string + " group -->" + webGroup.getName());
        }
        this.requestMapper.addMapping(string, webGroup);
    }

    protected void removeMapping(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeMapping contextRoot -->" + string);
        }
        this.requestMapper.removeMapping(string);
    }
}

