/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ejbcontainer.EJBFactory;
import com.ibm.ws.naming.util.NullRefAddrException;
import com.ibm.ws.util.MessageDestinationInfo;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.rmi.PortableRemoteObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDestinationObjectFactory
implements ObjectFactory {
    private static final String CLASS_NAME = MessageDestinationObjectFactory.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "InjectionEngine", "com.ibm.wsspi.injectionengine.injection");
    private static final String EJBFACTORY_JNDI_PREFIX = "com.ibm.websphere.ejbcontainer/";
    private static final String EJBFACTORY_JNDI_POSTFIX = "/EJBFactory";
    private EJBFactory ivEJBFactory = null;

    public MessageDestinationObjectFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "MessageDestinationObjectFactory.<init>");
        }
    }

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        InitialContext initialContext;
        String string;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance : " + object);
        }
        Object object2 = null;
        if (!(object instanceof Reference)) {
            InjectionException injectionException = new InjectionException("Binding object is not a Reference : " + object);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getObjectInstance : " + (Object)((Object)injectionException));
            }
            throw injectionException;
        }
        Reference reference = (Reference)object;
        if (!reference.getFactoryClassName().equals(CLASS_NAME)) {
            InjectionException injectionException = new InjectionException("Incorrect factory for Reference : " + object);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getObjectInstance : " + (Object)((Object)injectionException));
            }
            throw injectionException;
        }
        RefAddr refAddr = reference.get("MessageDestinationInfo");
        if (refAddr == null) {
            NullRefAddrException nullRefAddrException = new NullRefAddrException("The address for this Reference is empty (null)");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getObjectInstance : " + nullRefAddrException);
            }
            throw nullRefAddrException;
        }
        MessageDestinationInfo messageDestinationInfo = (MessageDestinationInfo)refAddr.getContent();
        EJBFactory eJBFactory = this.ivEJBFactory;
        if (eJBFactory == null) {
            string = EJBFACTORY_JNDI_PREFIX + messageDestinationInfo.ivApplication;
            string = string + EJBFACTORY_JNDI_POSTFIX;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking for EJBFactory : " + string);
            }
            initialContext = new InitialContext();
            Object object3 = initialContext.lookup(string);
            eJBFactory = (EJBFactory)PortableRemoteObject.narrow((Object)object3, EJBFactory.class);
        }
        string = eJBFactory.findDestinationByName(messageDestinationInfo.ivApplication, messageDestinationInfo.ivModule, messageDestinationInfo.ivLink);
        Tr.debug(tc, "destJndiName : " + string);
        if (string == null) {
            Tr.error(tc, "ENGLISH_ONLY_ERROR_MESSAGE_CNTR8992E", "No MessageDestination binding was found for destination " + messageDestinationInfo.ivLink);
            throw new RuntimeException("Destination not found : " + messageDestinationInfo.ivLink);
        }
        initialContext = new InitialContext();
        object2 = initialContext.lookup(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance : " + object2);
        }
        return object2;
    }
}

