/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse2.ProtoSSLEngine;
import com.ibm.jsse2.ProtoSSLEngineResult;
import com.ibm.jsse2.SSLContext;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeCompletedCallback;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeIOCallback;
import com.ibm.ws.ssl.channel.impl.SSLLinkConfig;
import com.ibm.ws.ssl.channel.impl.SSLQueuedHandshake;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import javax.net.ssl.SSLException;

public class SSLUtils {
    private static final TraceComponent tc = Tr.register(SSLUtils.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private static final String CLASS_NAME = "com.ibm.ws.ssl.channel.impl.SSLUtils";
    private static WsByteBufferPoolManager byteBufferManager = WsByteBufferPoolManagerImpl.getRef();

    public static void shutDownSSLEngine(ProtoSSLEngine protoSSLEngine, WsByteBuffer wsByteBuffer, TCPWriteRequestContext tCPWriteRequestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "shutDownSSLEngine");
        }
        if (!protoSSLEngine.isInboundDone()) {
            protoSSLEngine.closeInbound();
            SSLUtils.flushCloseDown(protoSSLEngine, wsByteBuffer, tCPWriteRequestContext);
        }
        if (!protoSSLEngine.isOutboundDone()) {
            protoSSLEngine.closeOutbound();
            SSLUtils.flushCloseDown(protoSSLEngine, wsByteBuffer, tCPWriteRequestContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "shutDownSSLEngine");
        }
    }

    private static void flushCloseDown(ProtoSSLEngine protoSSLEngine, WsByteBuffer wsByteBuffer, TCPWriteRequestContext tCPWriteRequestContext) {
        block8: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "flushCloseDown, engine=" + protoSSLEngine.hashCode());
            }
            ProtoSSLEngineResult protoSSLEngineResult = null;
            ProtoSSLEngineResult.Status status = null;
            wsByteBuffer.clear();
            try {
                do {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "before wrap: " + SSLUtils.getBufferTraceInfo(wsByteBuffer));
                    }
                    protoSSLEngineResult = protoSSLEngine.wrap(null, wsByteBuffer.getWrappedByteBuffer());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "after wrap: " + SSLUtils.getBufferTraceInfo(wsByteBuffer) + "\r\n\tresult=" + protoSSLEngineResult);
                    }
                    tCPWriteRequestContext.setBuffer(wsByteBuffer);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "write bytes: " + wsByteBuffer.remaining());
                    }
                    tCPWriteRequestContext.write(wsByteBuffer.remaining(), 0);
                } while ((status = protoSSLEngineResult.getStatus()) != ProtoSSLEngineResult.Status.CLOSED);
            }
            catch (Exception exception) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception caught closing down, " + exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "flushCloseDown");
        }
    }

    public static ByteBuffer[] getWrappedByteBuffers(WsByteBuffer[] wsByteBufferArray) {
        ByteBuffer[] byteBufferArray = new ByteBuffer[wsByteBufferArray.length];
        boolean bl = false;
        int n = 0;
        for (n = 0; n < wsByteBufferArray.length; ++n) {
            if (wsByteBufferArray[n] == null) {
                bl = true;
                break;
            }
            byteBufferArray[n] = wsByteBufferArray[n].getWrappedByteBuffer();
        }
        if (bl) {
            ByteBuffer[] byteBufferArray2 = byteBufferArray;
            byteBufferArray = new ByteBuffer[n];
            for (int i = 0; i < n; ++i) {
                byteBufferArray[i] = byteBufferArray2[i];
            }
        }
        return byteBufferArray;
    }

    public static void limitToCapacity(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                if (wsByteBufferArray[i] == null) continue;
                wsByteBufferArray[i].limit(wsByteBufferArray[i].capacity());
            }
        }
    }

    public static void positionToLimit(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                if (wsByteBufferArray[i] == null) continue;
                wsByteBufferArray[i].position(wsByteBufferArray[i].limit());
            }
        }
    }

    public static void flipBuffersToMark(WsByteBuffer[] wsByteBufferArray, int n, int n2) {
        WsByteBuffer wsByteBuffer = null;
        if (wsByteBufferArray != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                wsByteBuffer = wsByteBufferArray[i];
                if (wsByteBuffer == null) continue;
                if (i == n2 && n != 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "mark is " + n);
                    }
                    wsByteBuffer.limit(wsByteBuffer.position());
                    wsByteBuffer.position(n);
                    continue;
                }
                wsByteBuffer.flip();
            }
        }
    }

    public static void copyBuffer(WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2) {
        SSLUtils.copyBuffer(wsByteBuffer, wsByteBuffer2, wsByteBuffer.remaining());
    }

    public static void copyBuffer(WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "copyBuffer: length=" + n + "\r\n\tsrc: " + SSLUtils.getBufferTraceInfo(wsByteBuffer) + "\r\n\tdst: " + SSLUtils.getBufferTraceInfo(wsByteBuffer2));
        }
        if (wsByteBuffer2.remaining() < n || wsByteBuffer.remaining() < n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "copyBuffer: Not enough space");
            }
            RuntimeException runtimeException = new RuntimeException("Attempt to copy source buffer to inadequate destination buffer");
            FFDCFilter.processException((Throwable)runtimeException, CLASS_NAME, "762", wsByteBuffer);
            throw runtimeException;
        }
        if (wsByteBuffer.hasArray()) {
            int n2 = wsByteBuffer.position() + n;
            wsByteBuffer2.put(wsByteBuffer.array(), wsByteBuffer.arrayOffset() + wsByteBuffer.position(), n);
            wsByteBuffer.position(n2);
        } else {
            byte[] byArray = new byte[n];
            wsByteBuffer.get(byArray, 0, n);
            wsByteBuffer2.put(byArray);
        }
    }

    public static WsByteBuffer allocateByteBuffer(int n, boolean bl) {
        WsByteBuffer wsByteBuffer = null;
        wsByteBuffer = bl ? byteBufferManager.allocateDirect(n) : byteBufferManager.allocate(n);
        wsByteBuffer.limit(wsByteBuffer.capacity());
        return wsByteBuffer;
    }

    public static String getBufferTraceInfo(WsByteBuffer[] wsByteBufferArray) {
        if (null == wsByteBufferArray) {
            return "Null buffer array";
        }
        StringBuilder stringBuilder = new StringBuilder(32 + 64 * wsByteBufferArray.length);
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            stringBuilder.append("\r\n\t  Buffer [");
            stringBuilder.append(i);
            stringBuilder.append("]: ");
            SSLUtils.getBufferTraceInfo(stringBuilder, wsByteBufferArray[i]);
        }
        return stringBuilder.toString();
    }

    public static StringBuilder getBufferTraceInfo(StringBuilder stringBuilder, WsByteBuffer wsByteBuffer) {
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3 = stringBuilder2 = null == stringBuilder ? new StringBuilder(64) : stringBuilder;
        if (null == wsByteBuffer) {
            return stringBuilder2.append("null");
        }
        stringBuilder2.append("hc=");
        stringBuilder2.append(wsByteBuffer.hashCode());
        stringBuilder2.append(" pos=");
        stringBuilder2.append(wsByteBuffer.position());
        stringBuilder2.append(" lim=");
        stringBuilder2.append(wsByteBuffer.limit());
        stringBuilder2.append(" cap=");
        stringBuilder2.append(wsByteBuffer.capacity());
        return stringBuilder2;
    }

    public static String getBufferTraceInfo(WsByteBuffer wsByteBuffer) {
        if (null == wsByteBuffer) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("hc=");
        stringBuilder.append(wsByteBuffer.hashCode());
        stringBuilder.append(" pos=");
        stringBuilder.append(wsByteBuffer.position());
        stringBuilder.append(" lim=");
        stringBuilder.append(wsByteBuffer.limit());
        stringBuilder.append(" cap=");
        stringBuilder.append(wsByteBuffer.capacity());
        return stringBuilder.toString();
    }

    public static String showBufferContents(WsByteBuffer[] wsByteBufferArray) {
        if (null == wsByteBufferArray || 0 == wsByteBufferArray.length) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            stringBuilder.append("Buffer [");
            stringBuilder.append(i);
            if (null == wsByteBufferArray[i]) {
                stringBuilder.append("]: null\r\n");
                continue;
            }
            stringBuilder.append("]: ");
            stringBuilder.append(WsByteBufferUtils.asString(wsByteBufferArray[i]));
            stringBuilder.append("\r\n");
        }
        return stringBuilder.toString();
    }

    public static WsByteBuffer[] allocateByteBuffers(int n, long l, boolean bl, boolean bl2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry(tc, "allocateByteBuffers");
        }
        WsByteBuffer wsByteBuffer = SSLUtils.allocateByteBuffer(n, bl);
        if (bl2) {
            wsByteBuffer.limit(n);
        }
        int n2 = wsByteBuffer.limit();
        int n3 = (int)(l / (long)n2);
        if (l % (long)n2 > 0L) {
            ++n3;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "allocate: requestSize=" + n + ", actualSize=" + n2 + ", totSize=" + l + ", numBufs=" + n3);
        }
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[n3];
        wsByteBufferArray[0] = wsByteBuffer;
        for (int i = 1; i < wsByteBufferArray.length; ++i) {
            wsByteBufferArray[i] = SSLUtils.allocateByteBuffer(n, bl);
            if (!bl2) continue;
            wsByteBuffer.limit(n);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit(tc, "allocateByteBuffers");
        }
        return wsByteBufferArray;
    }

    public static boolean anyPositionsNonZero(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                if (wsByteBufferArray[i] == null || wsByteBufferArray[i].position() == 0) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProtoSSLEngineResult handleHandshake(SSLConnectionLink sSLConnectionLink, WsByteBuffer object, WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2, WsByteBuffer wsByteBuffer3, ProtoSSLEngineResult protoSSLEngineResult, SSLHandshakeCompletedCallback sSLHandshakeCompletedCallback, boolean bl) throws IOException, ReadOnlyBufferException {
        ProtoSSLEngineResult.Status status;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleHandshake, engine=" + sSLConnectionLink.getSSLEngine().hashCode());
        }
        if (sSLConnectionLink.getChannel().isZOSCR && sSLHandshakeCompletedCallback != null && !(Thread.currentThread() instanceof ThreadPool.DecoratedCRThread)) {
            if (sSLConnectionLink.isQueuedHandshake()) {
                FFDCFilter.processException(new Exception("SSL handshake on non-decorated thread"), "com.ibm.ws.ssl.channel.impl.SSLUtils.handleHandshake", "501");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Handshake on non-decorated thread; however already queued once");
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting off ACRW thread");
                }
                SSLQueuedHandshake sSLQueuedHandshake = new SSLQueuedHandshake(sSLConnectionLink, (WsByteBuffer)object, wsByteBuffer, wsByteBuffer2, wsByteBuffer3, protoSSLEngineResult, sSLHandshakeCompletedCallback);
                ChannelException channelException = null;
                try {
                    int n = sSLConnectionLink.getThreadPool().execute(sSLQueuedHandshake, 2);
                    if (n != 0) {
                        channelException = new ChannelException("threadpool at capacity, request rejected");
                    }
                }
                catch (ChannelException channelException2) {
                    channelException = channelException2;
                }
                if (channelException != null) {
                    FFDCFilter.processException((Throwable)channelException, CLASS_NAME, "563", sSLConnectionLink);
                    sSLHandshakeCompletedCallback.error(new IOException(channelException.toString()));
                }
                return null;
            }
        }
        sSLConnectionLink.setQueuedHandshake(false);
        ProtoSSLEngine protoSSLEngine = sSLConnectionLink.getSSLEngine();
        TCPReadRequestContext tCPReadRequestContext = sSLConnectionLink.getDeviceReadInterface();
        TCPWriteRequestContext tCPWriteRequestContext = sSLConnectionLink.getDeviceWriteInterface();
        int n = 0;
        boolean bl2 = true;
        ProtoSSLEngineResult.Status status2 = status = protoSSLEngineResult == null ? ProtoSSLEngineResult.Status.HS_NEED_WRAP : protoSSLEngineResult.getStatus();
        if (bl && status == ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "From callback, former status BUFFER_UNDERFLOW.");
            }
            object.limit(object.position());
            object.reset();
            status = ProtoSSLEngineResult.Status.HS_NEED_UNWRAP;
        }
        while (protoSSLEngine.isHandshaking() || status != ProtoSSLEngineResult.Status.HS_FINISHED && status != ProtoSSLEngineResult.Status.OK) {
            VirtualConnection virtualConnection;
            Object object2;
            block60: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "status=" + status);
                }
                if (status == ProtoSSLEngineResult.Status.HS_FINISHED) {
                    if (!sSLConnectionLink.getChannel().isZOS) break;
                    JSSEHelper.getInstance().setSSLPropertiesOnThread(null);
                    break;
                }
                if (status == ProtoSSLEngineResult.Status.HS_NEED_WRAP) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "before wrap: \r\n\tencBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer3));
                    }
                    protoSSLEngineResult = protoSSLEngine.wrap(null, wsByteBuffer3.getWrappedByteBuffer());
                    n = protoSSLEngineResult.outBytesProduced();
                    status = protoSSLEngineResult.getStatus();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "after wrap: \r\n\tencBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer3) + "\r\n\tstatus=" + status + " consumed=" + protoSSLEngineResult.inBytesConsumed() + " produced=" + protoSSLEngineResult.outBytesProduced());
                    }
                    if (0 < n) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Write bytes: " + n);
                        }
                        tCPWriteRequestContext.setBuffer(wsByteBuffer3);
                        if (sSLHandshakeCompletedCallback != null) {
                            object2 = new SSLHandshakeIOCallback(sSLConnectionLink, (WsByteBuffer)object, wsByteBuffer, wsByteBuffer2, wsByteBuffer3, protoSSLEngineResult, sSLHandshakeCompletedCallback);
                            virtualConnection = tCPWriteRequestContext.write(n, (TCPWriteCompletedCallback)object2, false, 0);
                            if (virtualConnection != null) {
                                wsByteBuffer3.clear();
                                break block60;
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Write is not done.  Callback will be used.");
                                }
                                protoSSLEngineResult = null;
                                break;
                            }
                        }
                        tCPWriteRequestContext.write(n, 0);
                        wsByteBuffer3.clear();
                    } else {
                        wsByteBuffer3.clear();
                    }
                }
            }
            while (status == ProtoSSLEngineResult.Status.HS_NEED_TASK) {
                object2 = protoSSLEngine.getDelegatedTask();
                if (object2 != null) {
                    object2.run();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "After task: sslEngine.isHandshaking=" + protoSSLEngine.isHandshaking());
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No task, setting status to HS_NEED_WRAP");
                }
                status = ProtoSSLEngineResult.Status.HS_NEED_WRAP;
            }
            if (status == ProtoSSLEngineResult.Status.HS_NEED_UNWRAP || status == ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW) {
                block61: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Get ready to decrypt data, netBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)object));
                    }
                    if (object.remaining() == object.capacity() && status == ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        object2 = SSLUtils.allocateByteBuffer(protoSSLEngine.getPacketBufferSize(), false);
                        SSLUtils.copyBuffer((WsByteBuffer)object, (WsByteBuffer)object2);
                        object2.flip();
                        object.release();
                        object = object2;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Had to grow the netBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)object));
                        }
                    }
                    if (ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW == status || !object.hasRemaining() && !bl2 || object.remaining() == object.capacity() && (!bl2 || ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW != status2)) {
                        tCPReadRequestContext.setBuffer((WsByteBuffer)object);
                        if (!object.hasRemaining() || object.remaining() == object.capacity()) {
                            object.clear();
                            object.mark();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Nothing was in the buffer");
                            }
                        } else {
                            object.mark();
                            object.position(object.limit());
                            object.limit(object.capacity());
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Existing data in netBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)object));
                            }
                        }
                        if (sSLHandshakeCompletedCallback != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Do async read");
                            }
                            if ((virtualConnection = tCPReadRequestContext.read(1L, (TCPReadCompletedCallback)(object2 = new SSLHandshakeIOCallback(sSLConnectionLink, (WsByteBuffer)object, wsByteBuffer, wsByteBuffer2, wsByteBuffer3, protoSSLEngineResult, sSLHandshakeCompletedCallback)), false, 0)) != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Read already done.  No callback necessary.");
                                }
                                object.limit(object.position());
                                object.reset();
                                break block61;
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Read is not done.  Callback will be used.");
                                }
                                protoSSLEngineResult = null;
                                break;
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Do sync read");
                        }
                        long l = 0L;
                        while (l == 0L) {
                            l = tCPReadRequestContext.read(1L, 0);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                            Tr.event(tc, "Read bytes: " + l);
                        }
                        object.limit(object.position());
                        object.reset();
                    } else {
                        if (!object.hasRemaining() && bl2) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Callback came back with data that needs to be flipped.");
                            }
                            object.flip();
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Data already in netBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)object));
                        }
                    }
                }
                if (0 != object.position() && object.limit() == object.capacity() && bl2 && ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW != status2) {
                    object.limit(object.position());
                    object.reset();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "before unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)object) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer));
                }
                protoSSLEngineResult = protoSSLEngine.unwrap(object.getWrappedByteBuffer(), wsByteBuffer.getWrappedByteBuffer());
                status = protoSSLEngineResult.getStatus();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "after unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)object) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer) + "\r\n\tstatus=" + status + " consumed=" + protoSSLEngineResult.inBytesConsumed() + " produced=" + protoSSLEngineResult.outBytesProduced());
                }
                if (object.remaining() == 0) {
                    object.clear();
                }
            }
            if (status == ProtoSSLEngineResult.Status.BUFFER_OVERFLOW) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "BUFFER_OVERFLOW occured during handshake: " + status);
                }
                throw new SSLException("BUFFER_OVERFLOW occured during handshake: " + status);
            }
            if (status == ProtoSSLEngineResult.Status.CLOSED) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Handshake terminated SSL engine: " + status);
                }
                throw new SSLException("Handshake terminated SSL engine: " + status);
            }
            bl2 = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "after handshake loop, status=" + status + ", fromCallback=" + bl + ", engine=" + protoSSLEngine.hashCode() + "\r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)object) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer));
        }
        if (bl && protoSSLEngineResult != null) {
            sSLHandshakeCompletedCallback.complete(protoSSLEngineResult);
            protoSSLEngineResult = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleHandshake");
        }
        return protoSSLEngineResult;
    }

    public static void handleHandshake(ProtoSSLEngine protoSSLEngine, ProtoSSLEngine protoSSLEngine2) throws SSLException {
        WsByteBuffer wsByteBuffer;
        WsByteBuffer wsByteBuffer2;
        WsByteBuffer wsByteBuffer3;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleHandshake");
        }
        if (protoSSLEngine == null || protoSSLEngine2 == null) {
            throw new SSLException("Null engine found: engine1=" + protoSSLEngine + ", engine2=" + protoSSLEngine2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parameters: engine1=" + protoSSLEngine.hashCode() + ", engine2=" + protoSSLEngine2.hashCode());
        }
        WsByteBuffer wsByteBuffer4 = wsByteBuffer3 = SSLUtils.allocateByteBuffer(protoSSLEngine.getPacketBufferSize(), false);
        WsByteBuffer wsByteBuffer5 = wsByteBuffer2 = SSLUtils.allocateByteBuffer(protoSSLEngine.getApplicationBufferSize(), false);
        WsByteBuffer wsByteBuffer6 = wsByteBuffer = SSLUtils.allocateByteBuffer(protoSSLEngine.getPacketBufferSize(), false);
        Runnable runnable = null;
        ProtoSSLEngine protoSSLEngine3 = null;
        ProtoSSLEngineResult.Status status = null;
        ProtoSSLEngineResult.Status status2 = ProtoSSLEngineResult.Status.HS_NEED_WRAP;
        ProtoSSLEngineResult.Status status3 = ProtoSSLEngineResult.Status.HS_NEED_UNWRAP;
        protoSSLEngine.beginHandshake();
        protoSSLEngine2.beginHandshake();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "current engine= " + protoSSLEngine.hashCode() + ", status=" + status2);
        }
        while (protoSSLEngine.isHandshaking() || protoSSLEngine2.isHandshaking() || status2 != ProtoSSLEngineResult.Status.HS_FINISHED || status3 != ProtoSSLEngineResult.Status.HS_FINISHED) {
            ProtoSSLEngineResult protoSSLEngineResult;
            if (status2 == ProtoSSLEngineResult.Status.HS_NEED_WRAP && wsByteBuffer6.limit() == wsByteBuffer6.capacity()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "before wrap: encBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer6));
                }
                protoSSLEngineResult = protoSSLEngine.wrap(null, wsByteBuffer6.getWrappedByteBuffer());
                status2 = protoSSLEngineResult.getStatus();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "after wrap: encBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer6) + "\r\n\tstatus=" + protoSSLEngineResult.getStatus() + " consumed=" + protoSSLEngineResult.inBytesConsumed() + " produced=" + protoSSLEngineResult.outBytesProduced());
                }
            } else if ((status2 == ProtoSSLEngineResult.Status.HS_FINISHED || status2 == ProtoSSLEngineResult.Status.HS_NEED_UNWRAP) && wsByteBuffer4.limit() != wsByteBuffer4.capacity()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "before unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer4) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer5));
                }
                protoSSLEngineResult = protoSSLEngine.unwrap(wsByteBuffer4.getWrappedByteBuffer(), wsByteBuffer5.getWrappedByteBuffer());
                status2 = protoSSLEngineResult.getStatus();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "after unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer4) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer5) + "\r\n\tstatus=" + protoSSLEngineResult.getStatus() + " consumed=" + protoSSLEngineResult.inBytesConsumed() + " produced=" + protoSSLEngineResult.outBytesProduced());
                }
                if (wsByteBuffer4.remaining() == 0) {
                    wsByteBuffer4.clear();
                }
            } else if (status2 != ProtoSSLEngineResult.Status.HS_NEED_UNWRAP && status2 != ProtoSSLEngineResult.Status.HS_NEED_WRAP && status2 != ProtoSSLEngineResult.Status.HS_FINISHED && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected status: " + status2);
                throw new SSLException("Unexpected status: " + status2);
            }
            if (status2 == ProtoSSLEngineResult.Status.HS_NEED_TASK) {
                while (status2 == ProtoSSLEngineResult.Status.HS_NEED_TASK) {
                    runnable = protoSSLEngine.getDelegatedTask();
                    if (runnable != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Run task");
                        }
                        runnable.run();
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "After task: sslEngine.isHandshaking=" + protoSSLEngine.isHandshaking());
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No task, setting status to HS_NEED_WRAP");
                    }
                    status2 = ProtoSSLEngineResult.Status.HS_NEED_WRAP;
                }
                if (status2 == ProtoSSLEngineResult.Status.HS_NEED_WRAP) continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Switching engines");
            }
            wsByteBuffer4 = wsByteBuffer6;
            protoSSLEngine3 = protoSSLEngine;
            protoSSLEngine = protoSSLEngine2;
            protoSSLEngine2 = protoSSLEngine3;
            status = status2;
            status2 = status3;
            status3 = status;
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "current engine= " + protoSSLEngine.hashCode() + ", status=" + status2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleHandshake");
        }
    }

    public static ProtoSSLEngine getOutboundSSLEngine(SSLContext sSLContext, SSLLinkConfig sSLLinkConfig, String string, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundSSLEngine, host=" + string + ", port=" + n);
        }
        ProtoSSLEngine protoSSLEngine = sSLContext.createProtoSSLEngine(string, n);
        SSLUtils.configureEngine(protoSSLEngine, FlowType.OUTBOUND, sSLLinkConfig);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundSSLEngine, hc=" + protoSSLEngine.hashCode());
        }
        return protoSSLEngine;
    }

    public static ProtoSSLEngine getSSLEngine(SSLContext sSLContext, FlowType flowType, SSLLinkConfig sSLLinkConfig) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLEngine");
        }
        ProtoSSLEngine protoSSLEngine = sSLContext.createProtoSSLEngine();
        SSLUtils.configureEngine(protoSSLEngine, flowType, sSLLinkConfig);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLEngine, hc=" + protoSSLEngine.hashCode());
        }
        return protoSSLEngine;
    }

    private static void configureEngine(ProtoSSLEngine protoSSLEngine, FlowType flowType, SSLLinkConfig sSLLinkConfig) {
        protoSSLEngine.setEnabledCipherSuites(sSLLinkConfig.getEnabledCipherSuites(protoSSLEngine));
        if (flowType == FlowType.INBOUND) {
            protoSSLEngine.setUseClientMode(false);
            boolean bl = sSLLinkConfig.getBooleanProperty("com.ibm.ssl.clientAuthentication");
            protoSSLEngine.setNeedClientAuth(bl);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Client auth needed is " + protoSSLEngine.getNeedClientAuth());
            }
            if (!bl) {
                bl = sSLLinkConfig.getBooleanProperty("com.ibm.ssl.clientAuthenticationSupported");
                protoSSLEngine.setWantClientAuth(bl);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client auth supported is " + protoSSLEngine.getWantClientAuth());
                }
            }
        } else {
            protoSSLEngine.setUseClientMode(true);
        }
        protoSSLEngine.beginHandshake();
    }

    public static int[] adjustBuffersForJSSE(WsByteBuffer[] wsByteBufferArray, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "adjustBuffersForJSSE");
        }
        int[] nArray = null;
        int n2 = 0;
        for (int i = 0; i < wsByteBufferArray.length && wsByteBufferArray[i] != null; ++i) {
            if ((n2 += wsByteBufferArray[i].remaining()) > n) {
                int n3 = wsByteBufferArray[i].limit();
                nArray = new int[]{i, n3};
                int n4 = n2 - n;
                wsByteBufferArray[i].limit(n3 - n4);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "adjusted limit of buffer [" + i + "] from " + n3 + " to " + wsByteBufferArray[i].limit());
                break;
            }
            if (n2 == n) break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "adjustBuffersForJSSE");
        }
        return nArray;
    }

    public static void resetBuffersAfterJSSE(WsByteBuffer[] wsByteBufferArray, int[] nArray) {
        WsByteBuffer wsByteBuffer;
        if (nArray == null) {
            return;
        }
        int n = nArray[0];
        int n2 = nArray[1];
        if (wsByteBufferArray.length > n && (wsByteBuffer = wsByteBufferArray[n]) != null && wsByteBuffer.capacity() >= n2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "resetBuffersAfterJSSE: buffer [" + n + "] from " + wsByteBuffer.limit() + " to " + n2);
            }
            wsByteBuffer.limit(n2);
        }
    }

    public static void getBufferLimits(WsByteBuffer[] wsByteBufferArray, int[] nArray) {
        if (wsByteBufferArray != null && nArray != null) {
            for (int i = 0; i < wsByteBufferArray.length && i < nArray.length; ++i) {
                if (wsByteBufferArray[i] != null) {
                    nArray[i] = wsByteBufferArray[i].limit();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "getBufferLimits: buffer[" + i + "] limit of " + nArray[i]);
                    continue;
                }
                nArray[i] = 0;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getBufferLimits: null buffer[" + i + "] limit of " + nArray[i]);
            }
        }
    }

    public static void setBufferLimits(WsByteBuffer[] wsByteBufferArray, int[] nArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setBufferLimits");
        }
        if (wsByteBufferArray != null && nArray != null) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < wsByteBufferArray.length && i < nArray.length; ++i) {
                if (wsByteBufferArray[i] == null) continue;
                n = wsByteBufferArray[i].capacity();
                n2 = nArray[i];
                if (wsByteBufferArray[i].limit() == n2) continue;
                if (n >= n2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Buffer [" + i + "] being updated from " + wsByteBufferArray[i].limit() + " to " + n2);
                    }
                    wsByteBufferArray[i].limit(n2);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Buffer [" + i + "] has capacity " + n + " less than passed in limit " + n2);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setBufferLimits");
        }
    }
}

