/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse2.ProtoSSLEngine;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class SSLChannelData {
    protected static final TraceComponent tc = Tr.register(SSLChannelData.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    public static final String ENCRYPT_BUFFERS_DIRECT = "encryptBuffersDirect";
    public static final String DECRYPT_BUFFERS_DIRECT = "decryptBuffersDirect";
    public static final String SSLSESSION_CACHE_SIZE = "SSLSessionCacheSize";
    public static final String SSLSESSION_TIMEOUT = "SSLSessionTimeout";
    private static final String DEFAULT_ENCRYPT_BUFFERS_DIRECT = "true";
    private static final String DEFAULT_DECRYPT_BUFFERS_DIRECT = "false";
    public static final int DEFAULT_SSLSESSION_CACHE_SIZE = 100;
    public static final int DEFAULT_SSLSESSION_TIMEOUT = 86400;
    public static final String ALIAS_KEY = "alias";
    public static final String KEY_FILE_NAME = "com.ibm.ssl.keyStore";
    public static final String KEY_FILE_PASSWORD = "com.ibm.ssl.keyStorePassword";
    public static final String TRUST_FILE_NAME = "com.ibm.ssl.trustStore";
    public static final String TRUST_FILE_PASSWORD = "com.ibm.ssl.trustStorePassword";
    public static final String SERVER_KEY_ALIAS = "com.ibm.ssl.keyStoreServerAlias";
    public static final String PROTOCOL = "com.ibm.ssl.protocol";
    public static final String SSL_TYPE = "com.ibm.ssl.sslType";
    public static final String KEY_MANAGER = "com.ibm.ssl.keyManager";
    public static final String KEY_STORE_TYPE = "com.ibm.ssl.keyStoreType";
    public static final String KEY_STORE_PROVIDER = "com.ibm.ssl.keyStoreProvider";
    public static final String TRUST_MANAGER = "com.ibm.ssl.trustManager";
    public static final String TRUST_STORE_TYPE = "com.ibm.ssl.trustStoreType";
    public static final String TRUST_STORE_PROVIDER = "com.ibm.ssl.trustStoreProvider";
    public static final String ENABLED_CIPHER_SUITES = "com.ibm.ssl.enabledCipherSuites";
    public static final String CLIENT_AUTH = "com.ibm.ssl.clientAuthentication";
    public static final String SECURITY_LEVEL = "com.ibm.ssl.securityLevel";
    public static final String TOKEN_TYPE = "com.ibm.ssl.tokenType";
    public static final String TOKEN_SLOT = "com.ibm.ssl.tokenSlot";
    public static final String TOKEN_LIBRARY_FILE = "com.ibm.ssl.tokenLibraryFile";
    public static final String TOKEN_PASSWORD = "com.ibm.ssl.tokenPassword";
    public static final String CONTEXT_PROVIDER = "com.ibm.ssl.contextProvider";
    public static final String CLIENT_KEY_ALIAS = "com.ibm.ssl.keyStoreClientAlias";
    private ChannelFramework framework = null;
    private String name = null;
    private boolean encryptBuffersDirect;
    private boolean decryptBuffersDirect;
    private int weight;
    private boolean isInbound;
    private boolean clientAuthentication;
    private Properties properties;
    private int sslSessionCacheSize = 0;
    private int sslSessionTimeout = 0;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SSLChannelData: ");
        stringBuilder.append(this.name);
        stringBuilder.append("\n\tencryptBuffersDirect = ");
        stringBuilder.append(this.encryptBuffersDirect);
        stringBuilder.append("\n\tdecryptBuffersDirect = ");
        stringBuilder.append(this.decryptBuffersDirect);
        stringBuilder.append("\n\tweight = ");
        stringBuilder.append(this.weight);
        stringBuilder.append("\n\tisInbound = ");
        stringBuilder.append(this.isInbound);
        stringBuilder.append("\n\tclientAuthentication = ");
        stringBuilder.append(this.clientAuthentication);
        stringBuilder.append("\n\tsession cache size = ");
        stringBuilder.append(this.getSSLSessionCacheSize());
        stringBuilder.append("\n\tsession timeout = ");
        stringBuilder.append(this.getSSLSessionTimeout());
        return stringBuilder.toString();
    }

    public SSLChannelData(ChannelData channelData) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor: SSLChannelData");
        }
        this.framework = channelData.getChannelFramework();
        this.name = channelData.getName();
        this.weight = channelData.getDiscriminatorWeight();
        this.isInbound = channelData.isInbound();
        this.properties = new Properties();
        Map map = channelData.getPropertyBag();
        Iterator iterator = map.keySet().iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.properties.put(string, map.get(string));
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.encryptBuffersDirect = this.getBooleanProperty(ENCRYPT_BUFFERS_DIRECT, DEFAULT_ENCRYPT_BUFFERS_DIRECT, stringBuilder);
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        if (platformHelper.isZOS() && (platformHelper.isControlJvm() || platformHelper.isClientJvm())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "On Z and either in CR or Client JVM so setting decryptBuffersDirect to true");
            }
            this.decryptBuffersDirect = true;
        } else {
            this.decryptBuffersDirect = this.getBooleanProperty(DECRYPT_BUFFERS_DIRECT, DEFAULT_DECRYPT_BUFFERS_DIRECT, stringBuilder);
        }
        this.sslSessionCacheSize = this.getIntProperty(SSLSESSION_CACHE_SIZE, true, 100, stringBuilder);
        this.sslSessionTimeout = this.getIntProperty(SSLSESSION_TIMEOUT, true, 86400, stringBuilder);
        if (stringBuilder.length() != 0) {
            Tr.error(tc, "invalid.security.properties", stringBuilder.toString());
            throw new ChannelException("Invalid property values found:\n" + stringBuilder.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor: SSLChannelData");
        }
    }

    public ChannelFramework getChannelFramework() {
        return this.framework;
    }

    public String getName() {
        return this.name;
    }

    public boolean getEncryptBuffersDirect() {
        return this.encryptBuffersDirect;
    }

    public boolean getDecryptBuffersDirect() {
        return this.decryptBuffersDirect;
    }

    public void setEncryptBuffersDirect(boolean bl) {
        this.encryptBuffersDirect = bl;
    }

    public void setDecryptBuffersDirect(boolean bl) {
        this.decryptBuffersDirect = bl;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isInbound() {
        return this.isInbound;
    }

    public int getSSLSessionCacheSize() {
        return this.sslSessionCacheSize;
    }

    public int getSSLSessionTimeout() {
        return this.sslSessionTimeout;
    }

    public FlowType getFlowType() {
        return this.isInbound() ? FlowType.INBOUND : FlowType.OUTBOUND;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean getBooleanProperty(String string) {
        boolean bl = false;
        Object object = this.properties.get(string);
        if (object != null) {
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            } else if (object instanceof String) {
                bl = DEFAULT_ENCRYPT_BUFFERS_DIRECT.equalsIgnoreCase((String)object);
            }
        }
        return bl;
    }

    public String getStringProperty(String string) {
        Object object = this.properties.get(string);
        if (null != object && object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public String[] getEnabledCipherSuites(ProtoSSLEngine protoSSLEngine) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getEnabledCipherSuites");
        }
        String[] stringArray = null;
        Object object = this.properties.get(ENABLED_CIPHER_SUITES);
        if (null == object) {
            String string = this.getProperties().getProperty(SECURITY_LEVEL);
            if (null == string) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Defaulting to HIGH security level");
                }
                string = "HIGH";
            }
            stringArray = SSLConfigManager.getInstance().adjustSupportedCiphersToSecurityLevel(protoSSLEngine.getSupportedCipherSuites(), string);
        } else if (object instanceof String) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "enabledCipherSuites is a String: " + object);
            }
            String string = (String)object;
            stringArray = string.split("\\s");
        } else if (object instanceof String[]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "enabledCipherSuites is a String array");
            }
            stringArray = (String[])object;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Invalid object for enabledCipherSuites: " + object);
        }
        if ((null == stringArray || 0 == stringArray.length) && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Unable to find any enabled ciphers");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getEnabledCipherSuites");
        }
        return stringArray;
    }

    public void updateChannelData(ChannelData channelData) {
    }

    private boolean getBooleanProperty(String string, String string2, StringBuilder stringBuilder) {
        boolean bl = false;
        String string3 = null;
        boolean bl2 = false;
        Object object = this.properties.get(string);
        if (object != null) {
            if (object instanceof Boolean) {
                bl = (Boolean)object;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Property " + string + " set to " + bl);
                }
                return bl;
            }
            if (object instanceof String) {
                string3 = (String)object;
            }
        } else if (string2 != null) {
            string3 = string2;
        } else {
            stringBuilder.append(string);
            stringBuilder.append(":");
            stringBuilder.append(string3);
            stringBuilder.append(" \n");
            return false;
        }
        if (string3 != null) {
            if (string3.equals(DEFAULT_ENCRYPT_BUFFERS_DIRECT)) {
                bl = true;
                bl2 = true;
            } else if (string3.equals(DEFAULT_DECRYPT_BUFFERS_DIRECT)) {
                bl = false;
                bl2 = true;
            }
        }
        if (bl2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Property " + string + " set to " + bl);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Property " + string + " has invalid value " + string3);
            }
            stringBuilder.append(string);
            stringBuilder.append(":");
            stringBuilder.append(string3);
            stringBuilder.append(" \n");
        }
        return bl;
    }

    private int getIntProperty(String string, boolean bl, int n, StringBuilder stringBuilder) {
        block7: {
            String string2 = this.getStringProperty(string);
            if (null != string2) {
                try {
                    int n2 = Integer.parseInt(string2);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Property " + string + " set to " + n2);
                    }
                    return n2;
                }
                catch (NumberFormatException numberFormatException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Property " + string + ", format error in [" + string2 + "]");
                }
            }
        }
        if (!bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Property " + string + " not found.  Error being tallied.");
            }
            stringBuilder.append(string);
            stringBuilder.append(":null \n");
            return -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Property " + string + " using default " + n);
        }
        return n;
    }
}

