/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.orbssl;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.transport.ServerConnectionData;
import com.ibm.ws.orb.transport.WSSSLServerSocketFactory;
import com.ibm.ws.orbimpl.transport.WSTransport;
import com.ibm.ws.security.orbssl.SSLServerConnectionData;
import com.ibm.ws.security.orbssl.SocketFactoryMessageUtility;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public final class WSSSLServerSocketFactoryImpl
implements WSSSLServerSocketFactory {
    private static final String SCCSID = " @(#) 1.22.2.1 ws/code/orbext/src/com/ibm/ws/security/orbssl/WSSSLServerSocketFactoryImpl.java, WAS.orbext, ASV 2/20/04 09:35:20 [2/20/04 16:38:57]";
    private static String[] ENABLED_CIPHERS = null;
    private static String[] SUPPORTED_CIPHERS = null;
    private static SSLContext sslContext;
    private static Properties sslProperties;

    public synchronized ServerSocket createSSLServerSocket(ServerConnectionData serverConnectionData) {
        SSLServerConnectionData sSLServerConnectionData = (SSLServerConnectionData)serverConnectionData;
        SSLServerSocket sSLServerSocket = null;
        boolean bl = sSLServerConnectionData.getMessageLoggingEnabled();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "IIOPSSLConnection.createSSLServerSocket", "\n[\n" + ((Object)sSLServerConnectionData).toString() + "\n]\n");
        }
        try {
            String string;
            String string2;
            String string3 = sSLServerConnectionData.getSSLConfigAlias();
            String string4 = sSLServerConnectionData.getEndPointName();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "inbound");
            hashMap.put("com.ibm.ssl.endPointName", string4);
            sslContext = JSSEHelper.getInstance().getSSLContext(string3, hashMap, WSTransport.getInstanceToRegisterListener());
            sslProperties = JSSEHelper.getInstance().getProperties(string3, hashMap, null);
            short s = sSLServerConnectionData.getTargetSupportsQOP();
            short s2 = sSLServerConnectionData.getTargetRequiresQOP();
            if (s < 1) {
                if (!bl) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", "The SSLServerConnectionData object that was passed to createSSLServerSocket returns a value for getTargetSupportsQOP() that is less than 1.");
                    }
                } else if (ORBRas.isMsgLogging) {
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.createSSLServerSocket"), (String)null, (Object[])null);
                }
                throw new INTERNAL("SSLSERVERSOCKET_TARGET_SUPPORTS_LESS_THAN_1", 1229066355, CompletionStatus.COMPLETED_NO);
            }
            if (s2 < 1) {
                if (!bl) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", "The SSLServerConnectionData object that is passed to createSSLServerSocket returned a value from getTargetRequiresQOP() that is less than 1.");
                    }
                } else if (ORBRas.isMsgLogging) {
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.targetRequires"), (String)null, (Object[])null);
                }
                throw new INTERNAL("SSLSERVERSOCKET_TARGET_REQUIRES_LESS_THAN_1", 1229066356, CompletionStatus.COMPLETED_NO);
            }
            if (s < s2) {
                if (!bl) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", "The SSLServerConnectionData object that is passed to createSSLServerSocket contains a TargetSupportsQOP value that is less than its  TargetRequirsQOP value.");
                    }
                } else if (ORBRas.isMsgLogging) {
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.targetSupports2"), (String)null, (Object[])null);
                }
                throw new INTERNAL("SSLSERVERSOCKET_TARGET_LESS_THAN_TARGET_REQUIRES", 1229066357, CompletionStatus.COMPLETED_NO);
            }
            SSLServerSocketFactory sSLServerSocketFactory = sslContext.getServerSocketFactory();
            try {
                if (sSLServerConnectionData.getUseSingleNIC()) {
                    sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(sSLServerConnectionData.getServerPort(), sSLServerConnectionData.getServerServerQueueDepth(), InetAddress.getByName(sSLServerConnectionData.getServerHost()));
                    if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSSLServerSocket()", "Bind Server Socket To A Specific NIC card=" + sSLServerConnectionData.getUseSingleNIC() + ", Remote Port=" + sSLServerConnectionData.getServerPort() + ", Server Queue Depth=" + sSLServerConnectionData.getServerServerQueueDepth() + ", LocalHost=" + sSLServerConnectionData.getServerHost() + ", java.net.InetAddress.getByName( LocalHost )=" + InetAddress.getByName(sSLServerConnectionData.getServerHost()));
                    }
                } else {
                    sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(sSLServerConnectionData.getServerPort(), sSLServerConnectionData.getServerServerQueueDepth());
                    if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSSLServerSocket()", "Bind Server Socket To Multiple NIC cards=" + !sSLServerConnectionData.getUseSingleNIC() + ", Remote Port=" + sSLServerConnectionData.getServerPort() + ", Server Queue Depth=" + sSLServerConnectionData.getServerServerQueueDepth());
                    }
                }
                if (string4 != null && string4.equals("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS")) {
                    sSLServerSocket.setNeedClientAuth(true);
                } else if (string4 != null && string4.equals("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS")) {
                    sSLServerSocket.setNeedClientAuth(false);
                    sSLServerSocket.setWantClientAuth(false);
                } else {
                    string2 = sslProperties.getProperty("com.ibm.ssl.clientAuthenticationSupported");
                    if (string2 != null && string2.equals("true")) {
                        sSLServerSocket.setWantClientAuth(true);
                    }
                    if ((string = sslProperties.getProperty("com.ibm.ssl.clientAuthentication")) != null && string.equals("true")) {
                        sSLServerSocket.setNeedClientAuth(true);
                    }
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.createSSLServerSocket", "368", this);
                if (!bl) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", (Exception)iOException);
                    }
                } else if (ORBRas.isMsgLogging) {
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.createSSLServerSocket"), (String)null, (Object)iOException);
                }
                throw new INTERNAL("UNABLE_TO_CREATE_SSL_SERVER_SOCKET Exception=" + iOException, 1229066358, CompletionStatus.COMPLETED_NO);
            }
            if (sSLServerSocket != null) {
                string2 = sslProperties.getProperty("com.ibm.ssl.enabledCipherSuites");
                ENABLED_CIPHERS = SSLConfigManager.getInstance().parseEnabledCiphers(string2);
                if (ENABLED_CIPHERS == null) {
                    string = sslProperties.getProperty("com.ibm.ssl.securityLevel");
                    SUPPORTED_CIPHERS = sSLServerSocketFactory.getSupportedCipherSuites();
                    SUPPORTED_CIPHERS = SSLConfigManager.getInstance().adjustSupportedCiphersToSecurityLevel(SUPPORTED_CIPHERS, string);
                }
                if (ENABLED_CIPHERS != null && ENABLED_CIPHERS.length > 0) {
                    sSLServerSocket.setEnabledCipherSuites(ENABLED_CIPHERS);
                } else if (SUPPORTED_CIPHERS != null && SUPPORTED_CIPHERS.length > 0) {
                    sSLServerSocket.setEnabledCipherSuites(SUPPORTED_CIPHERS);
                }
            }
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            FFDCFilter.processException((Throwable)cOMM_FAILURE, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.createSSLServerSocket", "426", this);
            if (!bl) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", (Exception)((Object)cOMM_FAILURE));
                }
            } else if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.createSSLServerSocket"), (String)null, (Object)cOMM_FAILURE);
            }
            throw cOMM_FAILURE;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl.createSSLServerSocket", "459", this);
            String[] stringArray = new String[]{exception.toString()};
            if (!bl) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", exception);
                }
            } else if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnection.createSSLServerSocket"), (String)null, (Object)exception);
            }
            throw new INTERNAL("CAUGHT_EXCEPTION_WHILE_CONFIGURING_SSL_SERVER_SOCKET, Exception=" + exception, 1229066359, CompletionStatus.COMPLETED_NO);
        }
        if (serverConnectionData.getServerPort() == 0) {
            serverConnectionData.setServerPort(sSLServerSocket.getLocalPort());
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "createSSLServerSocket", "Setting local port = " + serverConnectionData.getServerPort());
        }
        return sSLServerSocket;
    }

    public X509Certificate[] getPeerCertificateChain(SSLSocket sSLSocket) {
        SSLSession sSLSession;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (Object)this, "getPeerCertificateChain(SSLSocket)", "theSocket=" + sSLSocket);
        }
        if ((sSLSession = sSLSocket.getSession()) == null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl", "IIOPSSLConnection.createSSLServerSocket", "theSocket.getSession returned null");
            }
            throw new INTERNAL("GET_SSL_SESSION_RETURNED_NULL", 1229066362, CompletionStatus.COMPLETED_NO);
        }
        X509Certificate[] x509CertificateArray = null;
        try {
            x509CertificateArray = (X509Certificate[])sSLSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (Object)this, "getPeerCertificateChain(SSLSocket)", "Caught Exception from getPeerCertificateChain(),  returning a null for peerCertificateChain:  Exception=" + sSLPeerUnverifiedException);
            }
            x509CertificateArray = null;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (Object)this, "getPeerCertificateChain(SSLSocket)", "About to return peerCertificateChain=" + x509CertificateArray);
        }
        return x509CertificateArray;
    }
}

