/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.common.auth.WSPrincipalImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.KerberosToken;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import org.ietf.jgss.GSSCredential;

public class SubjectHelper {
    private static String currentHost = null;
    private static Boolean propagateFirstCallerOnlyBoolean = null;
    private static boolean propagateFirstCallerOnly = false;
    private static Boolean disableCallerListBoolean = null;
    private static boolean disableCallerList = false;
    private static Subject unauthenticatedSubject = null;
    private static final TraceComponent tc = Tr.register(SubjectHelper.class, null, "com.ibm.ejs.resources.security");
    private static Integer maxSizeValue = null;
    static /* synthetic */ Class class$org$ietf$jgss$GSSCredential;
    static /* synthetic */ Class class$com$ibm$wsspi$security$token$SingleSignonToken;
    static /* synthetic */ Class class$com$ibm$websphere$security$auth$WSPrincipal;

    public static Subject createSubjectFromWSCredential(WSCredential wSCredential) {
        return SubjectHelper.createSubjectFromWSCredential(wSCredential, null);
    }

    public static Subject createSubjectFromWSCredential(final WSCredential wSCredential, WSPrincipal wSPrincipal) {
        if (wSCredential == null) {
            return null;
        }
        if (wSPrincipal == null) {
            try {
                wSPrincipal = SubjectHelper.createPrincipal(wSCredential);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.core.ContextManagerImpl.createSubjectFromWSCredential", "118");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception creating principal from WSCredential.", new Object[]{exception});
                }
                return null;
            }
        }
        try {
            final Subject subject = new Subject();
            final WSPrincipal wSPrincipal2 = wSPrincipal;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (!subject.getPrincipals().contains(wSPrincipal2)) {
                        subject.getPrincipals().add((Principal)wSPrincipal2);
                    }
                    if (!subject.getPublicCredentials().contains(wSCredential)) {
                        subject.getPublicCredentials().add(wSCredential);
                    }
                    return null;
                }
            });
            return subject;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.core.ContextManagerImpl.createSubjectFromWSCredential", "150");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception creating Subject from WSCredential.", new Object[]{exception});
            }
            return null;
        }
    }

    public static WSCredential getWSCredentialFromSubject(Subject subject) {
        if (subject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Subject passed in is null.");
            }
            return null;
        }
        Set<Object> set = subject.getPublicCredentials();
        if (set != null && set.size() > 0) {
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object == null || !(object instanceof WSCredential)) continue;
                return (WSCredential)object;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSCredential not present in Subject.");
        }
        return null;
    }

    public static GSSCredential getGSSCredentialFromSubject(final Subject subject) {
        if (subject == null) {
            return null;
        }
        GSSCredential gSSCredential = null;
        try {
            gSSCredential = (GSSCredential)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return subject.getPrivateCredentials(class$org$ietf$jgss$GSSCredential == null ? (class$org$ietf$jgss$GSSCredential = SubjectHelper.class$("org.ietf.jgss.GSSCredential")) : class$org$ietf$jgss$GSSCredential).iterator().next();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        return null;
                    }
                }
            });
            return gSSCredential;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.core.ContextManagerImpl.getGSSCredentialFromSubject", "226");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting GSSCredential from Subject.", new Object[]{exception});
            }
            return null;
        }
    }

    public static boolean putGSSCredentialInSubject(final GSSCredential gSSCredential, final Subject subject) {
        if (subject == null || gSSCredential == null) {
            return false;
        }
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (!subject.getPrivateCredentials().contains(gSSCredential)) {
                        subject.getPrivateCredentials().add(gSSCredential);
                        return true;
                    }
                    return false;
                }
            });
            return bl;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.core.ContextManagerImpl.putGSSCredentialInSubject", "264");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception adding GSSCredential to Subject.", new Object[]{exception});
            }
            return false;
        }
    }

    public static SingleSignonToken getDefaultSSOTokenFromSubject(final Subject subject) {
        if (subject == null) {
            return null;
        }
        SingleSignonToken singleSignonToken = null;
        try {
            singleSignonToken = (SingleSignonToken)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Iterator iterator = subject.getPrivateCredentials(class$com$ibm$wsspi$security$token$SingleSignonToken == null ? (class$com$ibm$wsspi$security$token$SingleSignonToken = SubjectHelper.class$("com.ibm.wsspi.security.token.SingleSignonToken")) : class$com$ibm$wsspi$security$token$SingleSignonToken).iterator();
                    while (iterator.hasNext()) {
                        SingleSignonToken singleSignonToken = (SingleSignonToken)iterator.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Processing SSO token with name: " + singleSignonToken.getName());
                        }
                        if (!singleSignonToken.getName().equals("LtpaToken")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found default SSO token.");
                        }
                        return singleSignonToken;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not find default SSO token.");
                    }
                    return null;
                }
            });
            return singleSignonToken;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.core.ContextManagerImpl.getDefaultSSOTokenFromSubject", "314");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SingleSignonToken from Subject.", new Object[]{exception});
            }
            return null;
        }
    }

    public static AuthorizationToken getDefaultAuthzTokenFromSubject(Subject subject) {
        if (subject == null) {
            return null;
        }
        AuthorizationToken authorizationToken = null;
        try {
            Iterator iterator = subject.getPrivateCredentials(AuthorizationToken.class).iterator();
            while (iterator.hasNext()) {
                authorizationToken = (AuthorizationToken)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing AUTHZ token with name: " + authorizationToken.getName());
                }
                if (!authorizationToken.getName().equals("com.ibm.ws.security.token.AuthorizationTokenImpl")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found default AuthorizationToken.");
                }
                return authorizationToken;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find default Authorization token.");
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.core.ContextManagerImpl.getDefaultAuthzTokenFromSubject", "355");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting AuthorizationToken from Subject.", new Object[]{exception});
            }
            return null;
        }
    }

    public static AuthenticationToken getDefaultAuthTokenFromSubject(Subject subject) {
        if (subject == null) {
            return null;
        }
        AuthenticationToken authenticationToken = null;
        try {
            Iterator iterator = subject.getPrivateCredentials(AuthenticationToken.class).iterator();
            if (iterator.hasNext()) {
                authenticationToken = (AuthenticationToken)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing AUTH token with name: " + authenticationToken.getName());
                }
                return authenticationToken;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find default AuthenticationToken.");
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.core.ContextManagerImpl.getDefaultAuthzTokenFromSubject", "390");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting AuthenticationToken from Subject.", new Object[]{exception});
            }
            return null;
        }
    }

    public static KerberosToken getDefaultKerberosTokenFromSubject(Subject subject) {
        if (subject == null) {
            return null;
        }
        KerberosToken kerberosToken = null;
        try {
            Iterator iterator = subject.getPrivateCredentials(KerberosToken.class).iterator();
            while (iterator.hasNext()) {
                kerberosToken = (KerberosToken)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing Kerberos token with name: " + kerberosToken.getName());
                }
                if (!kerberosToken.getName().equals("com.ibm.ws.security.token.KerberosTokenImpl")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found default KerberosToken.");
                }
                return kerberosToken;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find default Kerberos token.");
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.core.ContextManagerImpl.getDefaultKerberosTokenFromSubject", "430");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting KerberosToken from Subject.", new Object[]{exception});
            }
            return null;
        }
    }

    public static KerberosToken getDefaultKerberosServiceTicketFromSubject(Subject subject) {
        if (subject == null) {
            return null;
        }
        KerberosToken kerberosToken = null;
        try {
            Iterator iterator = subject.getPrivateCredentials(KerberosToken.class).iterator();
            while (iterator.hasNext()) {
                kerberosToken = (KerberosToken)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing Kerberos ticket with name: " + kerberosToken.getName());
                }
                if (!kerberosToken.getName().equals("com.ibm.ws.security.token.KerberosServiceTicketImpl")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found default KerberosServiceTicket.");
                }
                return kerberosToken;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find default Kerberos Service Ticket.");
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.core.ContextManagerImpl.getDefaultKerberosServiceTicketFromSubject", "470");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting KerberosServiceTicket from Subject.", new Object[]{exception});
            }
            return null;
        }
    }

    public static boolean isWSCredentialValid(Subject subject) {
        return SubjectHelper.isWSCredentialValid(subject, false);
    }

    public static boolean isWSCredentialValid(final Subject subject, boolean bl) {
        if (subject == null) {
            return false;
        }
        WSCredential wSCredential = null;
        try {
            wSCredential = (WSCredential)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Iterator<Object> iterator = subject.getPublicCredentials().iterator();
                    while (iterator.hasNext()) {
                        Object object = iterator.next();
                        if (!(object instanceof WSCredential)) continue;
                        return (WSCredential)object;
                    }
                    return null;
                }
            });
            if (bl) {
                long l = wSCredential.getExpiration();
                long l2 = ContextManagerFactory.getInstance().getReqTimeout();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cushion in use is " + l2 + " millis.");
                }
                if (l != -1L && l != 0L) {
                    long l3 = System.currentTimeMillis();
                    long l4 = l - (l3 + l2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Time remaining is: " + l4 + " millis.");
                    }
                    if (l4 <= 0L) {
                        return ServerCredSigner.getInstance().isServerCred(wSCredential);
                    }
                    return true;
                }
                return true;
            }
            boolean bl2 = wSCredential.isCurrent();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Is credential valid? " + bl2);
            }
            return bl2;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.core.ContextManagerImpl.getWSCredentialFromSubject", "560");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting WSCredential from Subject.", new Object[]{exception});
            }
            return false;
        }
    }

    public static WSPrincipal getPrincipalFromSubject(final Subject subject) {
        if (subject == null) {
            return null;
        }
        try {
            WSPrincipal wSPrincipal = (WSPrincipal)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return subject.getPrincipals(class$com$ibm$websphere$security$auth$WSPrincipal == null ? (class$com$ibm$websphere$security$auth$WSPrincipal = SubjectHelper.class$("com.ibm.websphere.security.auth.WSPrincipal")) : class$com$ibm$websphere$security$auth$WSPrincipal).iterator().next();
                }
            });
            return wSPrincipal;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.core.ContextManagerImpl.getPrincipalFromSubject", "594");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting WSPrincipal from Subject.", new Object[]{exception});
            }
            return null;
        }
    }

    public static WSPrincipal createPrincipal(WSCredential wSCredential) throws WSSecurityException {
        WSPrincipal wSPrincipal = null;
        try {
            if (wSCredential != null) {
                CharSequence charSequence;
                String string = wSCredential.getRealmSecurityName();
                if (string == null || string.length() == 0) {
                    charSequence = new StringBuffer(ContextManagerFactory.getInstance().getDefaultRealm());
                    ((StringBuffer)charSequence).append("/").append(wSCredential.getSecurityName());
                    string = ((StringBuffer)charSequence).toString();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Principal name: " + string);
                }
                charSequence = string;
                wSPrincipal = (WSPrincipal)AccessController.doPrivileged(new PrivilegedAction((String)charSequence){
                    private final /* synthetic */ String val$securityNamePriv;
                    {
                        this.val$securityNamePriv = string;
                    }

                    public Object run() {
                        return new WSPrincipalImpl(this.val$securityNamePriv);
                    }
                });
            }
        }
        catch (CredentialExpiredException credentialExpiredException) {
            throw new WSSecurityException(credentialExpiredException.getMessage(), credentialExpiredException);
        }
        return wSPrincipal;
    }

    public static Subject createBasicAuthSubject(String string, String string2, String string3) {
        WSCredentialImpl wSCredentialImpl = null;
        wSCredentialImpl = string == null || string.length() == 0 ? new WSCredentialImpl(ContextManagerFactory.getInstance().getDefaultRealm(), string2, string3) : new WSCredentialImpl(string, string2, string3);
        return SubjectHelper.createSubjectFromWSCredential(wSCredentialImpl);
    }

    public static Subject createUnauthenticatedSubject() {
        block3: {
            if (unauthenticatedSubject == null) {
                try {
                    WSCredentialImpl wSCredentialImpl = new WSCredentialImpl("", ContextManagerFactory.getInstance().getUnauthenticatedString(), "");
                    unauthenticatedSubject = SubjectHelper.createSubjectFromWSCredential(wSCredentialImpl);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.security.auth.SubjectHelper.createUnauthenticatedSubject", "298");
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Exception getting real unauthenticated subject, use constant UNAUTHENTICATED", new Object[]{exception});
                }
            }
        }
        return unauthenticatedSubject;
    }

    public static Subject createNewSubjectFromExisting(Subject subject) {
        Subject subject2;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createNewSubjectFromExisting");
            }
            if (subject == null) {
                return null;
            }
            subject2 = new Subject();
            try {
                Object object;
                Iterator<Object> iterator;
                Set<Object> set = subject.getPublicCredentials();
                Set<Object> set2 = subject.getPrivateCredentials();
                Set<Principal> set3 = subject.getPrincipals();
                if (set.size() > 0) {
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        subject2.getPublicCredentials().add(object);
                    }
                }
                if (set2.size() > 0) {
                    iterator = set2.iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        subject2.getPrivateCredentials().add(object);
                    }
                }
                if (set3.size() > 0) {
                    iterator = set3.iterator();
                    while (iterator.hasNext()) {
                        object = (Principal)iterator.next();
                        subject2.getPrincipals().add((Principal)object);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.token.WSSecurityPropagationHelper.createNewSubjectFromExisting", "738");
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Error copying existing Subject.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNewSubjectFromExisting");
        }
        return subject2;
    }

    private static void initializePropagateFirstCaller() {
        if (propagateFirstCallerOnlyBoolean == null) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.security.core.SecurityConfig");
                Method method = clazz.getMethod("getConfig", null);
                Method method2 = clazz.getMethod("getValue", String.class);
                Object object = method.invoke(null, new Object[0]);
                String string = "com.ibm.CSI.propagateFirstCallerOnly";
                propagateFirstCallerOnlyBoolean = (Boolean)method2.invoke(object, string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (propagateFirstCallerOnlyBoolean == null) {
            propagateFirstCallerOnlyBoolean = Boolean.FALSE;
        }
        propagateFirstCallerOnly = propagateFirstCallerOnlyBoolean;
    }

    private static void initializeDisableCallerList() {
        if (disableCallerListBoolean == null) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.security.core.SecurityConfig");
                Method method = clazz.getMethod("getConfig", null);
                Method method2 = clazz.getMethod("getValue", String.class);
                Object object = method.invoke(null, new Object[0]);
                String string = "com.ibm.CSI.disablePropagationCallerList";
                disableCallerListBoolean = (Boolean)method2.invoke(object, string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (disableCallerListBoolean == null) {
            disableCallerListBoolean = Boolean.FALSE;
        }
        disableCallerList = disableCallerListBoolean;
    }

    public static PropagationToken updatePropagationTokenWithSubjectChange(final Subject subject) {
        PropagationToken propagationToken;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updatePropagationTokenWithSubjectChange");
            }
            if (subject == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "updatePropagationTokenWithSubjectChange");
                }
                return null;
            }
            if (disableCallerListBoolean == null) {
                SubjectHelper.initializeDisableCallerList();
            }
            if (disableCallerList) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "updatePropagationTokenWithSubjectChange: Caller list is disabled.");
                }
                return null;
            }
            propagationToken = null;
            try {
                propagationToken = (PropagationToken)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws WSSecurityException {
                        if (currentHost == null) {
                            currentHost = ContextManagerFactory.getInstance().getProperty("com.ibm.CSI.CellNodeServer");
                        }
                        try {
                            String[] stringArray;
                            WSCredential wSCredential;
                            PropagationToken propagationToken = ContextManagerFactory.getInstance().getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
                            if (propagationToken != null) {
                                if (propagateFirstCallerOnlyBoolean == null) {
                                    SubjectHelper.initializePropagateFirstCaller();
                                }
                                if (propagateFirstCallerOnly) {
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit(tc, "updatePropagationTokenWithSubjectChange: propagation token already exists and propagateFirstCallerOnly is true.");
                                    }
                                    return propagationToken;
                                }
                            }
                            if ((wSCredential = SubjectHelper.getWSCredentialFromSubject(subject)) == null || wSCredential != null && wSCredential.isUnauthenticated()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Not setting propagation token for UNAUTHENTICATED subject.");
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "updatePropagationTokenWithSubjectChange");
                                }
                                return null;
                            }
                            if (maxSizeValue == null) {
                                stringArray = ContextManagerFactory.getInstance().getProperty("com.ibm.websphere.security.auth.PropTokenMaxEntrySize");
                                if (stringArray != null && !stringArray.equals("")) {
                                    maxSizeValue = new Integer((String)stringArray);
                                } else {
                                    maxSizeValue = new Integer("20");
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Maximum PropagationToken Entries:" + maxSizeValue);
                                }
                            }
                            if (propagationToken == null) {
                                block64: {
                                    try {
                                        propagationToken = ContextManagerFactory.getInstance().createPropagationToken(subject);
                                        ContextManagerFactory.getInstance().setPropagationToken(propagationToken.getName() + ":" + propagationToken.getVersion(), propagationToken);
                                    }
                                    catch (Exception exception) {
                                        FFDCFilter.processException(exception, "com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", "735");
                                        if (!tc.isDebugEnabled()) break block64;
                                        Tr.debug(tc, "Error setting propagation token.", new Object[]{exception});
                                    }
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "updatePropagationTokenWithSubjectChange, new");
                                }
                                return propagationToken;
                            }
                            if (wSCredential != null) {
                                Object object;
                                boolean bl;
                                block69: {
                                    block68: {
                                        block66: {
                                            block65: {
                                                stringArray = null;
                                                try {
                                                    stringArray = propagationToken.getAttributes("com.ibm.wsspi.security.propagation.callers");
                                                }
                                                catch (Exception exception) {
                                                    FFDCFilter.processException(exception, "com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", "762");
                                                    if (!tc.isDebugEnabled()) break block65;
                                                    Tr.debug(tc, "Error setting propagation token attribute.", new Object[]{exception});
                                                }
                                            }
                                            String string = null;
                                            String string2 = currentHost + ":" + wSCredential.getRealmSecurityName();
                                            bl = false;
                                            if (stringArray != null && stringArray.length > 0) {
                                                string = stringArray[stringArray.length - 1];
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Last caller: " + string);
                                                }
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Current caller: " + string2);
                                                }
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Number of Callers entry: " + stringArray.length);
                                                }
                                                if (!(wSCredential.isUnauthenticated() || string == null || string.equals(string2) || maxSizeValue != 0 && stringArray.length >= maxSizeValue)) {
                                                    try {
                                                        propagationToken.addAttribute("com.ibm.wsspi.security.propagation.callers", string2);
                                                        bl = true;
                                                    }
                                                    catch (Exception exception) {
                                                        FFDCFilter.processException(exception, "com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", "793");
                                                        if (tc.isDebugEnabled()) {
                                                            Tr.debug(tc, "Error setting propagation token attribute.", new Object[]{exception});
                                                        }
                                                    }
                                                }
                                            } else {
                                                try {
                                                    propagationToken.addAttribute("com.ibm.wsspi.security.propagation.callers", string2);
                                                    bl = true;
                                                }
                                                catch (Exception exception) {
                                                    FFDCFilter.processException(exception, "com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", "817");
                                                    if (!tc.isDebugEnabled()) break block66;
                                                    Tr.debug(tc, "Error setting propagation token attribute.", new Object[]{exception});
                                                }
                                            }
                                        }
                                        if (tc.isDebugEnabled()) {
                                            block67: {
                                                try {
                                                    stringArray = propagationToken.getAttributes("com.ibm.wsspi.security.propagation.callers");
                                                }
                                                catch (Exception exception) {
                                                    FFDCFilter.processException(exception, "com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", "840");
                                                    if (!tc.isDebugEnabled()) break block67;
                                                    Tr.debug(tc, "Error setting propagation token attribute.", new Object[]{exception});
                                                }
                                            }
                                            object = new StringBuffer();
                                            ((StringBuffer)object).append("New contents of caller list: ");
                                            for (int i = 0; i < stringArray.length; ++i) {
                                                if (i != 0) {
                                                    ((StringBuffer)object).append("|");
                                                }
                                                ((StringBuffer)object).append(stringArray[i]);
                                            }
                                            Tr.debug(tc, ((StringBuffer)object).toString());
                                        }
                                        object = null;
                                        try {
                                            object = propagationToken.getAttributes("com.ibm.wsspi.security.propagation.hosts");
                                        }
                                        catch (Exception exception) {
                                            FFDCFilter.processException(exception, "com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", "873");
                                            if (!tc.isDebugEnabled()) break block68;
                                            Tr.debug(tc, "Error setting propagation token attribute.", new Object[]{exception});
                                        }
                                    }
                                    Object object2 = null;
                                    if (object != null && ((Object)object).length > 0) {
                                        object2 = object[((Object)object).length - 1];
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Last host: " + (String)object2);
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Current host: " + currentHost);
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Number of Hosts entry: " + ((Object)object).length);
                                        }
                                        if (!(object2 == null || ((String)object2).equals(currentHost) || maxSizeValue != 0 && ((Object)object).length >= maxSizeValue)) {
                                            try {
                                                propagationToken.addAttribute("com.ibm.wsspi.security.propagation.hosts", currentHost);
                                                bl = true;
                                            }
                                            catch (Exception exception) {
                                                FFDCFilter.processException(exception, "com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", "903");
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Error setting propagation token attribute.", new Object[]{exception});
                                                }
                                            }
                                        }
                                    } else {
                                        try {
                                            propagationToken.addAttribute("com.ibm.wsspi.security.propagation.hosts", currentHost);
                                            bl = true;
                                        }
                                        catch (Exception exception) {
                                            FFDCFilter.processException(exception, "com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", "927");
                                            if (!tc.isDebugEnabled()) break block69;
                                            Tr.debug(tc, "Error setting propagation token attribute.", new Object[]{exception});
                                        }
                                    }
                                }
                                if (tc.isDebugEnabled()) {
                                    block70: {
                                        try {
                                            object = propagationToken.getAttributes("com.ibm.wsspi.security.propagation.hosts");
                                        }
                                        catch (Exception exception) {
                                            FFDCFilter.processException(exception, "com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", "949");
                                            if (!tc.isDebugEnabled()) break block70;
                                            Tr.debug(tc, "Error setting propagation token attribute.", new Object[]{exception});
                                        }
                                    }
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("New contents of hosts list: ");
                                    for (int i = 0; i < ((Object)object).length; ++i) {
                                        if (i != 0) {
                                            stringBuffer.append("|");
                                        }
                                        stringBuffer.append((String)object[i]);
                                    }
                                    Tr.debug(tc, stringBuffer.toString());
                                }
                                if (bl) {
                                    block71: {
                                        try {
                                            ContextManagerFactory.getInstance().setPropagationToken(propagationToken.getName() + ":" + propagationToken.getVersion(), propagationToken);
                                        }
                                        catch (Exception exception) {
                                            FFDCFilter.processException(exception, "com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", "983");
                                            if (!tc.isDebugEnabled()) break block71;
                                            Tr.debug(tc, "Exception setting propagation token.", new Object[]{exception});
                                        }
                                    }
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit(tc, "updatePropagationTokenWithSubjectChange, modified propagation token.");
                                    }
                                } else if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "updatePropagationTokenWithSubjectChange, propagation token unchanged.");
                                }
                                return propagationToken;
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "updatePropagationTokenWithSubjectChange");
                            }
                            return null;
                        }
                        catch (Exception exception) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception occurred updating propagation token.", new Object[]{exception});
                            }
                            FFDCFilter.processException(exception, "com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", "1005");
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "updatePropagationTokenWithSubjectChange");
                            }
                            return null;
                        }
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException(privilegedActionException.getException(), "com.ibm.ws.security.token.WSSecurityPropagationHelper.updatePropagationTokenWithSubjectChange", "1104");
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception updating propagation token.", new Object[]{privilegedActionException.getException()});
            }
        }
        return propagationToken;
    }
}

