/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.j2c.GenericCredentialImpl;
import com.ibm.ws.security.common.auth.WSPrincipalImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.Subject;

public final class PlatformCredential
implements Serializable {
    public static final CredentialType BASIC = new CredentialType("Basic");
    public static final CredentialType DEFAULT = new CredentialType("Default");
    public static final CredentialType CERTIFICATE = new CredentialType("Certificate");
    public static final CredentialType ASSERTED = new CredentialType("Asserted");
    public static final CredentialType ROLE = new CredentialType("Role");
    public static final CredentialType SERVER = new CredentialType("Server");
    public static final int STATE_FREED = 1;
    private static final int VERSION_UNSET = 0;
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int VERSION_3 = 3;
    private static final int MAXIMUM_NAME_LENGTH = 8;
    private static final long serialVersionUID = -4979494157999039784L;
    private static final TraceComponent tc = Tr.register(PlatformCredential.class, "Security", "com.ibm.ejs.resources.security");
    private static final boolean isServant = PlatformHelperFactory.getPlatformHelper().isServantJvm();
    private transient String unauthenticatedUserId;
    private transient Subject j2cSubject;
    private transient boolean authenticated = false;
    private int version = 3;
    private String userId = null;
    private String mvsUserId = null;
    private String auditString = null;
    private long serializationTime;
    private CredentialType credType = DEFAULT;
    private boolean isDefault = false;
    private X509Certificate[] certChain = null;
    private String roleProfile = null;

    public PlatformCredential() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.userId = this.getUnauthenticatedUserId();
        this.auditString = "WebSphere Default/Unauthenticated Login";
        this.credType = DEFAULT;
        this.isDefault = true;
        this.j2cSubject = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public PlatformCredential(CredentialType credentialType, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{credentialType, string, string2});
        }
        this.credType = credentialType;
        this.auditString = string2;
        if (credentialType == ROLE) {
            this.roleProfile = string;
        } else {
            String string3 = this.userId = string != null ? string.toUpperCase().trim() : string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public PlatformCredential(X509Certificate[] x509CertificateArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{x509CertificateArray, string});
        }
        this.credType = CERTIFICATE;
        this.certChain = x509CertificateArray;
        this.auditString = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public String getUserId() {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserId");
        }
        if ((string = this.userId) == null) {
            string = this.getMvsUserId();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserId", string);
        }
        return string;
    }

    public String getMvsUserId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMvsUserId");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMvsUserId", this.mvsUserId);
        }
        return this.mvsUserId;
    }

    public void setMvsUserId(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMvsUserId", string);
        }
        String string2 = this.mvsUserId = string != null ? string.toUpperCase().trim() : string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMvsUserId");
        }
    }

    public String getUnauthenticatedUserId() {
        if (this.unauthenticatedUserId == null) {
            ContextManager contextManager = ContextManagerFactory.getInstance();
            this.unauthenticatedUserId = contextManager.getProperty("com.ibm.security.SAF.unauthenticated");
            this.unauthenticatedUserId = this.unauthenticatedUserId.toUpperCase().trim();
        }
        return this.unauthenticatedUserId;
    }

    public CredentialType getCredentialType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCredentialType");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCredentialType", this.credType);
        }
        return this.credType;
    }

    public String getAuditString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuditString");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuditString", this.auditString);
        }
        return this.auditString;
    }

    public X509Certificate[] getCertificateChain() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificateChain");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertificateChain", this.certChain);
        }
        return this.certChain;
    }

    public String getRoleProfile() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRoleProfileName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRoleProfileName", this.roleProfile);
        }
        return this.roleProfile;
    }

    public boolean isAuthenticated() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAuthenticated");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAuthenticated", new Boolean(this.authenticated));
        }
        return this.authenticated;
    }

    private void setAuthenticated(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAuthenticated", new Boolean(bl));
        }
        this.authenticated = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAuthenticated");
        }
    }

    public boolean isDefault() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDefault");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDefault", new Boolean(this.isDefault));
        }
        return this.isDefault;
    }

    public Subject getPlatformCredSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPlatformCredSubject");
        }
        Subject subject = this.createSubjectFromPlatformCred();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPlatformCredSubject", subject);
        }
        return subject;
    }

    public Subject getJ2CSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJ2CSubject");
        }
        Subject subject = null;
        if (this.isDefault) {
            ContextManager contextManager = ContextManagerFactory.getInstance();
            try {
                subject = contextManager.getServerSubject();
            }
            catch (Exception exception) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to get server subject", exception);
                }
            }
        } else {
            subject = !this.isDefault && this.j2cSubject != null ? this.j2cSubject : this.createJ2CSubject();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJ2CSubject", subject);
        }
        return subject;
    }

    private Subject createJ2CSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJ2CSubject");
        }
        Subject subject = null;
        byte[] byArray = PlatformCredentialManager.instance().createUtoken(this);
        if (byArray == null) {
            throw new IllegalStateException("Could not create credential utoken");
        }
        String string = this.getUserId();
        GenericCredentialImpl genericCredentialImpl = new GenericCredentialImpl(string, byArray, "oid:1.3.18.0.2.30.1");
        subject = new Subject();
        subject.getPrivateCredentials().add(genericCredentialImpl);
        subject.getPrivateCredentials().add(this);
        WSPrincipalImpl wSPrincipalImpl = new WSPrincipalImpl(this.getMvsUserId());
        subject.getPrincipals().add((Principal)wSPrincipalImpl);
        subject.setReadOnly();
        this.j2cSubject = subject;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJ2CSubject", subject);
        }
        return subject;
    }

    private Subject createSubjectFromPlatformCred() {
        Subject subject;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createSubjectFromPlatformCred");
            }
            subject = null;
            ContextManager contextManager = ContextManagerFactory.getInstance();
            String string = contextManager.getProperty("security.activeUserRegistry.realm");
            String string2 = this.getUserId();
            try {
                subject = contextManager.login(string, string2);
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.auth.PlatformCredential.createSubjectFromPlatformCred", "511", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Login failed", wSLoginFailedException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSubjectFromPlatformCred", subject);
        }
        return subject;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject", objectOutputStream);
        }
        long l = System.currentTimeMillis();
        CredentialType credentialType = this.credType;
        if (credentialType == BASIC && this.authenticated) {
            credentialType = ASSERTED;
        }
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("version", this.version);
        putField.put("userId", this.userId);
        putField.put("auditString", this.auditString);
        putField.put("serializationTime", l);
        putField.put("isDefault", this.isDefault);
        putField.put("mvsUserId", this.mvsUserId);
        putField.put("credType", credentialType);
        putField.put("certChain", this.certChain);
        putField.put("roleProfile", this.roleProfile);
        objectOutputStream.writeFields();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "readObject", objectInputStream);
        }
        ObjectInputStream.GetField getField = null;
        try {
            getField = objectInputStream.readFields();
            this.version = getField.get("version", 1);
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not determine version", iOException);
            }
            this.version = 0;
            this.userId = this.getUnauthenticatedUserId();
            this.isDefault = true;
        }
        switch (this.version) {
            default: {
                this.mvsUserId = (String)getField.get("mvsUserId", null);
                this.credType = (CredentialType)getField.get("credType", DEFAULT);
                this.certChain = (X509Certificate[])getField.get("certChain", null);
                this.roleProfile = (String)getField.get("roleProfile", null);
                this.credType = this.getNormalizedCredentialType(this.credType);
            }
            case 2: {
                this.userId = (String)getField.get("userId", this.getUnauthenticatedUserId());
                this.auditString = (String)getField.get("auditString", null);
                this.isDefault = getField.get("isDefault", true);
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Last serialized date", new Date(getField.get("serializationTime", 0L)));
            }
            case 0: 
            case 1: 
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject");
        }
    }

    public String getCacheKeyString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCacheKeyString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.credType).append(": ");
        stringBuffer.append("auditString=").append(this.auditString);
        if (this.credType == ROLE) {
            stringBuffer.append(",roleProfile=").append(this.roleProfile);
            stringBuffer.append(",mvsUserId=").append(this.mvsUserId);
        } else {
            stringBuffer.append(",userId=").append(this.userId);
            stringBuffer.append(",isDefault=").append(this.isDefault);
        }
        if (this.certChain != null && this.certChain[0] != null) {
            BigInteger bigInteger = this.certChain[0].getSerialNumber();
            stringBuffer.append(",certSerialNumber=").append(bigInteger);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCacheKeyString", stringBuffer);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return super.toString() + ",userId=" + this.userId + ",mvsUserId=" + this.mvsUserId + ",isDefault=" + this.isDefault + ",authenticated=" + this.authenticated + ",credType=" + this.credType + ",auditString=" + this.auditString;
    }

    public int hashCode() {
        String string = this.credType + this.userId + this.isDefault + this.auditString;
        return string.hashCode();
    }

    public boolean equals(Object object) {
        PlatformCredential platformCredential = null;
        if (this == object) {
            return true;
        }
        if (object instanceof PlatformCredential) {
            platformCredential = (PlatformCredential)object;
        }
        if (platformCredential != null) {
            boolean bl = this.credType == ROLE || this.userId == null && platformCredential.userId == null || this.userId != null && this.userId.equals(platformCredential.userId);
            boolean bl2 = this.credType == ROLE || this.mvsUserId == null && platformCredential.mvsUserId == null || this.mvsUserId != null && this.mvsUserId.equals(platformCredential.mvsUserId);
            boolean bl3 = this.auditString == null && platformCredential.auditString == null || this.auditString != null && this.auditString.equals(platformCredential.auditString);
            boolean bl4 = this.roleProfile == null && platformCredential.roleProfile == null || this.roleProfile != null && this.roleProfile.equals(platformCredential.roleProfile);
            boolean bl5 = this.credType != BASIC || this.authenticated == platformCredential.authenticated;
            return this.version == platformCredential.version && this.isDefault == platformCredential.isDefault && this.credType == platformCredential.credType && bl5 && bl3 && bl && bl2 && bl4;
        }
        return false;
    }

    private CredentialType getNormalizedCredentialType(CredentialType credentialType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "normalizeCredentialType", credentialType);
        }
        CredentialType credentialType2 = DEFAULT;
        if (BASIC.equals(credentialType)) {
            credentialType2 = BASIC;
        } else if (CERTIFICATE.equals(credentialType)) {
            credentialType2 = CERTIFICATE;
        } else if (ASSERTED.equals(credentialType)) {
            credentialType2 = ASSERTED;
        } else if (ROLE.equals(credentialType)) {
            credentialType2 = ROLE;
        } else if (SERVER.equals(credentialType)) {
            credentialType2 = SERVER;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "normalizeCredentialType", credentialType2);
        }
        return credentialType2;
    }

    public static final class CredentialType
    implements Serializable {
        final String name;

        CredentialType(String string) {
            this.name = string;
        }

        public String toString() {
            return "[" + this.name + "]";
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof CredentialType) {
                CredentialType credentialType = (CredentialType)object;
                return this.name.equals(credentialType.name);
            }
            return false;
        }
    }
}

