/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.jms.JMSResourceRefBuilder;
import com.ibm.ejs.jms.JMSResourceRefBuilderFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.jms.JMSProvider;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.MessagingExpiryType;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.MessagingPersistenceType;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.MessagingPriorityType;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASQueue;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.binder.JMSBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.ws.runtime.service.Server;
import java.util.Properties;
import javax.naming.Referenceable;

public class WASQueueBinder
extends JMSBinder {
    private static TraceComponent tc = Tr.register(WASQueueBinder.class, "ResourceBinders", "com.ibm.ejs.jms.messaging");

    public boolean isUsedFor(J2EEResourceFactory j2EEResourceFactory) {
        boolean bl = false;
        bl = j2EEResourceFactory instanceof WASQueue;
        return bl;
    }

    public Object getBindingObject(J2EEResourceFactory j2EEResourceFactory) throws ResourceBindingException {
        Number number;
        MessagingPersistenceType messagingPersistenceType;
        Properties properties = new Properties();
        WASQueue wASQueue = (WASQueue)j2EEResourceFactory;
        JMSProvider jMSProvider = (JMSProvider)wASQueue.getProvider();
        Server server = (Server)this.getService(Server.class);
        this.setProperty(properties, "CELL", server.getCellName(), true);
        this.releaseService(server);
        this.addPropertySet(properties, j2EEResourceFactory.getPropertySet(), true);
        this.addPropertySet(properties, jMSProvider.getPropertySet(), true);
        String string = wASQueue.getName();
        if (string == null || string.length() <= 0) {
            throw new ResourceBindingException("WASQueue can not be bound as no name has been specified.");
        }
        this.setProperty(properties, "NAME", string, true);
        this.setProperty(properties, "DESC", wASQueue.getDescription(), true);
        MessagingPersistenceType messagingPersistenceType2 = messagingPersistenceType = wASQueue.isSetPersistence() ? wASQueue.getPersistence() : null;
        if (messagingPersistenceType != null) {
            this.setProperty(properties, "PER", new Integer(wASQueue.getPersistence().getValue()), true);
        } else {
            this.setProperty(properties, "PER", new Integer(-2), true);
        }
        MessagingPriorityType messagingPriorityType = messagingPersistenceType = wASQueue.isSetPriority() ? wASQueue.getPriority() : null;
        if (messagingPersistenceType != null) {
            if (wASQueue.getPriority().getValue() == -2) {
                this.setProperty(properties, "PRI", new Integer(wASQueue.getPriority().getValue()), true);
            } else {
                number = wASQueue.isSetSpecifiedPriority() ? new Integer(wASQueue.getSpecifiedPriority()) : null;
                this.checkRequiredProperty(number, "WASQueue " + string + " can not be bound as specifiedPriority is required if priority=SPECIFIED.");
                this.setProperty(properties, "PRI", number, true);
            }
        } else {
            this.setProperty(properties, "PRI", new Integer(-2), true);
        }
        MessagingExpiryType messagingExpiryType = messagingPersistenceType = wASQueue.isSetExpiry() ? wASQueue.getExpiry() : null;
        if (messagingPersistenceType != null) {
            int n = wASQueue.getExpiry().getValue();
            if (n == -2 || n == 0) {
                this.setProperty(properties, "EXP", new Long(n), true);
            } else {
                number = wASQueue.isSetSpecifiedExpiry() ? new Long(wASQueue.getSpecifiedExpiry()) : null;
                this.checkRequiredProperty(number, "WASQueue " + string + " can not be bound as specifiedExpiry is required if expiry=SPECIFIED.");
                this.setProperty(properties, "EXP", number, true);
            }
        } else {
            this.setProperty(properties, "EXP", new Integer(-2), true);
        }
        JMSResourceRefBuilder jMSResourceRefBuilder = JMSResourceRefBuilderFactory.createJMSResourceRefBuilder();
        Referenceable referenceable = null;
        try {
            referenceable = jMSResourceRefBuilder.createEmbeddedQueueReferenceable(properties);
        }
        catch (ResourceBindingException resourceBindingException) {
            FFDCFilter.processException((Throwable)resourceBindingException, "com.ibm.ws.runtime.component.binder.WASQueueBinder.getBindingObject", "125", this);
            throw resourceBindingException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.runtime.component.binder.WASQueueBinder.getBindingObject", "130", this);
            throw new ResourceBindingException(throwable.toString());
        }
        return referenceable;
    }
}

