/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.WSThreadPoolRepository;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPool;

public final class WSThreadPool
implements ThreadPool {
    private static final TraceComponent tc = Tr.register(WSThreadPool.class, "Runtime", "com.ibm.ws.runtime");
    private com.ibm.ws.util.ThreadPool _threadPool;
    private WSThreadPoolRepository _repository;

    protected WSThreadPool(com.ibm.ws.util.ThreadPool threadPool, WSThreadPoolRepository wSThreadPoolRepository) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSThreadPool", threadPool);
        }
        this._threadPool = threadPool;
        this._repository = wSThreadPoolRepository;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSThreadPool");
        }
    }

    public void setThreadWaiting(boolean bl) {
        this._threadPool.setThreadWaiting(bl);
    }

    protected WSThreadPool(String string, int n, int n2, long l, WSThreadPoolRepository wSThreadPoolRepository) {
        this._threadPool = new com.ibm.ws.util.ThreadPool(string, n, n2);
        this._threadPool.setKeepAliveTime(l);
        this._repository = wSThreadPoolRepository;
    }

    protected WSThreadPool(String string, int n, int n2, long l, int n3, WSThreadPoolRepository wSThreadPoolRepository) {
        this(string, n, n2, l, wSThreadPoolRepository);
        this._threadPool.setRequestBufferSize(n3);
    }

    public int execute(Runnable runnable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", runnable);
        }
        try {
            this._threadPool.execute(runnable, this.mapExecutionMode(0));
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.runtime.WSThreadPool.execute", "97", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", new Integer(1));
            }
            return 1;
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.runtime.WSThreadPool.execute", "103", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", new Integer(1));
            }
            return 1;
        }
        catch (ThreadPool.ThreadPoolQueueIsFullException threadPoolQueueIsFullException) {
            FFDCFilter.processException((Throwable)threadPoolQueueIsFullException, "com.ibm.ws.runtime.WSThreadPool.execute", "109", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", new Integer(2));
            }
            return 2;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", new Integer(0));
        }
        return 0;
    }

    public int execute(Runnable runnable, int n) throws UnsupportedOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", new Object[]{runnable, new Integer(n)});
        }
        try {
            this._threadPool.execute(runnable, this.mapExecutionMode(n));
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.runtime.WSThreadPool.execute", "155", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", new Integer(1));
            }
            return 1;
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.runtime.WSThreadPool.execute", "161", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", new Integer(1));
            }
            return 1;
        }
        catch (ThreadPool.ThreadPoolQueueIsFullException threadPoolQueueIsFullException) {
            FFDCFilter.processException((Throwable)threadPoolQueueIsFullException, "com.ibm.ws.runtime.WSThreadPool.execute", "167", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", new Integer(2));
            }
            return 2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute", new Integer(0));
        }
        return 0;
    }

    public void setMinimumPoolSize(int n) throws UnsupportedOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMinimumPoolSize", new Integer(n));
        }
        this._threadPool.setMinimumPoolSize(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMinimumPoolSize");
        }
    }

    public void setMaximumPoolSize(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMaximumPoolSize", new Integer(n));
        }
        this._threadPool.setMaximumPoolSize(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMaximumPoolSize");
        }
    }

    public int getMinimumPoolSize() {
        return this._threadPool.getMinimumPoolSize();
    }

    public int getMaximumPoolSize() {
        return this._threadPool.getMaximumPoolSize();
    }

    public long getKeepAliveTime() {
        return this._threadPool.getKeepAliveTime();
    }

    public void setKeepAliveTime(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKeepAliveTime", new Long(l));
        }
        this._threadPool.setKeepAliveTime(l);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKeepAliveTime");
        }
    }

    public void shutdown() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        this._threadPool.shutdownAfterProcessingCurrentlyQueuedTasks();
        this._repository.removeThreadPool(this._threadPool.getName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    public com.ibm.ws.util.ThreadPool getBackingThreadPool() {
        return this._threadPool;
    }

    private int mapExecutionMode(int n) throws UnsupportedOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapExecutionMode", new Integer(n));
        }
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            default: {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "mapExecutionMode");
                }
                throw new UnsupportedOperationException("Unsupported execution mode : " + n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapExecutionMode", new Integer(n2));
        }
        return n2;
    }
}

