/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.FileAccessor;
import com.ibm.ws.policyset.runtime.FileLocator;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;

public class FileLocatorImpl
implements FileLocator {
    private static TraceComponent tc = Tr.register(FileLocatorImpl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private Repository repository = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    protected String SOURCE_FILE = this.getClass().getName();

    public FileLocatorImpl() {
        try {
            this.repository = (Repository)WsServiceRegistry.getService(this, Repository.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.SOURCE_FILE + ".FileLocatorImpl", FFDC_ID_1);
            Tr.error(tc, "CWPST0092E");
        }
    }

    public String getAttachmentPath(String string, String string2) {
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer(this.repository.getRootURI());
        stringBuffer.append("/cells/");
        stringBuffer.append(this.repository.getCellName());
        stringBuffer.append("/applications/");
        stringBuffer.append(this.getAppPathFragment(stringBuffer.toString(), string));
        string3 = this.getApplicationAttachment(stringBuffer.toString(), string, string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attachment location is " + string3);
        }
        return string3;
    }

    private String getAppPathFragment(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(".ear/deployments");
        final File file = new File(string + File.separator + stringBuffer.toString());
        StringBuffer stringBuffer2 = (StringBuffer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File[] fileArray;
                StringBuffer stringBuffer = new StringBuffer();
                if (file.exists() && (fileArray = file.listFiles()).length >= 1) {
                    stringBuffer.append("/");
                    stringBuffer.append(fileArray[0].getName());
                }
                return stringBuffer;
            }
        });
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getApplicationAttachment(String string, String string2, String string3) {
        Object object;
        String string4;
        block24: {
            EList eList;
            String string5;
            String string6;
            block27: {
                block26: {
                    Property property;
                    EList eList2;
                    String string7;
                    String string8;
                    block25: {
                        String string9;
                        string4 = null;
                        string8 = string9 = string + "/deployment.xml";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "application deployment.xml location is " + string9);
                        }
                        WASResourceSetImpl wASResourceSetImpl = null;
                        Deployment deployment = null;
                        ApplicationDeployment applicationDeployment = null;
                        try {
                            wASResourceSetImpl = new WASResourceSetImpl();
                            object = URI.createFileURI(string9);
                            final Resource resource = wASResourceSetImpl.createResource((URI)object);
                            final InputStream inputStream = FileAccessor.getInputStream(string9);
                            if (resource == null || inputStream == null) break block24;
                            try {
                                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                    public Object run() throws IOException {
                                        resource.load(inputStream, new HashMap());
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception thrown in getApplicationAttachment resource.load()");
                                }
                                throw privilegedActionException.getException();
                            }
                            deployment = (Deployment)resource.getContents().get(0);
                            if (deployment == null) break block24;
                            applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
                            if (applicationDeployment.isUseMetadataFromBinaries()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "in deployment.xml, useMetadataFromBinaries = true");
                                }
                                string6 = applicationDeployment.getBinariesURL();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "application location is " + string6);
                                }
                                if (string6 != null) {
                                    VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
                                    String string10 = variableExpander.expand(string6.trim());
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "expanded application location is " + string10);
                                    }
                                    string4 = string6 = string10;
                                    string7 = null;
                                    eList2 = applicationDeployment.getProperties();
                                    break block25;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "No binariesURL found in deployment.xml so use standard attachment path");
                                }
                                string4 = string;
                                break block24;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "in deployment.xml, useMetadataFromBinaries = false");
                            }
                            string4 = string;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, this.SOURCE_FILE + ".getAttachmentPath", FFDC_ID_2);
                            Tr.error(tc, "CWPST0097E", string8);
                        }
                        break block24;
                    }
                    for (int i = 0; i < eList2.size(); ++i) {
                        property = (Property)eList2.get(i);
                        if (!property.getName().equals("was.loose.config")) continue;
                        string7 = property.getValue();
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "loose config property is " + string7);
                        break;
                    }
                    if (string7 == null) break block26;
                    if (string7.toLowerCase().startsWith("file:/")) {
                        string7 = string7.substring(6);
                    }
                    string8 = string7;
                    LooseApplication looseApplication = null;
                    property = new WASResourceSetImpl();
                    URI uRI = URI.createFileURI(string7);
                    final Resource resource = property.createResource(uRI);
                    final InputStream inputStream = FileAccessor.getInputStream(string7);
                    if (resource == null || inputStream == null) break block24;
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException {
                                resource.load(inputStream, new HashMap());
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception thrown in getApplicationAttachment looseResource.load()");
                        }
                        throw privilegedActionException.getException();
                    }
                    looseApplication = (LooseApplication)resource.getContents().get(0);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Read loose application object");
                    }
                    string5 = null;
                    if (looseApplication == null) break block24;
                    eList = looseApplication.getLooseArchives();
                    break block27;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No looseconfig.xmi found in deployment.xml so use standard attachment path");
                }
                string4 = string;
                break block24;
            }
            for (int i = 0; i < eList.size(); ++i) {
                LooseArchive looseArchive = (LooseArchive)eList.get(i);
                if (!looseArchive.getBinariesPath().equals(string6)) continue;
                string5 = looseArchive.getResourcesPath();
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Found matching path in looseConfig.xml: " + string5);
                break;
            }
            if (string5 != null) {
                string4 = string5;
            }
        }
        if (string4 != null) {
            object = new StringBuffer(string4);
            ((StringBuffer)object).append("/META-INF");
            ((StringBuffer)object).append("/");
            ((StringBuffer)object).append(string3);
            string4 = ((StringBuffer)object).toString();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attachment path is " + string4);
        }
        return string4;
    }

    public String getSystemAttachmentPath(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.repository.getRootURI());
        stringBuffer.append("/cells/");
        stringBuffer.append(this.repository.getCellName());
        stringBuffer.append("/");
        stringBuffer.append(string);
        stringBuffer.append("/");
        stringBuffer.append("policyAttachments.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "System policyAttachment location is " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String getPolicySetPath(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.repository.getRootURI());
        stringBuffer.append("/cells/");
        stringBuffer.append(this.repository.getCellName());
        stringBuffer.append("/");
        stringBuffer.append("PolicySets");
        stringBuffer.append("/");
        stringBuffer.append(string);
        stringBuffer.append("/");
        stringBuffer.append("policySet.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Policy set path is " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    public String getPolicyTypeConfigPath(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(this.repository.getRootURI());
        stringBuffer.append("/cells/");
        stringBuffer.append(this.repository.getCellName());
        stringBuffer.append("/");
        stringBuffer.append("PolicySets");
        stringBuffer.append("/");
        stringBuffer.append(string);
        stringBuffer.append("/");
        stringBuffer.append("PolicyTypes");
        stringBuffer.append("/");
        stringBuffer.append(string2);
        stringBuffer.append("/");
        stringBuffer.append("policy.xml");
        return stringBuffer.toString();
    }

    public String getDefaultBindingPath(String string) {
        String string2;
        String string3;
        String string4;
        String string5 = this.repository.getRootURI();
        String string6 = FileLocatorImpl.constructPathName(string5, string4 = this.repository.getCellName(), string3 = this.repository.getNodeName(), string2 = this.repository.getServerName(), string);
        String string7 = FileAccessor.exists(string6) ? string6 : (FileAccessor.exists(string6 = FileLocatorImpl.constructPathName(string5, string4, string3, null, string)) ? string6 : FileLocatorImpl.constructPathName(string5, string4, null, null, string));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + ": " + string7);
        }
        return string7;
    }

    private static String constructPathName(String string, String string2, String string3, String string4, String string5) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("/cells/");
        stringBuffer.append(string2);
        if (string3 != null) {
            stringBuffer.append("/nodes/");
            stringBuffer.append(string3);
            if (string4 != null) {
                stringBuffer.append("/servers/");
                stringBuffer.append(string4);
            }
        }
        stringBuffer.append("/");
        stringBuffer.append("PolicyTypes");
        stringBuffer.append("/");
        stringBuffer.append(string5);
        stringBuffer.append("/bindings.xml");
        return stringBuffer.toString();
    }

    public String getCustomBindingPath(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("/");
        stringBuffer.append(string2);
        stringBuffer.append("/");
        stringBuffer.append("PolicyTypes");
        stringBuffer.append("/");
        stringBuffer.append(string3);
        stringBuffer.append("/bindings.xml");
        return stringBuffer.toString();
    }

    public String getParent(String string) {
        File file = new File(string);
        return file.getParent();
    }
}

