/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.FileAccessor;
import com.ibm.ws.policyset.runtime.FileLocator;
import com.ibm.ws.policyset.runtime.FileLocatorFactory;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetConfigurationImpl;
import com.ibm.ws.policyset.runtime.PolicySetUtil;
import com.ibm.ws.policyset.runtime.PolicyTypeLoader;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;

public class PolicyTypeAggregator {
    private static TraceComponent tc = Tr.register(PolicyTypeAggregator.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static String className = "com.ibm.ws.policyset.runtime.PolicySetAggregator";
    private static Map policySetConfigs = new HashMap();
    private static Integer policySetConfigsLock = new Integer(0);
    private static List extensions = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolicySetConfiguration getPolicySetConfiguration(ClassLoader classLoader, String string, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetConfiguration", string);
        }
        PolicySetConfigurationImpl policySetConfigurationImpl = null;
        Integer n = policySetConfigsLock;
        synchronized (n) {
            policySetConfigurationImpl = (PolicySetConfigurationImpl)policySetConfigs.get(string);
            if (policySetConfigurationImpl == null) {
                try {
                    policySetConfigurationImpl = new PolicySetConfigurationImpl();
                    List list2 = PolicyTypeAggregator.getExtensions();
                    VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
                    for (PolicyTypeLoader policyTypeLoader : list2) {
                        try {
                            if (list != null && list.contains(policyTypeLoader.getType())) {
                                InputStream inputStream = PolicyTypeAggregator.getPolicyTypeInputStream(string, policyTypeLoader.getType());
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "About to call load on " + policyTypeLoader.getClass().getName());
                                }
                                policyTypeLoader.load(classLoader, variableExpander, inputStream, policySetConfigurationImpl);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Back from load on " + policyTypeLoader.getClass().getName());
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Policy type is not included in policy set: " + policyTypeLoader.getType());
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, className, FFDC_ID_1);
                        }
                    }
                    policySetConfigs.put(string, policySetConfigurationImpl);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, className, FFDC_ID_2);
                }
            }
            policySetConfigurationImpl = new PolicySetConfigurationImpl(policySetConfigurationImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySetConfiguration", string);
        }
        return policySetConfigurationImpl;
    }

    private static List getExtensions() throws Throwable {
        if (extensions == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Loading policy type loader extensions");
            }
            extensions = new ArrayList();
            try {
                String string = PolicySetUtil.isClient() ? "com.ibm.wsfp.thinclient.ibmaxis2-qos-policytypeloader" : "com.ibm.wsfp.main.ibmaxis2-qos-policytypeloader";
                IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
                IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string);
                if (iConfigurationElementArray.length == 0 && PolicySetUtil.isClient()) {
                    string = "com.ibm.wsfp.main.ibmaxis2-qos-policytypeloader";
                    iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found " + iConfigurationElementArray.length + " extensions for " + string);
                }
                HashMap hashMap = new HashMap();
                for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                    try {
                        String string2 = iConfigurationElementArray[i].getValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found " + string2);
                        }
                        Class<?> clazz = Class.forName(string2);
                        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                        PolicyTypeLoader policyTypeLoader = (PolicyTypeLoader)constructor.newInstance(new Object[0]);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "About to call init on " + string2);
                        }
                        policyTypeLoader.init(hashMap);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "back from call init on " + string2);
                        }
                        extensions.add(policyTypeLoader);
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, className, FFDC_ID_3);
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, className, FFDC_ID_4);
                throw throwable;
            }
        }
        return extensions;
    }

    private static InputStream getPolicyTypeInputStream(String string, String string2) {
        FileLocator fileLocator = FileLocatorFactory.getFileLocator();
        String string3 = fileLocator.getPolicyTypeConfigPath(string, string2);
        InputStream inputStream = FileAccessor.getInputStream(string3);
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void refresh() {
        Integer n = policySetConfigsLock;
        synchronized (n) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resetting policySetConfigs");
            }
            policySetConfigs = new HashMap();
        }
    }
}

