/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.runtime.BindingAggregator;
import com.ibm.ws.policyset.runtime.EmptyPolicySetAttachmentsImpl;
import com.ibm.ws.policyset.runtime.FileAccessor;
import com.ibm.ws.policyset.runtime.FileLocator;
import com.ibm.ws.policyset.runtime.FileLocatorFactory;
import com.ibm.ws.policyset.runtime.PolicySetAttachments;
import com.ibm.ws.policyset.runtime.PolicySetAttachmentsImpl;
import com.ibm.ws.policyset.runtime.PolicyTypeAggregator;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBException;

public class PolicySetUtil {
    private static TraceComponent tc = Tr.register(PolicySetUtil.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", Locale.getDefault());
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private String className = this.getClass().getName();
    private static PolicySetUtil policySetUtil = null;
    private ClassLoader systemCL = null;
    private static FileLocator fileLocator = null;
    private static Boolean client = null;

    public static synchronized PolicySetUtil getInstance(ClassLoader classLoader) {
        if (policySetUtil == null) {
            policySetUtil = new PolicySetUtil();
            policySetUtil.init(classLoader);
            policySetUtil.initMBean();
        }
        return policySetUtil;
    }

    private PolicySetUtil() {
    }

    private void init(ClassLoader classLoader) {
        this.systemCL = classLoader;
    }

    public PolicySetAttachments getAttachments(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttachments", string);
        }
        String string2 = this.getAttachmentPath(string, "policyAttachments.xml");
        PolicySetAttachments policySetAttachments = this.getAttachmentsFromFile(string2, "application");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttachments", string);
        }
        return policySetAttachments;
    }

    public PolicySetAttachments getClientAttachments(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientAttachments", string);
        }
        String string2 = this.getAttachmentPath(string, "clientPolicyAttachments.xml");
        PolicySetAttachments policySetAttachments = this.getAttachmentsFromFile(string2, "client");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientAttachments", string);
        }
        return policySetAttachments;
    }

    public PolicySetAttachments getSystemAttachments(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSystemAttachments", string);
        }
        if (!string.equals("system/trust")) {
            throw new Exception(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0088E", new Object[]{string}, "Unknown system policy set type: {0}"));
        }
        String string2 = "sts/policy";
        String string3 = this.getSystemAttachmentPath(string2);
        PolicySetAttachments policySetAttachments = this.getAttachmentsFromFile(string3, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSystemAttachments", string);
        }
        return policySetAttachments;
    }

    public void refresh() {
        BindingAggregator.refresh();
        PolicyTypeAggregator.refresh();
    }

    private PolicySetAttachments getAttachmentsFromFile(String string, String string2) throws Exception {
        PolicySetAttachments policySetAttachments;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAttachmentsFromFile", string);
            }
            policySetAttachments = null;
            try {
                if (string != null && FileAccessor.exists(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found attachments");
                    }
                    BindingAggregator.getDefaultBinding(this.systemCL);
                    PolicySetAttachment policySetAttachment = null;
                    final InputStream inputStream = FileAccessor.getInputStream(string);
                    try {
                        policySetAttachment = (PolicySetAttachment)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws JAXBException, FileNotFoundException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
                                PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(inputStream);
                                PolicySetAttachment policySetAttachment = policySetAttachmentHelper.getPolicySetAttachmentObject();
                                return policySetAttachment;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException(privilegedActionException, this.className + ".getAttachmentsFromFile", FFDC_ID_2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception thrown in getPolicySetAttachmentObject");
                        }
                        throw privilegedActionException.getException();
                    }
                    String string3 = this.getFileLocator().getParent(string);
                    policySetAttachments = new PolicySetAttachmentsImpl(string3, policySetAttachment, string2);
                    break block10;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found no attachments at " + string);
                }
                policySetAttachments = new EmptyPolicySetAttachmentsImpl();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, this.className + ".getAttachmentsFromFile", FFDC_ID_1);
                throw exception;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttachmentsFromFile", string);
        }
        return policySetAttachments;
    }

    private synchronized FileLocator getFileLocator() {
        if (fileLocator == null) {
            fileLocator = FileLocatorFactory.getFileLocator();
        }
        return fileLocator;
    }

    private String getAttachmentPath(String string, String string2) {
        FileLocator fileLocator = this.getFileLocator();
        String string3 = fileLocator.getAttachmentPath(string, string2);
        return string3;
    }

    private String getSystemAttachmentPath(String string) {
        FileLocator fileLocator = this.getFileLocator();
        String string2 = fileLocator.getSystemAttachmentPath(string);
        return string2;
    }

    static boolean isClient() {
        if (client == null) {
            Repository repository = null;
            try {
                repository = (Repository)WsServiceRegistry.getService(FileAccessor.class, Repository.class);
                client = repository != null ? Boolean.FALSE : Boolean.TRUE;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting client flag to " + client);
                }
            }
            catch (Throwable throwable) {
                Tr.debug(tc, "Caught exception, setting client flag to true: ", throwable);
                client = Boolean.TRUE;
            }
        }
        return client;
    }

    void initMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initMBean");
        }
        if (!PolicySetUtil.isClient()) {
            try {
                DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(this, "PolicySetManager");
                AdminServiceFactory.getMBeanFactory().activateMBean("PolicySetManager", defaultRuntimeCollaborator, "PolicySetManager", "META-INF/PolicySetManager.xml");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Activated PolicySetManager MBean");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "PolicySetUtil.initMBean", FFDC_ID_3);
                Tr.error(tc, "CWPST0027E", throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initMBean");
        }
    }
}

