/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.deploy.PolicyResource;
import com.ibm.ws.policyset.runtime.BindingAggregator;
import com.ibm.ws.policyset.runtime.DefaultResourceEvaluator;
import com.ibm.ws.policyset.runtime.FileAccessor;
import com.ibm.ws.policyset.runtime.FileLocatorFactory;
import com.ibm.ws.policyset.runtime.PolicySetAttachments;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetConfigurationImpl;
import com.ibm.ws.policyset.runtime.PolicyTypeAggregator;
import com.ibm.ws.policyset.runtime.ResourceEvaluator;
import com.ibm.ws.security.util.AccessController;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetBinding;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.Resource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBException;

public class PolicySetAttachmentsImpl
implements PolicySetAttachments {
    private static TraceComponent tc = Tr.register(PolicySetAttachmentsImpl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", Locale.getDefault());
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private String applicationPath = null;
    private PolicySetAttachment attachments = null;
    private Map attachmentConfigs = null;
    private String attachmentType = null;
    private PolicySetConfiguration emptyPsConfig = new PolicySetConfigurationImpl();
    private static Map policySetTypes = new HashMap();
    private ResourceEvaluator defaultResourceEvaluator = null;

    public PolicySetAttachmentsImpl(String string, PolicySetAttachment policySetAttachment, String string2) {
        this.applicationPath = string;
        this.attachments = policySetAttachment;
        this.attachmentConfigs = new HashMap();
        this.attachmentType = string2;
        this.defaultResourceEvaluator = new DefaultResourceEvaluator();
    }

    public PolicySetConfiguration getPolicySet(String string, ClassLoader classLoader, ClassLoader classLoader2) throws Exception {
        return this.getPolicySet(string, this.defaultResourceEvaluator, classLoader, classLoader2);
    }

    public PolicySetConfiguration getPolicySet(String string, ResourceEvaluator resourceEvaluator, ClassLoader classLoader, ClassLoader classLoader2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySet", string);
        }
        PolicySetConfiguration policySetConfiguration = null;
        PolicySetReference policySetReference = this.findAttachment(string, resourceEvaluator);
        if (policySetReference != null) {
            String string2 = policySetReference.getId();
            policySetConfiguration = (PolicySetConfiguration)this.attachmentConfigs.get(string2);
            if (policySetConfiguration == null) {
                String string3 = policySetReference.getName();
                String string4 = null;
                PolicySetBinding policySetBinding = policySetReference.getPolicySetBinding();
                if (policySetBinding != null) {
                    string4 = policySetBinding.getName();
                }
                policySetConfiguration = this.getPSConfig(classLoader, classLoader2, string3, string4);
                this.attachmentConfigs.put(string2, policySetConfiguration);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getPolicySet, attachment is null");
            }
            policySetConfiguration = this.emptyPsConfig;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySet", string);
        }
        return policySetConfiguration;
    }

    public boolean isAttached(String string) {
        return this.isAttached(string, this.defaultResourceEvaluator);
    }

    public boolean isAttached(String string, ResourceEvaluator resourceEvaluator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAttached, resourceName=" + string);
        }
        boolean bl = false;
        if (string != null) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            List<PolicySetReference> list = this.attachments.getPolicySetReference();
            Iterator<PolicySetReference> iterator = list.iterator();
            block0: while (!bl && iterator.hasNext()) {
                PolicySetReference policySetReference = iterator.next();
                Tr.debug(tc, "Testing attachment id " + policySetReference.getId());
                Tr.debug(tc, "   Policy set name is " + policySetReference.getName());
                List<Resource> list2 = policySetReference.getResource();
                Iterator<Resource> iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    String string2 = iterator2.next().getPattern();
                    if (string2 == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "findAttachment, resourcePattern is null, skip it");
                        continue;
                    }
                    if (!string2.endsWith("/")) {
                        string2 = string2 + "/";
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resourceName=" + string + ", resourcePattern=" + string2);
                    }
                    if (!resourceEvaluator.matches(string2, string)) continue;
                    bl = true;
                    if (!tc.isDebugEnabled()) continue block0;
                    Tr.debug(tc, "Found attachment: " + string2);
                    continue block0;
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resourceName is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAttached", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl;
    }

    private PolicySetConfiguration getPSConfig(ClassLoader classLoader, ClassLoader classLoader2, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPSConfig", string);
        }
        List list = this.getTypesForPolicySet(string);
        PolicySetConfiguration policySetConfiguration = PolicyTypeAggregator.getPolicySetConfiguration(classLoader2, string, list);
        policySetConfiguration.setPolicyTypeConfiguration("attachmentType", this.attachmentType);
        BindingAggregator.getCustomBinding(this.applicationPath, string2, classLoader, classLoader2, policySetConfiguration, list);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPSConfig", string);
        }
        return policySetConfiguration;
    }

    private PolicySetReference findAttachment(String string, ResourceEvaluator resourceEvaluator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findAttachment", string);
        }
        PolicySetReference policySetReference = null;
        int n = Integer.MAX_VALUE;
        PolicySetReference policySetReference2 = null;
        int n2 = Integer.MAX_VALUE;
        if (string != null) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            String string2 = string;
            String string3 = string;
            boolean bl = true;
            boolean bl2 = false;
            if (this.attachmentType.equals("client") && !string.equals(string2 = this.removeModuleName(string))) {
                bl2 = true;
            }
            while (bl) {
                List<PolicySetReference> list = this.attachments.getPolicySetReference();
                Iterator<PolicySetReference> iterator = list.iterator();
                block1: while (n != 0 && iterator.hasNext()) {
                    PolicySetReference policySetReference3 = iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Testing attachment id " + policySetReference3.getId());
                        Tr.debug(tc, "   Policy set name is " + policySetReference3.getName());
                        Tr.debug(tc, "   Binding is " + policySetReference3.getPolicySetBinding());
                    }
                    List<Resource> list2 = policySetReference3.getResource();
                    Iterator<Resource> iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        int n3;
                        String string4 = iterator2.next().getPattern();
                        if (string4 == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "findAttachment, resourcePattern is null, skip it");
                            continue;
                        }
                        if (!string4.endsWith("/")) {
                            string4 = string4 + "/";
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "resourceName=" + string + ", resourcePattern=" + string4);
                        }
                        if ((n3 = resourceEvaluator.getMatchDistance(string4, string)) < 0) continue;
                        if (n3 < n) {
                            policySetReference = policySetReference3;
                            n = n3;
                        }
                        if (n != 0) continue;
                        continue block1;
                    }
                }
                if (this.attachmentType.equals("client")) {
                    if (n != 0 && bl2) {
                        policySetReference2 = policySetReference;
                        n2 = n;
                        string = string2;
                        bl2 = false;
                        n = Integer.MAX_VALUE;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "match distance = " + n2);
                        Tr.debug(tc, "getting ready to check without moduleName, updated resourceName = " + string);
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            }
            if (this.attachmentType.equals("client") && n2 <= n) {
                policySetReference = policySetReference2;
                n = n2;
                string = string3;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Closer match, so using policy reference with module name");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resourceName is null");
        }
        if (tc.isDebugEnabled()) {
            if (n < Integer.MAX_VALUE) {
                Tr.debug(tc, "Found attachment with id, name, and matchDistance of:", new Object[]{policySetReference.getId(), policySetReference.getName(), new Integer(n)});
            } else {
                Tr.debug(tc, "Found no attachment");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findAttachment", string);
        }
        return policySetReference;
    }

    private synchronized List getTypesForPolicySet(String string) throws Exception {
        List list = (List)policySetTypes.get(string);
        if (list == null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking up types for policy set " + string);
                }
                String string2 = FileLocatorFactory.getFileLocator().getPolicySetPath(string);
                final InputStream inputStream = FileAccessor.getInputStream(string2);
                try {
                    list = (List)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws JAXBException, FileNotFoundException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
                            PolicySetHelper policySetHelper = PolicySetHelperFactory.createHelper(inputStream);
                            return policySetHelper.listEnabledPolicyTypes();
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException(privilegedActionException, "com.ibm.ws.policyset.runtime.PolicySetAttachmentsImpl", FFDC_ID_2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception thrown in listEnabledPolicyTypes");
                    }
                    throw privilegedActionException.getException();
                }
                policySetTypes.put(string, list);
                if (tc.isDebugEnabled()) {
                    String string3 = "";
                    if (list != null) {
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            string3 = string3 + (String)iterator.next() + " ";
                        }
                    }
                    Tr.debug(tc, "Policy set has types " + string3);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                FFDCFilter.processException(fileNotFoundException, "com.ibm.ws.policyset.runtime.PolicySetAttachmentsImpl", FFDC_ID_3);
                throw new FileNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0055E", new Object[]{string}, "Policy set is not found: {0}"));
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.policyset.runtime.PolicySetAttachmentsImpl", FFDC_ID_1);
            }
        }
        return list;
    }

    private String removeModuleName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeModuleName", string);
        }
        String string2 = string;
        PolicyResource policyResource = new PolicyResource(string);
        String string3 = policyResource.getModuleName();
        if (string3 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, string.indexOf(string3)));
            stringBuffer.append(string.substring(string.indexOf(string3) + string3.length() + 1));
            string2 = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resource contains module name");
                Tr.debug(tc, "Resource without moduleName is: " + string2);
            }
        }
        return string2;
    }
}

