/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.runtime.PolicySetUtil;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class FileAccessor {
    private static TraceComponent tc = Tr.register(FileAccessor.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");

    public static boolean exists(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exists", string);
        }
        final String string2 = string;
        boolean bl = false;
        if (PolicySetUtil.isClient()) {
            Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    boolean bl = false;
                    URL uRL = FileAccessor.class.getClassLoader().getResource(string2);
                    if (uRL != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "exists, FileAccessor.class.getClassLoader().getResource returns url=" + uRL);
                        }
                        bl = true;
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "exists, cannot find URL, try Thread.currentThread().getContextClassLoader()");
                        }
                        if ((uRL = Thread.currentThread().getContextClassLoader().getResource(string2)) != null) {
                            bl = true;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "exists, Thread.currentThread().getContextClassLoader() returns url=" + uRL);
                        }
                    }
                    return bl;
                }
            });
            bl = bl2;
        } else {
            final File file = new File(string);
            Boolean bl3 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    boolean bl = file.exists();
                    return bl;
                }
            });
            bl = bl3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exists", new Object[]{string, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        return bl;
    }

    public static InputStream getInputStream(String string) {
        InputStream inputStream;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getInputStream", string);
            }
            inputStream = null;
            if (string != null) {
                if (PolicySetUtil.isClient()) {
                    InputStream inputStream2;
                    final String string2 = string;
                    inputStream = inputStream2 = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            InputStream inputStream = FileAccessor.class.getClassLoader().getResourceAsStream(string2);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "getInputStream, FileAccessor.class.getClassLoader().getResourceAsStream returns stream=" + inputStream + ", pathname=" + string2);
                            }
                            if (inputStream == null) {
                                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string2);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "getInputStream, Thread.currentThread().getContextClassLoader().getResourceAsStream returns stream=" + inputStream + ", pathname=" + string2);
                                }
                            }
                            return inputStream;
                        }
                    });
                } else {
                    try {
                        final File file = new File(string);
                        FileInputStream fileInputStream = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws FileNotFoundException {
                                return new FileInputStream(file);
                            }
                        });
                        inputStream = fileInputStream;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (!tc.isDebugEnabled()) break block7;
                        Tr.debug(tc, "FileNotFound: " + string);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInputStream", string);
        }
        return inputStream;
    }
}

