/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.xmlns.prod.websphere._200605.policyset.NamespacePrefixMapperImpl;
import com.ibm.xmlns.prod.websphere._200605.policyset.PolicySet;
import com.ibm.xmlns.prod.websphere._200605.policyset.PolicyType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;

public class PolicySetHelperImpl
implements PolicySetHelper,
PolicyConstants {
    private String fileName = null;
    private PolicySet policySet = null;
    private int rc = 0;
    private boolean fileLoaded = false;
    protected String className = this.getClass().getName();
    private InputStream inputStream = null;
    private boolean readOnly = false;
    private static Locale _locale = null;
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
    private static ResourceBundle resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";
    private static final String FFDC_ID_7 = "FFDC-7";
    private static final String[] supportedAttributes = new String[]{"name", "description", "default", "type"};
    private static TraceComponent tc = Tr.register(PolicySetHelperImpl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");

    public PolicySetHelperImpl(String string) {
        this.fileName = string;
    }

    public PolicySetHelperImpl(InputStream inputStream) {
        this.inputStream = inputStream;
        this.readOnly = true;
    }

    private void loadData() throws JAXBException, FileNotFoundException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadData for file " + this.fileName);
        }
        this.policySet = null;
        InputStream inputStream = this.inputStream;
        try {
            if (inputStream == null) {
                if (this.fileName != null) {
                    inputStream = new FileInputStream(this.fileName);
                } else {
                    throw new FileNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0067E", new Object[0], "The file name is invalid"));
                }
            }
            JAXBContext jAXBContext = JAXBContext.newInstance("com.ibm.xmlns.prod.websphere._200605.policyset");
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            this.policySet = (PolicySet)unmarshaller.unmarshal(inputStream);
            inputStream.close();
        }
        catch (JAXBException jAXBException) {
            FFDCFilter.processException(jAXBException, this.className, FFDC_ID_1);
            Tr.error(tc, "CWPST0001E", new Object[]{jAXBException.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught JAXBException while parsing file");
                jAXBException.printStackTrace();
            }
            inputStream.close();
            throw jAXBException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException(fileNotFoundException, this.className, FFDC_ID_2);
            Tr.error(tc, "CWPST0001E", new Object[]{fileNotFoundException.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught FileNotFoundException while parsing file");
                fileNotFoundException.printStackTrace();
            }
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, this.className, FFDC_ID_7);
            Tr.error(tc, "CWPST0001E", new Object[]{iOException.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught IOException while parsing file");
                iOException.printStackTrace();
            }
            throw iOException;
        }
        this.fileLoaded = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadData for file " + this.fileName);
        }
    }

    private int saveData() throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveData for file " + this.fileName);
        }
        if (this.readOnly) {
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        int n = 0;
        FileOutputStream fileOutputStream = null;
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance("com.ibm.xmlns.prod.websphere._200605.policyset");
            fileOutputStream = new FileOutputStream(this.fileName);
            Marshaller marshaller = jAXBContext.createMarshaller();
            try {
                marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", new NamespacePrefixMapperImpl());
                marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            }
            catch (PropertyException propertyException) {
                // empty catch block
            }
            marshaller.marshal((Object)this.policySet, fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
        catch (JAXBException jAXBException) {
            FFDCFilter.processException(jAXBException, this.className, FFDC_ID_3);
            Tr.error(tc, "CWPST0002E", new Object[]{jAXBException.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught JAXBException while writing file");
                jAXBException.printStackTrace();
            }
            ((OutputStream)fileOutputStream).close();
            throw jAXBException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException(fileNotFoundException, this.className, FFDC_ID_4);
            Tr.error(tc, "CWPST0002E", new Object[]{fileNotFoundException.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught FileNotFoundException while writing file");
                fileNotFoundException.printStackTrace();
            }
            throw fileNotFoundException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException(illegalArgumentException, this.className, FFDC_ID_5);
            Tr.error(tc, "CWPST0002E", new Object[]{illegalArgumentException.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught IllegalArgumentException while writing file");
                illegalArgumentException.printStackTrace();
            }
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
            throw illegalArgumentException;
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, this.className, FFDC_ID_6);
            Tr.error(tc, "CWPST0002E", new Object[]{iOException.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught IOException while writing file");
                iOException.printStackTrace();
            }
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveData for file " + this.fileName);
        }
        return n;
    }

    public Properties getPolicySet() throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        Properties properties = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.policySet != null) {
            String string;
            properties = new Properties();
            if (this.policySet.getName() == null) {
                throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"name", PolicySetHelperImpl.getPolicySetName(this.fileName)}, "Attribute not found in policy set: {0}"));
            }
            properties.setProperty("name", this.policySet.getName());
            if (this.policySet.getDefault() == null) {
                throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"default", PolicySetHelperImpl.getPolicySetName(this.fileName)}, "Attribute not found in policy set: {0}"));
            }
            properties.setProperty("default", this.policySet.getDefault());
            if (this.policySet.getDescription() != null) {
                string = this.policySet.getDescription();
                if (string.startsWith("$KEY_")) {
                    String string2 = string.substring(5);
                    string = resourceBundle2.getString(string2);
                }
            } else {
                throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"description", PolicySetHelperImpl.getPolicySetName(this.fileName)}, "Attribute not found in policy set: {0}"));
            }
            properties.setProperty("description", string);
            if (this.policySet.getType() != null) {
                properties.setProperty("type", this.policySet.getType());
            } else {
                throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"type", PolicySetHelperImpl.getPolicySetName(this.fileName)}, "Attribute not found in policy set: {0}"));
            }
        }
        return properties;
    }

    public PolicySet getPolicySetObject() throws JAXBException, FileNotFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        if (!this.fileLoaded) {
            this.loadData();
        }
        return this.policySet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int createPolicySet(String string, String string2) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        String string3 = null;
        this.rc = 0;
        if (this.fileName == null || !this.fileName.contains("policySet.xml")) throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0080E", new Object[]{this.fileName}, "The following file name is invalid: {0}"));
        String string4 = this.fileName.substring(0, this.fileName.indexOf("policySet.xml") - 1);
        string3 = string4.substring(string4.lastIndexOf(File.separator) + 1);
        if (string3 == null || string3.equals("")) throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0067E", new Object[0], "The file name is invalid"));
        this.policySet = new PolicySet();
        this.policySet.setName(string3);
        if (string != null) {
            this.policySet.setDescription(string);
        } else {
            this.policySet.setDescription("");
        }
        if (string2 != null) {
            if (!string2.equals("application") && !string2.equals("system/trust")) throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0076E", new Object[]{string2}, "Policy set type is invalid: {0}"));
            this.policySet.setType(string2);
        } else {
            this.policySet.setType("application");
        }
        this.policySet.setDefault("false");
        this.rc = this.saveData();
        if (!tc.isDebugEnabled()) return this.rc;
        Tr.debug(tc, "createPolicySet, rc = " + this.rc);
        return this.rc;
    }

    public int updatePolicySet(Properties properties, boolean bl) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        if (properties != null && !properties.isEmpty()) {
            if (!this.fileLoaded) {
                this.loadData();
            }
            if (this.policySet != null) {
                boolean bl2 = true;
                String string = null;
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements() && bl2) {
                    string = (String)enumeration.nextElement();
                    bl2 = this.isSupported(string);
                }
                if (!bl2) {
                    throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0077E", new Object[]{string}, "Attribute is invalid: {0}"));
                }
                String string2 = properties.getProperty("name");
                if (string2 != null) {
                    if (bl) {
                        this.policySet.setName(string2);
                    } else {
                        throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0078E", new Object[0], "The policy set name cannot be changed"));
                    }
                }
                if ((string2 = properties.getProperty("description")) != null) {
                    this.policySet.setDescription(string2);
                }
                if ((string2 = properties.getProperty("default")) != null) {
                    this.policySet.setDefault(string2);
                }
                if ((string2 = properties.getProperty("type")) != null) {
                    if (string2.equals("application") || string2.equals("system/trust")) {
                        this.policySet.setType(string2);
                    } else {
                        throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0076E", new Object[]{string2}, "Policy set type is invalid: {0}"));
                    }
                }
                this.rc = this.saveData();
            }
        } else {
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0068E", new Object[0], "Invalid input parameter"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updatePolicySet, rc = " + this.rc);
        }
        return this.rc;
    }

    public int addPolicyType(String string, boolean bl) throws JAXBException, FileNotFoundException, IllegalArgumentException, DuplicateItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        boolean bl2 = true;
        if (string != null && !string.equals("")) {
            List list = this.processPolicyTypes();
            if (list != null && !list.isEmpty()) {
                for (int i = 0; i < list.size() && bl2; ++i) {
                    PolicyType policyType = (PolicyType)list.get(i);
                    if (!policyType.getType().equals(string)) continue;
                    bl2 = false;
                    this.rc = -3;
                    throw new DuplicateItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0082E", new Object[]{string}, "Policy type already exists: {0}"));
                }
            }
            if (bl2 && this.rc == 0) {
                PolicyType policyType = new PolicyType();
                policyType.setType(string);
                if (bl) {
                    policyType.setEnabled("true");
                } else {
                    policyType.setEnabled("false");
                }
                policyType.setProvides("");
                this.policySet.getPolicyType().add(policyType);
                this.rc = this.saveData();
            }
        } else {
            this.rc = -7;
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{string}, "Input parameter is invalid: {0}"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addPolicyType, rc = " + this.rc + ", policyType = " + string);
        }
        return this.rc;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int deletePolicyType(String string) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        boolean bl = false;
        if (string != null && !string.equals("")) {
            List list = this.processPolicyTypes();
            if (list != null && !list.isEmpty()) {
                for (int i = 0; i < list.size() && !bl; ++i) {
                    PolicyType policyType = (PolicyType)list.get(i);
                    if (!policyType.getType().equals(string)) continue;
                    bl = true;
                    list.remove(i);
                }
            } else {
                this.rc = -4;
                throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{string}, "Policy type not found: {0}"));
            }
            if (this.rc == 0) {
                if (!bl) {
                    this.rc = -4;
                    throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{string}, "Policy type not found: {0}"));
                }
                this.rc = this.saveData();
            }
        } else {
            this.rc = -7;
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{string}, "Input parameter is invalid: {0}"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deletePolicyType, rc = " + this.rc + ", policyType = " + string);
        }
        return this.rc;
    }

    public List listPolicyTypes() throws JAXBException, FileNotFoundException, IOException {
        return this.listPolicyTypes(false);
    }

    public List listEnabledPolicyTypes() throws JAXBException, FileNotFoundException, IOException {
        return this.listPolicyTypes(true);
    }

    private List listPolicyTypes(boolean bl) throws JAXBException, FileNotFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        ArrayList<String> arrayList = null;
        this.rc = 0;
        List list = this.processPolicyTypes();
        if (list != null && !list.isEmpty()) {
            arrayList = new ArrayList<String>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                PolicyType policyType = (PolicyType)list.get(i);
                String string = policyType.getEnabled();
                if (string == null) {
                    string = "true";
                }
                if (bl && !string.equals("true")) continue;
                arrayList.add(policyType.getType());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "listPolicyTypes, rc = " + this.rc);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Properties getPolicyType(String string, String[] stringArray) throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        List list;
        String string2;
        boolean bl;
        Properties properties;
        block11: {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
            resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
            properties = null;
            this.rc = 0;
            bl = false;
            string2 = "";
            if (string != null && !string.equals("")) {
                list = this.processPolicyTypes();
                if (list != null && !list.isEmpty()) {
                    break block11;
                } else {
                    this.rc = -4;
                    throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{string}, "Policy type not found: {0}"));
                }
            }
            this.rc = -7;
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{string}, "Input parameter is invalid: {0}"));
        }
        for (int i = 0; i < list.size() && !bl; ++i) {
            PolicyType policyType = (PolicyType)list.get(i);
            if (!policyType.getType().equals(string)) continue;
            bl = true;
            properties = new Properties();
            if (stringArray != null && stringArray.length != 0) {
                for (int j = 0; j < stringArray.length; ++j) {
                    if ("type".equals(stringArray[j])) {
                        properties.setProperty("type", policyType.getType());
                    }
                    if ("provides".equals(stringArray[j])) {
                        properties.setProperty("provides", policyType.getProvides());
                    }
                    if ("enabled".equals(stringArray[j])) {
                        properties.setProperty("enabled", policyType.getEnabled());
                    }
                    if (!"description".equals(stringArray[j])) continue;
                    string2 = resourceBundle2.getString(string + ".description");
                    properties.setProperty("description", string2);
                }
                continue;
            }
            properties.setProperty("type", policyType.getType());
            properties.setProperty("provides", policyType.getProvides());
            properties.setProperty("enabled", policyType.getEnabled());
            string2 = resourceBundle2.getString(string + ".description");
            properties.setProperty("description", string2);
        }
        if (!bl) {
            this.rc = -4;
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{string}, "Policy type not found: {0}"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPolicyType, rc = " + this.rc + ", policyType = " + string);
        }
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int setPolicyType(String string, Properties properties) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        block9: {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
            resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
            if (this.readOnly) {
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
            }
            this.rc = 0;
            boolean bl = false;
            if (string != null && !string.equals("") && properties != null && !properties.isEmpty()) {
                List list = this.processPolicyTypes();
                if (list != null && !list.isEmpty()) {
                    for (int i = 0; i < list.size() && !bl; ++i) {
                        String string2;
                        PolicyType policyType = (PolicyType)list.get(i);
                        if (!policyType.getType().equals(string)) continue;
                        bl = true;
                        String string3 = properties.getProperty("provides");
                        if (string3 != null) {
                            policyType.setProvides(string3);
                        }
                        if ((string2 = properties.getProperty("enabled")) != null) {
                            policyType.setEnabled(string2);
                        }
                        this.policySet.getPolicyType().set(i, policyType);
                        this.rc = this.saveData();
                    }
                    if (!bl) {
                        this.rc = -4;
                        throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{string}, "Policy type not found: {0}"));
                    }
                    break block9;
                } else {
                    this.rc = -4;
                    throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{string}, "Policy type not found: {0}"));
                }
            }
            this.rc = -7;
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0068E", new Object[0], "Invalid input parameter"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setPolicyType, rc = " + this.rc + ", policyType = " + string);
        }
        return this.rc;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getPolicyTypeAttribute(String string, String string2) throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        String string3;
        block9: {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
            resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
            string3 = null;
            this.rc = 0;
            boolean bl = false;
            if (string != null && !string.equals("") && string2 != null && !string2.equals("")) {
                List list = this.processPolicyTypes();
                if (list != null && !list.isEmpty()) {
                    for (int i = 0; i < list.size() && !bl; ++i) {
                        PolicyType policyType = (PolicyType)list.get(i);
                        if (!policyType.getType().equals(string)) continue;
                        bl = true;
                        if (string2.equals("type")) {
                            string3 = policyType.getType();
                        }
                        if (string2.equals("provides")) {
                            string3 = policyType.getProvides();
                        }
                        if (string2.equals("enabled")) {
                            string3 = policyType.getEnabled();
                        }
                        if (!string2.equals("description")) continue;
                        string3 = resourceBundle2.getString(string + ".description");
                    }
                    if (!bl) {
                        this.rc = -4;
                        throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{string}, "Policy type not found: {0}"));
                    }
                    break block9;
                } else {
                    this.rc = -4;
                    throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{string}, "Policy type not found: {0}"));
                }
            }
            this.rc = -7;
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0068E", new Object[0], "Invalid input parameter"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPolicyTypeAttribute, rc = " + this.rc + ", policyType = " + string);
        }
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int setPolicyTypeAttribute(String string, String string2, String string3) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        List list;
        boolean bl;
        block11: {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
            resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
            if (this.readOnly) {
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
            }
            this.rc = 0;
            bl = false;
            if (string3 == null) {
                string3 = "";
            }
            if (string != null && !string.equals("") && string2 != null && !string2.equals("")) {
                list = this.processPolicyTypes();
                if (list != null && !list.isEmpty()) {
                    break block11;
                } else {
                    this.rc = -4;
                    throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{string}, "Policy type not found: {0}"));
                }
            }
            this.rc = -7;
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0068E", new Object[0], "Invalid input parameter"));
        }
        for (int i = 0; i < list.size() && !bl; ++i) {
            PolicyType policyType = (PolicyType)list.get(i);
            if (!policyType.getType().equals(string)) continue;
            bl = true;
            if (string2.equals("type")) {
                this.rc = -7;
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0079E", new Object[0], "The policy type cannot be changed"));
            }
            if (string2.equals("provides")) {
                policyType.setProvides(string3);
            }
            if (string2.equals("enabled")) {
                policyType.setEnabled(string3);
            }
            this.policySet.getPolicyType().set(i, policyType);
            this.rc = this.saveData();
        }
        if (!bl) {
            this.rc = -4;
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{string}, "Policy type not found: {0}"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setPolicyTypeAttribute, rc = " + this.rc + ", policyType = " + string);
        }
        return this.rc;
    }

    public boolean isDefaultPolicySet() throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        boolean bl = false;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.policySet != null) {
            if (this.policySet.getDefault() != null) {
                if (this.policySet.getDefault().equals("true")) {
                    bl = true;
                }
            } else {
                throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"default", PolicySetHelperImpl.getPolicySetName(this.fileName)}, "Attribute not found in policy set: {0}"));
            }
        }
        return bl;
    }

    public String getPolicySetType() throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        String string = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.policySet != null) {
            if (this.policySet.getType() != null) {
                string = this.policySet.getType();
            } else {
                throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"type", PolicySetHelperImpl.getPolicySetName(this.fileName)}, "Attribute not found in policy set: {0}"));
            }
        }
        return string;
    }

    public void setLocale(Locale locale) {
        _locale = locale;
    }

    private static Locale getLocale() {
        if (_locale == null) {
            return Locale.getDefault();
        }
        return _locale;
    }

    private List processPolicyTypes() throws JAXBException, FileNotFoundException, IOException {
        List<PolicyType> list = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.policySet != null) {
            list = this.policySet.getPolicyType();
        } else {
            this.rc = -1;
        }
        return list;
    }

    private boolean isSupported(String string) {
        for (int i = 0; i < supportedAttributes.length; ++i) {
            if (!supportedAttributes[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private static String getPolicySetName(String string) {
        String string2 = null;
        if (string != null) {
            int n = string.lastIndexOf(File.separatorChar);
            String string3 = string.substring(0, n);
            n = string3.lastIndexOf(File.separatorChar);
            string2 = string3.substring(n + 1);
        }
        return string2;
    }
}

