/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.NamespacePrefixMapperImpl;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetBinding;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.Resource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;

public class PolicySetAttachmentHelperImpl
implements PolicySetAttachmentHelper,
PolicyConstants {
    private String fileName = null;
    private int rc = 0;
    private boolean fileLoaded = false;
    private PolicySetAttachment policySetAttachment = null;
    private InputStream inputStream = null;
    private boolean readOnly = false;
    private static Locale _locale = null;
    protected String className = this.getClass().getName();
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";
    private static final String FFDC_ID_7 = "FFDC-7";
    private static TraceComponent tc = Tr.register(PolicySetAttachmentHelperImpl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");

    public PolicySetAttachmentHelperImpl(String string) {
        this.fileName = string;
    }

    public PolicySetAttachmentHelperImpl(InputStream inputStream) {
        this.inputStream = inputStream;
        this.readOnly = true;
    }

    private void loadData() throws JAXBException, FileNotFoundException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadData for file " + this.fileName);
        }
        this.policySetAttachment = null;
        InputStream inputStream = null;
        try {
            inputStream = this.inputStream;
            if (inputStream == null) {
                if (this.fileName != null) {
                    inputStream = new FileInputStream(this.fileName);
                } else {
                    throw new FileNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0067E", new Object[0], "The file name is invalid"));
                }
            }
            JAXBContext jAXBContext = JAXBContext.newInstance("com.ibm.xmlns.prod.websphere._200605.policysetattachment");
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            this.policySetAttachment = (PolicySetAttachment)unmarshaller.unmarshal(inputStream);
            inputStream.close();
        }
        catch (JAXBException jAXBException) {
            FFDCFilter.processException(jAXBException, this.className, FFDC_ID_1);
            Tr.error(tc, "CWPST0001E", new Object[]{jAXBException.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught JAXBException while parsing file");
                jAXBException.printStackTrace();
            }
            inputStream.close();
            throw jAXBException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException(fileNotFoundException, this.className, FFDC_ID_2);
            Tr.error(tc, "CWPST0001E", new Object[]{fileNotFoundException.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught FileNotFoundException while parsing file");
                fileNotFoundException.printStackTrace();
            }
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, this.className, FFDC_ID_7);
            Tr.error(tc, "CWPST0001E", new Object[]{iOException.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught IOException while parsing file");
                iOException.printStackTrace();
            }
            throw iOException;
        }
        this.fileLoaded = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadData for file " + this.fileName);
        }
    }

    private int saveData() throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveData for file " + this.fileName);
        }
        int n = 0;
        FileOutputStream fileOutputStream = null;
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance("com.ibm.xmlns.prod.websphere._200605.policysetattachment");
            fileOutputStream = new FileOutputStream(this.fileName);
            Marshaller marshaller = jAXBContext.createMarshaller();
            try {
                marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", new NamespacePrefixMapperImpl());
                marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            }
            catch (PropertyException propertyException) {
                // empty catch block
            }
            marshaller.marshal((Object)this.policySetAttachment, fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
        catch (JAXBException jAXBException) {
            FFDCFilter.processException(jAXBException, this.className, FFDC_ID_3);
            Tr.error(tc, "CWPST0002E", new Object[]{jAXBException.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught JAXBException while writing file");
                jAXBException.printStackTrace();
            }
            ((OutputStream)fileOutputStream).close();
            throw jAXBException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException(fileNotFoundException, this.className, FFDC_ID_4);
            Tr.error(tc, "CWPST0002E", new Object[]{fileNotFoundException.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught FileNotFoundException while writing file");
                fileNotFoundException.printStackTrace();
            }
            throw fileNotFoundException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException(illegalArgumentException, this.className, FFDC_ID_5);
            Tr.error(tc, "CWPST0002E", new Object[]{illegalArgumentException.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught IllegalArgumentException while writing file");
                illegalArgumentException.printStackTrace();
            }
            ((OutputStream)fileOutputStream).close();
            throw illegalArgumentException;
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, this.className, FFDC_ID_6);
            Tr.error(tc, "CWPST0002E", new Object[]{iOException.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught IOException while writing file");
                iOException.printStackTrace();
            }
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveData for file " + this.fileName);
        }
        return n;
    }

    public int createPolicySetAttachment() throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        if (this.fileName == null) {
            this.rc = -6;
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0067E", new Object[0], "The file name is invalid"));
        }
        this.policySetAttachment = new PolicySetAttachment();
        this.rc = this.saveData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createPolicySetAttachment, rc = " + this.rc);
        }
        return this.rc;
    }

    public int createPolicySetAttachment(PolicySetAttachment policySetAttachment) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        if (this.fileName == null) {
            this.rc = -6;
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0067E", new Object[0], "The file name is invalid"));
        }
        this.policySetAttachment = policySetAttachment;
        this.rc = this.saveData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createPolicySetAttachment(policyAttachment), rc = " + this.rc);
        }
        return this.rc;
    }

    public PolicySetAttachment getPolicySetAttachmentObject() throws JAXBException, FileNotFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        if (!this.fileLoaded) {
            this.loadData();
        }
        return this.policySetAttachment;
    }

    public boolean isAttachedToPolicySet(String string) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        boolean bl = false;
        if (string != null && !string.equals("")) {
            List list = this.returnPolicyReferences(string, "name");
            if (list != null && !list.isEmpty()) {
                bl = true;
            }
        } else {
            this.rc = -7;
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{string}, "Input parameter is invalid: {0}"));
        }
        return bl;
    }

    public boolean isAttachmentListEmpty() throws JAXBException, FileNotFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        boolean bl = true;
        List<PolicySetReference> list = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.policySetAttachment != null && (list = this.policySetAttachment.getPolicySetReference()) != null && !list.isEmpty()) {
            bl = false;
        }
        return bl;
    }

    public List getPolicySetAttachments(String string) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        ArrayList arrayList = null;
        this.rc = 0;
        List list = this.returnPolicyReferences(string, "name");
        if (list != null && !list.isEmpty()) {
            arrayList = this.returnAttachments(list);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPolicySetAttachments(String), rc = " + this.rc);
        }
        return arrayList;
    }

    public List getPolicySetAttachments() throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        ArrayList arrayList = null;
        List<PolicySetReference> list = null;
        this.rc = 0;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.policySetAttachment != null && (list = this.policySetAttachment.getPolicySetReference()) != null && !list.isEmpty()) {
            arrayList = this.returnAttachments(list);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPolicySetAttachments(), rc = " + this.rc);
        }
        return arrayList;
    }

    public String attachPolicySet(String string, String string2, String[] stringArray) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        String string3 = null;
        if (string != null && !string.equals("") && stringArray != null) {
            if (!this.fileLoaded) {
                this.loadData();
            }
        } else {
            this.rc = -7;
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0068E", new Object[0], "Invalid input parameter"));
        }
        string3 = this.createAttachmentId(string2);
        List list = this.convertResourceList(stringArray);
        PolicySetReference policySetReference = new PolicySetReference();
        policySetReference.setName(string);
        policySetReference.setId(string3);
        policySetReference.getResource().addAll(list);
        this.policySetAttachment.getPolicySetReference().add(policySetReference);
        this.rc = this.saveData();
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int updatePolicySetAttachment(String string, String[] stringArray, int n) throws JAXBException, FileNotFoundException, IllegalArgumentException, DuplicateItemFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        if (string != null && !string.equals("") && stringArray != null) {
            List list = this.returnPolicyReferences(string, "id");
            if (list != null && !list.isEmpty()) {
                if (list.size() != 1) {
                    this.rc = -9;
                    throw new DuplicateItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0072E", new Object[]{string}, "More than one attachment found with id: {0}"));
                }
                PolicySetReference policySetReference = (PolicySetReference)list.get(0);
                if (n == 1) {
                    List list2 = this.convertResourceList(stringArray);
                    policySetReference.getResource().clear();
                    policySetReference.getResource().addAll(list2);
                } else {
                    List list3 = this.convertResourceBeansToResourcePatterns(policySetReference.getResource());
                    List list4 = null;
                    if (n == 2) {
                        list4 = this.addResources(list3, stringArray);
                    } else if (n == 3) {
                        list4 = this.removeResources(list3, stringArray);
                    }
                    List list5 = this.convertResourceList(list4);
                    policySetReference.getResource().clear();
                    policySetReference.getResource().addAll(list5);
                }
                this.rc = this.saveData();
                return this.rc;
            }
            this.rc = -8;
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{string}, "Attachment not found: {0}"));
        }
        this.rc = -7;
        throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0068E", new Object[0], "Invalid input parameter"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isResourceListEmpty(String string) throws JAXBException, FileNotFoundException, NoItemFoundException, IllegalArgumentException, DuplicateItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        boolean bl = false;
        if (string != null && !string.equals("")) {
            List list = this.returnPolicyReferences(string, "id");
            if (list != null && !list.isEmpty()) {
                if (list.size() == 1) {
                    PolicySetReference policySetReference = (PolicySetReference)list.get(0);
                    List<Resource> list2 = policySetReference.getResource();
                    if (!list2.isEmpty()) return bl;
                    return true;
                }
                this.rc = -9;
                throw new DuplicateItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0072E", new Object[]{string}, "More than one attachment found with id: {0}"));
            }
            this.rc = -8;
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{string}, "Attachment not found: {0}"));
        }
        this.rc = -7;
        throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{string}, "Input parameter is invalid: {0}"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public int detachPolicyId(String string) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        if (string != null && !string.equals("")) {
            List list = this.returnPolicyReferences(string, "id");
            if (list != null && !list.isEmpty()) {
                int n = 0;
                while (true) {
                    if (n >= list.size()) {
                        this.rc = this.saveData();
                        return this.rc;
                    }
                    this.policySetAttachment.getPolicySetReference().remove(list.get(n));
                    ++n;
                }
            }
            this.rc = -8;
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{string}, "Attachment not found: {0}"));
        }
        this.rc = -7;
        throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{string}, "Input parameter is invalid: {0}"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public int detachPolicySet(String string) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        if (string != null && !string.equals("")) {
            List list = this.returnPolicyReferences(string, "name");
            if (list != null && !list.isEmpty()) {
                int n = 0;
                while (true) {
                    if (n >= list.size()) {
                        this.rc = this.saveData();
                        return this.rc;
                    }
                    this.policySetAttachment.getPolicySetReference().remove(list.get(n));
                    ++n;
                }
            }
            this.rc = -8;
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{string}, "Attachment not found: {0}"));
        }
        this.rc = -7;
        throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{string}, "Input parameter is invalid: {0}"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public int transferAttachments(String string, String string2) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        if (string != null && !string.equals("") && string2 != null && !string2.equals("")) {
            List list = this.returnPolicyReferences(string, "name");
            if (list != null && !list.isEmpty()) {
                int n = 0;
                while (true) {
                    if (n >= list.size()) {
                        this.rc = this.saveData();
                        return this.rc;
                    }
                    PolicySetReference policySetReference = (PolicySetReference)list.get(n);
                    policySetReference.setName(string2);
                    ++n;
                }
            }
            this.rc = -8;
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{string}, "Attachment not found: {0}"));
        }
        this.rc = -7;
        throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0068E", new Object[0], "Invalid input parameter"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPolicySetForAttachment(String string) throws JAXBException, FileNotFoundException, IllegalArgumentException, DuplicateItemFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        String string2 = "";
        this.rc = 0;
        if (string != null && !string.equals("")) {
            List list = this.returnPolicyReferences(string, "id");
            if (list != null && !list.isEmpty()) {
                if (list.size() == 1) {
                    PolicySetReference policySetReference = (PolicySetReference)list.get(0);
                    return policySetReference.getName();
                }
                this.rc = -9;
                throw new DuplicateItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0072E", new Object[]{string}, "More than one attachment found with id: {0}"));
            }
            this.rc = -8;
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{string}, "Attachment not found: {0}"));
        }
        this.rc = -7;
        throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{string}, "Input parameter is invalid: {0}"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getBindingReference(String string) throws JAXBException, FileNotFoundException, IllegalArgumentException, DuplicateItemFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        String string2 = "";
        this.rc = 0;
        if (string != null && !string.equals("")) {
            List list = this.returnPolicyReferences(string, "id");
            if (list != null && !list.isEmpty()) {
                if (list.size() == 1) {
                    PolicySetReference policySetReference = (PolicySetReference)list.get(0);
                    PolicySetBinding policySetBinding = policySetReference.getPolicySetBinding();
                    if (policySetBinding == null) return string2;
                    return policySetBinding.getName();
                }
                this.rc = -9;
                throw new DuplicateItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0072E", new Object[]{string}, "More than one attachment found with id: {0}"));
            }
            this.rc = -8;
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{string}, "Attachment not found: {0}"));
        }
        this.rc = -7;
        throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{"attachmentId"}, "Input parameter is invalid: {0}"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public int setBindingReference(String string, String string2) throws JAXBException, FileNotFoundException, IllegalArgumentException, DuplicateItemFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        boolean bl = true;
        if (string2 != null && !string2.equals("")) {
            bl = false;
        }
        if (string != null && !string.equals("")) {
            List list = this.returnPolicyReferences(string, "id");
            if (list != null && !list.isEmpty()) {
                if (list.size() != 1) {
                    this.rc = -9;
                    throw new DuplicateItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0072E", new Object[]{string}, "More than one attachment found with id: {0}"));
                }
                PolicySetReference policySetReference = (PolicySetReference)list.get(0);
                if (bl) {
                    policySetReference.setPolicySetBinding(null);
                } else {
                    PolicySetBinding policySetBinding = policySetReference.getPolicySetBinding();
                    if (policySetBinding != null) {
                        policySetBinding.setName(string2);
                    } else {
                        policySetBinding = new PolicySetBinding();
                        policySetBinding.setName(string2);
                        policySetReference.setPolicySetBinding(policySetBinding);
                    }
                }
                this.rc = this.saveData();
                return this.rc;
            }
            this.rc = -8;
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{string}, "Attachment not found: {0}"));
        }
        this.rc = -7;
        throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{string}, "Input parameter is invalid: {0}"));
    }

    public List getBindingReferencesForPolicySet(String string) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        ArrayList<String> arrayList = new ArrayList<String>();
        this.rc = 0;
        List list = this.returnPolicyReferences(string, "name");
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                PolicySetReference policySetReference = (PolicySetReference)list.get(i);
                PolicySetBinding policySetBinding = policySetReference.getPolicySetBinding();
                if (policySetBinding == null) continue;
                arrayList.add(policySetBinding.getName());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBindingReferencesForPolicySet(String), rc = " + this.rc);
        }
        return arrayList;
    }

    public List getAttachmentIdsForBinding(String string) throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        ArrayList<String> arrayList = new ArrayList<String>();
        this.rc = 0;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.policySetAttachment != null) {
            List<PolicySetReference> list = this.policySetAttachment.getPolicySetReference();
            if (list != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    PolicySetReference policySetReference = list.get(i);
                    PolicySetBinding policySetBinding = policySetReference.getPolicySetBinding();
                    if (policySetBinding == null || !policySetBinding.getName().equals(string)) continue;
                    arrayList.add(policySetReference.getId());
                }
            } else {
                throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0071E", new Object[0], "No attachments found"));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBindingReferencesForPolicySet(String), rc = " + this.rc);
        }
        return arrayList;
    }

    public void setLocale(Locale locale) {
        _locale = locale;
    }

    private static Locale getLocale() {
        if (_locale == null) {
            return Locale.getDefault();
        }
        return _locale;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List returnPolicyReferences(String string, String string2) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        List<PolicySetReference> list = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.policySetAttachment != null) {
            list = this.policySetAttachment.getPolicySetReference();
            if (list == null) return list;
            if (list.isEmpty()) return list;
            if (string == null || string.equals("") || string2 == null || string2.equals("")) throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{string}, "Input parameter is invalid: {0}"));
            ArrayList<PolicySetReference> arrayList = new ArrayList<PolicySetReference>();
            int n = 0;
            while (n < list.size()) {
                PolicySetReference policySetReference = list.get(n);
                String string3 = "";
                string3 = string2.equals("name") ? policySetReference.getName() : policySetReference.getId();
                if (string.equals(string3)) {
                    arrayList.add(policySetReference);
                }
                ++n;
            }
            return arrayList;
        }
        this.rc = -1;
        return list;
    }

    private ArrayList returnAttachments(List list) {
        ArrayList<Properties> arrayList = new ArrayList<Properties>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            List<Resource> list2;
            Properties properties = new Properties();
            PolicySetReference policySetReference = (PolicySetReference)list.get(i);
            properties.setProperty("name", policySetReference.getName());
            properties.setProperty("id", policySetReference.getId());
            PolicySetBinding policySetBinding = policySetReference.getPolicySetBinding();
            if (policySetBinding != null) {
                properties.setProperty("binding", policySetBinding.getName());
            }
            if ((list2 = policySetReference.getResource()) != null) {
                for (int j = 0; j < list2.size(); ++j) {
                    Resource resource = list2.get(j);
                    if (resource == null) continue;
                    properties.setProperty("pattern." + j, resource.getPattern());
                }
            }
            arrayList.add(properties);
        }
        return arrayList;
    }

    private List convertResourceList(String[] stringArray) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (int i = 0; i < stringArray.length; ++i) {
            Resource resource = new Resource();
            resource.setPattern(stringArray[i]);
            arrayList.add(resource);
        }
        return arrayList;
    }

    private List convertResourceList(List list) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (int i = 0; i < list.size(); ++i) {
            Resource resource = new Resource();
            resource.setPattern((String)list.get(i));
            arrayList.add(resource);
        }
        return arrayList;
    }

    private List convertResourceBeansToResourcePatterns(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            Resource resource = (Resource)list.get(i);
            arrayList.add(resource.getPattern());
        }
        return arrayList;
    }

    private List addResources(List list, String[] stringArray) throws DuplicateItemFoundException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(list);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (list.contains(string)) {
                this.rc = -7;
                throw new DuplicateItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0073E", new Object[]{string}, "The resource already exists in the attachment: {0}"));
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private List removeResources(List list, String[] stringArray) throws NoItemFoundException {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!list.contains(string)) {
                this.rc = -7;
                throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0074E", new Object[]{string}, "Resource not found in the attachment: {0}"));
            }
            arrayList.remove(string);
        }
        return arrayList;
    }

    private String createAttachmentId(String string) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        Random random = new Random();
        int n = random.nextInt(1000);
        if (string.equals("client")) {
            n += 1000;
        }
        String string2 = String.valueOf(n);
        List list = this.returnPolicyReferences(string2, "id");
        while (list != null && !list.isEmpty()) {
            n = random.nextInt(1000);
            string2 = String.valueOf(n);
            list = this.returnPolicyReferences(string2, "id");
        }
        return string2;
    }
}

