/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetBinding;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class PolicySetAttachmentReadTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(PolicySetAttachmentReadTask.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    protected String className = ((Object)((Object)this)).getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private RepositoryContext _deployContext = null;

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PolicySetAttachmentReadTask.performTask()");
        }
        try {
            Map map;
            PolicySetAttachmentHelper policySetAttachmentHelper;
            PolicySetAttachment policySetAttachment;
            this._deployContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            String string = "META-INF" + File.separator + "policyAttachments.xml";
            String string2 = this._deployContext.getPath() + File.separator + string;
            File file = new File(string2);
            if (file.exists() && (policySetAttachment = (policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string2)).getPolicySetAttachmentObject()) != null) {
                this.scheduler.getProperties().put("PolicySetAttachmentTask.PolicySetAttachments", policySetAttachment);
                map = this.readBindings(policySetAttachment);
                this.scheduler.getProperties().put("PolicySetAttachmentTask.PolicySetBindings", map);
            }
            string = "META-INF" + File.separator + "clientPolicyAttachments.xml";
            string2 = this._deployContext.getPath() + File.separator + string;
            file = new File(string2);
            if (file.exists() && (policySetAttachment = (policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string2)).getPolicySetAttachmentObject()) != null) {
                this.scheduler.getProperties().put("PolicySetAttachmentTask.ClientPolicySetAttachments", policySetAttachment);
                map = this.readBindings(policySetAttachment);
                this.scheduler.getProperties().put("PolicySetAttachmentTask.ClientPolicySetBindings", map);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "PolicySetAttachmentReadTask.performTask()");
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className, FFDC_ID_1);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), throwable.toString()}));
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, AppUtils.getMessage((ResourceBundle)this.getResourceBundle(), (String)"ADMA0066E"));
        }
    }

    private Map readBindings(PolicySetAttachment policySetAttachment) {
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        List<PolicySetReference> list = policySetAttachment.getPolicySetReference();
        for (PolicySetReference policySetReference : list) {
            Map map;
            PolicySetBinding policySetBinding = policySetReference.getPolicySetBinding();
            if (policySetBinding == null || (map = this.readBindings(policySetBinding.getName())) == null || map.isEmpty()) continue;
            hashMap.put(policySetReference.getName(), map);
        }
        return hashMap;
    }

    private Map readBindings(String string) {
        File file;
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        String string2 = this._deployContext.getPath() + File.separator + "META-INF";
        File file2 = new File(string2 + File.separator + string);
        if (file2.exists() && file2.isDirectory() && (file = new File(string2 + File.separator + string + File.separator + "PolicyTypes")).exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file3 = new File(fileArray[i].getPath() + File.separator + "bindings.xml");
                if (!file3.exists() || !file3.isFile()) continue;
                byte[] byArray = new byte[(int)file3.length()];
                try {
                    FileInputStream fileInputStream = new FileInputStream(file3);
                    fileInputStream.read(byArray);
                    hashMap.put(this.getRelativePath(file3.getPath(), string), byArray);
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, this.className, FFDC_ID_2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception, " + exception + ", while reading " + file3 + " ignored.");
                }
            }
        }
        return hashMap;
    }

    private String getRelativePath(String string, String string2) {
        int n = string.lastIndexOf(string2);
        return string.substring(n);
    }
}

