/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.deploy.PolicyResource;
import com.ibm.ws.policyset.admin.deploy.PolicySetAttachmentInstallTask;
import com.ibm.ws.webservices.admin.exceptions.NoItemFoundException;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelper;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetBinding;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.Resource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import org.xml.sax.SAXException;

public class PolicySetAttachmentProcessor {
    private static TraceComponent tc = Tr.register(PolicySetAttachmentInstallTask.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private PolicySetAttachment _attachment = null;
    private PolicySetAttachment _clientAttachment = null;
    private Map _serviceIndex = null;
    private Map _bindings = null;
    private Map _clientBindings = null;
    private List _bindingDeleteList = new ArrayList();
    protected String SOURCE_FILE = this.getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";
    private static final String FFDC_ID_7 = "FFDC-7";
    private static final String FFDC_ID_8 = "FFDC-8";
    private static final String FFDC_ID_9 = "FFDC-9";
    private static final String FFDC_ID_10 = "FFDC-10";
    private static final String FFDC_ID_11 = "FFDC-11";
    private static final String FFDC_ID_12 = "FFDC-12";

    PolicySetAttachmentProcessor() {
    }

    public PolicySetAttachment getPolicySetAttachment() {
        return this._attachment;
    }

    public void setPolicySetAttachment(PolicySetAttachment policySetAttachment) {
        this._attachment = policySetAttachment;
    }

    public PolicySetAttachment getClientPolicySetAttachment() {
        return this._clientAttachment;
    }

    public void setClientPolicySetAttachment(PolicySetAttachment policySetAttachment) {
        this._clientAttachment = policySetAttachment;
    }

    public List getBindingDeleteList() {
        return this._bindingDeleteList;
    }

    public Map getBindings() {
        return this._bindings;
    }

    public void setBindings(Map map) {
        this._bindings = map;
    }

    public Map getClientBindings() {
        return this._clientBindings;
    }

    public void setClientBindings(Map map) {
        this._clientBindings = map;
    }

    public Map getServiceIndex() {
        return this._serviceIndex;
    }

    public void setServiceIndex(Map map) {
        this._serviceIndex = map;
    }

    private List getEndpointHelpers(List list, PolicyResource policyResource, boolean bl) {
        ArrayList<ServiceIndexHelper> arrayList = new ArrayList<ServiceIndexHelper>();
        for (ServiceIndexHelper serviceIndexHelper : list) {
            try {
                AttributeList attributeList = serviceIndexHelper.getEndpoint(policyResource.getServiceName(), policyResource.getEndpointName(), bl);
                if (attributeList == null || attributeList.isEmpty()) continue;
                arrayList.add(serviceIndexHelper);
            }
            catch (NoItemFoundException noItemFoundException) {
                FFDCFilter.processException(noItemFoundException, this.SOURCE_FILE + ".getEndpointHelpers", FFDC_ID_1);
            }
            catch (FileNotFoundException fileNotFoundException) {
                FFDCFilter.processException(fileNotFoundException, this.SOURCE_FILE + ".getEndpointHelpers", FFDC_ID_2);
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, this.SOURCE_FILE + ".getEndpointHelpers", FFDC_ID_3);
            }
            catch (SAXException sAXException) {
                FFDCFilter.processException(sAXException, this.SOURCE_FILE + ".getEndpointHelpers", FFDC_ID_4);
            }
        }
        return arrayList;
    }

    private List getOperationHelpers(List list, PolicyResource policyResource, boolean bl) {
        ArrayList<ServiceIndexHelper> arrayList = new ArrayList<ServiceIndexHelper>();
        for (ServiceIndexHelper serviceIndexHelper : list) {
            try {
                List list2 = serviceIndexHelper.listOperations(policyResource.getServiceName(), policyResource.getEndpointName(), bl);
                AttributeList attributeList2 = null;
                if (list2 == null) continue;
                for (AttributeList attributeList2 : list2) {
                    Attribute attribute = (Attribute)attributeList2.get(0);
                    if (!attribute.getValue().equals(policyResource.getOperationName())) continue;
                    arrayList.add(serviceIndexHelper);
                }
            }
            catch (NoItemFoundException noItemFoundException) {
                FFDCFilter.processException(noItemFoundException, this.SOURCE_FILE + ".getOperationHelpers", FFDC_ID_5);
            }
            catch (FileNotFoundException fileNotFoundException) {
                FFDCFilter.processException(fileNotFoundException, this.SOURCE_FILE + ".getOperationHelpers", FFDC_ID_6);
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, this.SOURCE_FILE + ".getOperationHelpers", FFDC_ID_7);
            }
            catch (SAXException sAXException) {
                FFDCFilter.processException(sAXException, this.SOURCE_FILE + ".getOperationHelpers", FFDC_ID_8);
            }
        }
        return arrayList;
    }

    private String getRelativePath(String string, String string2) {
        int n = string.lastIndexOf(string2);
        return string.substring(n);
    }

    private List getServiceHelpers(PolicyResource policyResource, boolean bl) {
        ArrayList<ServiceIndexHelper> arrayList = new ArrayList<ServiceIndexHelper>();
        Collection<Object> collection = null;
        if (policyResource.getModuleName() != null) {
            collection = new ArrayList();
            ServiceIndexHelper serviceIndexHelper = (ServiceIndexHelper)this._serviceIndex.get(policyResource.getModuleName());
            if (serviceIndexHelper != null) {
                collection.add(serviceIndexHelper);
            }
        } else {
            collection = this._serviceIndex.values();
        }
        for (ServiceIndexHelper serviceIndexHelper : collection) {
            try {
                AttributeList attributeList = serviceIndexHelper.getWebService(policyResource.getServiceName(), bl);
                if (attributeList == null || attributeList.isEmpty()) continue;
                arrayList.add(serviceIndexHelper);
            }
            catch (NoItemFoundException noItemFoundException) {
                FFDCFilter.processException(noItemFoundException, this.SOURCE_FILE + ".getServiceHelpers", FFDC_ID_9);
            }
            catch (FileNotFoundException fileNotFoundException) {
                FFDCFilter.processException(fileNotFoundException, this.SOURCE_FILE + ".getServiceHelpers", FFDC_ID_10);
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, this.SOURCE_FILE + ".getServiceHelpers", FFDC_ID_11);
            }
            catch (SAXException sAXException) {
                FFDCFilter.processException(sAXException, this.SOURCE_FILE + ".getServiceHelpers", FFDC_ID_12);
            }
        }
        return arrayList;
    }

    private boolean indexContains(PolicyResource policyResource, boolean bl) {
        if (policyResource.getServiceName() == null) {
            return true;
        }
        List list = this.getServiceHelpers(policyResource, bl);
        if (list != null && !list.isEmpty()) {
            if (policyResource.getEndpointName() == null) {
                return true;
            }
            if ((list = this.getEndpointHelpers(list, policyResource, bl)) != null && !list.isEmpty()) {
                if (policyResource.getOperationName() == null) {
                    return true;
                }
                return (list = this.getOperationHelpers(list, policyResource, bl)) != null && !list.isEmpty();
            }
        }
        return false;
    }

    public boolean process() {
        boolean bl = false;
        if (this._attachment != null) {
            bl |= this.processReferences(this._attachment.getPolicySetReference(), this._bindings, false);
        }
        if (this._clientAttachment != null) {
            bl |= this.processReferences(this._clientAttachment.getPolicySetReference(), this._clientBindings, true);
        }
        return bl |= this.cleanupBindings();
    }

    private boolean processReferences(List list, Map map, boolean bl) {
        List<Resource> list2;
        Object object;
        boolean bl2 = false;
        for (PolicySetReference policySetReference : list) {
            object = policySetReference.getResource();
            list2 = object.iterator();
            while (list2.hasNext()) {
                Resource resource = list2.next();
                PolicyResource policyResource = new PolicyResource(resource);
                if (!policyResource.isValid() || this.indexContains(policyResource, bl)) continue;
                bl2 = true;
                list2.remove();
            }
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PolicySetReference policySetReference;
            policySetReference = (PolicySetReference)iterator.next();
            object = policySetReference.getPolicySetBinding();
            list2 = policySetReference.getResource();
            if (list2 != null && !list2.isEmpty()) continue;
            bl2 = true;
            map.remove(policySetReference.getName());
            iterator.remove();
            if (this._bindingDeleteList.contains(((PolicySetBinding)object).getName())) continue;
            this._bindingDeleteList.add(((PolicySetBinding)object).getName());
        }
        return bl2;
    }

    private boolean cleanupBindings() {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this._bindingDeleteList) {
            if ((this._attachment == null || !this.used(string, this._attachment.getPolicySetReference())) && (this._clientAttachment == null || !this.used(string, this._clientAttachment.getPolicySetReference()))) continue;
            arrayList.add(string);
        }
        for (String string : arrayList) {
            this._bindingDeleteList.remove(string);
        }
        return bl;
    }

    private boolean used(String string, List list) {
        for (PolicySetReference policySetReference : list) {
            PolicySetBinding policySetBinding = policySetReference.getPolicySetBinding();
            List<Resource> list2 = policySetReference.getResource();
            if (!string.equalsIgnoreCase(policySetBinding.getName())) continue;
            return true;
        }
        return false;
    }
}

