/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditSchedulerImpl;
import com.ibm.ws.management.application.UpdateSchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.deploy.PolicySetAttachmentIndexReader;
import com.ibm.ws.policyset.admin.deploy.PolicySetAttachmentProcessor;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class PolicySetAttachmentInstallTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(PolicySetAttachmentInstallTask.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    protected String className = ((Object)((Object)this)).getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private RepositoryContext _deployContext = null;
    private EARFile _localear = null;

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PolicySetAttachmentInstallTask.performTask()");
        }
        try {
            PolicySetAttachmentHelper policySetAttachmentHelper;
            String string;
            HashMap hashMap;
            this._deployContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            PolicySetAttachment policySetAttachment = (PolicySetAttachment)this.scheduler.getProperties().get("PolicySetAttachmentTask.PolicySetAttachments");
            PolicySetAttachment policySetAttachment2 = (PolicySetAttachment)this.scheduler.getProperties().get("PolicySetAttachmentTask.ClientPolicySetAttachments");
            if ((policySetAttachment == null || policySetAttachment.getPolicySetReference().isEmpty()) && (policySetAttachment2 == null || policySetAttachment2.getPolicySetReference().isEmpty())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PolicySetAttachmentInstallTask.performTask()-No PolicySet attachment objects so nothing to do");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "PolicySetAttachmentInstallTask.performTask()");
                }
                return true;
            }
            Map map = new PolicySetAttachmentIndexReader().readIndexes(this._deployContext, this.getEar());
            if (map == null || map.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PolicySetAttachmentInstallTask.performTask()-No Service Index files so nothing to do");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "PolicySetAttachmentInstallTask.performTask()");
                }
                return true;
            }
            HashMap hashMap2 = (HashMap)this.scheduler.getProperties().get("PolicySetAttachmentTask.PolicySetBindings");
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
            }
            if ((hashMap = (HashMap)this.scheduler.getProperties().get("PolicySetAttachmentTask.ClientPolicySetBindings")) == null) {
                hashMap = new HashMap();
            }
            PolicySetAttachmentProcessor policySetAttachmentProcessor = new PolicySetAttachmentProcessor();
            policySetAttachmentProcessor.setBindings(hashMap2);
            policySetAttachmentProcessor.setClientBindings(hashMap);
            policySetAttachmentProcessor.setServiceIndex(map);
            policySetAttachmentProcessor.setPolicySetAttachment(policySetAttachment);
            policySetAttachmentProcessor.setClientPolicySetAttachment(policySetAttachment2);
            policySetAttachmentProcessor.process();
            String string2 = "META-INF" + File.separator + "policyAttachments.xml";
            String string3 = "META-INF" + File.separator + "clientPolicyAttachments.xml";
            if (policySetAttachmentProcessor.getPolicySetAttachment() != null && policySetAttachmentProcessor.getPolicySetAttachment().getPolicySetReference() != null && !policySetAttachmentProcessor.getPolicySetAttachment().getPolicySetReference().isEmpty()) {
                string = this._deployContext.getPath() + File.separator + string2;
                policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string);
                policySetAttachmentHelper.createPolicySetAttachment(policySetAttachmentProcessor.getPolicySetAttachment());
                this._deployContext.notifyChanged(this.scheduler instanceof InstallScheduler ? 0 : 1, string2);
            } else {
                string = this._deployContext.getPath() + File.separator + string2;
                new File(string).delete();
                this._deployContext.notifyChanged(2, string2);
            }
            if (policySetAttachmentProcessor.getClientPolicySetAttachment() != null && policySetAttachmentProcessor.getClientPolicySetAttachment().getPolicySetReference() != null && !policySetAttachmentProcessor.getClientPolicySetAttachment().getPolicySetReference().isEmpty()) {
                string = this._deployContext.getPath() + File.separator + string3;
                policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string);
                policySetAttachmentHelper.createPolicySetAttachment(policySetAttachmentProcessor.getClientPolicySetAttachment());
                this._deployContext.notifyChanged(this.scheduler instanceof InstallScheduler ? 0 : 1, string3);
            } else {
                string = this._deployContext.getPath() + File.separator + string3;
                new File(string).delete();
                this._deployContext.notifyChanged(2, string3);
            }
            this.writeBindingFiles(policySetAttachmentProcessor.getBindings());
            this.writeBindingFiles(policySetAttachmentProcessor.getClientBindings());
            this.deleteBindingFiles(policySetAttachmentProcessor.getBindingDeleteList());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "PolicySetAttachmentInstallTask.performTask()");
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className, FFDC_ID_1);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), throwable.toString()}));
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, AppUtils.getMessage((ResourceBundle)this.getResourceBundle(), (String)"ADMA0066E"));
        }
    }

    private void writeBindingFiles(Map map) throws FileNotFoundException, IOException, WorkSpaceException {
        if (map == null) {
            return;
        }
        for (Map map2 : map.values()) {
            for (String string : map2.keySet()) {
                byte[] byArray = (byte[])map2.get(string);
                String string2 = this._deployContext.getPath() + File.separator + "META-INF" + File.separator + string;
                File file = new File(string2);
                boolean bl = !file.exists();
                OutputStream outputStream = this._deployContext.getOutputStream("META-INF" + File.separator + string);
                outputStream.write(byArray);
                this._deployContext.notifyChanged(bl ? 0 : 1, string);
            }
        }
    }

    private void deleteBindingFiles(List list) throws FileNotFoundException, IOException, WorkSpaceException {
        if (list == null) {
            return;
        }
        for (String string : list) {
            this._deployContext.delete(string);
            this._deployContext.notifyChanged(2, string);
        }
    }

    private EARFile getEar() throws Exception {
        if (this._localear != null) {
            return this._localear;
        }
        EARFile eARFile = null;
        if (this.scheduler instanceof InstallScheduler) {
            eARFile = this._localear = ((InstallScheduler)this.scheduler).getEarFile(false, true);
        } else if (this.scheduler instanceof UpdateScheduler) {
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            if (!ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)repositoryContext).isZeroBinaryCopy()) {
                this._localear = ConfigRepoHelper.getEarFileFromBinaries((RepositoryContext)repositoryContext, (WorkSpace)this.scheduler.getWorkSpace(), (ResourceBundle)this.getResourceBundle(), (boolean)true);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "zero bin copy so get ear from source");
                }
                this._localear = (EARFile)((UpdateSchedulerImpl)this.scheduler).getContentAsArchive(false, true);
            }
            eARFile = this._localear;
        } else if (this.scheduler instanceof EditSchedulerImpl) {
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            eARFile = this._localear = ConfigRepoHelper.getEarFileFromDeployment((WorkSpace)this.scheduler.getWorkSpace(), (RepositoryContext)repositoryContext);
        }
        return eARFile;
    }
}

