/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.ws.policyset.admin.deploy.PolicySetAttachmentInstallTask;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelper;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelperFactory;
import java.io.File;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class PolicySetAttachmentIndexReader {
    private static TraceComponent tc = Tr.register(PolicySetAttachmentInstallTask.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private RepositoryContext _deployContext = null;

    public Map readIndexes(RepositoryContext repositoryContext, EARFile eARFile) throws Exception {
        this._deployContext = repositoryContext;
        return this.readIndexFile(eARFile);
    }

    private ServiceIndexHelper readIndexFile(ModuleFile moduleFile) throws Exception {
        String string = moduleFile.getName() + File.separator + this.getMetaDirectory(moduleFile) + File.separator + "servicesIndex.xml";
        ServiceIndexHelper serviceIndexHelper = null;
        File file = new File(this._deployContext.getPath() + File.separator + string);
        if (file.exists()) {
            InputStream inputStream = this._deployContext.getInputStream(string);
            serviceIndexHelper = ServiceIndexHelperFactory.createHelper(inputStream);
            serviceIndexHelper.listWebServices(true);
        }
        return serviceIndexHelper;
    }

    private String getMetaDirectory(ModuleFile moduleFile) {
        return moduleFile.isWARFile() ? "WEB-INF" : "META-INF";
    }

    private Map readIndexFile(EARFile eARFile) throws Exception {
        Hashtable<String, ServiceIndexHelper> hashtable = new Hashtable<String, ServiceIndexHelper>();
        List list = eARFile.getModuleFiles();
        for (ModuleFile moduleFile : list) {
            ServiceIndexHelper serviceIndexHelper = this.readIndexFile(moduleFile);
            if (serviceIndexHelper == null || serviceIndexHelper.listWebServices(true).isEmpty() && serviceIndexHelper.listWebServices(false).isEmpty()) continue;
            hashtable.put(moduleFile.getName(), serviceIndexHelper);
        }
        return hashtable;
    }
}

