/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditSchedulerImpl;
import com.ibm.ws.management.application.UpdateSchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.deploy.PolicySetAttachmentInstallTask;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;

public class CopyBindingsTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(PolicySetAttachmentInstallTask.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    protected String className = ((Object)((Object)this)).getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private RepositoryContext _deployContext = null;
    private EARFile _localear = null;

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CopyBindingsTask.performTask()");
        }
        try {
            EARFile eARFile = this.getEar();
            this._deployContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            String string = "META-INF" + File.separator + "clientPolicyAttachments.xml";
            String string2 = "META-INF" + File.separator + "policyAttachments.xml";
            String string3 = this._deployContext.getPath() + File.separator + string;
            String string4 = this._deployContext.getPath() + File.separator + string2;
            File file = new File(string3);
            File file2 = new File(string4);
            if (file.exists()) {
                this.validatePolicySets(file, string3);
            }
            if (file2.exists()) {
                this.validatePolicySets(file2, string4);
            }
            String string5 = "META-INF/.*/bindings.xml";
            for (org.eclipse.jst.j2ee.commonarchivecore.internal.File file3 : eARFile.getFiles()) {
                if (file3 instanceof Container || file3.isSetDirectoryEntry() && file3.isDirectoryEntry()) continue;
                String string6 = file3.getURI();
                if (!(string6 = string6.replace('\\', '/')).matches(string5)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CopyBindingsTask, Copy " + string6);
                }
                InputStream inputStream = eARFile.getInputStream(string6);
                OutputStream outputStream = this._deployContext.getOutputStream(string6);
                this.save2File(inputStream, outputStream);
                outputStream.close();
                inputStream.close();
                this._deployContext.notifyChanged(0, string6);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "CopyBindingsTask.performTask()");
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className, FFDC_ID_1);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), throwable.toString()}));
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, AppUtils.getMessage((ResourceBundle)this.getResourceBundle(), (String)"ADMA0066E"));
        }
    }

    private void validatePolicySets(File file, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validatePolicySets(fileName = " + string + ")");
        }
        try {
            PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string);
            PolicySetAttachment policySetAttachment = policySetAttachmentHelper.getPolicySetAttachmentObject();
            if (policySetAttachment != null) {
                List<PolicySetReference> list = policySetAttachment.getPolicySetReference();
                List list2 = this.listPolicySets();
                for (PolicySetReference policySetReference : list) {
                    String string2 = policySetReference.getName();
                    boolean bl = false;
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext() && !bl) {
                        String string3 = iterator.next().toString();
                        if (!string3.equals(string2)) continue;
                        bl = true;
                        break;
                    }
                    if (bl || !tc.isWarningEnabled()) continue;
                    Tr.warning(tc, "The policyset of " + string2 + " is not defined in server. You may need to manually import or define this policyset to make your application work properly.");
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validatePolicySets(fileName = " + string + ")");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.className, FFDC_ID_1);
            Tr.error(tc, "Exception: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List listPolicySets() throws Exception {
        List list = null;
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        if (commandMgr != null) {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = new Session();
            try {
                AdminCommand adminCommand = commandMgr.createCommand("listPolicySets");
                adminCommand.setConfigSession(session);
                adminCommand.execute();
                CommandResult commandResult = adminCommand.getCommandResult();
                if (!commandResult.isSuccessful()) {
                    throw new Exception("failure during");
                }
                list = (List)commandResult.getResult();
            }
            catch (Exception exception) {
                Tr.error(tc, "Exception: " + exception.getMessage());
            }
            finally {
                configService.discard(session);
            }
        }
        return list;
    }

    private void save2File(InputStream inputStream, OutputStream outputStream) throws Exception {
        byte[] byArray;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save2File");
        }
        int n2 = inputStream.available();
        while (n2 > 0 && (n = inputStream.read(byArray = new byte[n2])) >= 1) {
            outputStream.write(byArray, 0, n);
            n2 = inputStream.available();
        }
        outputStream.flush();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save2File");
        }
    }

    private EARFile getEar() throws Exception {
        if (this._localear != null) {
            return this._localear;
        }
        EARFile eARFile = null;
        if (this.scheduler instanceof InstallScheduler) {
            eARFile = this._localear = ((InstallScheduler)this.scheduler).getEarFile(false, true);
        } else if (this.scheduler instanceof UpdateScheduler) {
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            if (!ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)repositoryContext).isZeroBinaryCopy()) {
                this._localear = ConfigRepoHelper.getEarFileFromBinaries((RepositoryContext)repositoryContext, (WorkSpace)this.scheduler.getWorkSpace(), (ResourceBundle)this.getResourceBundle(), (boolean)true);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "zero bin copy so get ear from source");
                }
                this._localear = (EARFile)((UpdateSchedulerImpl)this.scheduler).getContentAsArchive(false, true);
            }
            eARFile = this._localear;
        } else if (this.scheduler instanceof EditSchedulerImpl) {
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            eARFile = this._localear = ConfigRepoHelper.getEarFileFromDeployment((WorkSpace)this.scheduler.getWorkSpace(), (RepositoryContext)repositoryContext);
        }
        return eARFile;
    }
}

