/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceEvent;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceListener;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidationManager
implements WorkSpaceListener {
    private static TraceComponent tc = Tr.register(ValidationManager.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    static Map managers = Collections.synchronizedMap(new HashMap());
    private Session session = null;
    private List policySets = null;
    private boolean isValidated = false;

    static synchronized ValidationManager getManager(Session session) {
        String string;
        ValidationManager validationManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getManager", session);
        }
        if ((validationManager = (ValidationManager)managers.get(string = session.toString())) == null) {
            validationManager = ValidationManager.createManager(session);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getManager", session);
        }
        return validationManager;
    }

    private static ValidationManager createManager(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createManager", session);
        }
        String string = session.toString();
        ValidationManager validationManager = new ValidationManager(session);
        managers.put(string, validationManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createManager", session);
        }
        return validationManager;
    }

    private ValidationManager(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor", session);
        }
        this.session = session;
        try {
            WorkSpace workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
            workSpace.addWorkSpaceListener((WorkSpaceListener)this);
            this.policySets = new ArrayList();
        }
        catch (WorkSpaceException workSpaceException) {
            FFDCFilter.processException(workSpaceException, "com.ibm.ws.policyset.admin.commands.ValidationManager", "94");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor", session);
        }
    }

    void markForValidation(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "markForValidation", string);
        }
        if (!this.policySets.contains(string)) {
            this.policySets.add(string);
        }
    }

    public void handle(WorkSpaceEvent workSpaceEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle", workSpaceEvent.getType());
        }
        int n = workSpaceEvent.getType();
        if (n == 25 && !this.isValidated) {
            this.validate();
            this.isValidated = true;
            this.cleanUp();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle", workSpaceEvent.getType());
        }
    }

    private void validate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            for (String string : this.policySets) {
                String string2;
                StringBuffer stringBuffer = PolicySetCommandUtil.validatePolicySet(this.session, string, string2 = PolicySetWorkSpaceHelper.getPolicySetFile(this.session, string));
                if (stringBuffer.length() != 0) {
                    Tr.error(tc, "CWPST0025E", new Object[]{stringBuffer.toString()});
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Policy types valid for policy set: " + string);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.policyset.admin.commands.ValidationManager", "104");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    private void cleanUp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanUp");
        }
        managers.remove(this.session.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanUp");
        }
    }
}

