/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import java.util.Properties;
import java.util.ResourceBundle;

public class UpdatePolicySet
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(UpdatePolicySet.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String className = this.getClass().getName();
    private Session session = null;

    public UpdatePolicySet(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + commandMetadata);
        }
    }

    public UpdatePolicySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = null;
        String string = null;
        try {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String string2 = (String)this.getParameter("policySet");
            Properties properties = (Properties)this.getParameter("attributes");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string2, properties});
            }
            commandResultImpl = new CommandResultImpl();
            this.setCommandResult(commandResultImpl);
            commandResultImpl.reset();
            this.session = this.getConfigSession();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "UpdatePolicySet, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            string = PolicySetWorkSpaceHelper.getPolicySetFile(this.session, string2);
            if (string != null && string.length() > 0) {
                PolicySetHelper policySetHelper = PolicySetHelperFactory.createHelper(string);
                policySetHelper.setLocale(this.getLocale());
                if (policySetHelper.isDefaultPolicySet()) {
                    throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0004E", new Object[]{string2}, "A default policy set cannot be edited or deleted: {0}"));
                }
                int n = policySetHelper.updatePolicySet(properties, false);
                PolicySetWorkSpaceHelper.updatePolicySetFile(this.session, string2);
                if (n == 0) {
                    commandResultImpl.setResult(Boolean.TRUE);
                } else {
                    commandResultImpl.setResult(Boolean.FALSE);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.className + ".execute", FFDC_ID_1);
            Tr.error(tc, "CWPST0007E", new Object[]{exception.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + exception);
            }
            commandResultImpl.setException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }
}

