/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.PolicyTypeClassLoader;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.ValidationManager;
import java.util.Properties;
import java.util.ResourceBundle;

public class SetPolicyTypeAttribute
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(SetPolicyTypeAttribute.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String className = this.getClass().getName();
    private Session session = null;

    public SetPolicyTypeAttribute(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + commandMetadata);
        }
    }

    public SetPolicyTypeAttribute(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = null;
        String string = null;
        try {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String string2 = (String)this.getParameter("policySet");
            String string3 = (String)this.getParameter("policyType");
            String string4 = (String)this.getParameter("attributeName");
            String string5 = (String)this.getParameter("attributeValue");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string2, string3, string4, string5});
            }
            commandResultImpl = new CommandResultImpl();
            this.setCommandResult(commandResultImpl);
            commandResultImpl.reset();
            this.session = this.getConfigSession();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SetPolicyTypeAttribute, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            string = PolicySetWorkSpaceHelper.getPolicySetFile(this.session, string2);
            if (string != null && string.length() > 0) {
                Object object;
                PolicySetHelper policySetHelper = PolicySetHelperFactory.createHelper(string);
                policySetHelper.setLocale(this.getLocale());
                if (policySetHelper.isDefaultPolicySet()) {
                    throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0004E", new Object[]{string2}, "A default policy set cannot be edited or deleted: {0}"));
                }
                int n = policySetHelper.setPolicyTypeAttribute(string3, string4, string5);
                boolean bl = true;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!(string4.equals("provides") || string4.equals("enabled") || string4.equals("type") || string4.equals("description"))) {
                    object = PolicySetWorkSpaceHelper.getPolicyTypeFile(this.session, string2, string3);
                    PolicyTypeProvider policyTypeProvider = PolicyTypeClassLoader.getPolicyTypeProvider(string3);
                    if (policyTypeProvider == null) {
                        throw new ClassNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0042E", new Object[]{string3}, "PolicyTypeProvider class not found for Policy type: {0}"));
                    }
                    Properties properties = new Properties();
                    properties.setProperty(string4, string5);
                    bl = policyTypeProvider.setAttributes((String)object, properties, false);
                    bl2 = true;
                } else {
                    bl3 = true;
                }
                if (!bl) {
                    throw new Exception(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0044E", new Object[]{string3}, "Error in setting attributes for Policy type: {0}"));
                }
                if (bl3) {
                    PolicySetWorkSpaceHelper.updatePolicySetFile(this.session, string2);
                }
                if (bl2) {
                    PolicySetWorkSpaceHelper.updatePolicyTypeFile(this.session, string2, string3);
                }
                if ((object = ValidationManager.getManager(this.session)) != null) {
                    ((ValidationManager)object).markForValidation(string2);
                }
                if (n == 0 && bl) {
                    commandResultImpl.setResult(Boolean.TRUE);
                } else {
                    commandResultImpl.setResult(Boolean.FALSE);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.className + ".execute", FFDC_ID_1);
            Tr.error(tc, "CWPST0007E", new Object[]{exception.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + exception);
            }
            commandResultImpl.setException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }
}

