/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import java.io.FileNotFoundException;
import java.util.ResourceBundle;

public class RemoveFromPolicySetAttachment
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(RemoveFromPolicySetAttachment.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = null;
    public static final String POLICY_ATTACHMENT_NOT_FOUND_MSG = "Policy attachment file is not found: ";
    public static final String CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "Client policy attachment file is not found: ";
    public static final String TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG = "System/trust policy attachment file is not found";
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String className = this.getClass().getName();
    private Session session = null;

    public RemoveFromPolicySetAttachment(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + commandMetadata);
        }
    }

    public RemoveFromPolicySetAttachment(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = null;
        try {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String string = (String)this.getParameter("applicationName");
            String string2 = (String)this.getParameter("attachmentId");
            String[] stringArray = (String[])this.getParameter("resources");
            String string3 = (String)this.getParameter("attachmentType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string, string2, stringArray, string3});
            }
            commandResultImpl = new CommandResultImpl();
            this.setCommandResult(commandResultImpl);
            commandResultImpl.reset();
            this.session = this.getConfigSession();
            int n = 0;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RemoveFromPolicySetAttachment, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            if (string3 == null) {
                string3 = "application";
            }
            if (string == null && (string3.equals("application") || string3.equals("client"))) {
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0034E", new Object[]{string3}, "Application name required when attachment type is: {0}"));
            }
            String string4 = null;
            String string5 = null;
            String string6 = null;
            if (string3.equals("application")) {
                string4 = PolicySetWorkSpaceHelper.getPolicySetAttachmentFile(this.session, string);
                string5 = POLICY_ATTACHMENT_NOT_FOUND_MSG;
                string6 = "CWPST0031E";
            } else if (string3.equals("system/trust")) {
                string4 = PolicySetWorkSpaceHelper.getTrustAttachmentFile(this.session);
                string5 = TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                string6 = "CWPST0033E";
            } else if (string3.equals("client")) {
                string4 = PolicySetWorkSpaceHelper.getClientAttachmentFile(this.session, string);
                string5 = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                string6 = "CWPST0032E";
            } else {
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0035E", new Object[]{string3}, "Invalid attachment type: {0}"));
            }
            if (string4 != null) {
                PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string4);
                policySetAttachmentHelper.setLocale(this.getLocale());
                n = policySetAttachmentHelper.updatePolicySetAttachment(string2, stringArray, 3);
                if (policySetAttachmentHelper.isResourceListEmpty(string2)) {
                    n = policySetAttachmentHelper.detachPolicyId(string2);
                }
            } else {
                throw new FileNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, string6, new Object[]{string}, string5));
            }
            if (string3.equals("application")) {
                PolicySetWorkSpaceHelper.updatePolicySetAttachmentFile(this.session, string);
            } else if (string3.equals("system/trust")) {
                PolicySetWorkSpaceHelper.updateTrustAttachmentFile(this.session);
            } else if (string3.equals("client")) {
                PolicySetWorkSpaceHelper.updateClientAttachmentFile(this.session, string);
            }
            if (n == 0) {
                commandResultImpl.setResult(Boolean.TRUE);
            } else {
                commandResultImpl.setResult(Boolean.FALSE);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.className + ".execute", FFDC_ID_1);
            Tr.error(tc, "CWPST0007E", new Object[]{exception.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + exception);
            }
            commandResultImpl.setException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }
}

