/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class PolicySetWorkSpaceHelper
implements PolicyConstants {
    private static TraceComponent tc = Tr.register(PolicySetWorkSpaceHelper.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static Locale _locale = null;
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
    public static final String BINDING_NOT_FOUND_MSG = "Binding file is not found: ";
    public static final String BINDING_XML_NOT_FOUND_MSG = "cannot find bindings.xml";
    public static final String APP_REPOSITORY_TYPE = "deployments";
    public static final String CELL_REPOSITORY_TYPE = "cells";
    public static final String NODE_REPOSITORY_TYPE = "nodes";
    public static final String SERVER_REPOSITORY_TYPE = "servers";

    public static List listPolicySets(Session session) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicySets");
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        List list = repositoryContext.getAllList(false);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        boolean bl = tc.isDebugEnabled();
        for (int i = 0; i < list.size(); ++i) {
            string = ((WorkSpaceFile)list.get(i)).getFileName();
            if (string.endsWith("policySet.xml") && string.startsWith("PolicySets")) {
                if (!repositoryContext.isExtracted(string)) {
                    repositoryContext.extract(string, false);
                }
                String string2 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string);
                arrayList.add(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "listPolicySets, file path is " + string2);
                }
            }
            if (!bl) continue;
            Tr.debug(tc, "listPolicySets, fileName=" + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicySets, retList=" + arrayList);
        }
        return arrayList;
    }

    public static String getPolicySetFile(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetFile, policySet=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        String string2 = PolicySetWorkSpaceHelper.getPolicySetFileName(string);
        if (!repositoryContext.isAvailable(string2 = string2.replace(File.separatorChar, '/'))) {
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0055E", new Object[]{string}, "Policy set is not found: {0}"));
        }
        if (!repositoryContext.isExtracted(string2)) {
            repositoryContext.extract(string2, false);
        }
        String string3 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string2);
        string3 = string3.replace('/', File.separatorChar);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySetFile, fullPath=" + string3);
        }
        return string3;
    }

    public static List getPolicySetDirectoryFiles(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetDirectoryFiles, policySet=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        boolean bl = tc.isDebugEnabled();
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        if (!repositoryContext.isAvailable(string2 = PolicySetWorkSpaceHelper.getPolicySetFileName(string))) {
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0055E", new Object[]{string}, "Policy set is not found: {0}"));
        }
        List list = repositoryContext.getAllList(false);
        for (int i = 0; i < list.size(); ++i) {
            string3 = ((WorkSpaceFile)list.get(i)).getFileName();
            if (string3.equals("PolicySets" + File.separatorChar + string) || string3.startsWith("PolicySets" + File.separatorChar + string + File.separatorChar)) {
                if (!repositoryContext.isExtracted(string3)) {
                    repositoryContext.extract(string3, false);
                }
                arrayList.add(string3);
            }
            if (!bl) continue;
            Tr.debug(tc, "getPolicySetDirectoryFiles, fileName=" + string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySetDirectoryFiles, retList.size()=" + arrayList.size());
        }
        return arrayList;
    }

    public static String getCellRepositoryPath(Session session) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellRepositoryPath");
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        String string = repositoryContext.getPath();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellRepositoryPath, filePath=" + string);
        }
        return string;
    }

    public static boolean updatePolicySetFile(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "udpatePolicySetFile, policySet=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        if (!repositoryContext.isAvailable(string2 = PolicySetWorkSpaceHelper.getPolicySetFileName(string))) {
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0055E", new Object[]{string}, "Policy set is not found: {0}"));
        }
        repositoryContext.notifyChanged(1, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "udpatePolicySetFile, policySet=" + string);
        }
        return true;
    }

    public static String createPolicySet(Session session, String string) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPolicySet, policySet=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        String string2 = PolicySetWorkSpaceHelper.getPolicySetFileName(string);
        string2 = string2.replace(File.separatorChar, '/');
        List list = repositoryContext.getAllList(false);
        boolean bl = false;
        String string3 = null;
        String string4 = PolicySetWorkSpaceHelper.getPolicySetFilePrefix(string, true);
        for (int i = 0; i < list.size() && !bl; ++i) {
            string3 = ((WorkSpaceFile)list.get(i)).getFileName();
            if (!string3.toLowerCase().startsWith(string4)) continue;
            bl = true;
        }
        if (bl) {
            throw new DuplicateItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0058E", new Object[]{string}, "Duplicate policy set is found: {0}"));
        }
        repositoryContext.getOutputStream(string2);
        repositoryContext.notifyChanged(0, string2);
        String string5 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string2);
        string5 = string5.replace('/', File.separatorChar);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPolicySetFile, fullPath=" + string5);
        }
        return string5;
    }

    public static boolean deletePolicySet(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deletePolicySet, policySet=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        List list = repositoryContext.getAllList(false);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        String string2 = null;
        String string3 = PolicySetWorkSpaceHelper.getPolicySetFilePrefix(string, false);
        for (int i = 0; i < list.size(); ++i) {
            string2 = ((WorkSpaceFile)list.get(i)).getFileName();
            if (!string2.startsWith(string3)) continue;
            bl = true;
            arrayList.add(string2);
        }
        if (!bl) {
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0055E", new Object[]{string}, "Policy set is not found: {0}"));
        }
        repositoryContext.notifyChanged(2, arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deletePolicySet, policySet=" + string);
        }
        return true;
    }

    public static List listPolicyTypes(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicyTypes, policySet=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        if (string == null) {
            return PolicySetWorkSpaceHelper.listDefaultPolicyTypes(session);
        }
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        List list = repositoryContext.getAllList(false);
        String string2 = PolicySetWorkSpaceHelper.getPolicySetFilePrefix(string, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        for (int i = 0; i < list.size(); ++i) {
            string3 = ((WorkSpaceFile)list.get(i)).getFileName();
            if (!string3.endsWith("policy.xml") || !string3.startsWith(string2)) continue;
            arrayList.add(PolicySetWorkSpaceHelper.getLastDirName(string3));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicyTypes, retList=" + arrayList);
        }
        return arrayList;
    }

    private static List retrievePolicyTypes(RepositoryContext repositoryContext, String string, String string2) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrievePolicyTypes, startPath=" + string + ", endPath=" + string2);
        }
        List list = repositoryContext.getAllList(false);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        for (int i = 0; i < list.size(); ++i) {
            string3 = ((WorkSpaceFile)list.get(i)).getFileName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retievePolicyTypes, fileName=" + string3);
            }
            if (!string3.endsWith(string2) || !string3.startsWith(string)) continue;
            arrayList.add(PolicySetWorkSpaceHelper.getLastDirName(string3));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrievePolicyTypes, retList=" + arrayList);
        }
        return arrayList;
    }

    public static List listPolicyTypesForCellBindingFile(Session session) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicyTypesForCellBindingFile");
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        String string = "PolicyTypes" + File.separator;
        String string2 = File.separator + "bindings.xml";
        ArrayList arrayList = new ArrayList();
        arrayList = (ArrayList)PolicySetWorkSpaceHelper.retrievePolicyTypes(repositoryContext, string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicyTypesForCellBindingFile, retList=" + arrayList);
        }
        return arrayList;
    }

    public static List listPolicyTypesForServerBindingFile(Session session, String string, String string2) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicyTypesForServerBindingFile, node=" + string + ", server=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getServerRepositoryContext(session, string, string2);
        String string3 = "PolicyTypes" + File.separator;
        String string4 = File.separator + "bindings.xml";
        ArrayList arrayList = new ArrayList();
        arrayList = (ArrayList)PolicySetWorkSpaceHelper.retrievePolicyTypes(repositoryContext, string3, string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicyTypesForServerBindingFile, retList=" + arrayList);
        }
        return arrayList;
    }

    public static List listPolicyTypesForTrustBindingFile(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicyTypesForTrustBindingFile, bindingName=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        String string2 = "sts" + File.separator + "policy" + File.separator + string + File.separator + "PolicyTypes" + File.separator;
        String string3 = File.separator + "bindings.xml";
        ArrayList arrayList = new ArrayList();
        arrayList = (ArrayList)PolicySetWorkSpaceHelper.retrievePolicyTypes(repositoryContext, string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicyTypesForTrustBindingFile, retList=" + arrayList);
        }
        return arrayList;
    }

    public static List listPolicyTypesForApplicationBindingFile(Session session, String string, String string2) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicyTypesForApplicationBindingFile, appName=" + string + ", bindingName=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getAppRepositoryContext(session, string);
        String string3 = "META-INF" + File.separator + string2 + File.separator + "PolicyTypes" + File.separator;
        String string4 = File.separator + "bindings.xml";
        ArrayList arrayList = new ArrayList();
        arrayList = (ArrayList)PolicySetWorkSpaceHelper.retrievePolicyTypes(repositoryContext, string3, string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicyTypesForApplicationBindingFile, retList=" + arrayList);
        }
        return arrayList;
    }

    public static List listDefaultPolicyTypes(Session session) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listDefaultPolicyTypes");
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        List list = repositoryContext.getAllList(false);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        for (int i = 0; i < list.size(); ++i) {
            string = ((WorkSpaceFile)list.get(i)).getFileName();
            if (!string.endsWith("policy.xml") || !string.startsWith("PolicyTypes")) continue;
            arrayList.add(PolicySetWorkSpaceHelper.getLastDirName(string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listDefaultPolicyTypes, retList=" + arrayList);
        }
        return arrayList;
    }

    public static String getPolicyTypeFile(Session session, String string, String string2) throws WorkSpaceException, NoItemFoundException {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicyTypeFile, policySet=" + string + ", policyType=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        if (string == null) {
            return PolicySetWorkSpaceHelper.getDefaultPolicyTypeFile(session, string2);
        }
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        if (!repositoryContext.isExtracted(string3 = PolicySetWorkSpaceHelper.getPolicyTypeFileURI(repositoryContext, string, string2))) {
            repositoryContext.extract(string3, false);
        }
        String string4 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicyTypeFile, fullPath=" + string4);
        }
        return string4;
    }

    public static boolean updatePolicyTypeFile(Session session, String string, String string2) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updatePolicyTypeFile, policySet=" + string + ", policyType=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        String string3 = PolicySetWorkSpaceHelper.getPolicyTypeFileURI(repositoryContext, string, string2);
        repositoryContext.notifyChanged(1, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updatePolicyTypeFile");
        }
        return true;
    }

    public static String getDefaultPolicyTypeFile(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultPolicyTypeFile, policyType=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        if (repositoryContext.isAvailable(string2 = PolicySetWorkSpaceHelper.getDefaultPolicyTypeFileName(string))) {
            if (!repositoryContext.isExtracted(string2)) {
                repositoryContext.extract(string2, false);
            }
            String string3 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDefaultPolicyTypeFile, policyType=" + string + ", fullPath=" + string3);
            }
            return string3;
        }
        throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0057E", new Object[]{string}, "Default policy type is not found: {0}"));
    }

    public static boolean addPolicyType(Session session, String string, String string2) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addPolicyType, policySet=" + string + ", policyType=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        String string3 = PolicySetWorkSpaceHelper.getDefaultPolicyTypeFile(session, string2);
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        String string4 = PolicySetWorkSpaceHelper.getPolicyTypeFileName(string, string2);
        String string5 = PolicySetWorkSpaceHelper.getPolicySetFileName(string);
        if (!repositoryContext.isAvailable(string5)) {
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0055E", new Object[]{string}, "Policy set is not found: {0}"));
        }
        if (repositoryContext.isAvailable(string4)) {
            throw new DuplicateItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0059E", new Object[]{string2}, "Duplicate policy type is found: {0}"));
        }
        repositoryContext.getOutputStream(string4);
        String string6 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string4);
        PolicySetWorkSpaceHelper.copyFile(string3, string6);
        repositoryContext.notifyChanged(0, string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addPolicyType, policySet=" + string + ", policyType=" + string2);
        }
        return true;
    }

    public static List listBindingsForApplication(Session session, String string, String string2) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listBindingsForApplication, appName=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getAppRepositoryContext(session, string);
        String string3 = "META-INF" + File.separator;
        String string4 = File.separator + "bindings.xml";
        ArrayList arrayList = new ArrayList();
        arrayList = (ArrayList)PolicySetWorkSpaceHelper.retrieveBindingNames(repositoryContext, string3, string4, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listBindingsForApplication, retList=" + arrayList);
        }
        return arrayList;
    }

    public static List listBindingsForTrust(Session session) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listBindingsForTrust");
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        String string = "sts" + File.separator + "policy" + File.separator;
        String string2 = File.separator + "bindings.xml";
        ArrayList arrayList = new ArrayList();
        arrayList = (ArrayList)PolicySetWorkSpaceHelper.retrieveBindingNames(repositoryContext, string, string2, "system/trust");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listBindingsForTrust, retList=" + arrayList);
        }
        return arrayList;
    }

    private static List retrieveBindingNames(RepositoryContext repositoryContext, String string, String string2, String string3) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveBindingNames, startPath=" + string + ", endPath=" + string2);
        }
        List list = repositoryContext.getAllList(false);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = null;
        for (int i = 0; i < list.size(); ++i) {
            String string5;
            string4 = ((WorkSpaceFile)list.get(i)).getFileName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retrieveBindingNames, fileName=" + string4);
            }
            if (!string4.endsWith(string2) || !string4.startsWith(string) || arrayList.contains(string5 = PolicySetWorkSpaceHelper.getBindingDirName(string4))) continue;
            if (string3.equals("system/trust")) {
                arrayList.add(string5);
                continue;
            }
            String string6 = PolicySetWorkSpaceHelper.getProviderBindingIndicatorFileName(string5);
            if ((repositoryContext.isAvailable(string6) || !string3.equals("client")) && (!repositoryContext.isAvailable(string6) || !string3.equals("application"))) continue;
            arrayList.add(string5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveBindingNames, retList=" + arrayList);
        }
        return arrayList;
    }

    public static boolean copyPolicySetFiles(Session session, List list, String string, String string2, String string3) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyPolicySetFiles, filePath=" + string + ", sourcePolicySet=" + string2 + ", destPolicySet=" + string3 + ", fileList=" + list);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        Iterator iterator = list.iterator();
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        boolean bl = false;
        while (iterator.hasNext()) {
            string4 = (String)iterator.next();
            string5 = string4.replaceFirst(string2, string3);
            string6 = string + File.separatorChar + string4;
            string7 = string + File.separatorChar + string5;
            repositoryContext.getOutputStream(string5);
            PolicySetWorkSpaceHelper.copyFile(string6, string7);
            repositoryContext.notifyChanged(0, string5);
        }
        bl = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyPolicySetFiles, sourcePolicySet=" + string2 + ", destPolicySet=" + string3 + ", copyStatus=" + bl);
        }
        return bl;
    }

    public static String getImportFileName(Session session, String string, String string2) throws NoItemFoundException, WorkSpaceException {
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        string = string.replace(File.separatorChar, '/');
        repositoryContext.getOutputStream(string);
        repositoryContext.notifyChanged(0, string);
        String string3 = string2 + File.separatorChar + string;
        return string3;
    }

    public static boolean deletePolicyType(Session session, String string, String string2) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deletePolicyType, policySet=" + string + ", policyType=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        String string3 = PolicySetWorkSpaceHelper.getPolicyTypeFileURI(repositoryContext, string, string2);
        repositoryContext.notifyChanged(2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deletePolicyType, policySet=" + string + ", policyType=" + string2);
        }
        return true;
    }

    public static String getApplicationBindingFile(Session session, String string, String string2, String string3) throws WorkSpaceException, NoItemFoundException {
        String string4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationBindingFile, appName=" + string + ", bindingName=" + string2 + ", policyType=" + string3);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getAppRepositoryContext(session, string);
        if (repositoryContext.isAvailable(string4 = PolicySetWorkSpaceHelper.getApplicationBindingFileName(string2, string3))) {
            if (!repositoryContext.isExtracted(string4)) {
                repositoryContext.extract(string4, false);
            }
            String string5 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string4);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getApplicationBindingFile, fullPath=" + string5);
            }
            return string5;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationBindingFile, cannot find bindings.xml");
        }
        return null;
    }

    public static String createApplicationBindingFile(Session session, String string, String string2, String string3, String string4) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException, IOException {
        String string5;
        String string6;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createApplicationBindingFile, appName=" + string + ", bindingName=" + string2 + ", policyType=" + string3);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getAppRepositoryContext(session, string);
        if (repositoryContext.isAvailable(string6 = PolicySetWorkSpaceHelper.getApplicationBindingFileName(string2, string3))) {
            throw new DuplicateItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0085E", new Object[]{string}, "Duplicate bindings.xml already exists: {0}"));
        }
        repositoryContext.getOutputStream(string6);
        repositoryContext.notifyChanged(0, string6);
        String string7 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string6);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createApplicationBindingFile, fullPath=" + string7);
        }
        if (string4.equals("application") && !repositoryContext.isAvailable(string5 = PolicySetWorkSpaceHelper.getProviderBindingIndicatorFileName(string2))) {
            repositoryContext.getOutputStream(string5);
            String string8 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string5);
            PolicySetWorkSpaceHelper.writeFile(string8);
            repositoryContext.notifyChanged(0, string5);
        }
        return string7;
    }

    public static boolean updateApplicationBindingFile(Session session, String string, String string2, String string3) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateApplicationBindingFile, appName=" + string + ", bindingName=" + string2 + ", policyType=" + string3);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getAppRepositoryContext(session, string);
        String string4 = PolicySetWorkSpaceHelper.getApplicationBindingFileName(string2, string3);
        repositoryContext.notifyChanged(1, string4);
        return true;
    }

    public static boolean deleteApplicationBindingFile(Session session, String string, String string2, String string3) throws WorkSpaceException, NoItemFoundException {
        String string4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteApplicationBindingFile, appName=" + string + ", bindingName=" + string2 + ", policyType=" + string3);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getAppRepositoryContext(session, string);
        if (repositoryContext.isAvailable(string4 = PolicySetWorkSpaceHelper.getApplicationBindingFileName(string2, string3))) {
            repositoryContext.notifyChanged(2, string4);
            return true;
        }
        throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0063E", new Object[]{string2}, "Binding file is not found: {0}"));
    }

    public static boolean deleteApplicationBinding(Session session, String string, String string2) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteApplicationBinding, appName=" + string + ", bindingName=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getAppRepositoryContext(session, string);
        List list = repositoryContext.getAllList(false);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        String string3 = null;
        String string4 = PolicySetWorkSpaceHelper.getBindingDirPrefix(string2);
        for (int i = 0; i < list.size(); ++i) {
            string3 = ((WorkSpaceFile)list.get(i)).getFileName();
            if (!string3.startsWith(string4)) continue;
            bl = true;
            arrayList.add(string3);
        }
        if (!bl) {
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0063E", new Object[]{string2}, "Binding file is not found: {0}"));
        }
        repositoryContext.notifyChanged(2, arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteApplicationBinding, appName=" + string + ", bindingName=" + string2);
        }
        return true;
    }

    public static String getApplicationBindingDir(Session session, String string, String string2) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationBindingDir, appName=" + string + ", bindingName=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getAppRepositoryContext(session, string);
        List list = repositoryContext.getAllList(false);
        boolean bl = false;
        String string3 = null;
        String string4 = PolicySetWorkSpaceHelper.getBindingDirPrefix(string2);
        for (int i = 0; i < list.size() && !bl; ++i) {
            string3 = ((WorkSpaceFile)list.get(i)).getFileName();
            if (!string3.startsWith(string4)) continue;
            bl = true;
        }
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getApplicationBindingDir, bindingName=" + string2 + ", bindingFileNamePrefix=" + string4);
            }
            return string4;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationBindingDir, Binding file is not found: " + string2);
        }
        return null;
    }

    public static String getCellDefaultBindingFile(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellDefaultBindingFile, policyType=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        if (repositoryContext.isAvailable(string2 = PolicySetWorkSpaceHelper.getCellDefaultBindingFileName(string))) {
            if (!repositoryContext.isExtracted(string2)) {
                repositoryContext.extract(string2, false);
            }
            String string3 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCellDefaultBindingFile, policyType=" + string + ", fullPath=" + string3);
            }
            return string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellDefaultBindingFile, cannot find bindings.xml");
        }
        return null;
    }

    public static boolean updateCellDefaultBindingFile(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCellDefaultBindingFile, policyType=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        String string2 = PolicySetWorkSpaceHelper.getCellDefaultBindingFileName(string);
        repositoryContext.notifyChanged(1, string2);
        return true;
    }

    public static String getServerDefaultBindingFile(Session session, String string, String string2, String string3) throws WorkSpaceException, NoItemFoundException {
        String string4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerDefaultBindingFile, policyType=" + string + ", node=" + string2 + ", server=" + string3);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getServerRepositoryContext(session, string2, string3);
        if (repositoryContext.isAvailable(string4 = PolicySetWorkSpaceHelper.getServerDefaultBindingFileName(string))) {
            if (!repositoryContext.isExtracted(string4)) {
                repositoryContext.extract(string4, false);
            }
            String string5 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string4);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerDefaultBindingFile, policyType=" + string + ", fullPath=" + string5);
            }
            return string5;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerDefaultBindingFile, cannot find bindings.xml");
        }
        return null;
    }

    public static String createServerDefaultBindingFile(Session session, String string, String string2, String string3) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        String string4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerDefaultBindingFile, policyType=" + string + ", node=" + string2 + ", server=" + string3);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getServerRepositoryContext(session, string2, string3);
        if (repositoryContext.isAvailable(string4 = PolicySetWorkSpaceHelper.getServerDefaultBindingFileName(string))) {
            throw new DuplicateItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0085E", new Object[]{string3}, "Duplicate bindings.xml already exists: {0}"));
        }
        repositoryContext.getOutputStream(string4);
        repositoryContext.notifyChanged(0, string4);
        String string5 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerDefaultBindingFile, fullPath=" + string5);
        }
        return string5;
    }

    public static boolean updateServerDefaultBindingFile(Session session, String string, String string2, String string3) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServerDefaultBindingFile, policyType=" + string + ", node=" + string2 + ", server=" + string3);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getServerRepositoryContext(session, string2, string3);
        String string4 = PolicySetWorkSpaceHelper.getServerDefaultBindingFileName(string);
        repositoryContext.notifyChanged(1, string4);
        return true;
    }

    public static boolean deleteServerDefaultBindingFile(Session session, String string, String string2, String string3) throws WorkSpaceException, NoItemFoundException {
        String string4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteServerDefaultBindingFile, policyType=" + string + ", node=" + string2 + ", server=" + string3);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getServerRepositoryContext(session, string2, string3);
        if (repositoryContext.isAvailable(string4 = PolicySetWorkSpaceHelper.getServerDefaultBindingFileName(string))) {
            repositoryContext.notifyChanged(2, string4);
            return true;
        }
        throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0065E", new Object[]{string}, "Default server-level binding file is not found: {0}"));
    }

    public static String getTrustBindingFile(Session session, String string, String string2) throws WorkSpaceException, NoItemFoundException {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustBindingFile, bindingName=" + string + ", policyType=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        if (repositoryContext.isAvailable(string3 = PolicySetWorkSpaceHelper.getTrustBindingFileName(string, string2))) {
            if (!repositoryContext.isExtracted(string3)) {
                repositoryContext.extract(string3, false);
            }
            String string4 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string3);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTrustBindingFile, policyType=" + string2 + ", fullPath=" + string4);
            }
            return string4;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellDefaultBindingFile, cannot find bindings.xml");
        }
        return null;
    }

    public static String createTrustBindingFile(Session session, String string, String string2) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTrustBindingFile, bindingName=" + string + ", policyType=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        if (repositoryContext.isAvailable(string3 = PolicySetWorkSpaceHelper.getTrustBindingFileName(string, string2))) {
            throw new DuplicateItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0085E", new Object[]{string}, "Duplicate bindings.xml already exists: {0}"));
        }
        repositoryContext.getOutputStream(string3);
        repositoryContext.notifyChanged(0, string3);
        String string4 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTrustBindingFile, fullPath=" + string4);
        }
        return string4;
    }

    public static boolean updateTrustBindingFile(Session session, String string, String string2) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCellDefaultBindingFile, bindingName=" + string + ", policyType=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        String string3 = PolicySetWorkSpaceHelper.getTrustBindingFileName(string, string2);
        repositoryContext.notifyChanged(1, string3);
        return true;
    }

    public static boolean deleteTrustBindingFile(Session session, String string, String string2) throws WorkSpaceException, NoItemFoundException {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteTrustBindingFile, bindingName=" + string + ", policyType=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        if (!repositoryContext.isAvailable(string3 = PolicySetWorkSpaceHelper.getTrustBindingFileName(string, string2))) {
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0086E", new Object[]{string, string2}, "Binding file {0} is not found for policy type {1}"));
        }
        repositoryContext.notifyChanged(2, string3);
        return true;
    }

    public static boolean deleteTrustBinding(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteTrustBinding, bindingName=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        List list = repositoryContext.getAllList(false);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        String string2 = null;
        String string3 = PolicySetWorkSpaceHelper.getTrustBindingDirPrefix(string);
        for (int i = 0; i < list.size(); ++i) {
            string2 = ((WorkSpaceFile)list.get(i)).getFileName();
            if (!string2.startsWith(string3)) continue;
            bl = true;
            arrayList.add(string2);
        }
        if (!bl) {
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0063E", new Object[]{string}, "Binding file is not found: {0}"));
        }
        repositoryContext.notifyChanged(2, arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteTrustBinding, bindingName=" + string);
        }
        return true;
    }

    public static String getTrustBindingDir(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustBindingDir, bindingName=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        List list = repositoryContext.getAllList(false);
        boolean bl = false;
        String string2 = null;
        String string3 = PolicySetWorkSpaceHelper.getTrustBindingDirPrefix(string);
        for (int i = 0; i < list.size() && !bl; ++i) {
            string2 = ((WorkSpaceFile)list.get(i)).getFileName();
            if (!string2.startsWith(string3)) continue;
            bl = true;
        }
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTrustBindingDir, bindingName=" + string + ", bindingFileNamePrefix=" + string3);
            }
            return string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustBindingDir, Binding file is not found: " + string);
        }
        return null;
    }

    public static String getPolicySetAttachmentFile(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetAttachmentFile, appName=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getAppRepositoryContext(session, string);
        if (repositoryContext.isAvailable(string2 = "META-INF" + File.separator + "policyAttachments.xml")) {
            if (!repositoryContext.isExtracted(string2)) {
                repositoryContext.extract(string2, false);
            }
            String string3 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPolicySetAttachmentFile, fullPath=" + string3);
            }
            return string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySetAttachmentFile, cannot find " + string2);
        }
        return null;
    }

    public static String createPolicySetAttachmentFile(Session session, String string) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPolicySetAttachmentFile, appName=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getAppRepositoryContext(session, string);
        if (repositoryContext.isAvailable(string2 = "META-INF" + File.separator + "policyAttachments.xml")) {
            throw new DuplicateItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0060E", new Object[]{string}, "Duplicate policyAttachments.xml is found: {0}"));
        }
        repositoryContext.getOutputStream(string2);
        repositoryContext.notifyChanged(0, string2);
        String string3 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPolicySetAttachmentFile, fullPath=" + string3);
        }
        return string3;
    }

    public static boolean updatePolicySetAttachmentFile(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updatePolicySetAttachmentFile, appName=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getAppRepositoryContext(session, string);
        String string2 = "META-INF" + File.separator + "policyAttachments.xml";
        if (repositoryContext.isAvailable(string2 = string2.replace(File.separatorChar, '/'))) {
            repositoryContext.notifyChanged(1, string2);
            return true;
        }
        throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0031E", new Object[]{string}, "Policy attachment file is not found: {0}"));
    }

    public static boolean deletePolicySetAttachmentFile(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deletePolicySetAttachmentFile, appName=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getAppRepositoryContext(session, string);
        String string2 = "META-INF" + File.separator + "policyAttachments.xml";
        if (repositoryContext.isAvailable(string2 = string2.replace(File.separatorChar, '/'))) {
            repositoryContext.notifyChanged(2, string2);
            return true;
        }
        throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0031E", new Object[]{string}, "Policy attachment file is not found: {0}"));
    }

    public static String getTrustAttachmentFile(Session session) throws WorkSpaceException, NoItemFoundException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustAttachmentFile");
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        if (repositoryContext.isAvailable(string = PolicySetWorkSpaceHelper.getTrustFilePath())) {
            if (!repositoryContext.isExtracted(string)) {
                repositoryContext.extract(string, false);
            }
            String string2 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTrustAttachmentFile, fullPath=" + string2);
            }
            return string2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustAttachmentFile, cannot find " + string);
        }
        return null;
    }

    public static String createTrustAttachmentFile(Session session) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTrustAttachmentFile");
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        if (repositoryContext.isAvailable(string = PolicySetWorkSpaceHelper.getTrustFilePath())) {
            throw new DuplicateItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0087E", new Object[0], "Duplicate system/trust policyAttachments.xml is found"));
        }
        repositoryContext.getOutputStream(string);
        repositoryContext.notifyChanged(0, string);
        String string2 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTrustAttachmentFile, fullPath=" + string2);
        }
        return string2;
    }

    public static boolean updateTrustAttachmentFile(Session session) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateTrustAttachmentFile");
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        String string = PolicySetWorkSpaceHelper.getTrustFilePath();
        if (repositoryContext.isAvailable(string = string.replace(File.separatorChar, '/'))) {
            repositoryContext.notifyChanged(1, string);
            return true;
        }
        throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0033E", new Object[0], "System/trust policy attachment file is not found"));
    }

    public static boolean deleteTrustAttachmentFile(Session session) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteTrustAttachmentFile");
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        String string = PolicySetWorkSpaceHelper.getTrustFilePath();
        if (repositoryContext.isAvailable(string = string.replace(File.separatorChar, '/'))) {
            repositoryContext.notifyChanged(2, string);
            return true;
        }
        throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0033E", new Object[0], "System/trust policy attachment file is not found"));
    }

    public static String getClientAttachmentFile(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientAttachmentFile, appName=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getAppRepositoryContext(session, string);
        if (repositoryContext.isAvailable(string2 = "META-INF" + File.separator + "clientPolicyAttachments.xml")) {
            if (!repositoryContext.isExtracted(string2)) {
                repositoryContext.extract(string2, false);
            }
            String string3 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClientAttachmentFile, fullPath=" + string3);
            }
            return string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientAttachmentFile, cannot find " + string2);
        }
        return null;
    }

    public static String createClientAttachmentFile(Session session, String string) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClientAttachmentFile, appName=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getAppRepositoryContext(session, string);
        if (repositoryContext.isAvailable(string2 = "META-INF" + File.separator + "clientPolicyAttachments.xml")) {
            throw new DuplicateItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0061E", new Object[]{string}, "Duplicate clientPolicyAttachments.xml is found: {0}"));
        }
        repositoryContext.getOutputStream(string2);
        repositoryContext.notifyChanged(0, string2);
        String string3 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createClientAttachmentFile, fullPath=" + string3);
        }
        return string3;
    }

    public static boolean updateClientAttachmentFile(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateClientAttachmentFile, appName=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getAppRepositoryContext(session, string);
        String string2 = "META-INF" + File.separator + "clientPolicyAttachments.xml";
        if (repositoryContext.isAvailable(string2 = string2.replace(File.separatorChar, '/'))) {
            repositoryContext.notifyChanged(1, string2);
            return true;
        }
        throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0032E", new Object[]{string}, "Client policy attachment file is not found: {0}"));
    }

    public static boolean deleteClientAttachmentFile(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteClientAttachmentFile, appName=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getAppRepositoryContext(session, string);
        String string2 = "META-INF" + File.separator + "clientPolicyAttachments.xml";
        if (repositoryContext.isAvailable(string2 = string2.replace(File.separatorChar, '/'))) {
            repositoryContext.notifyChanged(2, string2);
            return true;
        }
        throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0032E", new Object[]{string}, "Client policy attachment file is not found: {0}"));
    }

    public static RepositoryContext getAppRepositoryContext(Session session, String string) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppRepositoryContext session=" + session.getUserName() + ", appName=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        WorkSpace workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
        Collection collection = workSpace.getRootContext().findContext(APP_REPOSITORY_TYPE, string);
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            return (RepositoryContext)iterator.next();
        }
        throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0062E", new Object[]{string}, "Application is not found: {0}"));
    }

    public static RepositoryContext getServerRepositoryContext(Session session, String string, String string2) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerRepositoryContext session=" + session.getUserName() + ", node=" + string + ", server=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        RepositoryContext repositoryContext = PolicySetWorkSpaceHelper.getCellRepositoryContext(session);
        Collection collection = repositoryContext.findContext(NODE_REPOSITORY_TYPE, string);
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            RepositoryContext repositoryContext2;
            Collection collection2;
            Iterator iterator2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getServerRepositoryContext find node context for " + string);
            }
            if ((iterator2 = (collection2 = (repositoryContext2 = (RepositoryContext)iterator.next()).findContext(SERVER_REPOSITORY_TYPE, string2)).iterator()).hasNext()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getServerRepositoryContext find server context for " + string2);
                }
                return (RepositoryContext)iterator2.next();
            }
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0096E", new Object[]{string2}, "Server is not found: {0}"));
        }
        throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0095E", new Object[]{string}, "Node is not found: {0}"));
    }

    public static List listPolicySetAttachmentFiles(Session session, String string) throws WorkSpaceException {
        return PolicySetWorkSpaceHelper.listPolicySetAttachmentFiles(session, string, "*");
    }

    public static List listPolicySetAttachmentFiles(Session session, String string, String string2) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicySetAttachmentFiles, attachmentType=" + string + ", appSearchPattern=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        WorkSpace workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
        RepositoryMetaData repositoryMetaData = workSpace.getMetaData();
        RepositoryContextType repositoryContextType = repositoryMetaData.getContextType(APP_REPOSITORY_TYPE);
        Collection collection = workSpace.findContext(repositoryContextType);
        Iterator iterator = collection.iterator();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "listPolicySetAttachmentFiles: find app repcontexts: " + collection.size());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        while (iterator.hasNext()) {
            string3 = string.equals("application") ? PolicySetWorkSpaceHelper.getPolicySetAttachmentFileInApp((RepositoryContext)iterator.next(), "application", string2) : PolicySetWorkSpaceHelper.getPolicySetAttachmentFileInApp((RepositoryContext)iterator.next(), "client", string2);
            if (string3 == null) continue;
            arrayList.add(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicySetAttachmentFiles, retList=" + arrayList + ", retList.size()=" + arrayList.size());
        }
        return arrayList;
    }

    private static String getPolicySetAttachmentFileInApp(RepositoryContext repositoryContext, String string, String string2) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetAttachmentFileInApp, attachmentType=" + string + ", appSearchPattern=" + string2);
        }
        String string3 = repositoryContext.getPath();
        int n = string3.lastIndexOf(File.separatorChar);
        String string4 = string3.substring(n + 1);
        boolean bl = PolicySetWorkSpaceHelper.matchAppName(string4, string2);
        boolean bl2 = tc.isDebugEnabled();
        if (bl2) {
            Tr.debug(tc, "getPolicySetAttachmentFileInApp, appSearchPattern=" + string2 + ", appName=" + string4 + ", match=" + bl);
        }
        if (!bl) {
            return null;
        }
        String string5 = null;
        string5 = string.equals("application") ? "META-INF" + File.separator + "policyAttachments.xml" : "META-INF" + File.separator + "clientPolicyAttachments.xml";
        if (repositoryContext.isAvailable(string5 = string5.replace(File.separatorChar, '/'))) {
            if (!repositoryContext.isExtracted(string5)) {
                repositoryContext.extract(string5, false);
            }
            String string6 = PolicySetWorkSpaceHelper.getFullPath(repositoryContext, string5);
            string6 = string6.replace('/', File.separatorChar);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPolicySetAttachmentFileInApp, fullPath=" + string6);
            }
            return string6;
        }
        return null;
    }

    public static boolean copyFile(String string, String string2) throws IOException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFile, srcFile=" + string + ", dstFile=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        FileReader fileReader = new FileReader(string);
        FileWriter fileWriter = new FileWriter(string2);
        while ((n = fileReader.read()) != -1) {
            fileWriter.write(n);
        }
        fileReader.close();
        fileWriter.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
        return true;
    }

    public static void writeFile(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeFile, outfilename=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetWorkSpaceHelper.getLocale());
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        bufferedWriter.write("provider");
        bufferedWriter.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeFile");
        }
    }

    private static boolean matchAppName(String string, String string2) {
        if (string2 == null || string2.equals("*")) {
            return true;
        }
        if (string2.endsWith("*")) {
            String string3 = string2.substring(0, string2.length() - 1);
            return string.startsWith(string3);
        }
        return string.equals(string2);
    }

    private static RepositoryContext getCellRepositoryContext(Session session) throws WorkSpaceException, NoItemFoundException {
        RepositoryMetaData repositoryMetaData;
        RepositoryContextType repositoryContextType;
        WorkSpace workSpace;
        Collection collection;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellRepositoryContext, session user=" + session.getUserName() + ", id=" + session.getSessionId());
        }
        if ((collection = (workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName())).findContext(repositoryContextType = (repositoryMetaData = workSpace.getMetaData()).getContextType(CELL_REPOSITORY_TYPE))).size() == 0) {
            Tr.error(tc, "CWPST0008E");
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0008E", new Object[0], "Cannot find cell repository context"));
        }
        if (collection.size() > 1) {
            Tr.error(tc, "CWPST0009E");
            if (tc.isDebugEnabled()) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Tr.debug(tc, "getCellRepositoryContext, find cell context " + ((RepositoryContext)iterator.next()).getPath());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCellRepositoryContext, find multiple cell repository context");
            }
            return (RepositoryContext)collection.iterator().next();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellRepositoryContext, find cell repository context");
        }
        return (RepositoryContext)collection.iterator().next();
    }

    private static String getPolicyTypeFileURI(RepositoryContext repositoryContext, String string, String string2) throws WorkSpaceException, NoItemFoundException {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicyTypeFileURI, policySet=" + string + ", policyType=" + string2);
        }
        if (repositoryContext.isAvailable(string3 = PolicySetWorkSpaceHelper.getPolicyTypeFileName(string, string2))) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPolicyTypeFileURI, expectedFileName=" + string3);
            }
            return string3;
        }
        String string4 = PolicySetWorkSpaceHelper.getPolicySetFileName(string);
        if (repositoryContext.isAvailable(string4)) {
            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0056E", new Object[]{string2}, "Policy type is not found: {0}"));
        }
        throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0055E", new Object[]{string}, "Policy set is not found: {0}"));
    }

    private static String getPolicySetFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PolicySets").append(File.separator).append(string).append(File.separator).append("policySet.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPolicySetFileName, buf.toString()=" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String getPolicySetFilePrefix(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PolicySets").append(File.separator).append(string).append(File.separator);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPolicySetFilePrefix, prefix=" + stringBuffer.toString() + ", toLowerCase=" + bl);
        }
        if (bl) {
            return stringBuffer.toString().toLowerCase();
        }
        return stringBuffer.toString();
    }

    private static String getPolicyTypeFileName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PolicySets").append(File.separator).append(string).append(File.separator).append("PolicyTypes").append(File.separator).append(string2).append(File.separator).append("policy.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPolicyTypeFileName, buf.toString()=" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String getDefaultPolicyTypeFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PolicyTypes").append(File.separator).append(string).append(File.separator).append("policy.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDefaultPolicyTypeFileName, buf.toString()=" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String getApplicationBindingFileName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("META-INF").append(File.separator).append(string).append(File.separator).append("PolicyTypes").append(File.separator).append(string2).append(File.separator).append("bindings.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getApplicationBindingFileName, buf.toString()=" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String getProviderBindingIndicatorFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("META-INF").append(File.separator).append(string).append(File.separator).append("provider.txt");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getProviderBindingIndicatorFileName, buf.toString()=" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String getTrustBindingFileName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sts").append(File.separator).append("policy").append(File.separator).append(string).append(File.separator).append("PolicyTypes").append(File.separator).append(string2).append(File.separator).append("bindings.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTrustBindingFileName, buf.toString()=" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String getCellDefaultBindingFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PolicyTypes").append(File.separator).append(string).append(File.separator).append("bindings.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCellDefaultBindingFileName, buf.toString()=" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String getServerDefaultBindingFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PolicyTypes").append(File.separator).append(string).append(File.separator).append("bindings.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getServerDefaultBindingFileName, buf.toString()=" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String getServerBindingDirPrefix(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NODE_REPOSITORY_TYPE).append(File.separator).append(string2).append(File.separator).append(SERVER_REPOSITORY_TYPE).append(File.separator).append(string3).append(File.separator).append("PolicyTypes").append(File.separator).append(string).append(File.separator).append("bindings.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getServerBindingDirPrefix, buf.toString()=" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String getBindingDirPrefix(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("META-INF").append(File.separator).append(string).append(File.separator);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBindingDirPrefix, buf.toString()=" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String getTrustBindingDirPrefix(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sts").append(File.separator).append("policy").append(File.separator).append(string).append(File.separator);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTrustBindingDirPrefix, buf.toString()=" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String getTrustFilePath() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sts").append(File.separator).append("policy").append(File.separator).append("policyAttachments.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTrustFilePath, buf.toString()=" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String getFullPath(RepositoryContext repositoryContext, String string) {
        StringBuffer stringBuffer = new StringBuffer(repositoryContext.getPath());
        stringBuffer.append(File.separator).append(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFullPath, buf.toString()=" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String getLastDirName(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        String string2 = string.substring(0, n);
        n = string2.lastIndexOf(File.separatorChar);
        String string3 = string2.substring(n + 1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLastDirName, filePath=" + string + ", str1=" + string2 + ", dirName=" + string3);
        }
        return string3;
    }

    private static String getBindingDirName(String string) {
        int n = string.lastIndexOf("PolicyTypes");
        String string2 = string.substring(0, n - 1);
        n = string2.lastIndexOf(File.separatorChar);
        String string3 = string2.substring(n + 1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLastDirName, filePath=" + string + ", str1=" + string2 + ", dirName=" + string3);
        }
        return string3;
    }

    public static void setLocale(Locale locale) {
        _locale = locale;
    }

    private static Locale getLocale() {
        if (_locale == null) {
            return Locale.getDefault();
        }
        return _locale;
    }
}

