/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.PolicyTypeClassLoader;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.ValidationManager;
import com.ibm.ws.policyset.admin.deploy.PolicyResource;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.policyset.runtime.DefaultResourceEvaluator;
import com.ibm.ws.policyset.runtime.ResourceEvaluator;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.webservices.admin.serviceindex.Endpoint;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelper;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelperFactory;
import com.ibm.ws.webservices.admin.serviceindex.WebService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBException;

public class PolicySetCommandUtil
implements PolicyConstants {
    private static TraceComponent tc = Tr.register(PolicySetCommandUtil.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static Locale _locale = null;
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetCommandUtil.getLocale());
    public static final String POLICY_ATTACHMENT_NOT_FOUND_MSG = "Policy attachment file is not found: ";
    public static final String CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "Client policy attachment file is not found: ";
    public static final String TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG = "System/trust policy attachment file is not found";
    public static final String INVALID_CHAR_ERROR_MSG = "Invalid character in destination policy set name: {0}";
    public static final String BINDING_FILE = "bindingFile";
    public static final String BINDING_REF = "bindingRef";
    public static final String CREATED_FILE = "createdFile";
    public static final String UPDATED_BINDING_REF = "updatedBindingRef";
    public static final String DEPLOYMENTS = "deployments";
    public static final String META_INF = "META-INF";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";

    public static int setPolicyType(Session session, String string, String string2, Properties properties, boolean bl) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPolicyType, policySetName=" + string + ", policyType=" + string2 + ", updatedValues=" + properties + ", replace=" + bl);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetCommandUtil.getLocale());
        int n = 0;
        String string3 = PolicySetWorkSpaceHelper.getPolicySetFile(session, string);
        PolicySetHelper policySetHelper = PolicySetHelperFactory.createHelper(string3);
        policySetHelper.setLocale(PolicySetCommandUtil.getLocale());
        if (policySetHelper.isDefaultPolicySet()) {
            throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0004E", new Object[]{string}, "A default policy set cannot be edited or deleted: {0}"));
        }
        n = policySetHelper.setPolicyType(string2, properties);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!properties.isEmpty()) {
            if (properties.containsKey("provides")) {
                properties.remove("provides");
                bl3 = true;
            }
            if (properties.containsKey("enabled")) {
                properties.remove("enabled");
                bl3 = true;
            }
            if (properties.containsKey("type")) {
                properties.remove("type");
                bl3 = true;
            }
            if (properties.containsKey("description")) {
                properties.remove("description");
            }
            if (!properties.isEmpty()) {
                bl2 = true;
            }
        }
        boolean bl4 = true;
        if (bl2) {
            object = PolicySetWorkSpaceHelper.getPolicyTypeFile(session, string, string2);
            PolicyTypeProvider policyTypeProvider = PolicyTypeClassLoader.getPolicyTypeProvider(string2);
            if (policyTypeProvider == null) {
                throw new ClassNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0042E", new Object[]{string2}, "PolicyTypeProvider class not found for Policy type: {0}"));
            }
            bl4 = policyTypeProvider.setAttributes((String)object, properties, bl);
            if (!bl4) {
                throw new Exception(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0044E", new Object[]{string2}, "Error in setting attributes for Policy type: {0}"));
            }
        }
        if (bl3) {
            PolicySetWorkSpaceHelper.updatePolicySetFile(session, string);
        }
        if (bl2) {
            PolicySetWorkSpaceHelper.updatePolicyTypeFile(session, string, string2);
        }
        if ((object = ValidationManager.getManager(session)) != null) {
            ((ValidationManager)object).markForValidation(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPolicyType, rc=" + n);
        }
        return n;
    }

    public static boolean setBinding(Session session, String string, Properties properties, Properties properties2, String string2, boolean bl, boolean bl2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setBinding, policyTypeName=" + string + ", bindingLocation=" + properties + ", requestedValues=" + properties2 + ", attachmentType=" + string2 + ", replace=" + bl + ", remove=" + bl2 + ", bindingName=" + string3);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetCommandUtil.getLocale());
        Properties properties3 = null;
        boolean bl3 = true;
        int n = PolicySetCommandUtil.getBindingLevel(properties, string2);
        if (bl2) {
            if (n == 1) {
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0049E", new Object[0], "Removal of cell-level binding not allowed"));
            }
            if (n == 2 && string == null) {
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0050E", new Object[0], "Policy type name is required to remove the server level binding"));
            }
            PolicySetCommandUtil.deleteBinding(session, string, properties, string2, n, string3);
        } else {
            properties3 = PolicySetCommandUtil.getBindingFile(session, string, properties, string2, n, string3, properties2);
            String string4 = properties3.getProperty(BINDING_FILE);
            String string5 = properties3.getProperty(BINDING_REF);
            boolean bl4 = Boolean.valueOf(properties3.getProperty(CREATED_FILE));
            boolean bl5 = Boolean.valueOf(properties3.getProperty(UPDATED_BINDING_REF));
            if (string4 != null) {
                Object object;
                if (properties2 != null) {
                    object = PolicyTypeClassLoader.getPolicyTypeProvider(string);
                    if (object != null) {
                        bl3 = object.setBinding(string4, properties2, bl);
                        if (!bl3) {
                            if (bl4) {
                                PolicySetCommandUtil.deleteBindingFile(session, string, properties, string5, string2);
                            }
                            throw new Exception(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0052E", new Object[]{string}, "Error in setting binding attributes for Policy type: {0}"));
                        }
                        if (!bl4) {
                            PolicySetCommandUtil.updateBindingFile(session, string, properties, string5, string2);
                        }
                    } else {
                        if (bl4) {
                            PolicySetCommandUtil.deleteBindingFile(session, string, properties, string5, string2);
                        }
                        throw new ClassNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0042E", new Object[]{string}, "PolicyTypeProvider class not found for Policy type: {0}"));
                    }
                }
                if (bl5 && n == 3) {
                    object = properties.getProperty("application");
                    if (string2.equals("application")) {
                        PolicySetWorkSpaceHelper.updatePolicySetAttachmentFile(session, (String)object);
                    } else if (string2.equals("system/trust")) {
                        PolicySetWorkSpaceHelper.updateTrustAttachmentFile(session);
                    } else if (string2.equals("client")) {
                        PolicySetWorkSpaceHelper.updateClientAttachmentFile(session, (String)object);
                    }
                }
            } else {
                throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0046E", new Object[]{string}, "Unable to update bindings for policy type: {0}"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setBinding, policyTypeSuccess=" + bl3);
        }
        return bl3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getBindingLevel(Properties properties, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBindingLevel, bindingLocation=" + properties + ", attachmentType=" + string);
        }
        int n = 1;
        if (properties != null && !properties.isEmpty()) {
            if (properties.containsKey("node") && properties.containsKey("server")) {
                n = 2;
            } else {
                if (!properties.containsKey("attachmentId")) throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0047E", new Object[0], "Required property not found for bindingLocation"));
                n = 3;
                if (!string.equals("system/trust")) {
                    if (!string.equals("application") && !string.equals("client")) {
                        throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0035E", new Object[]{string}, "Invalid attachment type: {0}"));
                    }
                    if (!properties.containsKey("application")) {
                        throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0048E", new Object[0], "Application name required for bindingLocation"));
                    }
                }
            }
        } else {
            n = 1;
        }
        if (!tc.isEntryEnabled()) return n;
        Tr.exit(tc, "getBindingLevel, bindingLevel=" + n);
        return n;
    }

    private static String getPolicyAttachmentFile(Session session, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicyAttachmentFile, attachmentType=" + string + ", appName=" + string2);
        }
        String string3 = null;
        if (string.equals("application")) {
            string3 = PolicySetWorkSpaceHelper.getPolicySetAttachmentFile(session, string2);
        } else if (string.equals("system/trust")) {
            string3 = PolicySetWorkSpaceHelper.getTrustAttachmentFile(session);
        } else if (string.equals("client")) {
            string3 = PolicySetWorkSpaceHelper.getClientAttachmentFile(session, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicyAttachmentFile, policyAttachmentFile=" + string3);
        }
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void deleteBinding(Session session, String string, Properties properties, String string2, int n, String string3) throws Exception {
        block16: {
            PolicySetAttachmentHelper policySetAttachmentHelper;
            String string4;
            block17: {
                block18: {
                    block20: {
                        String string5;
                        block19: {
                            String string6;
                            block15: {
                                if (tc.isEntryEnabled()) {
                                    Tr.entry(tc, "deleteBinding, policyTypeName=" + string + ", bindingLocation=" + properties + ", attachmentType=" + string2 + ", bindingLevel=" + n);
                                }
                                string6 = "";
                                if (n != 2) break block15;
                                String string7 = properties.getProperty("node");
                                String string8 = properties.getProperty("server");
                                PolicySetWorkSpaceHelper.deleteServerDefaultBindingFile(session, string, string7, string8);
                                break block16;
                            }
                            string4 = properties.getProperty("application");
                            string5 = properties.getProperty("attachmentId");
                            policySetAttachmentHelper = null;
                            String string9 = PolicySetCommandUtil.getPolicyAttachmentFile(session, string2, string4);
                            if (string9 != null) {
                                policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string9);
                                policySetAttachmentHelper.setLocale(PolicySetCommandUtil.getLocale());
                            }
                            if (string5.equals("*")) break block17;
                            if (string9 == null) break block18;
                            string6 = policySetAttachmentHelper.getBindingReference(string5);
                            if (string6.equals("")) {
                                throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0051E", new Object[]{string5}, "Binding not found for attachment: {0}"));
                            }
                            if (string == null) break block19;
                            PolicySetCommandUtil.removePolicyTypeFromBinding(session, policySetAttachmentHelper, string4, string6, string, string2);
                            break block16;
                        }
                        policySetAttachmentHelper.setBindingReference(string5, null);
                        if (!string2.equals("application")) break block20;
                        PolicySetWorkSpaceHelper.updatePolicySetAttachmentFile(session, string4);
                        break block16;
                    }
                    if (string2.equals("system/trust")) {
                        PolicySetWorkSpaceHelper.updateTrustAttachmentFile(session);
                        break block16;
                    } else if (string2.equals("client")) {
                        PolicySetWorkSpaceHelper.updateClientAttachmentFile(session, string4);
                    }
                    break block16;
                }
                String string10 = null;
                String string11 = null;
                if (string2.equals("application")) {
                    string10 = POLICY_ATTACHMENT_NOT_FOUND_MSG;
                    string11 = "CWPST0031E";
                    throw new FileNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, string11, new Object[]{string4}, string10));
                } else if (string2.equals("system/trust")) {
                    string10 = TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                    string11 = "CWPST0033E";
                    throw new FileNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, string11, new Object[]{string4}, string10));
                } else {
                    if (!string2.equals("client")) throw new FileNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, string11, new Object[]{string4}, string10));
                    string10 = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                    string11 = "CWPST0032E";
                }
                throw new FileNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, string11, new Object[]{string4}, string10));
            }
            if (string3 == null) {
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0106E", new Object[0], "The bindingName and remove parameters are required when you specify the attachment ID as an asterisk (*)"));
            }
            if (string != null) {
                PolicySetCommandUtil.removePolicyTypeFromBinding(session, policySetAttachmentHelper, string4, string3, string, string2);
            } else {
                PolicySetCommandUtil.deleteBindingIfNotUsed(session, policySetAttachmentHelper, string4, string3, string2, true);
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "deleteBinding");
    }

    private static void removePolicyTypeFromBinding(Session session, PolicySetAttachmentHelper policySetAttachmentHelper, String string, String string2, String string3, String string4) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removePolicyTypeFromBinding, appName=" + string + ", bindingName=" + string2 + ", policyTypeName=" + string3 + ", attachmentType=" + string4);
        }
        if (string4.equals("system/trust")) {
            PolicySetWorkSpaceHelper.deleteTrustBindingFile(session, string2, string3);
            if (PolicySetWorkSpaceHelper.getTrustBindingDir(session, string2) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removePolicyTypeFromBinding, trust binding " + string2 + " is deleted. So update the attachment file");
                }
                PolicySetCommandUtil.removeBindingRefFromAttachments(session, policySetAttachmentHelper, string2, string, string4);
            }
        } else {
            PolicySetWorkSpaceHelper.deleteApplicationBindingFile(session, string, string2, string3);
            if (PolicySetWorkSpaceHelper.getApplicationBindingDir(session, string, string2) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removePolicyTypeFromBinding, application " + string + " binding " + string2 + " is deleted. So update the attachment files");
                }
                PolicySetCommandUtil.removeBindingRefFromAttachments(session, policySetAttachmentHelper, string2, string, string4);
                String string5 = null;
                String string6 = null;
                if (string4.equals("application")) {
                    string5 = PolicySetWorkSpaceHelper.getClientAttachmentFile(session, string);
                    string6 = "client";
                } else {
                    string5 = PolicySetWorkSpaceHelper.getPolicySetAttachmentFile(session, string);
                    string6 = "application";
                }
                if (string5 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "removePolicyTypeFromBinding, another attachmentFile is " + string5);
                    }
                    PolicySetAttachmentHelper policySetAttachmentHelper2 = PolicySetAttachmentHelperFactory.createHelper(string5);
                    policySetAttachmentHelper2.setLocale(PolicySetCommandUtil.getLocale());
                    PolicySetCommandUtil.removeBindingRefFromAttachments(session, policySetAttachmentHelper2, string2, string, string6);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removePolicyTypeFromBinding");
        }
    }

    private static void removeBindingRefFromAttachments(Session session, PolicySetAttachmentHelper policySetAttachmentHelper, String string, String string2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeBindingRefFromAttachments bindingName=" + string + ", appName=" + string2 + ", attachmentType=" + string3);
        }
        List list = policySetAttachmentHelper.getAttachmentIdsForBinding(string);
        for (int i = 0; i < list.size(); ++i) {
            policySetAttachmentHelper.setBindingReference((String)list.get(i), null);
        }
        if (!list.isEmpty()) {
            if (string3.equals("system/trust")) {
                PolicySetWorkSpaceHelper.updateTrustAttachmentFile(session);
            } else if (string3.equals("application")) {
                PolicySetWorkSpaceHelper.updatePolicySetAttachmentFile(session, string2);
            } else {
                PolicySetWorkSpaceHelper.updateClientAttachmentFile(session, string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeBindingRefFromAttachments");
        }
    }

    protected static void deleteBindingIfNotUsed(Session session, PolicySetAttachmentHelper policySetAttachmentHelper, String string, String string2, String string3, boolean bl) throws Exception {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deleteBindingIfNotUsed, appName=" + string + ", bindingName=" + string2 + ", attachmentType=" + string3 + ", validateBinding=" + bl);
            }
            if (string2 == null || string2.equals("")) {
                return;
            }
            List list = new ArrayList(0);
            if (policySetAttachmentHelper != null) {
                if (!policySetAttachmentHelper.isAttachmentListEmpty()) {
                    list = policySetAttachmentHelper.getAttachmentIdsForBinding(string2);
                }
                if (!list.isEmpty()) {
                    throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0107E", new Object[]{string2}, "The {0} binding cannot be deleted because it is still referenced by an attachment"));
                }
            }
            try {
                if (string3.equals("system/trust")) {
                    PolicySetWorkSpaceHelper.deleteTrustBinding(session, string2);
                    break block14;
                }
                PolicySetAttachmentHelper policySetAttachmentHelper2 = null;
                String string4 = null;
                string4 = string3.equals("application") ? PolicySetWorkSpaceHelper.getClientAttachmentFile(session, string) : PolicySetWorkSpaceHelper.getPolicySetAttachmentFile(session, string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleteBindingIfNotUsed, otherAttachmentFile=" + string4);
                }
                if (string4 != null) {
                    policySetAttachmentHelper2 = PolicySetAttachmentHelperFactory.createHelper(string4);
                    policySetAttachmentHelper2.setLocale(PolicySetCommandUtil.getLocale());
                    if (!policySetAttachmentHelper2.isAttachmentListEmpty()) {
                        list = policySetAttachmentHelper2.getAttachmentIdsForBinding(string2);
                    }
                }
                if (string4 == null || list.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deleteBindingIfNotUsed, no attachment refers to this binding, so delete the binding");
                    }
                    PolicySetWorkSpaceHelper.deleteApplicationBinding(session, string, string2);
                    break block14;
                }
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0107E", new Object[]{string2}, "The {0} binding cannot be deleted because it is still referenced by an attachment"));
            }
            catch (NoItemFoundException noItemFoundException) {
                FFDCFilter.processException(noItemFoundException, "PolicySetCommandUtil.deleteBindingIfNotUsed", FFDC_ID_2);
                Tr.error(tc, "CWPST0084E", new Object[]{noItemFoundException.toString()});
                if (!bl) break block14;
                throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0054E", new Object[]{string2}, "Binding reference removed from attachment but binding file not found: {0}"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteBindingIfNotUsed");
        }
    }

    private static Properties getBindingFile(Session session, String string, Properties properties, String string2, int n, String string3, Properties properties2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBindingFile, policyTypeName=" + string + ", bindingLocation=" + properties + ", attachmentType=" + string2 + ", bindingLevel=" + n + ", requestedValues=" + properties2);
        }
        String string4 = null;
        String string5 = "";
        boolean bl = false;
        boolean bl2 = false;
        Properties properties3 = new Properties();
        if (n == 1) {
            string4 = PolicySetWorkSpaceHelper.getCellDefaultBindingFile(session, string);
        } else if (n == 2) {
            String string6;
            String string7 = properties.getProperty("node");
            string4 = PolicySetWorkSpaceHelper.getServerDefaultBindingFile(session, string, string7, string6 = properties.getProperty("server"));
            if (string4 == null) {
                string4 = PolicySetWorkSpaceHelper.createServerDefaultBindingFile(session, string, string7, string6);
                bl = true;
            }
        } else {
            int n2;
            String string8 = properties.getProperty("application");
            String string9 = properties.getProperty("attachmentId");
            String string10 = null;
            String string11 = null;
            String string12 = null;
            PolicySetAttachmentHelper policySetAttachmentHelper = null;
            if (string2.equals("application")) {
                string10 = PolicySetWorkSpaceHelper.getPolicySetAttachmentFile(session, string8);
                string11 = POLICY_ATTACHMENT_NOT_FOUND_MSG;
                string12 = "CWPST0031E";
            } else if (string2.equals("system/trust")) {
                string10 = PolicySetWorkSpaceHelper.getTrustAttachmentFile(session);
                string11 = TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                string12 = "CWPST0033E";
            } else if (string2.equals("client")) {
                string10 = PolicySetWorkSpaceHelper.getClientAttachmentFile(session, string8);
                string11 = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                string12 = "CWPST0032E";
            }
            if (string10 != null) {
                policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string10);
                policySetAttachmentHelper.setLocale(PolicySetCommandUtil.getLocale());
                string5 = policySetAttachmentHelper.getBindingReference(string9);
                String string13 = policySetAttachmentHelper.getPolicySetForAttachment(string9);
                if (string5.equals("")) {
                    bl2 = true;
                    string5 = string3 != null ? string3 : string13 + " " + string9 + " " + "binding";
                } else if (string3 != null && !string3.equals(string5)) {
                    bl2 = true;
                    string5 = string3;
                }
                if (string2.equals("system/trust")) {
                    if (properties2 == null) {
                        string4 = PolicySetWorkSpaceHelper.getTrustBindingDir(session, string5);
                        if (string4 == null) {
                            throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0053E", new Object[]{string5}, "Binding not found: {0}"));
                        }
                    } else {
                        string4 = PolicySetWorkSpaceHelper.getTrustBindingFile(session, string5, string);
                        if (string4 == null) {
                            string4 = PolicySetWorkSpaceHelper.createTrustBindingFile(session, string5, string);
                            bl = true;
                        }
                    }
                } else if (properties2 == null) {
                    string4 = PolicySetWorkSpaceHelper.getApplicationBindingDir(session, string8, string5);
                    if (string4 == null) {
                        throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0053E", new Object[]{string5}, "Binding not found: {0}"));
                    }
                } else {
                    string4 = PolicySetWorkSpaceHelper.getApplicationBindingFile(session, string8, string5, string);
                    if (string4 == null) {
                        string4 = PolicySetWorkSpaceHelper.createApplicationBindingFile(session, string8, string5, string, string2);
                        bl = true;
                    }
                }
            } else {
                throw new FileNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, string12, new Object[]{string8}, string11));
            }
            if (bl2 && (n2 = policySetAttachmentHelper.setBindingReference(string9, string5)) != 0) {
                throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0045E", new Object[]{string9}, "Unable to create binding reference for attachment: {0}"));
            }
        }
        if (string4 != null) {
            properties3.setProperty(BINDING_FILE, string4);
        }
        properties3.setProperty(BINDING_REF, string5);
        properties3.setProperty(CREATED_FILE, Boolean.toString(bl));
        properties3.setProperty(UPDATED_BINDING_REF, Boolean.toString(bl2));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBindingFile, bindingProps=" + properties3);
        }
        return properties3;
    }

    private static void updateBindingFile(Session session, String string, Properties properties, String string2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateBindingFile, policyTypeName=" + string + ", bindingLocation=" + properties + ", bindingRef=" + string2 + ", attachmentType=" + string3);
        }
        if (properties != null && !properties.isEmpty()) {
            if (properties.containsKey("node")) {
                String string4 = properties.getProperty("node");
                String string5 = properties.getProperty("server");
                PolicySetWorkSpaceHelper.updateServerDefaultBindingFile(session, string, string4, string5);
            } else if (string3.equals("system/trust")) {
                PolicySetWorkSpaceHelper.updateTrustBindingFile(session, string2, string);
            } else {
                String string6 = properties.getProperty("application");
                PolicySetWorkSpaceHelper.updateApplicationBindingFile(session, string6, string2, string);
            }
        } else {
            PolicySetWorkSpaceHelper.updateCellDefaultBindingFile(session, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateBindingFile");
        }
    }

    private static void deleteBindingFile(Session session, String string, Properties properties, String string2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteBindingFile, policyTypeName=" + string + ", bindingLocation=" + properties + ", bindingRef=" + string2 + ", attachmentType=" + string3);
        }
        if (properties != null && !properties.isEmpty()) {
            if (properties.containsKey("node")) {
                String string4 = properties.getProperty("node");
                String string5 = properties.getProperty("server");
                PolicySetWorkSpaceHelper.deleteServerDefaultBindingFile(session, string, string4, string5);
            } else if (string3.equals("system/trust")) {
                PolicySetWorkSpaceHelper.deleteTrustBindingFile(session, string2, string);
            } else {
                String string6 = properties.getProperty("application");
                PolicySetWorkSpaceHelper.deleteApplicationBindingFile(session, string6, string2, string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteBindingFile");
        }
    }

    public static StringBuffer getApplicationsAttachedToPolicySet(Session session, String string) throws WorkSpaceException, NoItemFoundException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, FileNotFoundException, IllegalArgumentException, JAXBException, CommandValidationException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationsAttachedToPolicySet, policySetName=" + string);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetCommandUtil.getLocale());
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = null;
        String string32 = null;
        int n = 0;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        arrayList = (ArrayList)PolicySetWorkSpaceHelper.listPolicySetAttachmentFiles(session, "application", "*");
        arrayList2 = (ArrayList)PolicySetWorkSpaceHelper.listPolicySetAttachmentFiles(session, "client", "*");
        if (arrayList2 != null) {
            arrayList.addAll(arrayList2);
        }
        for (String string32 : arrayList) {
            string2 = PolicySetCommandUtil.getApplicationName(string32, DEPLOYMENTS, META_INF);
            if (string32 == null) continue;
            PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string32);
            policySetAttachmentHelper.setLocale(PolicySetCommandUtil.getLocale());
            boolean bl = policySetAttachmentHelper.isAttachedToPolicySet(string);
            if (!bl) continue;
            if (n > 0) {
                stringBuffer.append(",");
            }
            ++n;
            stringBuffer.append(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationsAttachedToPolicySet, appBuffer=" + stringBuffer);
        }
        return stringBuffer;
    }

    public static StringBuffer validateTrustResources(Session session, String[] stringArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateTrustResources, resources=" + stringArray);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetCommandUtil.getLocale());
        String string = "";
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            PolicySetCommandUtil.checkResourceIsPopulated(string);
            PolicyResource policyResource = new PolicyResource(string);
            string2 = policyResource.getType();
            boolean bl = false;
            if (!PolicySetCommandUtil.isSupportedOperation(string2)) {
                bl = true;
            } else {
                int n = string.indexOf(":/") + 2;
                int n2 = string.length();
                if (n <= 0) {
                    bl = true;
                } else {
                    String string3 = string.substring(n, n2);
                    if (string3.length() != 0) {
                        try {
                            URL uRL = new URL(string3);
                        }
                        catch (MalformedURLException malformedURLException) {
                            bl = true;
                        }
                    }
                }
            }
            if (!bl) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateTrustResources, resourcesNotValid=" + stringBuffer);
        }
        return stringBuffer;
    }

    public static StringBuffer validateResourcesForApplication(Session session, String string, String[] stringArray, String string2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateResourcesForApplication, applicationName=" + string + ", resources=" + stringArray + ", attachmentType=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetCommandUtil.getLocale());
        String string4 = "";
        String string5 = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string6 = null;
        String string7 = null;
        String string8 = null;
        List list = new ArrayList();
        if (stringArray.length == 0) {
            throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0015E", new Object[0], "A resource was specified as empty or null"));
        }
        list = ServiceIndexHelperFactory.createWorkSpaceHelper().listServiceIndexFiles(session, string, string5);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2;
            string4 = stringArray[i];
            PolicySetCommandUtil.checkResourceIsPopulated(string4);
            PolicyResource policyResource = new PolicyResource(string4);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "policyResource: " + policyResource);
            }
            string5 = policyResource.getModuleName();
            string6 = policyResource.getServiceName();
            string7 = policyResource.getEndpointName();
            string8 = policyResource.getOperationName();
            String string9 = null;
            boolean bl = false;
            boolean bl2 = true;
            if (string4.equals("WebService:/") || string4.equals("/")) {
                bl = true;
            }
            if (!string4.startsWith("WebService:/")) {
                bl2 = false;
            }
            if (!bl && bl2 && (string7 != null || string8 != null)) {
                object2 = PolicySetWorkSpaceHelper.getPolicySetFile(session, string3);
                object = PolicySetHelperFactory.createHelper((String)object2);
                List list2 = object.listEnabledPolicyTypes();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "policyTypes: " + list2);
                }
                if (list2 != null && list2.contains("WSReliableMessaging")) {
                    bl2 = false;
                }
            }
            object2 = list.iterator();
            while (object2.hasNext() && !bl && bl2) {
                object = new Properties();
                object = (Properties)object2.next();
                boolean bl3 = false;
                String string10 = ((Properties)object).getProperty("module");
                if (string2.equals("application")) {
                    if (string5 != null && string5.equals(string10)) {
                        bl3 = true;
                    }
                } else if (string2.equals("client")) {
                    if (string5 == null) {
                        bl3 = true;
                    } else if (string5.equals(string10)) {
                        bl3 = true;
                    }
                }
                if (!bl3) continue;
                string9 = ((Properties)object).getProperty("file");
                String string11 = ((Properties)object).getProperty("application");
                if (string9 == null) {
                    throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0014E", new Object[]{string11 + " / " + string10}, "The serviceIndex file could not be located for the application / module of: {0}"));
                }
                FileInputStream fileInputStream = new FileInputStream(string9);
                ServiceIndexHelper serviceIndexHelper = ServiceIndexHelperFactory.createHelper(string11, string10, fileInputStream);
                if (string2.equals("application")) {
                    bl = serviceIndexHelper.contains(string6, string7, string8, false);
                    continue;
                }
                bl = serviceIndexHelper.contains(string6, string7, string8, true);
            }
            if (bl && bl2) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateResourcesForApplication, resourceNotFound=" + stringBuffer);
        }
        return stringBuffer;
    }

    private static void checkResourceIsPopulated(String string) throws CommandValidationException {
        if (string.equals("") || string == null) {
            throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0015E", new Object[0], "A resource was specified as empty or null"));
        }
    }

    public static StringBuffer validateResourcesNotAttached(Session session, String string, String string2, String string3, String[] stringArray, String string4, boolean bl) throws WorkSpaceException, NoItemFoundException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, FileNotFoundException, JAXBException, CommandValidationException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateResourcesNotAttached, attachmentType=" + string + ", attachmentFile=" + string2 + ", applicationName=" + string3 + ", resources=" + stringArray + ", id=" + string4 + ", matchToID=" + bl);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetCommandUtil.getLocale());
        StringBuffer stringBuffer = new StringBuffer();
        String string5 = "";
        List list = new ArrayList();
        if (string2 != null) {
            Object object;
            ResourceEvaluator resourceEvaluator = null;
            if (string != null && string.equals("system/trust")) {
                object = Class.forName("com.ibm.ws.wssecurity.trust.server.sts.Util.STSResourceEvaluator");
                Constructor constructor = ((Class)object).getConstructor(new Class[0]);
                resourceEvaluator = (ResourceEvaluator)constructor.newInstance(new Object[0]);
            } else {
                resourceEvaluator = new DefaultResourceEvaluator();
            }
            object = PolicySetAttachmentHelperFactory.createHelper(string2);
            object.setLocale(PolicySetCommandUtil.getLocale());
            list = object.getPolicySetAttachments();
            if (list != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    boolean bl2 = false;
                    string5 = stringArray[i];
                    PolicySetCommandUtil.checkResourceIsPopulated(string5);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext() && !bl2) {
                        Properties properties = new Properties();
                        properties = (Properties)iterator.next();
                        Enumeration<?> enumeration = properties.propertyNames();
                        String string6 = "";
                        String string7 = "";
                        string7 = properties.getProperty("id");
                        while (enumeration.hasMoreElements() && !bl2) {
                            String string8 = (String)enumeration.nextElement();
                            if (!string8.startsWith("pattern")) continue;
                            string6 = properties.getProperty(string8);
                            if (string4 == null && resourceEvaluator.getMatchDistance(string6, string5) == 0) {
                                bl2 = true;
                            }
                            if (string4 != null && !bl && !string4.equals(string7) && resourceEvaluator.getMatchDistance(string6, string5) == 0) {
                                bl2 = true;
                            }
                            if (string4 == null || !bl || !string4.equals(string7) || resourceEvaluator.getMatchDistance(string6, string5) != 0) continue;
                            bl2 = true;
                        }
                    }
                    if (!bl2) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(string5);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateResourcesNotAttached, resourcesAttached=" + stringBuffer);
        }
        return stringBuffer;
    }

    public static String getFormattedMessage(ResourceBundle resourceBundle, String string, Object[] objectArray, String string2) {
        String string3 = null;
        try {
            String string4 = resourceBundle.getString(string);
            string3 = string4 == null ? string2 : MessageFormat.format(string4, objectArray);
        }
        catch (Throwable throwable) {
            string3 = string2;
        }
        return string3;
    }

    private static String getApplicationName(String string, String string2, String string3) throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationName, path=" + string + ", prefix=" + string2 + ", suffix=" + string3);
        }
        int n = string.lastIndexOf(File.separatorChar + string2 + File.separatorChar);
        int n2 = string.lastIndexOf(File.separatorChar + string3 + File.separatorChar);
        if (n < 0) {
            throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0017E", new Object[]{string, string2}, "The pathname of {0} did not contain the string of {1}"));
        }
        if (n2 < 0) {
            throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0017E", new Object[]{string, string3}, "The pathname of {0} did not contain the string of {1}"));
        }
        int n3 = n + string2.length() + 2;
        String string4 = string.substring(n3, n2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationName, appName=" + string4 + ", index1=" + n + ", index2=" + n2 + ", startpos=" + n3);
        }
        return string4;
    }

    private static boolean isSupportedOperation(String string) {
        for (int i = 0; i < supportedTrustOperations.length; ++i) {
            if (!supportedTrustOperations[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static int transferAttachments(Session session, String string, String string2, String string3, String string4) throws WorkSpaceException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        String string5;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transferAttachments, sourcePolicysetName=" + string + ", destPolicysetName=" + string2 + ", applicationName=" + string3 + ", policySetType=" + string4);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetCommandUtil.getLocale());
        int n = 0;
        if (string4.equals("application")) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            if (string3 != null) {
                arrayList = (ArrayList)PolicySetWorkSpaceHelper.listPolicySetAttachmentFiles(session, "application", string3);
                arrayList2 = (ArrayList)PolicySetWorkSpaceHelper.listPolicySetAttachmentFiles(session, "client", string3);
                arrayList.addAll(arrayList2);
                if (arrayList.isEmpty()) {
                    throw new FileNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0031E", new Object[]{string3}, "Policy attachment file is not found: {0}"));
                }
            } else {
                arrayList = (ArrayList)PolicySetWorkSpaceHelper.listPolicySetAttachmentFiles(session, "application", "*");
                arrayList2 = (ArrayList)PolicySetWorkSpaceHelper.listPolicySetAttachmentFiles(session, "client", "*");
                arrayList.addAll(arrayList2);
            }
            if (arrayList != null && !arrayList.isEmpty()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string6 = (String)arrayList.get(i);
                    PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string6);
                    policySetAttachmentHelper.setLocale(PolicySetCommandUtil.getLocale());
                    if (!policySetAttachmentHelper.isAttachedToPolicySet(string)) continue;
                    n += policySetAttachmentHelper.transferAttachments(string, string2);
                    String string7 = null;
                    if (string6.contains("policyAttachments.xml")) {
                        string7 = string6.substring(0, string6.indexOf("policyAttachments.xml") - 1);
                    } else if (string6.contains("clientPolicyAttachments.xml")) {
                        string7 = string6.substring(0, string6.indexOf("clientPolicyAttachments.xml") - 1);
                    }
                    string7 = string7.substring(0, string7.lastIndexOf(File.separator));
                    String string8 = string7.substring(string7.lastIndexOf(File.separator) + 1);
                    if (string8 == null) continue;
                    if (string6.contains("policyAttachments.xml")) {
                        PolicySetWorkSpaceHelper.updatePolicySetAttachmentFile(session, string8);
                        continue;
                    }
                    if (!string6.contains("clientPolicyAttachments.xml")) continue;
                    PolicySetWorkSpaceHelper.updateClientAttachmentFile(session, string8);
                }
            }
        } else if (string4.equals("system/trust") && (string5 = PolicySetWorkSpaceHelper.getTrustAttachmentFile(session)) != null) {
            PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string5);
            policySetAttachmentHelper.setLocale(PolicySetCommandUtil.getLocale());
            if (policySetAttachmentHelper.isAttachedToPolicySet(string)) {
                n = policySetAttachmentHelper.transferAttachments(string, string2);
                PolicySetWorkSpaceHelper.updateTrustAttachmentFile(session);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transferAttachments, rc=" + n);
        }
        return n;
    }

    public static List getExpandedResources(Session session, String string, String string2, List list, String string3) throws Exception {
        Properties properties;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExpandedResources, applicationName=" + string + ", expandResources=" + string2 + ", attachmentList=" + list + ", attachmentType=" + string3);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetCommandUtil.getLocale());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = string;
        List list2 = ServiceIndexHelperFactory.createWorkSpaceHelper().listServiceIndexFiles(session, string, string4);
        if (list2 != null && !list2.isEmpty() && list != null) {
            object = new Properties();
            ((Properties)object).setProperty("resource", string);
            properties = PolicySetCommandUtil.getPropertiesIfAttached(list, "WebService:/", string3);
            if (!properties.isEmpty()) {
                bl2 = true;
                string6 = properties.getProperty("policySet");
                string7 = properties.getProperty("attachmentId");
                string8 = properties.getProperty("binding");
                ((Properties)object).setProperty("policySet", string6);
                ((Properties)object).setProperty("attachmentId", string7);
                if (string8 != null) {
                    ((Properties)object).setProperty("binding", string8);
                }
                ((Properties)object).setProperty("directAttachment", "true");
            }
            if (string2.equals("*")) {
                arrayList.add(object);
            }
        }
        object = list2.iterator();
        while (object.hasNext()) {
            properties = new Properties();
            properties = (Properties)object.next();
            string4 = properties.getProperty("module");
            string5 = properties.getProperty("file");
            if (string5 == null) {
                throw new FileNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0014E", new Object[]{string + " / " + string4}, "The serviceIndex file could not be located for the application / module of: {0}"));
            }
            FileInputStream fileInputStream = new FileInputStream(string5);
            ServiceIndexHelper serviceIndexHelper = ServiceIndexHelperFactory.createHelper(string, string4, fileInputStream);
            if (!string2.equals("*") && !(bl = string3.equals("application") ? serviceIndexHelper.contains(string2, null, null, false) : serviceIndexHelper.contains(string2, null, null, true))) continue;
            List list3 = null;
            list3 = string3.equals("application") ? serviceIndexHelper.listWebServiceObjects(false) : serviceIndexHelper.listWebServiceObjects(true);
            for (int i = 0; i < list3.size(); ++i) {
                String string10;
                WebService webService = (WebService)list3.get(i);
                if (!string2.equals("*") && !string2.equals(webService.getServiceName())) continue;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("WebService:/").append(string4).append(":");
                stringBuffer.append(webService.getServiceName());
                string9 = string10 = stringBuffer.toString();
                Properties properties2 = new Properties();
                properties2.setProperty("resource", string9);
                bl3 = false;
                String string11 = null;
                String string12 = null;
                String string13 = null;
                Properties properties3 = PolicySetCommandUtil.getPropertiesIfAttached(list, string9, string3);
                if (!properties3.isEmpty()) {
                    bl3 = true;
                    string11 = properties3.getProperty("policySet");
                    string12 = properties3.getProperty("attachmentId");
                    string13 = properties3.getProperty("binding");
                    properties2.setProperty("policySet", string11);
                    properties2.setProperty("attachmentId", string12);
                    if (string13 != null) {
                        properties2.setProperty("binding", string13);
                    }
                    properties2.setProperty("directAttachment", "true");
                } else if (bl2) {
                    properties2.setProperty("policySet", string6);
                    properties2.setProperty("attachmentId", string7);
                    if (string8 != null) {
                        properties2.setProperty("binding", string8);
                    }
                    properties2.setProperty("directAttachment", "false");
                }
                arrayList.add(properties2);
                List list4 = webService.listEndpoints();
                for (int j = 0; j < list4.size(); ++j) {
                    Endpoint endpoint = (Endpoint)list4.get(j);
                    String string14 = endpoint.getName();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer2.append(string10).append("/").append(string14);
                    string9 = stringBuffer2.toString();
                    properties2 = new Properties();
                    properties2.setProperty("resource", string9);
                    bl4 = false;
                    String string15 = null;
                    String string16 = null;
                    String string17 = null;
                    properties3 = PolicySetCommandUtil.getPropertiesIfAttached(list, string9, string3);
                    if (!properties3.isEmpty()) {
                        bl4 = true;
                        string15 = properties3.getProperty("policySet");
                        string16 = properties3.getProperty("attachmentId");
                        string17 = properties3.getProperty("binding");
                        properties2.setProperty("policySet", string15);
                        properties2.setProperty("attachmentId", string16);
                        if (string17 != null) {
                            properties2.setProperty("binding", string17);
                        }
                        properties2.setProperty("directAttachment", "true");
                    } else if (bl3) {
                        properties2.setProperty("policySet", string11);
                        properties2.setProperty("attachmentId", string12);
                        if (string13 != null) {
                            properties2.setProperty("binding", string13);
                        }
                        properties2.setProperty("directAttachment", "false");
                    } else if (bl2) {
                        properties2.setProperty("policySet", string6);
                        properties2.setProperty("attachmentId", string7);
                        if (string8 != null) {
                            properties2.setProperty("binding", string8);
                        }
                        properties2.setProperty("directAttachment", "false");
                    }
                    arrayList.add(properties2);
                    List list5 = endpoint.listOperations();
                    for (int k = 0; k < list5.size(); ++k) {
                        String string18 = (String)list5.get(k);
                        StringBuffer stringBuffer3 = new StringBuffer();
                        stringBuffer3.append(string10).append("/").append(string14).append("/").append(string18);
                        string9 = stringBuffer3.toString();
                        properties2 = new Properties();
                        properties2.setProperty("resource", string9);
                        properties3 = PolicySetCommandUtil.getPropertiesIfAttached(list, string9, string3);
                        if (!properties3.isEmpty()) {
                            String string19 = properties3.getProperty("policySet");
                            String string20 = properties3.getProperty("attachmentId");
                            String string21 = properties3.getProperty("binding");
                            properties2.setProperty("policySet", string19);
                            properties2.setProperty("attachmentId", string20);
                            if (string21 != null) {
                                properties2.setProperty("binding", string21);
                            }
                            properties2.setProperty("directAttachment", "true");
                        } else if (bl4) {
                            properties2.setProperty("policySet", string15);
                            properties2.setProperty("attachmentId", string16);
                            if (string17 != null) {
                                properties2.setProperty("binding", string17);
                            }
                            properties2.setProperty("directAttachment", "false");
                        } else if (bl3) {
                            properties2.setProperty("policySet", string11);
                            properties2.setProperty("attachmentId", string12);
                            if (string13 != null) {
                                properties2.setProperty("binding", string13);
                            }
                            properties2.setProperty("directAttachment", "false");
                        } else if (bl2) {
                            properties2.setProperty("policySet", string6);
                            properties2.setProperty("attachmentId", string7);
                            if (string8 != null) {
                                properties2.setProperty("binding", string8);
                            }
                            properties2.setProperty("directAttachment", "false");
                        }
                        arrayList.add(properties2);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExpandedResources, resourceList=" + arrayList);
        }
        return arrayList;
    }

    public static List getExpandedResourcesForTrust(String string, List list) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExpandedResourcesForTrust, expandResources=" + string + ", attachmentList=" + list);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetCommandUtil.getLocale());
        if (list == null || list.isEmpty()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getExpandedResourceForTrust, attachmentList is null");
            }
            return new ArrayList(0);
        }
        ArrayList arrayList = new ArrayList();
        for (Properties properties : list) {
            String string2 = properties.getProperty("name");
            String string3 = properties.getProperty("id");
            String string4 = properties.getProperty("binding");
            Properties properties2 = null;
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                if (!string5.startsWith("pattern")) continue;
                properties2 = new Properties();
                properties2.setProperty("resource", properties.getProperty(string5));
                properties2.setProperty("policySet", string2);
                properties2.setProperty("attachmentId", string3);
                if (string4 != null) {
                    properties2.setProperty("binding", string4);
                }
                PolicySetCommandUtil.addURLResourceToList(arrayList, properties2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExpandedResourcesForTrust, resourceList=" + arrayList);
        }
        return arrayList;
    }

    private static void addURLResourceToList(List list, Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addURLResourceToList, resourceList=" + list + ", props=" + properties);
        }
        String string = properties.getProperty("resource");
        String string2 = PolicySetCommandUtil.getURLFromResource(string);
        String string3 = PolicySetCommandUtil.getTrustOpFromResource(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addURLResourceToList, url=" + string2 + ", trustOp=" + string3);
        }
        Properties properties2 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        for (n = 0; n < list.size(); ++n) {
            properties2 = (Properties)list.get(n);
            string4 = properties2.getProperty("resource");
            string5 = PolicySetCommandUtil.getURLFromResource(string4);
            if (string2 == null || string2.equals(string5)) {
                if (string3 != null && string3.compareTo(PolicySetCommandUtil.getTrustOpFromResource(string4)) >= 0) continue;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "addURLResourceToList, trustOp=" + string3 + ", otherTrustOp=" + PolicySetCommandUtil.getTrustOpFromResource(string4));
                break;
            }
            if (string2.compareTo(string5) >= 0) continue;
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "addURLResourceToList, url=" + string2 + ", otherUrl=" + string5);
            break;
        }
        list.add(n, properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addURLResourceToList");
        }
    }

    private static String getURLFromResource(String string) {
        int n = string.indexOf(":/");
        if (n > 0) {
            return string.substring(n + 1);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getURLFromResource, the resource pattern is not valid.");
        }
        return null;
    }

    private static String getTrustOpFromResource(String string) {
        int n = string.indexOf(":/");
        if (n > 0) {
            return string.substring(0, n);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getURLFromResource, the resource pattern is not valid.");
        }
        return null;
    }

    private static Properties getPropertiesIfAttached(List list, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertiesIfAttached, attachmentList=" + list + ", resource=" + string);
        }
        Properties properties = new Properties();
        boolean bl = false;
        String string3 = null;
        if (list != null) {
            boolean bl2 = true;
            boolean bl3 = false;
            if (string2.equals("client") && !string.equals(string3 = PolicySetCommandUtil.removeModuleName(string))) {
                bl3 = true;
            }
            while (bl2) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && !bl) {
                    Properties properties2 = new Properties();
                    properties2 = (Properties)iterator.next();
                    Enumeration<?> enumeration = properties2.propertyNames();
                    String string4 = "";
                    String string5 = properties2.getProperty("name");
                    String string6 = properties2.getProperty("id");
                    String string7 = properties2.getProperty("binding");
                    while (enumeration.hasMoreElements() && !bl) {
                        String string8 = (String)enumeration.nextElement();
                        if (!string8.startsWith("pattern") || !(string4 = properties2.getProperty(string8)).equals(string)) continue;
                        properties.setProperty("policySet", string5);
                        properties.setProperty("attachmentId", string6);
                        if (string7 != null) {
                            properties.setProperty("binding", string7);
                        }
                        bl = true;
                    }
                }
                if (string2.equals("client")) {
                    if (!bl && bl3) {
                        bl3 = false;
                        string = string3;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "didn't find matching attachment; now checking without moduleName for resource = " + string);
                        continue;
                    }
                    bl2 = false;
                    continue;
                }
                bl2 = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertiesIfAttached, attachmentProperties=" + properties);
        }
        return properties;
    }

    private static String removeModuleName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeModuleName", string);
        }
        String string2 = string;
        PolicyResource policyResource = new PolicyResource(string);
        String string3 = policyResource.getModuleName();
        if (string3 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, string.indexOf(string3)));
            stringBuffer.append(string.substring(string.indexOf(string3) + string3.length() + 1));
            string2 = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resource contains module name");
                Tr.debug(tc, "Resource without moduleName is: " + string2);
            }
        }
        return string2;
    }

    public static StringBuffer validatePolicySet(Session session, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validatePolicySet, policySetName=" + string + ", policySetFilePath=" + string2);
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetCommandUtil.getLocale());
        StringBuffer stringBuffer = new StringBuffer();
        List list = new ArrayList();
        list = PolicySetWorkSpaceHelper.listPolicyTypes(session, string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            String string3 = (String)iterator.next();
            String string4 = PolicySetWorkSpaceHelper.getPolicyTypeFile(session, string, string3);
            if (string4 == null) continue;
            PolicyTypeProvider policyTypeProvider = PolicyTypeClassLoader.getPolicyTypeProvider(string3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Before validate, policyTypeProvider=" + policyTypeProvider + " " + string3 + " " + string4);
            }
            if (policyTypeProvider != null) {
                block10: {
                    try {
                        bl = policyTypeProvider.validate(string2, string4, session);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, "PolicySetCommandUtil.validatePolicySet", FFDC_ID_1);
                        Tr.error(tc, "CWPST0028E", new Object[]{exception.toString()});
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "Exception caught - " + exception);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "After validate, policyTypeValid=" + bl);
                }
                if (bl) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(string3);
                continue;
            }
            Tr.error(tc, "CWPST0042E", new Object[]{string3});
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validatePolicySet, invalidPolicyTypes=" + stringBuffer);
        }
        return stringBuffer;
    }

    public static void validatePolicySetName(String string) throws IllegalArgumentException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetCommandUtil.getLocale());
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (!Character.isWhitespace(c) && !Character.isLetterOrDigit(c) && "-_".indexOf(c) == -1) {
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0026E", new Object[]{string}, INVALID_CHAR_ERROR_MSG));
            }
            c = stringCharacterIterator.next();
        }
    }

    public static void setLocale(Locale locale) {
        _locale = locale;
    }

    private static Locale getLocale() {
        if (_locale == null) {
            return Locale.getDefault();
        }
        return _locale;
    }
}

