/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBException;

public class ListPolicyTypes
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(ListPolicyTypes.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    public static final String POLICY_ATTACHMENT_NOT_FOUND_MSG = "Policy attachment file is not found: ";
    public static final String CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "Client policy attachment file is not found: ";
    public static final String TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG = "System/trust policy attachment file is not found";
    protected String SOURCE_FILE = this.getClass().getName();
    private Session session = null;

    public ListPolicyTypes(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + commandMetadata);
        }
    }

    public ListPolicyTypes(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = null;
        List list = null;
        try {
            commandResultImpl = new CommandResultImpl();
            this.setCommandResult(commandResultImpl);
            commandResultImpl.reset();
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String string = (String)this.getParameter("policySet");
            Properties properties = (Properties)this.getParameter("bindingLocation");
            String string2 = (String)this.getParameter("attachmentType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string, properties, string2});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ListPolicyTypes, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            if (string != null && properties != null) {
                throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0029E", new Object[]{"bindingLocation", "policySet"}, "The {1} parameter cannot be used if the {0} parameter is specified"));
            }
            if (properties != null) {
                if (properties.containsKey("application") && string2 == null) {
                    throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0030E", new Object[]{"attachmentType", "bindingLocation"}, "The input argument {0} must also be specified with {1}"));
                }
                if (properties.containsKey("node") && !properties.containsKey("server") || properties.containsKey("server") && !properties.containsKey("node")) {
                    throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0030E", new Object[]{"node", "server"}, "The input argument {0} must also be specified with {1}"));
                }
            }
            this.session = this.getConfigSession();
            list = properties == null ? (string == null || string.equals("") ? PolicySetWorkSpaceHelper.listDefaultPolicyTypes(this.session) : PolicySetWorkSpaceHelper.listPolicyTypes(this.session, string)) : this.findPolicyTypesForBindingFiles(this.session, properties, string2);
            commandResultImpl.setResult(list);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.SOURCE_FILE + ".execute", FFDC_ID_1);
            Tr.error(tc, "CWPST0007E", new Object[]{exception.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + exception);
            }
            commandResultImpl.setException(exception);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "finally");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List findPolicyTypesForBindingFiles(Session session, Properties properties, String string) throws WorkSpaceException, NoItemFoundException, InstantiationException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, JAXBException, FileNotFoundException, DuplicateItemFoundException, IOException {
        List list = null;
        if (properties.isEmpty()) {
            return PolicySetWorkSpaceHelper.listPolicyTypesForCellBindingFile(session);
        }
        if (properties.containsKey("node")) {
            String string2 = properties.getProperty("node");
            String string3 = properties.getProperty("server");
            return PolicySetWorkSpaceHelper.listPolicyTypesForServerBindingFile(session, string2, string3);
        }
        String string4 = properties.getProperty("application");
        String string5 = properties.getProperty("attachmentId");
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        if (string.equals("application")) {
            string6 = PolicySetWorkSpaceHelper.getPolicySetAttachmentFile(session, string4);
            string7 = POLICY_ATTACHMENT_NOT_FOUND_MSG;
            string8 = "CWPST0031E";
        } else if (string.equals("system/trust")) {
            string6 = PolicySetWorkSpaceHelper.getTrustAttachmentFile(session);
            string7 = TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG;
            string8 = "CWPST0033E";
        } else {
            if (!string.equals("client")) throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0035E", new Object[]{string}, "Invalid attachment type: {0}"));
            string6 = PolicySetWorkSpaceHelper.getClientAttachmentFile(session, string4);
            string7 = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
            string8 = "CWPST0032E";
        }
        if (string6 == null) throw new FileNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, string8, new Object[]{string4}, string7));
        PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string6);
        policySetAttachmentHelper.setLocale(this.getLocale());
        string9 = policySetAttachmentHelper.getBindingReference(string5);
        if (string9.equals("")) throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0037E", new Object[]{string5}, "Binding reference not found for attachment: {0}"));
        if (!string.equals("system/trust")) return PolicySetWorkSpaceHelper.listPolicyTypesForApplicationBindingFile(session, string4, string9);
        return PolicySetWorkSpaceHelper.listPolicyTypesForTrustBindingFile(session, string9);
    }
}

