/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ListPolicySets
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(ListPolicySets.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    protected String SOURCE_FILE = this.getClass().getName();
    private Session session = null;

    public ListPolicySets(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + commandMetadata);
        }
    }

    public ListPolicySets(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = null;
        List list = null;
        try {
            commandResultImpl = new CommandResultImpl();
            this.setCommandResult(commandResultImpl);
            commandResultImpl.reset();
            this.session = this.getConfigSession();
            String string = (String)this.getParameter("policySetType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ListPolicySets, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            list = PolicySetWorkSpaceHelper.listPolicySets(this.session);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (string == null) {
                string = "application";
            }
            for (int i = 0; i < list.size(); ++i) {
                String string2 = (String)list.get(i);
                Properties properties = null;
                try {
                    PolicySetHelper policySetHelper = PolicySetHelperFactory.createHelper(string2);
                    policySetHelper.setLocale(this.getLocale());
                    properties = policySetHelper.getPolicySet();
                    if (!string.equals(properties.getProperty("type"))) continue;
                    arrayList.add(ListPolicySets.getLastDirName(string2));
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, this.SOURCE_FILE + ".execute", FFDC_ID_2);
                    Tr.error(tc, "CWPST0007E", new Object[]{exception.toString()});
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception caught - " + exception);
                }
            }
            commandResultImpl.setResult(arrayList);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.SOURCE_FILE + ".execute", FFDC_ID_1);
            Tr.error(tc, "CWPST0007E", new Object[]{exception.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + exception);
            }
            commandResultImpl.setException(exception);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "finally");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }

    private static String getLastDirName(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        String string2 = string.substring(0, n);
        n = string2.lastIndexOf(File.separatorChar);
        String string3 = string2.substring(n + 1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLastDirName, filePath=" + string + ", str1=" + string2 + ", dir=" + string3);
        }
        return string3;
    }
}

