/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class ListAttachmentsForPolicySet
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(ListAttachmentsForPolicySet.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String className = this.getClass().getName();
    private Session session = null;

    public ListAttachmentsForPolicySet(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + commandMetadata);
        }
    }

    public ListAttachmentsForPolicySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            this.session = this.getConfigSession();
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String string = (String)this.getParameter("policySet");
            String string2 = (String)this.getParameter("attachmentType");
            if (string2 == null) {
                string2 = "all";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string, string2});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ListAttachmentsForPolicySet, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            if (!(string2.equals("application") || string2.equals("client") || string2.equals("all"))) {
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0035E", new Object[]{string2}, "Invalid attachment type: {0}"));
            }
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            if (string2.equals("application") || string2.equals("all")) {
                arrayList2 = (ArrayList)PolicySetWorkSpaceHelper.listPolicySetAttachmentFiles(this.session, "application", "*");
            }
            if (string2.equals("client") || string2.equals("all")) {
                arrayList3 = (ArrayList)PolicySetWorkSpaceHelper.listPolicySetAttachmentFiles(this.session, "client", "*");
            }
            arrayList2.addAll(arrayList3);
            if (arrayList2 != null && !arrayList2.isEmpty()) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string3;
                    String string4 = (String)arrayList2.get(i);
                    PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string4);
                    policySetAttachmentHelper.setLocale(this.getLocale());
                    if (!policySetAttachmentHelper.isAttachedToPolicySet(string)) continue;
                    String string5 = null;
                    if (string4.contains("policyAttachments.xml")) {
                        string5 = string4.substring(0, string4.indexOf("policyAttachments.xml") - 1);
                    } else if (string4.contains("clientPolicyAttachments.xml")) {
                        string5 = string4.substring(0, string4.indexOf("clientPolicyAttachments.xml") - 1);
                    }
                    if (string5 == null || (string3 = (string5 = string5.substring(0, string5.lastIndexOf(File.separator))).substring(string5.lastIndexOf(File.separator) + 1)) == null) continue;
                    arrayList.add(string3);
                }
                commandResultImpl.setResult(arrayList);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className + ".execute()", FFDC_ID_1);
            commandResultImpl.setException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }
}

