/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ImportPolicySet
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(ImportPolicySet.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private String className = this.getClass().getName();

    public ImportPolicySet(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public ImportPolicySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String validate(Session session, String string) throws CommandValidationException, WorkSpaceException, NoItemFoundException, Exception {
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        if ((file = new File(string)).exists()) {
            if (file.isDirectory()) {
                throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0104E", new Object[]{string}, "The {0} file name is a directory."));
            }
        } else {
            throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0020E", new Object[]{string}, "The following directory path does not exist: {0}"));
        }
        List list = this.getZipFileList(string);
        if (list.size() < 1) {
            throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0098E", new Object[]{string}, "The {0} zip file does not contain any files."));
        }
        Iterator iterator = list.iterator();
        String string2 = "";
        while (iterator.hasNext()) {
            String string3 = iterator.next().toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validate, fileName=" + string3);
            }
            int n = string3.indexOf("\\");
            int n2 = string3.indexOf("/");
            String string4 = "";
            if (n > 0) {
                string4 = "\\";
            } else if (n2 > 0) {
                string4 = "/";
            } else {
                throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0099E", new Object[]{string}, "The {0} zip file contains entries that have no directory path information."));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, string4);
            int n3 = stringTokenizer.countTokens();
            if (n3 > 5) {
                throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0100E", new Object[]{string}, "The {0} zip file contains directory entries that are not valid."));
            }
            int n4 = 0;
            String string5 = "";
            String string6 = "";
            while (stringTokenizer.hasMoreTokens()) {
                ++n4;
                string5 = stringTokenizer.nextToken();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "validate, currentToken=" + string5);
                }
                if (n4 == 1) {
                    this.validateToken1(string5, string);
                    continue;
                }
                if (n4 == 2) {
                    string2 = this.validateToken2(session, string5, string2, string);
                    continue;
                }
                if (n4 == 3) {
                    this.validateToken3(string5, string);
                    continue;
                }
                if (n4 == 4) {
                    this.validateToken4(session, string5, string);
                    continue;
                }
                if (n4 != 5) continue;
                this.validateToken5(string5, string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        if (string2.equals("")) {
            throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0105E", new Object[]{string}, "The {0} zip file does not contain a policy set."));
        }
        return string2;
    }

    private void validateToken1(String string, String string2) throws CommandValidationException {
        if (!string.equals("PolicySets")) {
            throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0100E", new Object[]{string2}, "The {0} zip file contains directory entries that are not valid."));
        }
    }

    private String validateToken2(Session session, String string, String string2, String string3) throws CommandValidationException, WorkSpaceException, NoItemFoundException {
        if (string2.equals("")) {
            string2 = string;
            List list = PolicySetWorkSpaceHelper.listPolicySets(session);
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !bl) {
                String string4 = iterator.next().toString();
                if (!string4.contains("PolicySets" + File.separatorChar + string2 + File.separatorChar)) continue;
                bl = true;
            }
            if (bl) {
                throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0101E", new Object[]{string3, string2}, "The {0} zip file contains the {1} policyset that exists on this system."));
            }
        }
        if (!string.equals(string2)) {
            throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0102E", new Object[]{string3, string2}, "The {0} zip file contains more than one policy set."));
        }
        return string2;
    }

    private void validateToken3(String string, String string2) throws CommandValidationException {
        if (!string.equals("PolicyTypes") && !string.equals("policySet.xml")) {
            throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0100E", new Object[]{string2}, "The {0} zip file contains directory entries that are not valid."));
        }
    }

    private void validateToken4(Session session, String string, String string2) throws CommandValidationException, WorkSpaceException, NoItemFoundException {
        String string3 = string;
        List list = PolicySetWorkSpaceHelper.listDefaultPolicyTypes(session);
        Iterator iterator = list.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            String string4 = iterator.next().toString();
            if (!string3.equals(string4)) continue;
            bl = true;
        }
        if (!bl) {
            throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0103E", new Object[]{string2, string3}, "The {0} zip file contains a {1} policy that is not valid on this system."));
        }
    }

    private void validateToken5(String string, String string2) throws CommandValidationException {
        if (!string.equals("policy.xml")) {
            throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0100E", new Object[]{string2}, "The {0} zip file contains directory entries that are not valid."));
        }
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
        Session session = this.getConfigSession();
        String string = "";
        try {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String string2 = (String)this.getParameter("importFile");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string2});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ImportPolicySet, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            string = this.validate(session, string2);
            String string3 = PolicySetWorkSpaceHelper.getCellRepositoryPath(session);
            boolean bl = this.importFiles(session, string3, string2);
            String string4 = PolicySetWorkSpaceHelper.getPolicySetFile(session, string);
            PolicySetHelper policySetHelper = PolicySetHelperFactory.createHelper(string4);
            policySetHelper.setLocale(this.getLocale());
            Properties properties = policySetHelper.getPolicySet();
            StringBuffer stringBuffer = PolicySetCommandUtil.validatePolicySet(session, string, string4);
            if (stringBuffer.length() != 0) {
                throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0025E", new Object[]{stringBuffer.toString()}, "The following list of policy types are invalid: {0}"));
            }
            commandResultImpl.setResult(bl);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className, FFDC_ID_1);
            try {
                PolicySetWorkSpaceHelper.deletePolicySet(session, string);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            commandResultImpl.setException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    private boolean importFiles(Session session, String string, String string2) throws IOException, WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFiles");
        }
        boolean bl = false;
        String string3 = "";
        ZipFile zipFile = new ZipFile(string2);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) continue;
            string3 = zipEntry.toString();
            String string4 = PolicySetWorkSpaceHelper.getImportFileName(session, string3, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "importFiles, zipFullName=" + string3 + " , outFileName=" + string4);
            }
            this.copyImportFile(zipFile.getInputStream(zipEntry), new BufferedOutputStream(new FileOutputStream(string4)));
        }
        zipFile.close();
        bl = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFiles");
        }
        return bl;
    }

    private void copyImportFile(InputStream inputStream, BufferedOutputStream bufferedOutputStream) throws IOException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyImportFile");
        }
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        bufferedOutputStream.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyImportFile");
        }
    }

    private List getZipFileList(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getZipFileList");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.clear();
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getZipFileList, zfileEntryName=" + string2);
            }
            arrayList.add(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getZipFileList");
        }
        return arrayList;
    }
}

